/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;

public abstract class AConverter
implements IConverter {
    protected IVideoResampler mToPictureResampler = null;
    protected IVideoResampler mToImageResampler = null;
    protected int mPictureWidth;
    protected int mPictureHeight;
    protected int mImageWidth;
    protected int mImageHeight;
    private final IPixelFormat.Type mPictureType;
    private final IPixelFormat.Type mRequiredPictureType;
    private final int mImageType;
    private final String mDescription;

    public AConverter(IPixelFormat.Type pictureType, IPixelFormat.Type requiredPictureType, int imageType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        String resampleDescription = "";
        this.mPictureType = pictureType;
        this.mRequiredPictureType = requiredPictureType;
        this.mImageType = imageType;
        this.mPictureWidth = pictureWidth;
        this.mPictureHeight = pictureHeight;
        this.mImageWidth = imageWidth;
        this.mImageHeight = imageHeight;
        if (!pictureType.equals((Object)requiredPictureType) || this.mPictureWidth != this.mImageWidth || this.mPictureHeight != this.mImageHeight) {
            if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
                throw new RuntimeException("0 Could not create could resampler to translate from " + (Object)((Object)pictureType) + " to " + (Object)((Object)requiredPictureType) + ".  Color space conversion is not supported by this version ofXuggler.  Recompile Xuggler with the GPL option enabled.");
            }
            this.mToImageResampler = IVideoResampler.make(imageWidth, imageHeight, requiredPictureType, this.mPictureWidth, this.mPictureHeight, pictureType);
            if (this.mToImageResampler == null) {
                throw new RuntimeException("1 Could not create could resampler to translate from " + (Object)((Object)pictureType) + " to " + (Object)((Object)requiredPictureType) + ".");
            }
            this.mToPictureResampler = IVideoResampler.make(this.mPictureWidth, this.mPictureHeight, pictureType, imageWidth, imageHeight, requiredPictureType);
            if (this.mToPictureResampler == null) {
                throw new RuntimeException("2 Could not create could resampler to translate from " + (Object)((Object)requiredPictureType) + " to " + (Object)((Object)pictureType));
            }
            resampleDescription = "Pictures will be resampled to and from " + (Object)((Object)requiredPictureType) + " during translation.";
        }
        this.mDescription = "A converter which translates [" + pictureWidth + "x" + pictureHeight + "] IVideoPicture type " + (Object)((Object)pictureType) + " to and from [" + imageWidth + "x" + imageHeight + "] BufferedImage type " + imageType + ".  " + resampleDescription;
    }

    @Override
    public IPixelFormat.Type getPictureType() {
        return this.mPictureType;
    }

    protected IPixelFormat.Type getRequiredPictureType() {
        return this.mRequiredPictureType;
    }

    @Override
    public int getImageType() {
        return this.mImageType;
    }

    @Override
    public boolean willResample() {
        return null != this.mToPictureResampler && null != this.mToImageResampler;
    }

    protected static IVideoPicture resample(IVideoPicture picture1, IVideoResampler resampler) {
        IVideoPicture picture2 = IVideoPicture.make(resampler.getOutputPixelFormat(), resampler.getOutputWidth(), resampler.getOutputHeight());
        if (resampler.resample(picture2, picture1) < 0) {
            throw new RuntimeException("could not resample from " + (Object)((Object)resampler.getInputPixelFormat()) + " to " + (Object)((Object)resampler.getOutputPixelFormat()) + " for picture of type " + (Object)((Object)picture1.getPixelType()));
        }
        if (picture2.getPixelType() != resampler.getOutputPixelFormat() || !picture2.isComplete()) {
            throw new RuntimeException("did not resample from " + (Object)((Object)resampler.getInputPixelFormat()) + " to " + (Object)((Object)resampler.getOutputPixelFormat()) + " for picture of type " + (Object)((Object)picture1.getPixelType()));
        }
        return picture2;
    }

    protected void validateImage(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("The passed image is NULL.");
        }
        if (image.getType() != this.getImageType()) {
            throw new IllegalArgumentException("The passed image is of type #" + image.getType() + " but is required to be of BufferedImage type #" + this.getImageType() + ".");
        }
    }

    protected void validatePicture(IVideoPicture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("The picture is NULL.");
        }
        if (!picture.isComplete()) {
            throw new IllegalArgumentException("The picture is not complete.");
        }
        IPixelFormat.Type type = picture.getPixelType();
        if (type != this.getPictureType() && this.willResample() && type != this.mToImageResampler.getOutputPixelFormat()) {
            throw new IllegalArgumentException("Picture is of type: " + (Object)((Object)type) + ", but must be " + (Object)((Object)this.getPictureType()) + (this.willResample() ? " or " + (Object)((Object)this.mToImageResampler.getOutputPixelFormat()) : "") + ".");
        }
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return this.getDescription();
    }

    public void close() {
        if (this.mToPictureResampler != null) {
            this.mToPictureResampler.delete();
        }
        this.mToPictureResampler = null;
        if (this.mToImageResampler != null) {
            this.mToImageResampler.delete();
        }
        this.mToImageResampler = null;
    }
}

