/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.XugglerJNI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class IVideoResampler
extends RefCounted
implements IConfigurable {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IVideoResampler(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.IVideoResampler_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IVideoResampler(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.IVideoResampler_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IVideoResampler obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IVideoResampler copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IVideoResampler(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IVideoResampler) {
            equal = ((IVideoResampler)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public Collection<String> getPropertyNames() {
        LinkedList<String> retval = new LinkedList<String>();
        int numProperties = this.getNumProperties();
        for (int i = 0; i < numProperties; ++i) {
            IProperty property = this.getPropertyMetaData(i);
            String name = property.getName();
            retval.add(name);
        }
        return retval;
    }

    public int getInputWidth() {
        return XugglerJNI.IVideoResampler_getInputWidth(this.swigCPtr, this);
    }

    public int getInputHeight() {
        return XugglerJNI.IVideoResampler_getInputHeight(this.swigCPtr, this);
    }

    public IPixelFormat.Type getInputPixelFormat() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IVideoResampler_getInputPixelFormat(this.swigCPtr, this));
    }

    public int getOutputWidth() {
        return XugglerJNI.IVideoResampler_getOutputWidth(this.swigCPtr, this);
    }

    public int getOutputHeight() {
        return XugglerJNI.IVideoResampler_getOutputHeight(this.swigCPtr, this);
    }

    public IPixelFormat.Type getOutputPixelFormat() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IVideoResampler_getOutputPixelFormat(this.swigCPtr, this));
    }

    public int resample(IVideoPicture outVideoPicture, IVideoPicture inVideoPicture) {
        return XugglerJNI.IVideoResampler_resample(this.swigCPtr, this, IVideoPicture.getCPtr(outVideoPicture), outVideoPicture, IVideoPicture.getCPtr(inVideoPicture), inVideoPicture);
    }

    @Override
    public int getNumProperties() {
        return XugglerJNI.IVideoResampler_getNumProperties(this.swigCPtr, this);
    }

    @Override
    public IProperty getPropertyMetaData(int propertyNo) {
        long cPtr = XugglerJNI.IVideoResampler_getPropertyMetaData__SWIG_0(this.swigCPtr, this, propertyNo);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public IProperty getPropertyMetaData(String name) {
        long cPtr = XugglerJNI.IVideoResampler_getPropertyMetaData__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public int setProperty(String name, String value) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_0(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, double value) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_1(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, long value) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_2(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, boolean value) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_3(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, IRational value) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_4(this.swigCPtr, this, name, IRational.getCPtr(value), value);
    }

    @Override
    public String getPropertyAsString(String name) {
        return XugglerJNI.IVideoResampler_getPropertyAsString(this.swigCPtr, this, name);
    }

    @Override
    public double getPropertyAsDouble(String name) {
        return XugglerJNI.IVideoResampler_getPropertyAsDouble(this.swigCPtr, this, name);
    }

    @Override
    public long getPropertyAsLong(String name) {
        return XugglerJNI.IVideoResampler_getPropertyAsLong(this.swigCPtr, this, name);
    }

    @Override
    public IRational getPropertyAsRational(String name) {
        long cPtr = XugglerJNI.IVideoResampler_getPropertyAsRational(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    @Override
    public boolean getPropertyAsBoolean(String name) {
        return XugglerJNI.IVideoResampler_getPropertyAsBoolean(this.swigCPtr, this, name);
    }

    public static IVideoResampler make(int outputWidth, int outputHeight, IPixelFormat.Type outputFmt, int inputWidth, int inputHeight, IPixelFormat.Type inputFmt) {
        long cPtr = XugglerJNI.IVideoResampler_make(outputWidth, outputHeight, outputFmt.swigValue(), inputWidth, inputHeight, inputFmt.swigValue());
        return cPtr == 0L ? null : new IVideoResampler(cPtr, false);
    }

    public static boolean isSupported(Feature feature) {
        return XugglerJNI.IVideoResampler_isSupported(feature.swigValue());
    }

    @Override
    public int setProperty(IMetaData valuesToSet, IMetaData valuesNotFound) {
        return XugglerJNI.IVideoResampler_setProperty__SWIG_5(this.swigCPtr, this, IMetaData.getCPtr(valuesToSet), valuesToSet, IMetaData.getCPtr(valuesNotFound), valuesNotFound);
    }

    public static enum Feature {
        FEATURE_IMAGERESCALING,
        FEATURE_COLORSPACECONVERSION;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Feature swigToEnum(int swigValue) {
            Feature[] swigValues = (Feature[])Feature.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Feature swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Feature.class + " with value " + swigValue);
        }

        private Feature() {
            this.swigValue = SwigNext.next++;
        }

        private Feature(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Feature(Feature swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

