/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.util.concurrent.atomic.AtomicLong;

public class IPacket
extends IMediaData {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IPacket(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.IPacket_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IPacket(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.IPacket_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IPacket obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IPacket copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IPacket(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IPacket) {
            equal = ((IPacket)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("complete:" + this.isComplete() + ";");
        result.append("dts:" + this.getDts() + ";");
        result.append("pts:" + this.getPts() + ";");
        result.append("size:" + this.getSize() + ";");
        result.append("key:" + this.isKey() + ";");
        result.append("flags:" + this.getFlags() + ";");
        result.append("stream index:" + this.getStreamIndex() + ";");
        result.append("duration:" + this.getDuration() + ";");
        result.append("position:" + this.getPosition() + ";");
        IRational timeBase = this.getTimeBase();
        result.append("time base:" + timeBase + ";");
        if (timeBase != null) {
            timeBase.delete();
        }
        result.append("]");
        return result.toString();
    }

    public void reset() {
        XugglerJNI.IPacket_reset(this.swigCPtr, this);
    }

    public boolean isComplete() {
        return XugglerJNI.IPacket_isComplete(this.swigCPtr, this);
    }

    public long getPts() {
        return XugglerJNI.IPacket_getPts(this.swigCPtr, this);
    }

    public void setPts(long aPts) {
        XugglerJNI.IPacket_setPts(this.swigCPtr, this, aPts);
    }

    public long getDts() {
        return XugglerJNI.IPacket_getDts(this.swigCPtr, this);
    }

    public void setDts(long aDts) {
        XugglerJNI.IPacket_setDts(this.swigCPtr, this, aDts);
    }

    @Override
    public int getSize() {
        return XugglerJNI.IPacket_getSize(this.swigCPtr, this);
    }

    public int getMaxSize() {
        return XugglerJNI.IPacket_getMaxSize(this.swigCPtr, this);
    }

    public int getStreamIndex() {
        return XugglerJNI.IPacket_getStreamIndex(this.swigCPtr, this);
    }

    public int getFlags() {
        return XugglerJNI.IPacket_getFlags(this.swigCPtr, this);
    }

    public boolean isKeyPacket() {
        return XugglerJNI.IPacket_isKeyPacket(this.swigCPtr, this);
    }

    public long getDuration() {
        return XugglerJNI.IPacket_getDuration(this.swigCPtr, this);
    }

    public long getPosition() {
        return XugglerJNI.IPacket_getPosition(this.swigCPtr, this);
    }

    public int allocateNewPayload(int payloadSize) {
        return XugglerJNI.IPacket_allocateNewPayload(this.swigCPtr, this, payloadSize);
    }

    public static IPacket make() {
        long cPtr = XugglerJNI.IPacket_make__SWIG_0();
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }

    public static IPacket make(IBuffer buffer) {
        long cPtr = XugglerJNI.IPacket_make__SWIG_1(IBuffer.getCPtr(buffer), buffer);
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }

    public void setKeyPacket(boolean keyPacket) {
        XugglerJNI.IPacket_setKeyPacket(this.swigCPtr, this, keyPacket);
    }

    public void setFlags(int flags) {
        XugglerJNI.IPacket_setFlags(this.swigCPtr, this, flags);
    }

    public void setComplete(boolean complete, int size) {
        XugglerJNI.IPacket_setComplete(this.swigCPtr, this, complete, size);
    }

    public void setStreamIndex(int streamIndex) {
        XugglerJNI.IPacket_setStreamIndex(this.swigCPtr, this, streamIndex);
    }

    public void setDuration(long duration) {
        XugglerJNI.IPacket_setDuration(this.swigCPtr, this, duration);
    }

    public void setPosition(long position) {
        XugglerJNI.IPacket_setPosition(this.swigCPtr, this, position);
    }

    public static IPacket make(IPacket packet, boolean copyData) {
        long cPtr = XugglerJNI.IPacket_make__SWIG_2(IPacket.getCPtr(packet), packet, copyData);
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }

    public static IPacket make(int size) {
        long cPtr = XugglerJNI.IPacket_make__SWIG_3(size);
        return cPtr == 0L ? null : new IPacket(cPtr, false);
    }
}

