/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.XugglerJNI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class IMetaData
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IMetaData(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.IMetaData_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IMetaData(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.IMetaData_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IMetaData obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IMetaData copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IMetaData(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IMetaData) {
            equal = ((IMetaData)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName()).append("@").append(this.hashCode());
        result.append("[");
        Collection<String> keys = this.getKeys();
        for (String key : keys) {
            String value = this.getValue(key, Flags.METADATA_NONE);
            result.append(key).append("=").append(value).append(";");
        }
        result.append("]");
        return result.toString();
    }

    public Collection<String> getKeys() {
        int numKeys = this.getNumKeys();
        ArrayList<String> retval = new ArrayList<String>(numKeys);
        for (int i = 0; i < this.getNumKeys(); ++i) {
            String key = this.getKey(i);
            if (key == null || key.length() <= 0) continue;
            retval.add(key);
        }
        return retval;
    }

    public String getValue(String key) {
        return this.getValue(key, Flags.METADATA_NONE);
    }

    public int getNumKeys() {
        return XugglerJNI.IMetaData_getNumKeys(this.swigCPtr, this);
    }

    private String getKey(int position) {
        return XugglerJNI.IMetaData_getKey(this.swigCPtr, this, position);
    }

    public String getValue(String key, Flags flag) {
        return XugglerJNI.IMetaData_getValue(this.swigCPtr, this, key, flag.swigValue());
    }

    public int setValue(String key, String value) {
        return XugglerJNI.IMetaData_setValue__SWIG_0(this.swigCPtr, this, key, value);
    }

    public static IMetaData make() {
        long cPtr = XugglerJNI.IMetaData_make();
        return cPtr == 0L ? null : new IMetaData(cPtr, false);
    }

    public int setValue(String key, String value, Flags flag) {
        return XugglerJNI.IMetaData_setValue__SWIG_1(this.swigCPtr, this, key, value, flag.swigValue());
    }

    public static enum Flags {
        METADATA_NONE(XugglerJNI.IMetaData_METADATA_NONE_get()),
        METADATA_MATCH_CASE(XugglerJNI.IMetaData_METADATA_MATCH_CASE_get()),
        METADATA_DONT_OVERWRITE(XugglerJNI.IMetaData_METADATA_DONT_OVERWRITE_get()),
        META_DATA_APPEND(XugglerJNI.IMetaData_META_DATA_APPEND_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

