/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.XugglerJNI;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.XugglerIO;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class IContainer
extends RefCounted
implements IConfigurable {
    private volatile long swigCPtr;
    public static final int SEEK_FLAG_BACKWARDS = XugglerJNI.IContainer_SEEK_FLAG_BACKWARDS_get();
    public static final int SEEK_FLAG_BYTE = XugglerJNI.IContainer_SEEK_FLAG_BYTE_get();
    public static final int SEEK_FLAG_ANY = XugglerJNI.IContainer_SEEK_FLAG_ANY_get();
    public static final int SEEK_FLAG_FRAME = XugglerJNI.IContainer_SEEK_FLAG_FRAME_get();

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IContainer(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.IContainer_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IContainer(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.IContainer_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IContainer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IContainer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IContainer(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IContainer) {
            equal = ((IContainer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("url:" + this.getURL() + ";");
        result.append("type:" + (Object)((Object)this.getType()) + ";");
        result.append("format:" + this.getContainerFormat() + ";");
        result.append("]");
        return result.toString();
    }

    public int open(IURLProtocolHandler handler, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(handler), type, format);
    }

    public int open(OutputStream output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(InputStream input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(DataOutput output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(DataOutputStream output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(DataInput input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(DataInputStream input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(RandomAccessFile file, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(file), type, format);
    }

    public int open(WritableByteChannel output, IContainerFormat format) {
        return this.open(XugglerIO.map(output), Type.WRITE, format);
    }

    public int open(ReadableByteChannel input, IContainerFormat format) {
        return this.open(XugglerIO.map(input), Type.READ, format);
    }

    public int open(ByteChannel channel, Type type, IContainerFormat format) {
        return this.open(XugglerIO.map(channel), type, format);
    }

    public int open(IURLProtocolHandler handler, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(handler), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(OutputStream output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(InputStream input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataOutput output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataOutputStream output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataInput input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(DataInputStream input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(RandomAccessFile file, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(file), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(WritableByteChannel output, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(output), Type.WRITE, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(ReadableByteChannel input, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(input), Type.READ, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public int open(ByteChannel channel, Type type, IContainerFormat format, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData) {
        return this.open(XugglerIO.map(channel), type, format, streamsCanBeAddedDynamically, queryStreamMetaData);
    }

    public String createSDPData() {
        IBuffer buffer = IBuffer.make(null, 4096);
        int len = this.createSDPData(buffer);
        if (len > 1) {
            byte[] stringBuf = new byte[len - 1];
            buffer.get(0, stringBuf, 0, stringBuf.length);
            return new String(stringBuf);
        }
        return null;
    }

    @Override
    public Collection<String> getPropertyNames() {
        LinkedList<String> retval = new LinkedList<String>();
        int numProperties = this.getNumProperties();
        for (int i = 0; i < numProperties; ++i) {
            IProperty property = this.getPropertyMetaData(i);
            String name = property.getName();
            retval.add(name);
        }
        return retval;
    }

    public int setInputBufferLength(long size) {
        return XugglerJNI.IContainer_setInputBufferLength(this.swigCPtr, this, size);
    }

    public long getInputBufferLength() {
        return XugglerJNI.IContainer_getInputBufferLength(this.swigCPtr, this);
    }

    public boolean isOpened() {
        return XugglerJNI.IContainer_isOpened(this.swigCPtr, this);
    }

    public boolean isHeaderWritten() {
        return XugglerJNI.IContainer_isHeaderWritten(this.swigCPtr, this);
    }

    public int open(String url, Type type, IContainerFormat pContainerFormat) {
        return XugglerJNI.IContainer_open__SWIG_0(this.swigCPtr, this, url, type.swigValue(), IContainerFormat.getCPtr(pContainerFormat), pContainerFormat);
    }

    public int open(String url, Type type, IContainerFormat pContainerFormat, boolean aStreamsCanBeAddedDynamically, boolean aQueryStreamMetaData) {
        return XugglerJNI.IContainer_open__SWIG_1(this.swigCPtr, this, url, type.swigValue(), IContainerFormat.getCPtr(pContainerFormat), pContainerFormat, aStreamsCanBeAddedDynamically, aQueryStreamMetaData);
    }

    public IStreamCoder.CodecStandardsCompliance getStandardsCompliance() {
        return IStreamCoder.CodecStandardsCompliance.swigToEnum(XugglerJNI.IContainer_getStandardsCompliance(this.swigCPtr, this));
    }

    public int setStandardsCompliance(IStreamCoder.CodecStandardsCompliance compliance) {
        return XugglerJNI.IContainer_setStandardsCompliance(this.swigCPtr, this, compliance.swigValue());
    }

    public IContainerFormat getContainerFormat() {
        long cPtr = XugglerJNI.IContainer_getContainerFormat(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public int close(boolean dangling) {
        return XugglerJNI.IContainer_close__SWIG_0(this.swigCPtr, this, dangling);
    }

    public int close() {
        return XugglerJNI.IContainer_close__SWIG_1(this.swigCPtr, this);
    }

    public Type getType() {
        return Type.swigToEnum(XugglerJNI.IContainer_getType(this.swigCPtr, this));
    }

    public int getNumStreams() {
        return XugglerJNI.IContainer_getNumStreams(this.swigCPtr, this);
    }

    public IStream getStream(long streamIndex) {
        long cPtr = XugglerJNI.IContainer_getStream(this.swigCPtr, this, streamIndex);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    @Deprecated
    public IStream addNewStream(int id) {
        long cPtr = XugglerJNI.IContainer_addNewStream__SWIG_0(this.swigCPtr, this, id);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public int writeHeader() {
        return XugglerJNI.IContainer_writeHeader(this.swigCPtr, this);
    }

    public int writeTrailer() {
        return XugglerJNI.IContainer_writeTrailer(this.swigCPtr, this);
    }

    public int readNextPacket(IPacket packet) {
        return XugglerJNI.IContainer_readNextPacket(this.swigCPtr, this, IPacket.getCPtr(packet), packet);
    }

    public int writePacket(IPacket packet, boolean forceInterleave) {
        return XugglerJNI.IContainer_writePacket__SWIG_0(this.swigCPtr, this, IPacket.getCPtr(packet), packet, forceInterleave);
    }

    public int writePacket(IPacket packet) {
        return XugglerJNI.IContainer_writePacket__SWIG_1(this.swigCPtr, this, IPacket.getCPtr(packet), packet);
    }

    public static IContainer make() {
        long cPtr = XugglerJNI.IContainer_make__SWIG_0();
        return cPtr == 0L ? null : new IContainer(cPtr, false);
    }

    public int queryStreamMetaData() {
        return XugglerJNI.IContainer_queryStreamMetaData(this.swigCPtr, this);
    }

    public int seekKeyFrame(int streamIndex, long timestamp, int flags) {
        return XugglerJNI.IContainer_seekKeyFrame__SWIG_0(this.swigCPtr, this, streamIndex, timestamp, flags);
    }

    public long getDuration() {
        return XugglerJNI.IContainer_getDuration(this.swigCPtr, this);
    }

    public long getStartTime() {
        return XugglerJNI.IContainer_getStartTime(this.swigCPtr, this);
    }

    public long getFileSize() {
        return XugglerJNI.IContainer_getFileSize(this.swigCPtr, this);
    }

    public int getBitRate() {
        return XugglerJNI.IContainer_getBitRate(this.swigCPtr, this);
    }

    @Override
    public int getNumProperties() {
        return XugglerJNI.IContainer_getNumProperties(this.swigCPtr, this);
    }

    @Override
    public IProperty getPropertyMetaData(int propertyNo) {
        long cPtr = XugglerJNI.IContainer_getPropertyMetaData__SWIG_0(this.swigCPtr, this, propertyNo);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public IProperty getPropertyMetaData(String name) {
        long cPtr = XugglerJNI.IContainer_getPropertyMetaData__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public int setProperty(String name, String value) {
        return XugglerJNI.IContainer_setProperty__SWIG_0(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, double value) {
        return XugglerJNI.IContainer_setProperty__SWIG_1(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, long value) {
        return XugglerJNI.IContainer_setProperty__SWIG_2(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, boolean value) {
        return XugglerJNI.IContainer_setProperty__SWIG_3(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, IRational value) {
        return XugglerJNI.IContainer_setProperty__SWIG_4(this.swigCPtr, this, name, IRational.getCPtr(value), value);
    }

    @Override
    public String getPropertyAsString(String name) {
        return XugglerJNI.IContainer_getPropertyAsString(this.swigCPtr, this, name);
    }

    @Override
    public double getPropertyAsDouble(String name) {
        return XugglerJNI.IContainer_getPropertyAsDouble(this.swigCPtr, this, name);
    }

    @Override
    public long getPropertyAsLong(String name) {
        return XugglerJNI.IContainer_getPropertyAsLong(this.swigCPtr, this, name);
    }

    @Override
    public IRational getPropertyAsRational(String name) {
        long cPtr = XugglerJNI.IContainer_getPropertyAsRational(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    @Override
    public boolean getPropertyAsBoolean(String name) {
        return XugglerJNI.IContainer_getPropertyAsBoolean(this.swigCPtr, this, name);
    }

    public int getFlags() {
        return XugglerJNI.IContainer_getFlags(this.swigCPtr, this);
    }

    public void setFlags(int newFlags) {
        XugglerJNI.IContainer_setFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getFlag(Flags flag) {
        return XugglerJNI.IContainer_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setFlag(Flags flag, boolean value) {
        XugglerJNI.IContainer_setFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public String getURL() {
        return XugglerJNI.IContainer_getURL(this.swigCPtr, this);
    }

    public int flushPackets() {
        return XugglerJNI.IContainer_flushPackets(this.swigCPtr, this);
    }

    public int getReadRetryCount() {
        return XugglerJNI.IContainer_getReadRetryCount(this.swigCPtr, this);
    }

    public void setReadRetryCount(int count) {
        XugglerJNI.IContainer_setReadRetryCount(this.swigCPtr, this, count);
    }

    public boolean canStreamsBeAddedDynamically() {
        return XugglerJNI.IContainer_canStreamsBeAddedDynamically(this.swigCPtr, this);
    }

    public IMetaData getMetaData() {
        long cPtr = XugglerJNI.IContainer_getMetaData(this.swigCPtr, this);
        return cPtr == 0L ? null : new IMetaData(cPtr, false);
    }

    public void setMetaData(IMetaData data) {
        XugglerJNI.IContainer_setMetaData(this.swigCPtr, this, IMetaData.getCPtr(data), data);
    }

    public int createSDPData(IBuffer buffer) {
        return XugglerJNI.IContainer_createSDPData(this.swigCPtr, this, IBuffer.getCPtr(buffer), buffer);
    }

    public int setForcedAudioCodec(ICodec.ID id) {
        return XugglerJNI.IContainer_setForcedAudioCodec(this.swigCPtr, this, id.swigValue());
    }

    public int setForcedVideoCodec(ICodec.ID id) {
        return XugglerJNI.IContainer_setForcedVideoCodec(this.swigCPtr, this, id.swigValue());
    }

    public int setForcedSubtitleCodec(ICodec.ID id) {
        return XugglerJNI.IContainer_setForcedSubtitleCodec(this.swigCPtr, this, id.swigValue());
    }

    public int seekKeyFrame(int streamIndex, long minTimeStamp, long targetTimeStamp, long maxTimeStamp, int flags) {
        return XugglerJNI.IContainer_seekKeyFrame__SWIG_1(this.swigCPtr, this, streamIndex, minTimeStamp, targetTimeStamp, maxTimeStamp, flags);
    }

    @Deprecated
    public int setPreload(int preload) {
        return XugglerJNI.IContainer_setPreload(this.swigCPtr, this, preload);
    }

    @Deprecated
    public int getPreload() {
        return XugglerJNI.IContainer_getPreload(this.swigCPtr, this);
    }

    public int setMaxDelay(int maxdelay) {
        return XugglerJNI.IContainer_setMaxDelay(this.swigCPtr, this, maxdelay);
    }

    public int getMaxDelay() {
        return XugglerJNI.IContainer_getMaxDelay(this.swigCPtr, this);
    }

    public IStream addNewStream(ICodec.ID id) {
        long cPtr = XugglerJNI.IContainer_addNewStream__SWIG_1(this.swigCPtr, this, id.swigValue());
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public IStream addNewStream(ICodec codec) {
        long cPtr = XugglerJNI.IContainer_addNewStream__SWIG_2(this.swigCPtr, this, ICodec.getCPtr(codec), codec);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public IStream addNewStream(IStreamCoder coder) {
        long cPtr = XugglerJNI.IContainer_addNewStream__SWIG_3(this.swigCPtr, this, IStreamCoder.getCPtr(coder), coder);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    @Override
    public int setProperty(IMetaData valuesToSet, IMetaData valuesNotFound) {
        return XugglerJNI.IContainer_setProperty__SWIG_5(this.swigCPtr, this, IMetaData.getCPtr(valuesToSet), valuesToSet, IMetaData.getCPtr(valuesNotFound), valuesNotFound);
    }

    public IContainerFormat getFormat() {
        long cPtr = XugglerJNI.IContainer_getFormat(this.swigCPtr, this);
        return cPtr == 0L ? null : new IContainerFormat(cPtr, false);
    }

    public int setFormat(IContainerFormat format) {
        return XugglerJNI.IContainer_setFormat(this.swigCPtr, this, IContainerFormat.getCPtr(format), format);
    }

    public static IContainer make(IContainerFormat format) {
        long cPtr = XugglerJNI.IContainer_make__SWIG_1(IContainerFormat.getCPtr(format), format);
        return cPtr == 0L ? null : new IContainer(cPtr, false);
    }

    public int open(String url, Type type, IContainerFormat containerFormat, boolean streamsCanBeAddedDynamically, boolean queryStreamMetaData, IMetaData options, IMetaData optionsNotSet) {
        return XugglerJNI.IContainer_open__SWIG_2(this.swigCPtr, this, url, type.swigValue(), IContainerFormat.getCPtr(containerFormat), containerFormat, streamsCanBeAddedDynamically, queryStreamMetaData, IMetaData.getCPtr(options), options, IMetaData.getCPtr(optionsNotSet), optionsNotSet);
    }

    public static enum Flags {
        FLAG_GENPTS(XugglerJNI.IContainer_FLAG_GENPTS_get()),
        FLAG_IGNIDX(XugglerJNI.IContainer_FLAG_IGNIDX_get()),
        FLAG_NONBLOCK(XugglerJNI.IContainer_FLAG_NONBLOCK_get()),
        FLAG_IGNDTS(XugglerJNI.IContainer_FLAG_IGNDTS_get()),
        FLAG_NOFILLIN(XugglerJNI.IContainer_FLAG_NOFILLIN_get()),
        FLAG_NOPARSE(XugglerJNI.IContainer_FLAG_NOPARSE_get()),
        FLAG_NOBUFFER(XugglerJNI.IContainer_FLAG_NOBUFFER_get()),
        FLAG_CUSTOM_IO(XugglerJNI.IContainer_FLAG_CUSTOM_IO_get()),
        FLAG_DISCARD_CORRUPT(XugglerJNI.IContainer_FLAG_DISCARD_CORRUPT_get()),
        FLAG_FLUSH_PACKETS(XugglerJNI.IContainer_FLAG_FLUSH_PACKETS_get()),
        FLAG_BITEXACT(XugglerJNI.IContainer_FLAG_BITEXACT_get()),
        FLAG_MP4A_LATM(XugglerJNI.IContainer_FLAG_MP4A_LATM_get()),
        FLAG_SORT_DTS(XugglerJNI.IContainer_FLAG_SORT_DTS_get()),
        FLAG_PRIV_OPT(XugglerJNI.IContainer_FLAG_PRIV_OPT_get()),
        FLAG_KEEP_SIDE_DATA(XugglerJNI.IContainer_FLAG_KEEP_SIDE_DATA_get()),
        FLAG_FAST_SEEK(XugglerJNI.IContainer_FLAG_FAST_SEEK_get()),
        FLAG_SHORTEST(XugglerJNI.IContainer_FLAG_SHORTEST_get()),
        FLAG_AUTO_BSF(XugglerJNI.IContainer_FLAG_AUTO_BSF_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Type {
        READ,
        WRITE;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

