/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ICodec
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected ICodec(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.ICodec_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected ICodec(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.ICodec_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(ICodec obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public ICodec copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new ICodec(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof ICodec) {
            equal = ((ICodec)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("type=" + (Object)((Object)this.getType()) + ";");
        result.append("id=" + (Object)((Object)this.getID()) + ";");
        result.append("name=" + this.getName() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<ICodec> getInstalledCodecs() {
        HashSet<ICodec> retval = new HashSet<ICodec>();
        int count = ICodec.getNumInstalledCodecs();
        for (int i = 0; i < count; ++i) {
            ICodec codec = ICodec.getInstalledCodec(i);
            if (codec == null) continue;
            retval.add(codec);
        }
        return retval;
    }

    public List<IRational> getSupportedVideoFrameRates() {
        LinkedList<IRational> retval = new LinkedList<IRational>();
        int count = this.getNumSupportedVideoFrameRates();
        for (int i = 0; i < count; ++i) {
            IRational rate = this.getSupportedVideoFrameRate(i);
            if (rate == null) continue;
            retval.add(rate);
        }
        return retval;
    }

    public List<IPixelFormat.Type> getSupportedVideoPixelFormats() {
        LinkedList<IPixelFormat.Type> retval = new LinkedList<IPixelFormat.Type>();
        int count = this.getNumSupportedVideoPixelFormats();
        for (int i = 0; i < count; ++i) {
            IPixelFormat.Type type = this.getSupportedVideoPixelFormat(i);
            if (type == null || type == IPixelFormat.Type.NONE) continue;
            retval.add(type);
        }
        return retval;
    }

    public List<Integer> getSupportedAudioSampleRates() {
        LinkedList<Integer> retval = new LinkedList<Integer>();
        int count = this.getNumSupportedAudioSampleRates();
        for (int i = 0; i < count; ++i) {
            int rate = this.getSupportedAudioSampleRate(i);
            if (rate == 0) continue;
            retval.add(rate);
        }
        return retval;
    }

    public List<IAudioSamples.Format> getSupportedAudioSampleFormats() {
        LinkedList<IAudioSamples.Format> retval = new LinkedList<IAudioSamples.Format>();
        int count = this.getNumSupportedAudioSampleFormats();
        for (int i = 0; i < count; ++i) {
            IAudioSamples.Format fmt = this.getSupportedAudioSampleFormat(i);
            if (fmt == null || fmt == IAudioSamples.Format.FMT_NONE) continue;
            retval.add(fmt);
        }
        return retval;
    }

    public List<Long> getSupportedAudioChannelLayouts() {
        LinkedList<Long> retval = new LinkedList<Long>();
        int count = this.getNumSupportedAudioChannelLayouts();
        for (int i = 0; i < count; ++i) {
            long layout = this.getSupportedAudioChannelLayout(i);
            if (layout == 0L) continue;
            retval.add(layout);
        }
        return retval;
    }

    public String getName() {
        return XugglerJNI.ICodec_getName(this.swigCPtr, this);
    }

    public int getIDAsInt() {
        return XugglerJNI.ICodec_getIDAsInt(this.swigCPtr, this);
    }

    public ID getID() {
        return ID.swigToEnum(XugglerJNI.ICodec_getID(this.swigCPtr, this));
    }

    public Type getType() {
        return Type.swigToEnum(XugglerJNI.ICodec_getType(this.swigCPtr, this));
    }

    public boolean canDecode() {
        return XugglerJNI.ICodec_canDecode(this.swigCPtr, this);
    }

    public boolean canEncode() {
        return XugglerJNI.ICodec_canEncode(this.swigCPtr, this);
    }

    public static ICodec findEncodingCodec(ID id, IPixelFormat.Type arg1) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodec__SWIG_0(id.swigValue(), arg1.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findEncodingCodec(ID id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodec__SWIG_1(id.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findEncodingCodecByIntID(int id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodecByIntID(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findEncodingCodecByName(String id) {
        long cPtr = XugglerJNI.ICodec_findEncodingCodecByName(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodec(ID id, IPixelFormat.Type arg1) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodec__SWIG_0(id.swigValue(), arg1.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodec(ID id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodec__SWIG_1(id.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodecByIntID(int id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodecByIntID(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec findDecodingCodecByName(String id) {
        long cPtr = XugglerJNI.ICodec_findDecodingCodecByName(id);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public static ICodec guessEncodingCodec(IContainerFormat fmt, String shortName, String url, String mimeType, Type type) {
        long cPtr = XugglerJNI.ICodec_guessEncodingCodec(IContainerFormat.getCPtr(fmt), fmt, shortName, url, mimeType, type.swigValue());
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public String getLongName() {
        return XugglerJNI.ICodec_getLongName(this.swigCPtr, this);
    }

    public int getCapabilities() {
        return XugglerJNI.ICodec_getCapabilities(this.swigCPtr, this);
    }

    public boolean hasCapability(Capabilities capability) {
        return XugglerJNI.ICodec_hasCapability(this.swigCPtr, this, capability.swigValue());
    }

    public static int getNumInstalledCodecs() {
        return XugglerJNI.ICodec_getNumInstalledCodecs();
    }

    public static ICodec getInstalledCodec(int index) {
        long cPtr = XugglerJNI.ICodec_getInstalledCodec(index);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public int getNumSupportedVideoFrameRates() {
        return XugglerJNI.ICodec_getNumSupportedVideoFrameRates(this.swigCPtr, this);
    }

    public IRational getSupportedVideoFrameRate(int index) {
        long cPtr = XugglerJNI.ICodec_getSupportedVideoFrameRate(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public int getNumSupportedVideoPixelFormats() {
        return XugglerJNI.ICodec_getNumSupportedVideoPixelFormats(this.swigCPtr, this);
    }

    public IPixelFormat.Type getSupportedVideoPixelFormat(int index) {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.ICodec_getSupportedVideoPixelFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioSampleRates() {
        return XugglerJNI.ICodec_getNumSupportedAudioSampleRates(this.swigCPtr, this);
    }

    public int getSupportedAudioSampleRate(int index) {
        return XugglerJNI.ICodec_getSupportedAudioSampleRate(this.swigCPtr, this, index);
    }

    public int getNumSupportedAudioSampleFormats() {
        return XugglerJNI.ICodec_getNumSupportedAudioSampleFormats(this.swigCPtr, this);
    }

    public IAudioSamples.Format getSupportedAudioSampleFormat(int index) {
        return IAudioSamples.Format.swigToEnum(XugglerJNI.ICodec_getSupportedAudioSampleFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioChannelLayouts() {
        return XugglerJNI.ICodec_getNumSupportedAudioChannelLayouts(this.swigCPtr, this);
    }

    public long getSupportedAudioChannelLayout(int index) {
        return XugglerJNI.ICodec_getSupportedAudioChannelLayout(this.swigCPtr, this, index);
    }

    public static enum Capabilities {
        CAP_DRAW_HORIZ_BAND(XugglerJNI.ICodec_CAP_DRAW_HORIZ_BAND_get()),
        CAP_DR1(XugglerJNI.ICodec_CAP_DR1_get()),
        CAP_PARSE_ONLY(XugglerJNI.ICodec_CAP_PARSE_ONLY_get()),
        CAP_TRUNCATED(XugglerJNI.ICodec_CAP_TRUNCATED_get()),
        CAP_HWACCEL(XugglerJNI.ICodec_CAP_HWACCEL_get()),
        CAP_DELAY(XugglerJNI.ICodec_CAP_DELAY_get()),
        CAP_SMALL_LAST_FRAME(XugglerJNI.ICodec_CAP_SMALL_LAST_FRAME_get()),
        CAP_HWACCEL_VDPAU(XugglerJNI.ICodec_CAP_HWACCEL_VDPAU_get()),
        CAP_SUBFRAMES(XugglerJNI.ICodec_CAP_SUBFRAMES_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Capabilities swigToEnum(int swigValue) {
            Capabilities[] swigValues = (Capabilities[])Capabilities.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Capabilities swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Capabilities.class + " with value " + swigValue);
        }

        private Capabilities() {
            this.swigValue = SwigNext.next++;
        }

        private Capabilities(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Capabilities(Capabilities swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Type {
        CODEC_TYPE_UNKNOWN(XugglerJNI.ICodec_CODEC_TYPE_UNKNOWN_get()),
        CODEC_TYPE_VIDEO,
        CODEC_TYPE_AUDIO,
        CODEC_TYPE_DATA,
        CODEC_TYPE_SUBTITLE,
        CODEC_TYPE_ATTACHMENT;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ID {
        AV_CODEC_ID_NONE,
        AV_CODEC_ID_MPEG1VIDEO,
        AV_CODEC_ID_MPEG2VIDEO,
        AV_CODEC_ID_MPEG2VIDEO_XVMC,
        AV_CODEC_ID_H261,
        AV_CODEC_ID_H263,
        AV_CODEC_ID_RV10,
        AV_CODEC_ID_RV20,
        AV_CODEC_ID_MJPEG,
        AV_CODEC_ID_MJPEGB,
        AV_CODEC_ID_LJPEG,
        AV_CODEC_ID_SP5X,
        AV_CODEC_ID_JPEGLS,
        AV_CODEC_ID_MPEG4,
        AV_CODEC_ID_RAWVIDEO,
        AV_CODEC_ID_MSMPEG4V1,
        AV_CODEC_ID_MSMPEG4V2,
        AV_CODEC_ID_MSMPEG4V3,
        AV_CODEC_ID_WMV1,
        AV_CODEC_ID_WMV2,
        AV_CODEC_ID_H263P,
        AV_CODEC_ID_H263I,
        AV_CODEC_ID_FLV1,
        AV_CODEC_ID_SVQ1,
        AV_CODEC_ID_SVQ3,
        AV_CODEC_ID_DVVIDEO,
        AV_CODEC_ID_HUFFYUV,
        AV_CODEC_ID_CYUV,
        AV_CODEC_ID_H264,
        AV_CODEC_ID_INDEO3,
        AV_CODEC_ID_VP3,
        AV_CODEC_ID_THEORA,
        AV_CODEC_ID_ASV1,
        AV_CODEC_ID_ASV2,
        AV_CODEC_ID_FFV1,
        AV_CODEC_ID_4XM,
        AV_CODEC_ID_VCR1,
        AV_CODEC_ID_CLJR,
        AV_CODEC_ID_MDEC,
        AV_CODEC_ID_ROQ,
        AV_CODEC_ID_INTERPLAY_VIDEO,
        AV_CODEC_ID_XAN_WC3,
        AV_CODEC_ID_XAN_WC4,
        AV_CODEC_ID_RPZA,
        AV_CODEC_ID_CINEPAK,
        AV_CODEC_ID_WS_VQA,
        AV_CODEC_ID_MSRLE,
        AV_CODEC_ID_MSVIDEO1,
        AV_CODEC_ID_IDCIN,
        AV_CODEC_ID_8BPS,
        AV_CODEC_ID_SMC,
        AV_CODEC_ID_FLIC,
        AV_CODEC_ID_TRUEMOTION1,
        AV_CODEC_ID_VMDVIDEO,
        AV_CODEC_ID_MSZH,
        AV_CODEC_ID_ZLIB,
        AV_CODEC_ID_QTRLE,
        AV_CODEC_ID_TSCC,
        AV_CODEC_ID_ULTI,
        AV_CODEC_ID_QDRAW,
        AV_CODEC_ID_VIXL,
        AV_CODEC_ID_QPEG,
        AV_CODEC_ID_PNG,
        AV_CODEC_ID_PPM,
        AV_CODEC_ID_PBM,
        AV_CODEC_ID_PGM,
        AV_CODEC_ID_PGMYUV,
        AV_CODEC_ID_PAM,
        AV_CODEC_ID_FFVHUFF,
        AV_CODEC_ID_RV30,
        AV_CODEC_ID_RV40,
        AV_CODEC_ID_VC1,
        AV_CODEC_ID_WMV3,
        AV_CODEC_ID_LOCO,
        AV_CODEC_ID_WNV1,
        AV_CODEC_ID_AASC,
        AV_CODEC_ID_INDEO2,
        AV_CODEC_ID_FRAPS,
        AV_CODEC_ID_TRUEMOTION2,
        AV_CODEC_ID_BMP,
        AV_CODEC_ID_CSCD,
        AV_CODEC_ID_MMVIDEO,
        AV_CODEC_ID_ZMBV,
        AV_CODEC_ID_AVS,
        AV_CODEC_ID_SMACKVIDEO,
        AV_CODEC_ID_NUV,
        AV_CODEC_ID_KMVC,
        AV_CODEC_ID_FLASHSV,
        AV_CODEC_ID_CAVS,
        AV_CODEC_ID_JPEG2000,
        AV_CODEC_ID_VMNC,
        AV_CODEC_ID_VP5,
        AV_CODEC_ID_VP6,
        AV_CODEC_ID_VP6F,
        AV_CODEC_ID_TARGA,
        AV_CODEC_ID_DSICINVIDEO,
        AV_CODEC_ID_TIERTEXSEQVIDEO,
        AV_CODEC_ID_TIFF,
        AV_CODEC_ID_GIF,
        AV_CODEC_ID_DXA,
        AV_CODEC_ID_DNXHD,
        AV_CODEC_ID_THP,
        AV_CODEC_ID_SGI,
        AV_CODEC_ID_C93,
        AV_CODEC_ID_BETHSOFTVID,
        AV_CODEC_ID_PTX,
        AV_CODEC_ID_TXD,
        AV_CODEC_ID_VP6A,
        AV_CODEC_ID_AMV,
        AV_CODEC_ID_VB,
        AV_CODEC_ID_PCX,
        AV_CODEC_ID_SUNRAST,
        AV_CODEC_ID_INDEO4,
        AV_CODEC_ID_INDEO5,
        AV_CODEC_ID_MIMIC,
        AV_CODEC_ID_RL2,
        AV_CODEC_ID_ESCAPE124,
        AV_CODEC_ID_DIRAC,
        AV_CODEC_ID_BFI,
        AV_CODEC_ID_CMV,
        AV_CODEC_ID_MOTIONPIXELS,
        AV_CODEC_ID_TGV,
        AV_CODEC_ID_TGQ,
        AV_CODEC_ID_TQI,
        AV_CODEC_ID_AURA,
        AV_CODEC_ID_AURA2,
        AV_CODEC_ID_V210X,
        AV_CODEC_ID_TMV,
        AV_CODEC_ID_V210,
        AV_CODEC_ID_DPX,
        AV_CODEC_ID_MAD,
        AV_CODEC_ID_FRWU,
        AV_CODEC_ID_FLASHSV2,
        AV_CODEC_ID_CDGRAPHICS,
        AV_CODEC_ID_R210,
        AV_CODEC_ID_ANM,
        AV_CODEC_ID_BINKVIDEO,
        AV_CODEC_ID_IFF_ILBM,
        AV_CODEC_ID_KGV1,
        AV_CODEC_ID_YOP,
        AV_CODEC_ID_VP8,
        AV_CODEC_ID_PICTOR,
        AV_CODEC_ID_ANSI,
        AV_CODEC_ID_A64_MULTI,
        AV_CODEC_ID_A64_MULTI5,
        AV_CODEC_ID_R10K,
        AV_CODEC_ID_MXPEG,
        AV_CODEC_ID_LAGARITH,
        AV_CODEC_ID_PRORES,
        AV_CODEC_ID_JV,
        AV_CODEC_ID_DFA,
        AV_CODEC_ID_WMV3IMAGE,
        AV_CODEC_ID_VC1IMAGE,
        AV_CODEC_ID_UTVIDEO,
        AV_CODEC_ID_BMV_VIDEO,
        AV_CODEC_ID_VBLE,
        AV_CODEC_ID_DXTORY,
        AV_CODEC_ID_V410,
        AV_CODEC_ID_XWD,
        AV_CODEC_ID_CDXL,
        AV_CODEC_ID_XBM,
        AV_CODEC_ID_ZEROCODEC,
        AV_CODEC_ID_MSS1,
        AV_CODEC_ID_MSA1,
        AV_CODEC_ID_TSCC2,
        AV_CODEC_ID_MTS2,
        AV_CODEC_ID_CLLC,
        AV_CODEC_ID_MSS2,
        AV_CODEC_ID_VP9,
        AV_CODEC_ID_AIC,
        AV_CODEC_ID_ESCAPE130,
        AV_CODEC_ID_G2M,
        AV_CODEC_ID_WEBP,
        AV_CODEC_ID_HNM4_VIDEO,
        AV_CODEC_ID_HEVC,
        AV_CODEC_ID_FIC,
        AV_CODEC_ID_ALIAS_PIX,
        AV_CODEC_ID_BRENDER_PIX,
        AV_CODEC_ID_PAF_VIDEO,
        AV_CODEC_ID_EXR,
        AV_CODEC_ID_VP7,
        AV_CODEC_ID_SANM,
        AV_CODEC_ID_SGIRLE,
        AV_CODEC_ID_MVC1,
        AV_CODEC_ID_MVC2,
        AV_CODEC_ID_HQX,
        AV_CODEC_ID_TDSC,
        AV_CODEC_ID_HQ_HQA,
        AV_CODEC_ID_HAP,
        AV_CODEC_ID_DDS,
        AV_CODEC_ID_DXV,
        AV_CODEC_ID_SCREENPRESSO,
        AV_CODEC_ID_RSCC,
        AV_CODEC_ID_Y41P(XugglerJNI.ICodec_AV_CODEC_ID_Y41P_get()),
        AV_CODEC_ID_AVRP,
        AV_CODEC_ID_012V,
        AV_CODEC_ID_AVUI,
        AV_CODEC_ID_AYUV,
        AV_CODEC_ID_TARGA_Y216,
        AV_CODEC_ID_V308,
        AV_CODEC_ID_V408,
        AV_CODEC_ID_YUV4,
        AV_CODEC_ID_AVRN,
        AV_CODEC_ID_CPIA,
        AV_CODEC_ID_XFACE,
        AV_CODEC_ID_SNOW,
        AV_CODEC_ID_SMVJPEG,
        AV_CODEC_ID_APNG,
        AV_CODEC_ID_DAALA,
        AV_CODEC_ID_CFHD,
        AV_CODEC_ID_TRUEMOTION2RT,
        AV_CODEC_ID_M101,
        AV_CODEC_ID_MAGICYUV,
        AV_CODEC_ID_SHEERVIDEO,
        AV_CODEC_ID_YLC,
        AV_CODEC_ID_PSD,
        AV_CODEC_ID_PIXLET,
        AV_CODEC_ID_SPEEDHQ,
        AV_CODEC_ID_FMVC,
        AV_CODEC_ID_SCPR,
        AV_CODEC_ID_CLEARVIDEO,
        AV_CODEC_ID_XPM,
        AV_CODEC_ID_AV1,
        AV_CODEC_ID_BITPACKED,
        AV_CODEC_ID_MSCC,
        AV_CODEC_ID_SRGC,
        AV_CODEC_ID_SVG,
        AV_CODEC_ID_GDV,
        AV_CODEC_ID_FITS,
        AV_CODEC_ID_FIRST_AUDIO(XugglerJNI.ICodec_AV_CODEC_ID_FIRST_AUDIO_get()),
        AV_CODEC_ID_PCM_S16LE(XugglerJNI.ICodec_AV_CODEC_ID_PCM_S16LE_get()),
        AV_CODEC_ID_PCM_S16BE,
        AV_CODEC_ID_PCM_U16LE,
        AV_CODEC_ID_PCM_U16BE,
        AV_CODEC_ID_PCM_S8,
        AV_CODEC_ID_PCM_U8,
        AV_CODEC_ID_PCM_MULAW,
        AV_CODEC_ID_PCM_ALAW,
        AV_CODEC_ID_PCM_S32LE,
        AV_CODEC_ID_PCM_S32BE,
        AV_CODEC_ID_PCM_U32LE,
        AV_CODEC_ID_PCM_U32BE,
        AV_CODEC_ID_PCM_S24LE,
        AV_CODEC_ID_PCM_S24BE,
        AV_CODEC_ID_PCM_U24LE,
        AV_CODEC_ID_PCM_U24BE,
        AV_CODEC_ID_PCM_S24DAUD,
        AV_CODEC_ID_PCM_ZORK,
        AV_CODEC_ID_PCM_S16LE_PLANAR,
        AV_CODEC_ID_PCM_DVD,
        AV_CODEC_ID_PCM_F32BE,
        AV_CODEC_ID_PCM_F32LE,
        AV_CODEC_ID_PCM_F64BE,
        AV_CODEC_ID_PCM_F64LE,
        AV_CODEC_ID_PCM_BLURAY,
        AV_CODEC_ID_PCM_LXF,
        AV_CODEC_ID_S302M,
        AV_CODEC_ID_PCM_S8_PLANAR,
        AV_CODEC_ID_PCM_S24LE_PLANAR,
        AV_CODEC_ID_PCM_S32LE_PLANAR,
        AV_CODEC_ID_PCM_S16BE_PLANAR,
        AV_CODEC_ID_PCM_S64LE(XugglerJNI.ICodec_AV_CODEC_ID_PCM_S64LE_get()),
        AV_CODEC_ID_PCM_S64BE,
        AV_CODEC_ID_PCM_F16LE,
        AV_CODEC_ID_PCM_F24LE,
        AV_CODEC_ID_ADPCM_IMA_QT(XugglerJNI.ICodec_AV_CODEC_ID_ADPCM_IMA_QT_get()),
        AV_CODEC_ID_ADPCM_IMA_WAV,
        AV_CODEC_ID_ADPCM_IMA_DK3,
        AV_CODEC_ID_ADPCM_IMA_DK4,
        AV_CODEC_ID_ADPCM_IMA_WS,
        AV_CODEC_ID_ADPCM_IMA_SMJPEG,
        AV_CODEC_ID_ADPCM_MS,
        AV_CODEC_ID_ADPCM_4XM,
        AV_CODEC_ID_ADPCM_XA,
        AV_CODEC_ID_ADPCM_ADX,
        AV_CODEC_ID_ADPCM_EA,
        AV_CODEC_ID_ADPCM_G726,
        AV_CODEC_ID_ADPCM_CT,
        AV_CODEC_ID_ADPCM_SWF,
        AV_CODEC_ID_ADPCM_YAMAHA,
        AV_CODEC_ID_ADPCM_SBPRO_4,
        AV_CODEC_ID_ADPCM_SBPRO_3,
        AV_CODEC_ID_ADPCM_SBPRO_2,
        AV_CODEC_ID_ADPCM_THP,
        AV_CODEC_ID_ADPCM_IMA_AMV,
        AV_CODEC_ID_ADPCM_EA_R1,
        AV_CODEC_ID_ADPCM_EA_R3,
        AV_CODEC_ID_ADPCM_EA_R2,
        AV_CODEC_ID_ADPCM_IMA_EA_SEAD,
        AV_CODEC_ID_ADPCM_IMA_EA_EACS,
        AV_CODEC_ID_ADPCM_EA_XAS,
        AV_CODEC_ID_ADPCM_EA_MAXIS_XA,
        AV_CODEC_ID_ADPCM_IMA_ISS,
        AV_CODEC_ID_ADPCM_G722,
        AV_CODEC_ID_ADPCM_IMA_APC,
        AV_CODEC_ID_ADPCM_VIMA,
        AV_CODEC_ID_VIMA(XugglerJNI.ICodec_AV_CODEC_ID_VIMA_get()),
        AV_CODEC_ID_ADPCM_AFC(XugglerJNI.ICodec_AV_CODEC_ID_ADPCM_AFC_get()),
        AV_CODEC_ID_ADPCM_IMA_OKI,
        AV_CODEC_ID_ADPCM_DTK,
        AV_CODEC_ID_ADPCM_IMA_RAD,
        AV_CODEC_ID_ADPCM_G726LE,
        AV_CODEC_ID_ADPCM_THP_LE,
        AV_CODEC_ID_ADPCM_PSX,
        AV_CODEC_ID_ADPCM_AICA,
        AV_CODEC_ID_ADPCM_IMA_DAT4,
        AV_CODEC_ID_ADPCM_MTAF,
        AV_CODEC_ID_AMR_NB(XugglerJNI.ICodec_AV_CODEC_ID_AMR_NB_get()),
        AV_CODEC_ID_AMR_WB,
        AV_CODEC_ID_RA_144(XugglerJNI.ICodec_AV_CODEC_ID_RA_144_get()),
        AV_CODEC_ID_RA_288,
        AV_CODEC_ID_ROQ_DPCM(XugglerJNI.ICodec_AV_CODEC_ID_ROQ_DPCM_get()),
        AV_CODEC_ID_INTERPLAY_DPCM,
        AV_CODEC_ID_XAN_DPCM,
        AV_CODEC_ID_SOL_DPCM,
        AV_CODEC_ID_SDX2_DPCM(XugglerJNI.ICodec_AV_CODEC_ID_SDX2_DPCM_get()),
        AV_CODEC_ID_GREMLIN_DPCM,
        AV_CODEC_ID_MP2(XugglerJNI.ICodec_AV_CODEC_ID_MP2_get()),
        AV_CODEC_ID_MP3,
        AV_CODEC_ID_AAC,
        AV_CODEC_ID_AC3,
        AV_CODEC_ID_DTS,
        AV_CODEC_ID_VORBIS,
        AV_CODEC_ID_DVAUDIO,
        AV_CODEC_ID_WMAV1,
        AV_CODEC_ID_WMAV2,
        AV_CODEC_ID_MACE3,
        AV_CODEC_ID_MACE6,
        AV_CODEC_ID_VMDAUDIO,
        AV_CODEC_ID_FLAC,
        AV_CODEC_ID_MP3ADU,
        AV_CODEC_ID_MP3ON4,
        AV_CODEC_ID_SHORTEN,
        AV_CODEC_ID_ALAC,
        AV_CODEC_ID_WESTWOOD_SND1,
        AV_CODEC_ID_GSM,
        AV_CODEC_ID_QDM2,
        AV_CODEC_ID_COOK,
        AV_CODEC_ID_TRUESPEECH,
        AV_CODEC_ID_TTA,
        AV_CODEC_ID_SMACKAUDIO,
        AV_CODEC_ID_QCELP,
        AV_CODEC_ID_WAVPACK,
        AV_CODEC_ID_DSICINAUDIO,
        AV_CODEC_ID_IMC,
        AV_CODEC_ID_MUSEPACK7,
        AV_CODEC_ID_MLP,
        AV_CODEC_ID_GSM_MS,
        AV_CODEC_ID_ATRAC3,
        AV_CODEC_ID_VOXWARE,
        AV_CODEC_ID_APE,
        AV_CODEC_ID_NELLYMOSER,
        AV_CODEC_ID_MUSEPACK8,
        AV_CODEC_ID_SPEEX,
        AV_CODEC_ID_WMAVOICE,
        AV_CODEC_ID_WMAPRO,
        AV_CODEC_ID_WMALOSSLESS,
        AV_CODEC_ID_ATRAC3P,
        AV_CODEC_ID_EAC3,
        AV_CODEC_ID_SIPR,
        AV_CODEC_ID_MP1,
        AV_CODEC_ID_TWINVQ,
        AV_CODEC_ID_TRUEHD,
        AV_CODEC_ID_MP4ALS,
        AV_CODEC_ID_ATRAC1,
        AV_CODEC_ID_BINKAUDIO_RDFT,
        AV_CODEC_ID_BINKAUDIO_DCT,
        AV_CODEC_ID_AAC_LATM,
        AV_CODEC_ID_QDMC,
        AV_CODEC_ID_CELT,
        AV_CODEC_ID_G723_1,
        AV_CODEC_ID_G729,
        AV_CODEC_ID_8SVX_EXP,
        AV_CODEC_ID_8SVX_FIB,
        AV_CODEC_ID_BMV_AUDIO,
        AV_CODEC_ID_RALF,
        AV_CODEC_ID_IAC,
        AV_CODEC_ID_ILBC,
        AV_CODEC_ID_OPUS,
        AV_CODEC_ID_COMFORT_NOISE,
        AV_CODEC_ID_TAK,
        AV_CODEC_ID_METASOUND,
        AV_CODEC_ID_PAF_AUDIO,
        AV_CODEC_ID_ON2AVC,
        AV_CODEC_ID_DSS_SP,
        AV_CODEC_ID_FFWAVESYNTH(XugglerJNI.ICodec_AV_CODEC_ID_FFWAVESYNTH_get()),
        AV_CODEC_ID_SONIC,
        AV_CODEC_ID_SONIC_LS,
        AV_CODEC_ID_EVRC,
        AV_CODEC_ID_SMV,
        AV_CODEC_ID_DSD_LSBF,
        AV_CODEC_ID_DSD_MSBF,
        AV_CODEC_ID_DSD_LSBF_PLANAR,
        AV_CODEC_ID_DSD_MSBF_PLANAR,
        AV_CODEC_ID_4GV,
        AV_CODEC_ID_INTERPLAY_ACM,
        AV_CODEC_ID_XMA1,
        AV_CODEC_ID_XMA2,
        AV_CODEC_ID_DST,
        AV_CODEC_ID_ATRAC3AL,
        AV_CODEC_ID_ATRAC3PAL,
        AV_CODEC_ID_DOLBY_E,
        AV_CODEC_ID_FIRST_SUBTITLE(XugglerJNI.ICodec_AV_CODEC_ID_FIRST_SUBTITLE_get()),
        AV_CODEC_ID_DVD_SUBTITLE(XugglerJNI.ICodec_AV_CODEC_ID_DVD_SUBTITLE_get()),
        AV_CODEC_ID_DVB_SUBTITLE,
        AV_CODEC_ID_TEXT,
        AV_CODEC_ID_XSUB,
        AV_CODEC_ID_SSA,
        AV_CODEC_ID_MOV_TEXT,
        AV_CODEC_ID_HDMV_PGS_SUBTITLE,
        AV_CODEC_ID_DVB_TELETEXT,
        AV_CODEC_ID_SRT,
        AV_CODEC_ID_MICRODVD(XugglerJNI.ICodec_AV_CODEC_ID_MICRODVD_get()),
        AV_CODEC_ID_EIA_608,
        AV_CODEC_ID_JACOSUB,
        AV_CODEC_ID_SAMI,
        AV_CODEC_ID_REALTEXT,
        AV_CODEC_ID_STL,
        AV_CODEC_ID_SUBVIEWER1,
        AV_CODEC_ID_SUBVIEWER,
        AV_CODEC_ID_SUBRIP,
        AV_CODEC_ID_WEBVTT,
        AV_CODEC_ID_MPL2,
        AV_CODEC_ID_VPLAYER,
        AV_CODEC_ID_PJS,
        AV_CODEC_ID_ASS,
        AV_CODEC_ID_HDMV_TEXT_SUBTITLE,
        AV_CODEC_ID_FIRST_UNKNOWN(XugglerJNI.ICodec_AV_CODEC_ID_FIRST_UNKNOWN_get()),
        AV_CODEC_ID_TTF(XugglerJNI.ICodec_AV_CODEC_ID_TTF_get()),
        AV_CODEC_ID_SCTE_35,
        AV_CODEC_ID_BINTEXT(XugglerJNI.ICodec_AV_CODEC_ID_BINTEXT_get()),
        AV_CODEC_ID_XBIN,
        AV_CODEC_ID_IDF,
        AV_CODEC_ID_OTF,
        AV_CODEC_ID_SMPTE_KLV,
        AV_CODEC_ID_DVD_NAV,
        AV_CODEC_ID_TIMED_ID3,
        AV_CODEC_ID_BIN_DATA,
        AV_CODEC_ID_PROBE(XugglerJNI.ICodec_AV_CODEC_ID_PROBE_get()),
        AV_CODEC_ID_MPEG2TS(XugglerJNI.ICodec_AV_CODEC_ID_MPEG2TS_get()),
        AV_CODEC_ID_MPEG4SYSTEMS(XugglerJNI.ICodec_AV_CODEC_ID_MPEG4SYSTEMS_get()),
        AV_CODEC_ID_FFMETADATA(XugglerJNI.ICodec_AV_CODEC_ID_FFMETADATA_get()),
        AV_CODEC_ID_WRAPPED_AVFRAME(XugglerJNI.ICodec_AV_CODEC_ID_WRAPPED_AVFRAME_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ID swigToEnum(int swigValue) {
            ID[] swigValues = (ID[])ID.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ID swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ID.class + " with value " + swigValue);
        }

        private ID() {
            this.swigValue = SwigNext.next++;
        }

        private ID(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ID(ID swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

