/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IMediaFilter;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.XugglerJNI;
import java.util.concurrent.atomic.AtomicLong;

public class IBufferSink
extends IMediaFilter {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IBufferSink(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.IBufferSink_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IBufferSink(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.IBufferSink_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IBufferSink obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IBufferSink copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IBufferSink(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IBufferSink) {
            equal = ((IBufferSink)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public int getSampleRate() {
        return XugglerJNI.IBufferSink_getSampleRate(this.swigCPtr, this);
    }

    public int getChannels() {
        return XugglerJNI.IBufferSink_getChannels(this.swigCPtr, this);
    }

    public int getWidth() {
        return XugglerJNI.IBufferSink_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return XugglerJNI.IBufferSink_getHeight(this.swigCPtr, this);
    }

    public IRational getFrameRate() {
        long cPtr = XugglerJNI.IBufferSink_getFrameRate(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IBufferSink_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setNumSamples(int frameSize) {
        XugglerJNI.IBufferSink_setNumSamples(this.swigCPtr, this, frameSize);
    }

    public int fillAudioSamples(IAudioSamples samples) {
        return XugglerJNI.IBufferSink_fillAudioSamples(this.swigCPtr, this, IAudioSamples.getCPtr(samples), samples);
    }

    public int fillVideoPicture(IVideoPicture picture) {
        return XugglerJNI.IBufferSink_fillVideoPicture(this.swigCPtr, this, IVideoPicture.getCPtr(picture), picture);
    }
}

