/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoResampler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);

    private Configuration() {
    }

    public static void main(String[] args) {
        Configuration.printHelp(System.out);
    }

    public static void printHelp(PrintStream stream) {
        Configuration.printSupportedContainerFormats(stream);
        Configuration.printSupportedCodecs(stream);
        Configuration.printSupportedContainerProperties(stream);
        Configuration.printSupportedStreamCoderProperties(stream);
        Configuration.printSupportedVideoResamplerProperties(stream);
    }

    public static void printSupportedContainerFormats(PrintStream stream) {
        stream.println("=======================================");
        stream.println("  Demuxable Formats");
        stream.println("=======================================");
        Collection<IContainerFormat> inputFormats = IContainerFormat.getInstalledInputFormats();
        for (IContainerFormat inputFormat : inputFormats) {
            stream.printf("  \"%s\": %s\n", inputFormat.getInputFormatShortName(), inputFormat.getInputFormatLongName());
        }
        stream.println("=======================================");
        stream.println("  Muxable Formats");
        stream.println("=======================================");
        Collection<IContainerFormat> outputFormats = IContainerFormat.getInstalledOutputFormats();
        for (IContainerFormat outputFormat : outputFormats) {
            stream.printf("  \"%s\": %s\n", outputFormat.getOutputFormatShortName(), outputFormat.getOutputFormatLongName());
        }
    }

    public static void printSupportedCodecs(PrintStream stream) {
        Collection<ICodec> codecs = ICodec.getInstalledCodecs();
        stream.println("=======================================");
        stream.println("  Decodeable Codecs");
        stream.println("=======================================");
        for (ICodec codec : codecs) {
            if (!codec.canDecode()) continue;
            stream.printf("%s %s (%s): %s\n", new Object[]{codec.getType(), codec.getID(), codec.getName(), codec.getLongName()});
        }
        stream.println("=======================================");
        stream.println("  Encodeable Codecs");
        stream.println("=======================================");
        for (ICodec codec : codecs) {
            if (!codec.canEncode()) continue;
            stream.printf("%s %s (%s): %s\n", new Object[]{codec.getType(), codec.getID(), codec.getName(), codec.getLongName()});
        }
    }

    public static void printSupportedVideoResamplerProperties(PrintStream stream) {
        if (IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            Configuration.printConfigurable(stream, IVideoResampler.make(100, 100, IPixelFormat.Type.YUV420P, 200, 200, IPixelFormat.Type.RGB24));
        }
    }

    public static void printSupportedStreamCoderProperties(PrintStream stream) {
        Configuration.printConfigurable(stream, IStreamCoder.make(IStreamCoder.Direction.ENCODING, (ICodec)null));
    }

    public static void printSupportedContainerProperties(PrintStream stream) {
        Configuration.printConfigurable(stream, IContainer.make());
    }

    public static void printConfigurable(PrintStream stream, IConfigurable configObj) {
        stream.println("=======================================");
        stream.println("  " + configObj.getClass().getName() + " Properties");
        stream.println("=======================================");
        int numOptions = configObj.getNumProperties();
        for (int i = 0; i < numOptions; ++i) {
            IProperty prop = configObj.getPropertyMetaData(i);
            Configuration.printOption(stream, configObj, prop);
        }
    }

    public static void printOption(PrintStream stream, IConfigurable configObj, IProperty prop) {
        if (prop.getType() != IProperty.Type.PROPERTY_FLAGS) {
            stream.printf("  %s; default= %s; type=%s;\n", new Object[]{prop.getName(), configObj.getPropertyAsString(prop.getName()), prop.getType()});
        } else {
            stream.printf("  %s; default= %d; valid values=(", prop.getName(), configObj.getPropertyAsLong(prop.getName()));
            int numSettings = prop.getNumFlagSettings();
            long value = configObj.getPropertyAsLong(prop.getName());
            for (int i = 0; i < numSettings; ++i) {
                IProperty fprop = prop.getFlagConstant(i);
                long flagMask = fprop.getDefault();
                boolean isSet = (value & flagMask) > 0L;
                stream.printf("%s%s; ", isSet ? "+" : "-", fprop.getName());
            }
            stream.printf("); type=%s;\n", new Object[]{prop.getType()});
        }
        stream.printf("    help for %s: %s\n", prop.getName(), prop.getHelp() == null ? "no help available" : prop.getHelp());
    }

    public static int configure(Properties properties, IConfigurable config) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            int retval;
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            if (value == null || (retval = config.setProperty(name, value)) >= 0) continue;
            log.warn("Invalid property on object {}; name=\"{}\"; value=\"{}\"", config, name, value);
            return retval;
        }
        return 0;
    }

    public static int configure(String file, IConfigurable config) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return Configuration.configure(props, config);
    }
}

