/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.mediatool.AMediaCoderMixin;
import com.xuggle.mediatool.IMediaCoder;
import com.xuggle.mediatool.IMediaGenerator;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.event.AddStreamEvent;
import com.xuggle.mediatool.event.AudioSamplesEvent;
import com.xuggle.mediatool.event.CloseCoderEvent;
import com.xuggle.mediatool.event.CloseEvent;
import com.xuggle.mediatool.event.FlushEvent;
import com.xuggle.mediatool.event.IAddStreamEvent;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.ICloseCoderEvent;
import com.xuggle.mediatool.event.ICloseEvent;
import com.xuggle.mediatool.event.IFlushEvent;
import com.xuggle.mediatool.event.IOpenCoderEvent;
import com.xuggle.mediatool.event.IOpenEvent;
import com.xuggle.mediatool.event.IReadPacketEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.mediatool.event.IWriteHeaderEvent;
import com.xuggle.mediatool.event.IWritePacketEvent;
import com.xuggle.mediatool.event.IWriteTrailerEvent;
import com.xuggle.mediatool.event.OpenCoderEvent;
import com.xuggle.mediatool.event.OpenEvent;
import com.xuggle.mediatool.event.VideoPictureEvent;
import com.xuggle.mediatool.event.WriteHeaderEvent;
import com.xuggle.mediatool.event.WritePacketEvent;
import com.xuggle.mediatool.event.WriteTrailerEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MediaWriter
extends AMediaCoderMixin
implements IMediaWriter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final IPixelFormat.Type DEFAULT_PIXEL_TYPE;
    private static final IAudioSamples.Format DEFAULT_SAMPLE_FORMAT;
    private static final IRational DEFAULT_TIMEBASE;
    private final IContainer mInputContainer;
    private IContainerFormat mContainerFormat;
    private Map<Integer, Integer> mOutputStreamIndices;
    private Map<Integer, IStream> mStreams;
    private Map<Integer, IConverter> mVideoConverters;
    private final Collection<IStream> mOpenedStreams;
    private boolean mForceInterleave;
    private boolean mMaskLateStreamException;

    MediaWriter(String url, IMediaReader reader) {
        this(url, reader.getContainer());
        if (reader.canAddDynamicStreams()) {
            throw new IllegalArgumentException("inputContainer is improperly configured to allow dynamic adding of streams.");
        }
    }

    MediaWriter(String url, IContainer inputContainer) {
        super(url, IContainer.make());
        this.log.trace("<init>");
        this.mOutputStreamIndices = new HashMap<Integer, Integer>();
        this.mStreams = new HashMap<Integer, IStream>();
        this.mVideoConverters = new HashMap<Integer, IConverter>();
        this.mOpenedStreams = new Vector<IStream>();
        this.mForceInterleave = true;
        this.mMaskLateStreamException = false;
        if (inputContainer.getType() != IContainer.Type.READ) {
            throw new IllegalArgumentException("inputContainer is improperly must be of type readable.");
        }
        if (inputContainer.canStreamsBeAddedDynamically()) {
            throw new IllegalArgumentException("inputContainer is improperly configured to allow dynamic adding of streams.");
        }
        this.mInputContainer = inputContainer;
        this.mContainerFormat = IContainerFormat.make();
        this.mContainerFormat.setOutputFormat(this.mInputContainer.getContainerFormat().getInputFormatShortName(), this.getUrl(), null);
    }

    MediaWriter(String url) {
        super(url, IContainer.make());
        this.log.trace("<init>");
        this.mOutputStreamIndices = new HashMap<Integer, Integer>();
        this.mStreams = new HashMap<Integer, IStream>();
        this.mVideoConverters = new HashMap<Integer, IConverter>();
        this.mOpenedStreams = new Vector<IStream>();
        this.mForceInterleave = true;
        this.mMaskLateStreamException = false;
        this.mInputContainer = null;
        this.mContainerFormat = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAudioStream(int inputIndex, int streamId, int channelCount, int sampleRate) {
        IContainerFormat format = null;
        if (this.getContainer() != null) {
            format = this.getContainer().getContainerFormat();
        }
        if (format != null && !format.isOutput()) {
            format.delete();
            format = null;
        }
        String url = this.getUrl();
        if (format == null && (url == null || url.length() < 0)) {
            throw new IllegalArgumentException("Cannot guess codec without container or url");
        }
        ICodec codec = ICodec.guessEncodingCodec(format, null, url, null, ICodec.Type.CODEC_TYPE_AUDIO);
        if (codec == null) {
            throw new UnsupportedOperationException("could not guess audio codec");
        }
        try {
            int n = this.addAudioStream(inputIndex, streamId, codec, channelCount, sampleRate);
            return n;
        }
        finally {
            if (codec != null) {
                codec.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAudioStream(int inputIndex, int streamId, ICodec.ID codecId, int channelCount, int sampleRate) {
        if (codecId == null) {
            throw new IllegalArgumentException("null codecId");
        }
        ICodec codec = ICodec.findEncodingCodec(codecId);
        if (codec == null) {
            throw new UnsupportedOperationException("cannot encode with codec: " + (Object)((Object)codecId));
        }
        try {
            int n = this.addAudioStream(inputIndex, streamId, codec, channelCount, sampleRate);
            return n;
        }
        finally {
            codec.delete();
        }
    }

    @Override
    public int addAudioStream(int inputIndex, int streamId, ICodec codec, int channelCount, int sampleRate) {
        if (channelCount <= 0) {
            throw new IllegalArgumentException("invalid channel count " + channelCount);
        }
        if (sampleRate <= 0) {
            throw new IllegalArgumentException("invalid sample rate " + sampleRate);
        }
        IStream stream = this.establishStream(inputIndex, streamId, codec);
        IStreamCoder coder = stream.getStreamCoder();
        coder.setChannels(channelCount);
        coder.setSampleRate(sampleRate);
        coder.setSampleFormat(codec.getSupportedAudioSampleFormat(0));
        this.addStream(stream, inputIndex, stream.getIndex());
        return stream.getIndex();
    }

    @Override
    public int addVideoStream(int inputIndex, int streamId, int width, int height) {
        return this.addVideoStream(inputIndex, streamId, (IRational)null, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addVideoStream(int inputIndex, int streamId, IRational frameRate, int width, int height) {
        IContainerFormat format = null;
        if (this.getContainer() != null) {
            format = this.getContainer().getContainerFormat();
        }
        if (format != null && !format.isOutput()) {
            format.delete();
            format = null;
        }
        String url = this.getUrl();
        if (format == null && (url == null || url.length() < 0)) {
            throw new IllegalArgumentException("Cannot guess codec without container or url");
        }
        ICodec codec = ICodec.guessEncodingCodec(format, null, url, null, ICodec.Type.CODEC_TYPE_VIDEO);
        if (codec == null) {
            throw new UnsupportedOperationException("could not guess video codec");
        }
        try {
            int n = this.addVideoStream(inputIndex, streamId, codec, frameRate, width, height);
            return n;
        }
        finally {
            if (codec != null) {
                codec.delete();
            }
        }
    }

    @Override
    public int addVideoStream(int inputIndex, int streamId, ICodec.ID codecId, int width, int height) {
        return this.addVideoStream(inputIndex, streamId, codecId, null, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addVideoStream(int inputIndex, int streamId, ICodec.ID codecId, IRational frameRate, int width, int height) {
        if (codecId == null) {
            throw new IllegalArgumentException("null codecId");
        }
        ICodec codec = ICodec.findEncodingCodec(codecId);
        if (codec == null) {
            throw new UnsupportedOperationException("cannot encode with codec: " + (Object)((Object)codecId));
        }
        try {
            int n = this.addVideoStream(inputIndex, streamId, codec, frameRate, width, height);
            return n;
        }
        finally {
            codec.delete();
        }
    }

    @Override
    public int addVideoStream(int inputIndex, int streamId, ICodec codec, int width, int height) {
        return this.addVideoStream(inputIndex, streamId, codec, null, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addVideoStream(int inputIndex, int streamId, ICodec codec, IRational frameRate, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("invalid video frame size [" + width + " x " + height + "]");
        }
        IStream stream = this.establishStream(inputIndex, streamId, codec);
        IStreamCoder coder = stream.getStreamCoder();
        try {
            List<IRational> supportedFrameRates = codec.getSupportedVideoFrameRates();
            IRational timeBase = null;
            if (supportedFrameRates != null && supportedFrameRates.size() > 0) {
                IRational highestResolution = null;
                for (IRational supportedRate : supportedFrameRates) {
                    if (!IRational.positive(supportedRate)) continue;
                    if (highestResolution == null) {
                        highestResolution = supportedRate.copyReference();
                    }
                    if (IRational.positive(frameRate)) {
                        if (supportedRate.compareTo(frameRate) == 0) {
                            highestResolution = frameRate.copyReference();
                        }
                    } else if (highestResolution.getDouble() < supportedRate.getDouble()) {
                        highestResolution.delete();
                        highestResolution = supportedRate.copyReference();
                    }
                    supportedRate.delete();
                }
                if (IRational.positive(frameRate) && (highestResolution == null || highestResolution.compareTo(frameRate) != 0)) {
                    throw new UnsupportedOperationException("container does not support encoding at given frame rate: " + frameRate);
                }
                if (highestResolution == null) {
                    throw new UnsupportedOperationException("could not find supported frame rate for container: " + this.getUrl());
                }
                if (timeBase == null) {
                    timeBase = IRational.make(highestResolution.getDenominator(), highestResolution.getNumerator());
                }
                highestResolution.delete();
                highestResolution = null;
            }
            if (IRational.positive(frameRate) && timeBase == null) {
                timeBase = IRational.make(frameRate.getDenominator(), frameRate.getNumerator());
            }
            if (timeBase == null) {
                timeBase = this.getDefaultTimebase();
                if (codec.getID() == ICodec.ID.AV_CODEC_ID_MPEG4 && timeBase.getDenominator() > 65535) {
                    timeBase.delete();
                    timeBase = IRational.make(1, 65535);
                }
            }
            coder.setTimeBase(timeBase);
            timeBase.delete();
            timeBase = null;
            coder.setWidth(width);
            coder.setHeight(height);
            coder.setPixelType(DEFAULT_PIXEL_TYPE);
            this.addStream(stream, inputIndex, stream.getIndex());
        }
        finally {
            coder.delete();
        }
        return stream.getIndex();
    }

    private IStream establishStream(int inputIndex, int streamId, ICodec codec) {
        IStream stream;
        if (inputIndex < 0) {
            throw new IllegalArgumentException("invalid input index " + inputIndex);
        }
        if (streamId < 0) {
            throw new IllegalArgumentException("invalid stream id " + streamId);
        }
        if (null == codec) {
            throw new IllegalArgumentException("null codec");
        }
        if (!this.isOpen()) {
            this.open();
        }
        if ((stream = this.getContainer().addNewStream(codec)) == null) {
            throw new RuntimeException("Unable to create stream id " + streamId + ", index " + inputIndex + ", codec " + codec);
        }
        this.setForceInterleave(this.getContainer().getNumStreams() != 1);
        return stream;
    }

    @Override
    public void setMaskLateStreamExceptions(boolean maskLateStreamExceptions) {
        this.mMaskLateStreamException = maskLateStreamExceptions;
    }

    @Override
    public boolean willMaskLateStreamExceptions() {
        return this.mMaskLateStreamException;
    }

    @Override
    public void setForceInterleave(boolean forceInterleave) {
        this.mForceInterleave = forceInterleave;
    }

    @Override
    public boolean willForceInterleave() {
        return this.mForceInterleave;
    }

    @Override
    public Integer getOutputStreamIndex(int inputStreamIndex) {
        return this.mOutputStreamIndices.get(inputStreamIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeVideo(int streamIndex, IVideoPicture picture, BufferedImage image) {
        if (null == picture) {
            throw new IllegalArgumentException("no picture");
        }
        IStream stream = this.getStream(streamIndex);
        if (null == stream) {
            return;
        }
        Integer outputIndex = this.getOutputStreamIndex(streamIndex);
        if (null == outputIndex) {
            throw new IllegalArgumentException("unknow stream index: " + streamIndex);
        }
        if (ICodec.Type.CODEC_TYPE_VIDEO != this.mStreams.get(outputIndex).getStreamCoder().getCodecType()) {
            throw new IllegalArgumentException("stream[" + streamIndex + "] is not video");
        }
        IPacket packet = IPacket.make();
        try {
            if (stream.getStreamCoder().encodeVideo(packet, picture, 0) < 0) {
                throw new RuntimeException("failed to encode video");
            }
            if (packet.isComplete()) {
                this.writePacket(packet);
            }
        }
        finally {
            if (packet != null) {
                packet.delete();
            }
        }
        super.onVideoPicture(new VideoPictureEvent((IMediaGenerator)this, picture, image, picture.getTimeStamp(), TimeUnit.MICROSECONDS, (Integer)streamIndex));
    }

    @Override
    public void encodeVideo(int streamIndex, IVideoPicture picture) {
        this.encodeVideo(streamIndex, picture, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeVideo(int streamIndex, BufferedImage image, long timeStamp, TimeUnit timeUnit) {
        if (null == image) {
            throw new IllegalArgumentException("NULL input image");
        }
        if (null == timeUnit) {
            throw new IllegalArgumentException("NULL time unit");
        }
        IStream stream = this.getStream(streamIndex);
        if (null == stream) {
            return;
        }
        IVideoPicture picture = this.convertToPicture(streamIndex, image, TimeUnit.MICROSECONDS.convert(timeStamp, timeUnit));
        try {
            this.encodeVideo(streamIndex, picture, image);
        }
        finally {
            if (picture != null) {
                picture.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAudio(int streamIndex, IAudioSamples samples) {
        if (null == samples) {
            throw new IllegalArgumentException("NULL input samples");
        }
        IStream stream = this.getStream(streamIndex);
        if (null == stream) {
            return;
        }
        IStreamCoder coder = stream.getStreamCoder();
        try {
            if (ICodec.Type.CODEC_TYPE_AUDIO != coder.getCodecType()) {
                throw new IllegalArgumentException("stream[" + streamIndex + "] is not audio");
            }
            int consumed = 0;
            while ((long)consumed < samples.getNumSamples()) {
                IPacket packet = IPacket.make();
                try {
                    int result = coder.encodeAudio(packet, samples, consumed);
                    if (result < 0) {
                        throw new RuntimeException("failed to encode audio");
                    }
                    consumed += result;
                    if (!packet.isComplete()) continue;
                    this.writePacket(packet);
                }
                finally {
                    if (packet == null) continue;
                    packet.delete();
                }
            }
            super.onAudioSamples(new AudioSamplesEvent(this, samples, streamIndex));
        }
        finally {
            if (coder != null) {
                coder.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAudio(int streamIndex, short[] samples, long timeStamp, TimeUnit timeUnit) {
        if (null == samples) {
            throw new IllegalArgumentException("NULL input samples");
        }
        IStream stream = this.getStream(streamIndex);
        if (null == stream) {
            return;
        }
        IStreamCoder coder = stream.getStreamCoder();
        try {
            long sampleCount = samples.length / coder.getChannels();
            IAudioSamples audioFrame = IAudioSamples.make(sampleCount, coder.getChannels());
            long timeStampMicro = timeUnit == null ? Global.NO_PTS : TimeUnit.MICROSECONDS.convert(timeStamp, timeUnit);
            audioFrame.setComplete(true, sampleCount, coder.getSampleRate(), coder.getChannels(), coder.getSampleFormat(), timeStampMicro);
            audioFrame.put(samples, 0, 0, samples.length);
            this.encodeAudio(streamIndex, audioFrame);
        }
        finally {
            if (coder != null) {
                coder.delete();
            }
        }
    }

    @Override
    public void encodeAudio(int streamIndex, short[] samples) {
        this.encodeAudio(streamIndex, samples, Global.NO_PTS, null);
    }

    private IVideoPicture convertToPicture(int streamIndex, BufferedImage image, long timeStamp) {
        IConverter videoConverter = this.mVideoConverters.get(streamIndex);
        if (videoConverter == null) {
            IStream stream = this.mStreams.get(streamIndex);
            IStreamCoder coder = stream.getStreamCoder();
            videoConverter = ConverterFactory.createConverter(ConverterFactory.findDescriptor(image), coder.getPixelType(), coder.getWidth(), coder.getHeight(), image.getWidth(), image.getHeight());
            this.mVideoConverters.put(streamIndex, videoConverter);
        }
        return videoConverter.toPicture(image, timeStamp);
    }

    private IStream getStream(int inputStreamIndex) {
        IStream stream;
        if (!this.isOpen()) {
            this.open();
        }
        if (null == this.getOutputStreamIndex(inputStreamIndex)) {
            if (this.getContainer().isHeaderWritten()) {
                if (this.willMaskLateStreamExceptions()) {
                    return null;
                }
                throw new RuntimeException("Input stream index " + inputStreamIndex + " has not been seen before, but the media header has already been written.  To mask these exceptions call setMaskLateStreamExceptions()");
            }
            if (null == this.mInputContainer) {
                throw new UnsupportedOperationException("MediaWriter can not yet create streams without an input container.");
            }
            if (!this.mInputContainer.isOpened()) {
                throw new RuntimeException("Can't get stream information from a closed input IContainer.");
            }
            for (int i = 0; i < this.mInputContainer.getNumStreams(); ++i) {
                if (null != this.mOutputStreamIndices.get(i)) continue;
                this.addStreamFromContainer(i);
            }
        }
        if (!this.getContainer().isHeaderWritten()) {
            for (IStream stream2 : this.mStreams.values()) {
                if (stream2.getStreamCoder().isOpen()) continue;
                this.openStream(stream2);
            }
            int rv = this.getContainer().writeHeader();
            if (0 != rv) {
                throw new RuntimeException("Error " + IError.make(rv) + ", failed to write header to container " + this.getContainer() + " while establishing stream " + this.mStreams.get(this.getOutputStreamIndex(inputStreamIndex)));
            }
            super.onWriteHeader(new WriteHeaderEvent(this));
        }
        if (null == (stream = this.mStreams.get(this.getOutputStreamIndex(inputStreamIndex)))) {
            throw new RuntimeException("invalid input stream index (no stream): " + inputStreamIndex);
        }
        IStreamCoder coder = stream.getStreamCoder();
        if (null == coder) {
            throw new RuntimeException("invalid input stream index (no coder): " + inputStreamIndex);
        }
        return stream;
    }

    @Override
    public boolean isSupportedCodecType(ICodec.Type type) {
        return ICodec.Type.CODEC_TYPE_VIDEO == type || ICodec.Type.CODEC_TYPE_AUDIO == type;
    }

    private boolean addStreamFromContainer(int inputStreamIndex) {
        IStream inputStream = this.mInputContainer.getStream(inputStreamIndex);
        IStreamCoder inputCoder = inputStream.getStreamCoder();
        ICodec.Type inputType = inputCoder.getCodecType();
        ICodec.ID inputID = inputCoder.getCodecID();
        if (!this.isSupportedCodecType(inputType)) {
            return false;
        }
        IContainerFormat format = this.getContainer().getContainerFormat();
        switch (inputType) {
            case CODEC_TYPE_AUDIO: {
                this.addAudioStream(inputStream.getIndex(), inputStream.getId(), format.establishOutputCodecId(inputID), inputCoder.getChannels(), inputCoder.getSampleRate());
                break;
            }
            case CODEC_TYPE_VIDEO: {
                this.addVideoStream(inputStream.getIndex(), inputStream.getId(), format.establishOutputCodecId(inputID), inputCoder.getFrameRate(), inputCoder.getWidth(), inputCoder.getHeight());
                break;
            }
        }
        return true;
    }

    private void addStream(IStream stream, int inputStreamIndex, int outputStreamIndex) {
        this.mOutputStreamIndices.put(inputStreamIndex, outputStreamIndex);
        this.mStreams.put(outputStreamIndex, stream);
        IStreamCoder coder = stream.getStreamCoder();
        if (ICodec.Type.CODEC_TYPE_VIDEO == coder.getCodecType()) {
            coder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
        }
        super.onAddStream(new AddStreamEvent(this, (Integer)outputStreamIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStream(IStream stream) {
        IStreamCoder coder = stream.getStreamCoder();
        try {
            ICodec.Type type = coder.getCodecType();
            if (!coder.isOpen() && this.isSupportedCodecType(type)) {
                int rv = coder.open(null, null);
                if (rv < 0) {
                    throw new RuntimeException("could not open stream " + stream + ": " + MediaWriter.getErrorMessage(rv));
                }
                this.mOpenedStreams.add(stream);
                super.onOpenCoder(new OpenCoderEvent(this, (Integer)stream.getIndex()));
            }
        }
        finally {
            coder.delete();
        }
    }

    private void writePacket(IPacket packet) {
        if (this.getContainer().writePacket(packet, this.mForceInterleave) < 0) {
            throw new RuntimeException("failed to write packet: " + packet);
        }
        super.onWritePacket(new WritePacketEvent((IMediaCoder)this, packet));
    }

    @Override
    public void flush() {
        long audioDts = 0L;
        long audioPts = 0L;
        long videoDts = 0L;
        long videoPts = 0L;
        for (IStream stream : this.mStreams.values()) {
            IPacket packet;
            IStreamCoder coder = stream.getStreamCoder();
            if (!coder.isOpen()) continue;
            if (ICodec.Type.CODEC_TYPE_AUDIO == coder.getCodecType()) {
                packet = IPacket.make();
                while (coder.encodeAudio(packet, null, 0L) >= 0 && packet.isComplete()) {
                    if (audioPts == 0L) {
                        audioDts = packet.getDts();
                        audioPts = packet.getPts();
                    } else {
                        packet.setPts(audioPts += packet.getDuration());
                        packet.setDts(audioDts += packet.getDuration());
                    }
                    this.writePacket(packet);
                    packet.delete();
                    packet = IPacket.make();
                }
                packet.delete();
                continue;
            }
            if (ICodec.Type.CODEC_TYPE_VIDEO != coder.getCodecType()) continue;
            packet = IPacket.make();
            while (coder.encodeVideo(packet, null, 0) >= 0 && packet.isComplete()) {
                if (videoPts == 0L) {
                    videoDts = packet.getDts();
                    videoPts = packet.getPts();
                } else {
                    packet.setPts(videoPts += packet.getDuration());
                    packet.setDts(videoDts += packet.getDuration());
                }
                this.writePacket(packet);
                packet.delete();
                packet = IPacket.make();
            }
            packet.delete();
        }
        this.getContainer().flushPackets();
        super.onFlush(new FlushEvent(this));
    }

    @Override
    public void open() {
        if (this.getContainer().open(this.getUrl(), IContainer.Type.WRITE, this.mContainerFormat, true, false) < 0) {
            throw new IllegalArgumentException("could not open: " + this.getUrl());
        }
        super.onOpen(new OpenEvent(this));
        this.setShouldCloseContainer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.flush();
        int rv = this.getContainer().writeTrailer();
        if (rv < 0) {
            throw new RuntimeException("error " + IError.make(rv) + ", failed to write trailer to " + this.getUrl());
        }
        super.onWriteTrailer(new WriteTrailerEvent(this));
        for (IStream stream : this.mOpenedStreams) {
            IStreamCoder coder = stream.getStreamCoder();
            try {
                rv = coder.close();
                if (rv < 0) {
                    throw new RuntimeException("error " + MediaWriter.getErrorMessage(rv) + ", failed close coder " + coder);
                }
                super.onCloseCoder(new CloseCoderEvent(this, (Integer)stream.getIndex()));
            }
            finally {
                coder.delete();
            }
        }
        this.mStreams.clear();
        this.mOpenedStreams.clear();
        this.mVideoConverters.clear();
        if (this.getShouldCloseContainer()) {
            rv = this.getContainer().close();
            if (rv < 0) {
                throw new RuntimeException("error " + IError.make(rv) + ", failed close IContainer " + this.getContainer() + " for " + this.getUrl());
            }
            this.setShouldCloseContainer(false);
        }
        super.onClose(new CloseEvent(this));
    }

    @Override
    public IPixelFormat.Type getDefaultPixelType() {
        return DEFAULT_PIXEL_TYPE;
    }

    @Override
    public IAudioSamples.Format getDefaultSampleFormat() {
        return DEFAULT_SAMPLE_FORMAT;
    }

    @Override
    public IRational getDefaultTimebase() {
        return DEFAULT_TIMEBASE.copyReference();
    }

    public String toString() {
        return "MediaWriter[" + this.getUrl() + "]";
    }

    @Override
    public void onOpen(IOpenEvent event) {
    }

    @Override
    public void onClose(ICloseEvent event) {
        if (this.isOpen()) {
            this.close();
        }
    }

    @Override
    public void onAddStream(IAddStreamEvent event) {
    }

    @Override
    public void onOpenCoder(IOpenCoderEvent event) {
    }

    @Override
    public void onCloseCoder(ICloseCoderEvent event) {
    }

    @Override
    public void onVideoPicture(IVideoPictureEvent event) {
        if (event.getImage() != null) {
            this.encodeVideo(event.getStreamIndex(), event.getImage(), event.getTimeStamp(event.getTimeUnit()), event.getTimeUnit());
        } else {
            this.encodeVideo(event.getStreamIndex(), event.getPicture());
        }
    }

    @Override
    public void onAudioSamples(IAudioSamplesEvent event) {
        this.encodeAudio((int)event.getStreamIndex(), event.getAudioSamples());
    }

    @Override
    public void onReadPacket(IReadPacketEvent event) {
    }

    @Override
    public void onWritePacket(IWritePacketEvent event) {
    }

    @Override
    public void onWriteHeader(IWriteHeaderEvent event) {
    }

    @Override
    public void onFlush(IFlushEvent event) {
    }

    @Override
    public void onWriteTrailer(IWriteTrailerEvent event) {
    }

    private static String getErrorMessage(int rv) {
        String errorString = "";
        IError error = IError.make(rv);
        if (error != null) {
            errorString = error.toString();
            error.delete();
        }
        return errorString;
    }

    static {
        JNIMemoryManager.setMemoryModel(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS);
        DEFAULT_PIXEL_TYPE = IPixelFormat.Type.YUV420P;
        DEFAULT_SAMPLE_FORMAT = IAudioSamples.Format.FMT_S16P;
        DEFAULT_TIMEBASE = IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND);
    }
}

