/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.JNIEnv;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JNIManifest {
    private static Logger log = LoggerFactory.getLogger(JNIManifest.class);
    private static final String XUGGLE_APP = "Xuggle-Native-App";
    private static final String XUGGLE_ROOT = "Xuggle-Native-Root";
    private static final String XUGGLE_PATH = "Xuggle-Native-Paths";
    private static final String XUGGLE_BUNDLES = "Xuggle-Native-Bundles";
    private final String mName;
    private final String mPath;
    private final String mCPU;
    private final String mOS;
    private final String mVendor;

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getCPU() {
        return this.mCPU;
    }

    public String getOS() {
        return this.mOS;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[");
        builder.append("name=");
        builder.append(this.mName);
        builder.append("; ");
        builder.append("path=");
        builder.append(this.mPath);
        builder.append("; ");
        builder.append("cpu=");
        builder.append(this.mCPU);
        builder.append("; ");
        builder.append("os=");
        builder.append(this.mOS);
        builder.append("; ");
        builder.append("vendor=");
        builder.append(this.mVendor);
        builder.append("; ");
        builder.append("]");
        return builder.toString();
    }

    public static JNIManifest create(URL url, String appName, Properties props) {
        String name = props.getProperty(XUGGLE_APP);
        String root = props.getProperty(XUGGLE_ROOT);
        String paths = props.getProperty(XUGGLE_PATH);
        String bundles = props.getProperty(XUGGLE_BUNDLES);
        return JNIManifest.create(url, appName, name, root, paths, bundles);
    }

    public static JNIManifest create(URL url, String appName, Manifest manifest) {
        Attributes attr = manifest.getMainAttributes();
        String name = attr.getValue(XUGGLE_APP);
        String root = attr.getValue(XUGGLE_ROOT);
        String paths = attr.getValue(XUGGLE_PATH);
        String bundles = attr.getValue(XUGGLE_BUNDLES);
        return JNIManifest.create(url, appName, name, root, paths, bundles);
    }

    public static JNIManifest create(URL url, String appName, String name, String root, String aPaths, String aBundles) {
        if (name == null || name.compareTo(name) != 0) {
            log.trace("{}: no match.  \"{}\" vs \"{}\"", XUGGLE_APP, appName, name);
            return null;
        }
        if (root == null) {
            return null;
        }
        if (aBundles == null) {
            return null;
        }
        if (aPaths == null) {
            return null;
        }
        StringTokenizer pathTokens = new StringTokenizer(aPaths, ";");
        StringTokenizer bundleTokens = new StringTokenizer(aBundles, ";");
        LinkedList<String> paths = new LinkedList<String>();
        LinkedList<String> bundles = new LinkedList<String>();
        while (pathTokens.hasMoreTokens()) {
            String path = pathTokens.nextToken();
            paths.add(path);
        }
        while (bundleTokens.hasMoreTokens()) {
            String bundle = bundleTokens.nextToken();
            bundles.add(bundle);
        }
        if (paths.size() != bundles.size()) {
            log.debug("path and bundle strings have different number of entries; invalid manifest: {}", (Object)appName);
            return null;
        }
        Iterator bundleIter = bundles.iterator();
        Iterator pathIter = paths.iterator();
        while (bundleIter.hasNext()) {
            String nativeOs;
            String bundle = (String)bundleIter.next();
            String path = (String)pathIter.next();
            StringTokenizer bundleParser = new StringTokenizer(bundle, "-");
            if (!bundleParser.hasMoreTokens()) continue;
            String nativeCpu = bundleParser.nextToken();
            if (!bundleParser.hasMoreTokens()) continue;
            String nativeVendor = bundleParser.nextToken();
            if (!bundleParser.hasMoreTokens() || !JNIManifest.validMatch(nativeCpu, nativeOs = bundleParser.nextToken())) continue;
            StringBuilder nativePath = new StringBuilder();
            if (!root.equals(".") && !root.equals("")) {
                nativePath.append(root);
                if (!root.endsWith("/")) {
                    nativePath.append("/");
                }
            }
            if (!path.equals(".") && !path.equals("")) {
                if (path.startsWith("/")) {
                    String subPath = path.substring(1);
                    nativePath.append(subPath);
                    if (!subPath.endsWith("/")) {
                        nativePath.append("/");
                    }
                } else {
                    nativePath.append(path);
                    if (!path.endsWith("/")) {
                        nativePath.append("/");
                    }
                }
            }
            JNIManifest retval = new JNIManifest(appName, nativePath.toString(), nativeCpu, nativeOs, nativeVendor);
            log.trace("found matching manifest: {}", (Object)retval);
            return retval;
        }
        return null;
    }

    private JNIManifest(String appName, String nativePath, String cpu, String os, String vendor) {
        this.mName = appName;
        this.mPath = nativePath;
        this.mCPU = cpu;
        this.mOS = os;
        this.mVendor = vendor;
    }

    private static boolean validMatch(String cpu, String os) {
        JNIEnv.OSFamily javaOs = JNIEnv.getEnv().getOSFamily();
        JNIEnv.OSFamily nativeOs = JNIEnv.getOSFamilyFromGNUString(os);
        if (nativeOs != JNIEnv.OSFamily.UNKNOWN && javaOs == nativeOs) {
            return JNIManifest.validMatchCPU(cpu);
        }
        return false;
    }

    private static boolean validMatchCPU(String aNativeCpu) {
        String nativeCpu = aNativeCpu.toLowerCase();
        JNIEnv.CPUArch javaArch = JNIEnv.getEnv().getCPUArch();
        JNIEnv.CPUArch nativeArch = nativeCpu.startsWith("universal") ? javaArch : JNIEnv.getCPUArchFromGNUString(nativeCpu);
        return nativeArch != JNIEnv.CPUArch.UNKNOWN && nativeArch == javaArch;
    }

    static enum OS {
        LINUX,
        MAC,
        WINDOZE,
        UNKNOWN;

    }

    static enum CPUArch {
        X86,
        X86_64,
        PPC,
        PPC64,
        ARM,
        ARM_64,
        UNKNOWN;

    }
}

