/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.TransferenceView;
import com.tonikelope.megabasterd.Upload;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UploadView
extends JPanel
implements TransferenceView {
    private final Upload _upload;
    private JLabel cbc_label;
    private JButton close_button;
    private JButton file_link_button;
    private JLabel file_name_label;
    private JLabel file_size_label;
    private JButton folder_link_button;
    private JButton open_browser_button;
    private JButton pause_button;
    private JProgressBar progress_pbar;
    private JButton queue_bottom_button;
    private JButton queue_down_button;
    private JButton queue_top_button;
    private JButton queue_up_button;
    private JButton restart_button;
    private JLabel slot_status_label;
    private JLabel slots_label;
    private JSpinner slots_spinner;
    private JLabel speed_label;
    private JLabel status_label;
    private JButton stop_button;
    private static final Logger LOG = Logger.getLogger(UploadView.class.getName());

    public JLabel getCbc_label() {
        return this.cbc_label;
    }

    public JButton getQueue_bottom_button() {
        return this.queue_bottom_button;
    }

    public JButton getQueue_top_button() {
        return this.queue_top_button;
    }

    public JLabel getSlot_status_label() {
        return this.slot_status_label;
    }

    public JSpinner getSlots_spinner() {
        return this.slots_spinner;
    }

    public JLabel getFile_name_label() {
        return this.file_name_label;
    }

    public JLabel getFile_size_label() {
        return this.file_size_label;
    }

    public JProgressBar getProgress_pbar() {
        return this.progress_pbar;
    }

    public JButton getRestart_button() {
        return this.restart_button;
    }

    public JButton getClose_button() {
        return this.close_button;
    }

    public JButton getPause_button() {
        return this.pause_button;
    }

    public JLabel getSlots_label() {
        return this.slots_label;
    }

    public JLabel getSpeed_label() {
        return this.speed_label;
    }

    public JButton getStop_button() {
        return this.stop_button;
    }

    public JButton getFile_link_button() {
        return this.file_link_button;
    }

    public JButton getFolder_link_button() {
        return this.folder_link_button;
    }

    public JButton getOpen_browser_button() {
        return this.open_browser_button;
    }

    public JLabel getStatus_label() {
        return this.status_label;
    }

    public JButton getQueue_down_button() {
        return this.queue_down_button;
    }

    public JButton getQueue_up_button() {
        return this.queue_up_button;
    }

    public UploadView(Upload upload) {
        this._upload = upload;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, upload.getMain_panel().getZoom_factor());
            MiscTools.translateLabels(this);
            this.slots_spinner.setModel(new SpinnerNumberModel(this._upload.getMain_panel().getDefault_slots_up(), 1, 20, 1));
            ((JSpinner.DefaultEditor)this.slots_spinner.getEditor()).getTextField().setEditable(false);
            this.speed_label.setForeground(new Color(0, 128, 255));
            this.progress_pbar.setMinimum(0);
            this.progress_pbar.setMaximum(Integer.MAX_VALUE);
            this.progress_pbar.setStringPainted(true);
            this.status_label.setText("");
            for (JComponent c : new JComponent[]{this.queue_up_button, this.queue_down_button, this.queue_top_button, this.queue_bottom_button, this.cbc_label, this.slots_spinner, this.slots_label, this.pause_button, this.stop_button, this.speed_label, this.progress_pbar, this.file_name_label, this.close_button, this.restart_button, this.file_size_label}) {
                c.setVisible(false);
            }
            if (upload.getFolder_link() == null) {
                this.folder_link_button.setVisible(false);
                this.open_browser_button.setVisible(false);
            }
        });
    }

    private void initComponents() {
        this.status_label = new JLabel();
        this.slots_label = new JLabel();
        this.slots_spinner = new JSpinner();
        this.speed_label = new JLabel();
        this.progress_pbar = new JProgressBar();
        this.pause_button = new JButton();
        this.stop_button = new JButton();
        this.file_name_label = new JLabel();
        this.close_button = new JButton();
        this.restart_button = new JButton();
        this.file_size_label = new JLabel();
        this.slot_status_label = new JLabel();
        this.folder_link_button = new JButton();
        this.file_link_button = new JButton();
        this.queue_up_button = new JButton();
        this.queue_down_button = new JButton();
        this.cbc_label = new JLabel();
        this.queue_top_button = new JButton();
        this.queue_bottom_button = new JButton();
        this.open_browser_button = new JButton();
        this.setBorder(new LineBorder(new Color(153, 204, 255), 3, true));
        this.status_label.setFont(new Font("Dialog", 1, 20));
        this.status_label.setForeground(new Color(102, 102, 102));
        this.status_label.setText("status");
        this.status_label.setDoubleBuffered(true);
        this.slots_label.setFont(new Font("Dialog", 1, 18));
        this.slots_label.setText("Slots");
        this.slots_label.setDoubleBuffered(true);
        this.slots_spinner.setFont(new Font("Dialog", 0, 18));
        this.slots_spinner.setToolTipText("Slots");
        this.slots_spinner.setDoubleBuffered(true);
        this.slots_spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UploadView.this.slots_spinnerStateChanged(evt);
            }
        });
        this.speed_label.setFont(new Font("Dialog", 1, 26));
        this.speed_label.setHorizontalAlignment(2);
        this.speed_label.setText("speed");
        this.speed_label.setDoubleBuffered(true);
        this.progress_pbar.setFont(new Font("Dialog", 1, 18));
        this.progress_pbar.setDoubleBuffered(true);
        this.pause_button.setBackground(new Color(255, 153, 0));
        this.pause_button.setFont(new Font("Dialog", 1, 16));
        this.pause_button.setForeground(Color.white);
        this.pause_button.setText("PAUSE UPLOAD");
        this.pause_button.setDoubleBuffered(true);
        this.pause_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.pause_buttonActionPerformed(evt);
            }
        });
        this.stop_button.setBackground(new Color(255, 0, 0));
        this.stop_button.setFont(new Font("Dialog", 1, 16));
        this.stop_button.setForeground(Color.white);
        this.stop_button.setText("CANCEL UPLOAD");
        this.stop_button.setDoubleBuffered(true);
        this.stop_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.stop_buttonActionPerformed(evt);
            }
        });
        this.file_name_label.setFont(new Font("Dialog", 1, 20));
        this.file_name_label.setForeground(new Color(0, 102, 153));
        this.file_name_label.setText("---");
        this.file_name_label.setDoubleBuffered(true);
        this.close_button.setFont(new Font("Dialog", 1, 16));
        this.close_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cancel-30.png")));
        this.close_button.setText("Close");
        this.close_button.setDoubleBuffered(true);
        this.close_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.close_buttonActionPerformed(evt);
            }
        });
        this.restart_button.setFont(new Font("Dialog", 1, 16));
        this.restart_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-restart-30.png")));
        this.restart_button.setText("Restart");
        this.restart_button.setDoubleBuffered(true);
        this.restart_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.restart_buttonActionPerformed(evt);
            }
        });
        this.file_size_label.setFont(new Font("Dialog", 1, 20));
        this.file_size_label.setForeground(new Color(0, 102, 153));
        this.file_size_label.setText("---");
        this.file_size_label.setDoubleBuffered(true);
        this.slot_status_label.setFont(new Font("Dialog", 1, 16));
        this.slot_status_label.setHorizontalAlignment(4);
        this.slot_status_label.setDoubleBuffered(true);
        this.folder_link_button.setFont(new Font("Dialog", 1, 16));
        this.folder_link_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.folder_link_button.setText("Copy folder link");
        this.folder_link_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.folder_link_buttonActionPerformed(evt);
            }
        });
        this.file_link_button.setFont(new Font("Dialog", 1, 16));
        this.file_link_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.file_link_button.setText("Copy file link");
        this.file_link_button.setEnabled(false);
        this.file_link_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.file_link_buttonActionPerformed(evt);
            }
        });
        this.queue_up_button.setFont(new Font("Dialog", 1, 18));
        this.queue_up_button.setIcon(new ImageIcon(this.getClass().getResource("/images/arriba_1.png")));
        this.queue_up_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.queue_up_buttonActionPerformed(evt);
            }
        });
        this.queue_down_button.setFont(new Font("Dialog", 1, 18));
        this.queue_down_button.setIcon(new ImageIcon(this.getClass().getResource("/images/abajo_1.png")));
        this.queue_down_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.queue_down_buttonActionPerformed(evt);
            }
        });
        this.cbc_label.setFont(new Font("Dialog", 1, 18));
        this.cbc_label.setForeground(new Color(102, 102, 102));
        this.cbc_label.setText("CBC-MAC 000%");
        this.cbc_label.setDoubleBuffered(true);
        this.queue_top_button.setFont(new Font("Dialog", 1, 14));
        this.queue_top_button.setIcon(new ImageIcon(this.getClass().getResource("/images/arrow_up.png")));
        this.queue_top_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.queue_top_buttonActionPerformed(evt);
            }
        });
        this.queue_bottom_button.setFont(new Font("Dialog", 1, 14));
        this.queue_bottom_button.setIcon(new ImageIcon(this.getClass().getResource("/images/arrow_down.png")));
        this.queue_bottom_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.queue_bottom_buttonActionPerformed(evt);
            }
        });
        this.open_browser_button.setFont(new Font("Dialog", 1, 16));
        this.open_browser_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-export-30.png")));
        this.open_browser_button.setText("Open folder in browser");
        this.open_browser_button.setDoubleBuffered(true);
        this.open_browser_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadView.this.open_browser_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progress_pbar, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.file_size_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.open_browser_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folder_link_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.file_link_button)).addGroup(layout.createSequentialGroup().addComponent(this.file_name_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slot_status_label)).addGroup(layout.createSequentialGroup().addComponent(this.speed_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pause_button)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.close_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restart_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.stop_button)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.queue_top_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queue_up_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queue_down_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queue_bottom_button).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.status_label, -1, 446, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.cbc_label))).addGap(18, 18, 18).addComponent(this.slots_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slots_spinner, -2, 70, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.queue_up_button).addComponent(this.queue_top_button).addComponent(this.queue_down_button).addComponent(this.queue_bottom_button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.slots_spinner, -2, 32, -2).addComponent(this.slots_label).addComponent(this.status_label).addComponent(this.cbc_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.file_name_label).addComponent(this.slot_status_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.open_browser_button).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folder_link_button).addComponent(this.file_link_button).addComponent(this.file_size_label))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress_pbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speed_label).addComponent(this.pause_button)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close_button).addComponent(this.restart_button)).addComponent(this.stop_button)).addContainerGap()));
    }

    private void slots_spinnerStateChanged(ChangeEvent evt) {
        MainPanel.THREAD_POOL.execute(this._upload::checkSlotsAndWorkers);
    }

    private void close_buttonActionPerformed(ActionEvent evt) {
        this._upload.close();
    }

    private void restart_buttonActionPerformed(ActionEvent evt) {
        this._upload.restart();
    }

    private void stop_buttonActionPerformed(ActionEvent evt) {
        this._upload.stop();
    }

    private void pause_buttonActionPerformed(ActionEvent evt) {
        this._upload.pause();
    }

    public void hideAllExceptStatus() {
        MiscTools.GUIRunAndWait(() -> {
            for (JComponent c : new JComponent[]{this.speed_label, this.slots_spinner, this.slots_label, this.slot_status_label, this.pause_button, this.stop_button, this.progress_pbar, this.cbc_label}) {
                c.setVisible(false);
            }
            for (JComponent c : new JComponent[]{this.status_label, this.file_name_label, this.file_size_label}) {
                c.setVisible(true);
            }
        });
    }

    private void folder_link_buttonActionPerformed(ActionEvent evt) {
        this.folder_link_button.setEnabled(false);
        this.folder_link_button.setText(LabelTranslatorSingleton.getInstance().translate("Please wait..."));
        MiscTools.copyTextToClipboard("[" + this._upload.getMa().getEmail() + "] " + this._upload.getFolder_link());
        this.folder_link_button.setText(LabelTranslatorSingleton.getInstance().translate("Copy folder link"));
        this.folder_link_button.setEnabled(true);
    }

    private void file_link_buttonActionPerformed(ActionEvent evt) {
        this.file_link_button.setEnabled(false);
        this.file_link_button.setText(LabelTranslatorSingleton.getInstance().translate("Please wait..."));
        MiscTools.copyTextToClipboard("[" + this._upload.getMa().getEmail() + "] " + this._upload.getFile_link());
        this.file_link_button.setText(LabelTranslatorSingleton.getInstance().translate("Copy file link"));
        this.file_link_button.setEnabled(true);
    }

    private void queue_up_buttonActionPerformed(ActionEvent evt) {
        this.queue_up_button.setEnabled(false);
        MainPanel.THREAD_POOL.execute(() -> {
            this._upload.upWaitQueue();
            MiscTools.GUIRunAndWait(() -> this.queue_up_button.setEnabled(true));
        });
    }

    private void queue_down_buttonActionPerformed(ActionEvent evt) {
        this.queue_down_button.setEnabled(false);
        MainPanel.THREAD_POOL.execute(() -> {
            this._upload.downWaitQueue();
            MiscTools.GUIRunAndWait(() -> this.queue_down_button.setEnabled(true));
        });
    }

    private void queue_top_buttonActionPerformed(ActionEvent evt) {
        this.queue_top_button.setEnabled(false);
        MainPanel.THREAD_POOL.execute(() -> {
            this._upload.topWaitQueue();
            MiscTools.GUIRunAndWait(() -> this.queue_top_button.setEnabled(true));
        });
    }

    private void queue_bottom_buttonActionPerformed(ActionEvent evt) {
        this.queue_bottom_button.setEnabled(false);
        MainPanel.THREAD_POOL.execute(() -> {
            this._upload.bottomWaitQueue();
            MiscTools.GUIRunAndWait(() -> this.queue_bottom_button.setEnabled(true));
        });
    }

    private void open_browser_buttonActionPerformed(ActionEvent evt) {
        MiscTools.openBrowserURL(this._upload.getFolder_link());
    }

    public void updateCBC(String status) {
        MiscTools.GUIRunAndWait(() -> this.cbc_label.setText(status));
    }

    @Override
    public void pause() {
        this.printStatusNormal("Pausing upload ...");
        MiscTools.GUIRunAndWait(() -> {
            for (JComponent c : new JComponent[]{this.pause_button, this.speed_label, this.slots_label, this.slots_spinner, this.progress_pbar, this.file_name_label, this.file_size_label}) {
                c.setEnabled(false);
            }
            for (JComponent c : new JComponent[]{this.stop_button}) {
                c.setVisible(true);
            }
        });
    }

    @Override
    public void stop(String status) {
        this.printStatusNormal(status);
        MiscTools.GUIRunAndWait(() -> {
            for (JComponent c : new JComponent[]{this.pause_button, this.stop_button, this.speed_label, this.slots_label, this.slots_spinner, this.progress_pbar, this.file_name_label, this.file_size_label}) {
                c.setEnabled(false);
            }
        });
    }

    @Override
    public void resume() {
        this.printStatusNormal("Uploading file to mega ...");
        MiscTools.GUIRunAndWait(() -> {
            for (JComponent c : new JComponent[]{this.pause_button, this.speed_label, this.slots_label, this.slots_spinner, this.progress_pbar, this.file_name_label, this.file_size_label}) {
                c.setEnabled(true);
            }
            for (JComponent c : new JComponent[]{this.stop_button}) {
                c.setVisible(false);
            }
            this.pause_button.setText(LabelTranslatorSingleton.getInstance().translate("PAUSE UPLOAD"));
            this._upload.getMain_panel().getView().getPause_all_up_button().setVisible(true);
        });
    }

    @Override
    public void updateSpeed(String speed, Boolean visible) {
        MiscTools.GUIRunAndWait(() -> {
            if (speed != null) {
                this.speed_label.setText(speed);
            }
            if (visible != null) {
                this.speed_label.setVisible(visible);
            }
        });
    }

    @Override
    public void updateProgressBar(long progress, double bar_rate) {
        MiscTools.GUIRunAndWait(() -> this.progress_pbar.setValue((int)Math.floor(bar_rate * (double)progress)));
    }

    @Override
    public void updateProgressBar(int value) {
        MiscTools.GUIRunAndWait(() -> this.progress_pbar.setValue(value));
    }

    @Override
    public void printStatusError(String message) {
        MiscTools.GUIRunAndWait(() -> {
            this.status_label.setForeground(Color.red);
            this.status_label.setText(LabelTranslatorSingleton.getInstance().translate(message));
        });
    }

    @Override
    public void printStatusOK(String message) {
        MiscTools.GUIRunAndWait(() -> {
            this.status_label.setForeground(new Color(0, 170, 0));
            this.status_label.setText(LabelTranslatorSingleton.getInstance().translate(message));
        });
    }

    @Override
    public void printStatusNormal(String message) {
        MiscTools.GUIRunAndWait(() -> {
            this.status_label.setForeground(new Color(102, 102, 102));
            this.status_label.setText(LabelTranslatorSingleton.getInstance().translate(message));
        });
    }

    public void printStatusWarning(String message) {
        MiscTools.GUIRunAndWait(() -> {
            this.status_label.setForeground(new Color(255, 0, 255));
            this.status_label.setText(LabelTranslatorSingleton.getInstance().translate(message));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSlotsStatus() {
        Object object = this._upload.getWorkers_lock();
        synchronized (object) {
            int conta_error = 0;
            conta_error = this._upload.getChunkworkers().stream().filter(c -> c.isError_wait()).map(_item -> 1).reduce(conta_error, Integer::sum);
            String status = conta_error > 0 ? "(" + String.valueOf(conta_error) + ")" : "";
            MiscTools.GUIRun(() -> {
                this.slot_status_label.setForeground(Color.RED);
                this.slot_status_label.setText(status);
            });
        }
    }

    @Override
    public int getSlots() {
        try {
            return (Integer)MiscTools.futureRun(this.getSlots_spinner()::getValue).get();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(UploadView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(UploadView.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }
}

