/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.Transference;
import com.tonikelope.megabasterd.TransferenceManager;
import com.tonikelope.megabasterd.Upload;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploadManager
extends TransferenceManager {
    private static final Logger LOG = Logger.getLogger(UploadManager.class.getName());
    private final Object _log_file_lock = new Object();

    public UploadManager(MainPanel main_panel) {
        super(main_panel, main_panel.getMax_ul(), main_panel.getView().getStatus_up_label(), main_panel.getView().getjPanel_scroll_up(), main_panel.getView().getClose_all_finished_up_button(), main_panel.getView().getPause_all_up_button(), main_panel.getView().getClean_all_up_menu());
    }

    public Object getLog_file_lock() {
        return this._log_file_lock;
    }

    @Override
    public void provision(Transference upload) {
        MiscTools.GUIRun(() -> this.getScroll_panel().add(((Upload)upload).getView()));
        ((Upload)upload).provisionIt();
        if (((Upload)upload).isProvision_ok()) {
            this.increment_total_size(upload.getFile_size());
            this.getTransference_waitstart_aux_queue().add(upload);
        } else {
            this.getTransference_finished_queue().add(upload);
        }
        this.secureNotify();
    }

    @Override
    public void remove(Transference[] uploads) {
        ArrayList<String[]> delete_up = new ArrayList<String[]>();
        for (Transference u : uploads) {
            MiscTools.GUIRun(() -> this.getScroll_panel().remove(((Upload)u).getView()));
            this.getTransference_waitstart_queue().remove(u);
            this.getTransference_running_list().remove(u);
            this.getTransference_finished_queue().remove(u);
            this.increment_total_size(-1L * u.getFile_size());
            this.increment_total_progress(-1L * u.getProgress());
            if (u.isCanceled() && !u.isClosed()) continue;
            delete_up.add(new String[]{u.getFile_name(), ((Upload)u).getMa().getFull_email()});
        }
        try {
            DBTools.deleteUploads((String[][])delete_up.toArray((T[])new String[delete_up.size()][]));
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.secureNotify();
    }

    public int copyAllLinksToClipboard() {
        Upload up;
        int total = 0;
        ArrayList<String> links = new ArrayList<String>();
        String out = "";
        for (Transference t : this._transference_waitstart_aux_queue) {
            up = (Upload)t;
            links.add(up.getFile_name() + " [" + up.getMa().getEmail() + "] " + (up.getFolder_link() != null ? up.getFolder_link() : ""));
        }
        for (Transference t : this._transference_waitstart_queue) {
            up = (Upload)t;
            links.add(up.getFile_name() + " [" + up.getMa().getEmail() + "] " + (up.getFolder_link() != null ? up.getFolder_link() : ""));
        }
        out = out + String.join((CharSequence)"\r\n", links);
        total += links.size();
        links.clear();
        for (Transference t : this._transference_running_list) {
            up = (Upload)t;
            links.add(up.getFile_name() + " [" + up.getMa().getEmail() + "] " + (up.getFolder_link() != null ? up.getFolder_link() : "") + (up.getFile_link() != null ? " " + up.getFile_link() : ""));
        }
        out = out + String.join((CharSequence)"\r\n", links);
        total += links.size();
        links.clear();
        for (Transference t : this._transference_finished_queue) {
            up = (Upload)t;
            links.add("(UPLOAD FINISHED) " + up.getFile_name() + " [" + up.getMa().getEmail() + "] " + (up.getFolder_link() != null ? up.getFolder_link() : "") + (up.getFile_link() != null ? " " + up.getFile_link() : ""));
        }
        out = out + String.join((CharSequence)"\r\n", links);
        MiscTools.copyTextToClipboard(out);
        return total += links.size();
    }
}

