/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.ChunkWriterManager;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.Upload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class UploadMACGenerator
implements Runnable,
SecureSingleThreadNotifiable {
    private static final Logger LOG = Logger.getLogger(UploadMACGenerator.class.getName());
    private final Upload _upload;
    private final Object _secure_notify_lock;
    private volatile boolean _notified = false;
    private volatile boolean _exit;
    public final ConcurrentHashMap<Long, ByteArrayOutputStream> CHUNK_QUEUE = new ConcurrentHashMap();

    public UploadMACGenerator(Upload upload) {
        this._secure_notify_lock = new Object();
        this._upload = upload;
        this._exit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified = false;
        }
    }

    public Upload getUpload() {
        return this._upload;
    }

    public boolean isExit() {
        return this._exit;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} MAC GENERATOR {1} Hello!", new Object[]{Thread.currentThread().getName(), this.getUpload().getFile_name()});
        try {
            long chunk_id = 1L;
            long tot = 0L;
            boolean mac = false;
            int cbc_per = 0;
            int[] file_mac = new int[]{0, 0, 0, 0};
            HashMap<String, Object> upload_progress = DBTools.selectUploadProgress(this._upload.getFile_name(), this._upload.getMa().getFull_email());
            if (upload_progress != null && (String)upload_progress.get("meta_mac") != null) {
                String[] temp_meta_mac = ((String)upload_progress.get("meta_mac")).split("#");
                tot = Long.valueOf(temp_meta_mac[0]);
                chunk_id = Long.valueOf(temp_meta_mac[1]);
                file_mac = MiscTools.bin2i32a(MiscTools.BASE642Bin(temp_meta_mac[2]));
                cbc_per = (int)((double)tot / (double)this._upload.getFile_size() * 100.0);
                this._upload.getView().updateCBC("CBC-MAC " + String.valueOf(cbc_per) + "%");
            }
            int[] file_iv = MiscTools.bin2i32a(this._upload.getByte_file_iv());
            int[] mac_iv = CryptTools.AES_ZERO_IV_I32A;
            Cipher cryptor = CryptTools.genCrypter("AES", "AES/CBC/NoPadding", this._upload.getByte_file_key(), MiscTools.i32a2bin(mac_iv));
            int[] chunk_mac = new int[4];
            byte[] byte_block = new byte[16];
            try {
                while (!(this._exit || this._upload.isStopped() || this._upload.getMain_panel().isExit())) {
                    long chunk_offset = ChunkWriterManager.calculateChunkOffset(chunk_id, 1);
                    long chunk_size = ChunkWriterManager.calculateChunkSize(chunk_id, this._upload.getFile_size(), chunk_offset, 1);
                    ChunkWriterManager.checkChunkID(chunk_id, this._upload.getFile_size(), chunk_offset);
                    while (!this.CHUNK_QUEUE.containsKey(chunk_offset)) {
                        MiscTools.pausar(1000L);
                    }
                    try {
                        byte[] chunk_bytes;
                        chunk_mac[0] = file_iv[0];
                        chunk_mac[1] = file_iv[1];
                        chunk_mac[2] = file_iv[0];
                        chunk_mac[3] = file_iv[1];
                        long conta_chunk = 0L;
                        try (ByteArrayOutputStream baos = this.CHUNK_QUEUE.remove(chunk_offset);){
                            chunk_bytes = baos.toByteArray();
                        }
                        try (ByteArrayInputStream bais = new ByteArrayInputStream(chunk_bytes);){
                            int reads;
                            while (conta_chunk < chunk_size && (reads = bais.read(byte_block)) != -1) {
                                int i;
                                if (reads < byte_block.length) {
                                    for (i = reads; i < byte_block.length; ++i) {
                                        byte_block[i] = 0;
                                    }
                                }
                                int[] int_block = MiscTools.bin2i32a(byte_block);
                                for (i = 0; i < chunk_mac.length; ++i) {
                                    int n = i;
                                    chunk_mac[n] = chunk_mac[n] ^ int_block[i];
                                }
                                chunk_mac = MiscTools.bin2i32a(cryptor.doFinal(MiscTools.i32a2bin(chunk_mac)));
                                conta_chunk += (long)reads;
                                tot += (long)reads;
                            }
                        }
                        for (int i = 0; i < file_mac.length; ++i) {
                            int n = i;
                            file_mac[n] = file_mac[n] ^ chunk_mac[i];
                        }
                        file_mac = MiscTools.bin2i32a(cryptor.doFinal(MiscTools.i32a2bin(file_mac)));
                    }
                    catch (BadPaddingException | IllegalBlockSizeException ex) {
                        LOG.log(Level.SEVERE, ex.getMessage());
                    }
                    ++chunk_id;
                    int new_cbc_per = (int)((double)tot / (double)this._upload.getFile_size() * 100.0);
                    if (new_cbc_per == cbc_per) continue;
                    this._upload.getView().updateCBC("CBC-MAC " + String.valueOf(new_cbc_per) + "%");
                    cbc_per = new_cbc_per;
                }
                mac = tot == this._upload.getFile_size();
            }
            catch (ChunkInvalidException e) {
                mac = true;
            }
            this._upload.setTemp_mac_data(String.valueOf(tot) + "#" + String.valueOf(chunk_id) + "#" + MiscTools.Bin2BASE64(MiscTools.i32a2bin(file_mac)));
            if (mac) {
                int[] meta_mac = new int[]{file_mac[0] ^ file_mac[1], file_mac[2] ^ file_mac[3]};
                this._upload.setFile_meta_mac(meta_mac);
                LOG.log(Level.INFO, "{0} MAC GENERATOR {1} finished MAC CALCULATION. Waiting workers to finish uploading (if any)...", new Object[]{Thread.currentThread().getName(), this.getUpload().getFile_name()});
            }
            while (!(this._exit || this._upload.isStopped() || this._upload.getChunkworkers().isEmpty())) {
                while (this._upload.getMain_panel().isExit()) {
                    this._upload.secureNotifyWorkers();
                    this.secureWait();
                }
                this.secureWait();
            }
            this._upload.secureNotify();
            LOG.log(Level.INFO, "{0} MAC GENERATOR {1} BYE BYE...", new Object[]{Thread.currentThread().getName(), this.getUpload().getFile_name()});
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
    }
}

