/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.MiscTools;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Thumbnailer {
    public static final int IMAGE_THUMB_SIZE = 250;
    public static final float SECONDS_BETWEEN_FRAMES_PERC = 0.03f;
    private long nano_seconds_between_frames;
    private long mLastPtsWrite = Global.NO_PTS;
    private int conta_frames = 0;

    private String processFrame(IVideoPicture picture, BufferedImage image) {
        try {
            if (this.mLastPtsWrite == Global.NO_PTS) {
                this.mLastPtsWrite = picture.getPts() - this.nano_seconds_between_frames;
            }
            if (picture.getPts() - this.mLastPtsWrite >= this.nano_seconds_between_frames) {
                if (this.conta_frames == 1) {
                    File file = File.createTempFile("megabasterd_thumbnail_" + MiscTools.genID(20), ".jpg");
                    ImageIO.write((RenderedImage)image, "jpg", file);
                    ++this.conta_frames;
                    return file.getAbsolutePath();
                }
                ++this.conta_frames;
                this.mLastPtsWrite += this.nano_seconds_between_frames;
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String createThumbnail(String filename) {
        try {
            if (MiscTools.isVideoFile(filename)) {
                return this.createVideoThumbnail(filename);
            }
            if (MiscTools.isImageFile(filename)) {
                return this.createImageThumbnail(filename);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createImageThumbnail(String filename) {
        try {
            BufferedImage imagen_original = ImageIO.read(new File(filename));
            if (imagen_original.getHeight() <= 250) {
                return filename;
            }
            int h = 250;
            int w = Math.round((float)imagen_original.getWidth() * (float)h / (float)imagen_original.getHeight());
            BufferedImage newImage = new BufferedImage(w, h, imagen_original.getType());
            Graphics2D g = newImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(imagen_original, 0, 0, w, h, null);
            g.dispose();
            File file = File.createTempFile("megabasterd_thumbnail_" + MiscTools.genID(20), ".png");
            ImageIO.write((RenderedImage)newImage, "png", file);
            return file.getAbsolutePath();
        }
        catch (Exception ex) {
            Logger.getLogger(Thumbnailer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String createVideoThumbnail(String filename) {
        if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        this.nano_seconds_between_frames = Global.DEFAULT_PTS_PER_SECOND * (long)Math.round(0.03f * (float)container.getDuration() / 1000000.0f);
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            videoCoder = coder;
            break;
        }
        if (videoStreamId == -1) {
            throw new RuntimeException("could not find video stream in container: " + filename);
        }
        if (videoCoder.open() < 0) {
            throw new RuntimeException("could not open video decoder for container: " + filename);
        }
        IVideoResampler resampler = null;
        if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make(videoCoder.getWidth(), videoCoder.getHeight(), IPixelFormat.Type.BGR24, videoCoder.getWidth(), videoCoder.getHeight(), videoCoder.getPixelType())) == null) {
            throw new RuntimeException("could not create color space resampler for: " + filename);
        }
        IPacket packet = IPacket.make();
        String frame_file = null;
        while (container.readNextPacket(packet) >= 0 && this.conta_frames < 2) {
            int bytesDecoded;
            if (packet.getStreamIndex() != videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding video in: " + filename);
            }
        }
        if (videoCoder != null) {
            videoCoder.close();
            videoCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
        return frame_file;
    }
}

