/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.StreamThrottlerSupervisor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class ThrottledOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getLogger(ThrottledOutputStream.class.getName());
    private final OutputStream _rawStream;
    private final StreamThrottlerSupervisor _stream_supervisor;
    private Integer _slice_size;

    public ThrottledOutputStream(OutputStream rawStream, StreamThrottlerSupervisor stream_supervisor) {
        this._rawStream = rawStream;
        this._stream_supervisor = stream_supervisor;
        this._slice_size = null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._stream_supervisor.getMaxBytesPerSecOutput() > 0) {
            int written = 0;
            do {
                this.throttle(len - written);
                this._rawStream.write(b, off + written, this._slice_size != null ? this._slice_size : len - written);
            } while ((written += this._slice_size != null ? this._slice_size : len - written) < len);
        } else {
            this._rawStream.write(b, off, len);
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (this._stream_supervisor.getMaxBytesPerSecOutput() > 0) {
            this.throttle(1);
        }
        this._rawStream.write(i);
    }

    private void throttle(int req_slice_size) throws IOException {
        this._slice_size = null;
        while (this._stream_supervisor.getMaxBytesPerSecOutput() > 0 && (this._stream_supervisor.isQueue_swapping() || (this._slice_size = this._stream_supervisor.getOutput_slice_queue().poll()) == null)) {
            this._stream_supervisor.secureWait();
        }
        if (this._slice_size != null && req_slice_size < this._slice_size) {
            if (!this._stream_supervisor.isQueue_swapping()) {
                this._stream_supervisor.getOutput_slice_queue().add(this._slice_size - req_slice_size);
                this._stream_supervisor.secureNotifyAll();
            }
            this._slice_size = req_slice_size;
        }
    }
}

