/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.StreamThrottlerSupervisor;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class ThrottledInputStream
extends InputStream {
    private static final Logger LOG = Logger.getLogger(ThrottledInputStream.class.getName());
    private final InputStream _rawStream;
    private final StreamThrottlerSupervisor _stream_supervisor;
    private Integer _slice_size;
    private boolean _stream_finish;

    public ThrottledInputStream(InputStream rawStream, StreamThrottlerSupervisor stream_supervisor) {
        this._rawStream = rawStream;
        this._stream_supervisor = stream_supervisor;
        this._stream_finish = false;
        this._slice_size = null;
    }

    @Override
    public int read() throws IOException {
        if (this._stream_supervisor.getMaxBytesPerSecInput() > 0) {
            if (!this._stream_finish) {
                this.throttle(1);
                int r = this._rawStream.read();
                if (r == -1) {
                    this._stream_finish = true;
                }
                return r;
            }
            return -1;
        }
        int r = this._rawStream.read();
        if (r == -1) {
            this._stream_finish = true;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = b.length;
        if (this._stream_supervisor.getMaxBytesPerSecInput() > 0) {
            if (!this._stream_finish) {
                this.throttle(len);
                int readLen = this._rawStream.read(b, 0, this._slice_size != null ? this._slice_size : len);
                if (readLen == -1) {
                    this._stream_finish = true;
                } else if (this._slice_size != null && readLen < this._slice_size && !this._stream_supervisor.isQueue_swapping()) {
                    this._stream_supervisor.getInput_slice_queue().add(this._slice_size - readLen);
                    this._stream_supervisor.secureNotifyAll();
                }
                return readLen;
            }
            return -1;
        }
        return this._rawStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._stream_supervisor.getMaxBytesPerSecInput() > 0) {
            if (!this._stream_finish) {
                this.throttle(len);
                int readLen = this._rawStream.read(b, off, this._slice_size != null ? this._slice_size : len);
                if (readLen == -1) {
                    this._stream_finish = true;
                } else if (this._slice_size != null && readLen < this._slice_size && !this._stream_supervisor.isQueue_swapping()) {
                    this._stream_supervisor.getInput_slice_queue().add(this._slice_size - readLen);
                    this._stream_supervisor.secureNotifyAll();
                }
                return readLen;
            }
            return -1;
        }
        return this._rawStream.read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this._stream_finish = false;
        this._rawStream.reset();
    }

    private void throttle(int req_slice_size) throws IOException {
        this._slice_size = null;
        while (this._stream_supervisor.getMaxBytesPerSecInput() > 0 && (this._stream_supervisor.isQueue_swapping() || (this._slice_size = this._stream_supervisor.getInput_slice_queue().poll()) == null)) {
            this._stream_supervisor.secureWait();
        }
        if (this._slice_size != null && req_slice_size < this._slice_size) {
            if (!this._stream_supervisor.isQueue_swapping()) {
                this._stream_supervisor.getInput_slice_queue().add(this._slice_size - req_slice_size);
                this._stream_supervisor.secureNotifyAll();
            }
            this._slice_size = req_slice_size;
        }
    }
}

