/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ClipboardChangeObserver;
import com.tonikelope.megabasterd.ClipboardSpy;
import com.tonikelope.megabasterd.ContextMenuMouseListener;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class StreamerDialog
extends JDialog
implements ClipboardChangeObserver {
    private final ClipboardSpy _clipboardspy;
    private final MainPanelView _mainPanelView;
    private final MainPanel _main_panel;
    private String _selected_item;
    private JButton dance_button;
    private JTextField original_link_textfield;
    private JLabel put_label;
    private JComboBox<String> use_mega_account_down_combobox;
    private JLabel use_mega_account_down_label;
    private static final Logger LOG = Logger.getLogger(StreamerDialog.class.getName());

    public JButton getDance_button() {
        return this.dance_button;
    }

    public JComboBox<String> getUse_mega_account_down_combobox() {
        return this.use_mega_account_down_combobox;
    }

    public MainPanel getMain_panel() {
        return this._main_panel;
    }

    public StreamerDialog(MainPanelView parent, boolean modal, ClipboardSpy clipboardspy) {
        super((Frame)parent, modal);
        this._main_panel = parent.getMain_panel();
        this._clipboardspy = clipboardspy;
        this._selected_item = null;
        this._mainPanelView = parent;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, this._main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            if (this._main_panel.isUse_mega_account_down() && this._main_panel.getMega_accounts().size() > 0) {
                MainPanel.THREAD_POOL.execute(() -> MiscTools.GUIRun(() -> {
                    String mega_default_down = this._main_panel.getMega_account_down();
                    this.use_mega_account_down_combobox.addItem(mega_default_down);
                    this._main_panel.getMega_accounts().keySet().stream().filter(k -> !mega_default_down.equals(k)).forEachOrdered(k -> this.use_mega_account_down_combobox.addItem((String)k));
                    this.use_mega_account_down_combobox.addItem("");
                    this.use_mega_account_down_combobox.setSelectedIndex(0);
                }));
            } else {
                this.use_mega_account_down_combobox.setEnabled(false);
                this.use_mega_account_down_combobox.setVisible(false);
                this.use_mega_account_down_label.setEnabled(false);
                this.use_mega_account_down_label.setVisible(false);
            }
            this.pack();
        });
    }

    private void initComponents() {
        this.put_label = new JLabel();
        this.dance_button = new JButton();
        this.original_link_textfield = new JTextField();
        this.use_mega_account_down_label = new JLabel();
        this.use_mega_account_down_combobox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Streamer");
        this.setResizable(false);
        this.put_label.setFont(new Font("Dialog", 1, 18));
        this.put_label.setText("Put your MEGA/MegaCrypter/ELC link here in order to get a streaming link:");
        this.put_label.setDoubleBuffered(true);
        this.dance_button.setBackground(new Color(102, 204, 255));
        this.dance_button.setFont(new Font("Dialog", 1, 22));
        this.dance_button.setForeground(new Color(255, 255, 255));
        this.dance_button.setText("Let's dance, baby");
        this.dance_button.setDoubleBuffered(true);
        this.dance_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StreamerDialog.this.dance_buttonActionPerformed(evt);
            }
        });
        this.original_link_textfield.setFont(new Font("Dialog", 0, 18));
        this.original_link_textfield.setDoubleBuffered(true);
        this.use_mega_account_down_label.setFont(new Font("Dialog", 1, 16));
        this.use_mega_account_down_label.setText("Use this account for streaming:");
        this.use_mega_account_down_combobox.setFont(new Font("Dialog", 0, 16));
        this.use_mega_account_down_combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StreamerDialog.this.use_mega_account_down_comboboxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.use_mega_account_down_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.use_mega_account_down_combobox, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.dance_button)).addComponent(this.put_label, -1, -1, Short.MAX_VALUE).addComponent(this.original_link_textfield, -2, 1000, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.put_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.original_link_textfield, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dance_button).addComponent(this.use_mega_account_down_combobox, -1, -1, -2).addComponent(this.use_mega_account_down_label)).addContainerGap()));
        this.original_link_textfield.addMouseListener(new ContextMenuMouseListener());
        this.pack();
    }

    private void dance_buttonActionPerformed(ActionEvent evt) {
        this.dance_button.setEnabled(false);
        this.original_link_textfield.setEnabled(false);
        StreamerDialog tthis = this;
        MainPanel.THREAD_POOL.execute(() -> {
            try {
                boolean error = false;
                String stream_link = null;
                String link = URLDecoder.decode(this.original_link_textfield.getText(), "UTF-8").trim();
                if (link.length() > 0) {
                    try {
                        HashSet<String> links;
                        if (MiscTools.findFirstRegex("://enc", link, 0) != null) {
                            link = CryptTools.decryptMegaDownloaderLink(link);
                        } else if (MiscTools.findFirstRegex("://elc", link, 0) != null && (links = CryptTools.decryptELC(link, ((MainPanelView)tthis.getParent()).getMain_panel())) != null) {
                            link = links.iterator().next();
                        }
                    }
                    catch (Exception ex) {
                        error = true;
                        LOG.log(Level.SEVERE, ex.getMessage());
                    }
                    if (MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/#[^fF]", link, 0) != null || MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/#F*", link, 0) != null || MiscTools.findFirstRegex("https?://[^/]+/![^!]+![0-9a-fA-F]+", link, 0) != null) {
                        if (link.contains("#F*")) {
                            MegaAPI ma = new MegaAPI();
                            HashSet<String> links = new HashSet<String>();
                            links.add(link);
                            ArrayList<String> nlinks = ma.GENERATE_N_LINKS(links);
                            link = (String)nlinks.get(0);
                        }
                        String selected_account = (String)this.use_mega_account_down_combobox.getSelectedItem();
                        String data = MiscTools.Bin2UrlBASE64(((selected_account != null ? selected_account : "") + "|" + link).getBytes("UTF-8"));
                        stream_link = "http://localhost:1337/video/" + data;
                    } else {
                        error = true;
                    }
                } else {
                    error = true;
                }
                if (error) {
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("Please, paste a Mega/MegaCrypter/ELC link!"), "Error", 0);
                        this.original_link_textfield.setText("");
                        this.dance_button.setEnabled(true);
                        this.original_link_textfield.setEnabled(true);
                    });
                } else {
                    this._mainPanelView.getMain_panel().getClipboardspy().detachObserver((ClipboardChangeObserver)((Object)tthis));
                    MiscTools.copyTextToClipboard(stream_link);
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("Streaming link was copied to clipboard!\nRemember to keep MegaBasterd running in background while playing content."));
                        this.dispose();
                        this.getParent().dispatchEvent(new WindowEvent(tthis, 201));
                    });
                }
            }
            catch (UnsupportedEncodingException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        });
    }

    private void use_mega_account_down_comboboxItemStateChanged(ItemEvent evt) {
        if (this._selected_item == null || !this.use_mega_account_down_combobox.getSelectedItem().equals(this._selected_item)) {
            this._selected_item = (String)this.use_mega_account_down_combobox.getSelectedItem();
            if (this._main_panel.isUse_mega_account_down() && !"".equals(this._selected_item)) {
                this.use_mega_account_down_combobox.setEnabled(false);
                this.dance_button.setEnabled(false);
                this.dance_button.setText(LabelTranslatorSingleton.getInstance().translate("Checking MEGA account..."));
                this.pack();
                StreamerDialog tthis = this;
                MainPanel.THREAD_POOL.execute(() -> {
                    boolean use_account = true;
                    try {
                        if (MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(this._main_panel, tthis, this._selected_item) == null) {
                            use_account = false;
                        }
                    }
                    catch (Exception ex) {
                        use_account = false;
                    }
                    if (!use_account) {
                        MiscTools.GUIRun(() -> this.use_mega_account_down_combobox.setSelectedIndex(this._main_panel.getMega_accounts().size()));
                    }
                    MiscTools.GUIRun(() -> {
                        this.getUse_mega_account_down_combobox().setEnabled(true);
                        this.getDance_button().setText(LabelTranslatorSingleton.getInstance().translate("Let's dance, baby"));
                        this.getDance_button().setEnabled(true);
                        this.pack();
                    });
                });
            }
        }
    }

    @Override
    public void notifyClipboardChange() {
        MiscTools.GUIRun(() -> {
            String link = MiscTools.extractFirstMegaLinkFromString(MiscTools.extractStringFromClipboardContents(this._clipboardspy.getContents()));
            if (!link.contains("/#F!")) {
                this.original_link_textfield.setText(link);
            }
        });
    }
}

