/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.SecureMultiThreadNotifiable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamThrottlerSupervisor
implements Runnable,
SecureMultiThreadNotifiable {
    private static final Logger LOG = Logger.getLogger(StreamThrottlerSupervisor.class.getName());
    private ConcurrentLinkedQueue<Integer> _input_slice_queue;
    private ConcurrentLinkedQueue<Integer> _output_slice_queue;
    private final int _slice_size;
    private volatile int _maxBytesPerSecInput;
    private volatile int _maxBytesPerSecOutput;
    private volatile boolean _queue_swapping = false;
    private final Object _secure_notify_lock = new Object();
    private final Object _timer_lock = new Object();
    private final ConcurrentHashMap<Thread, Boolean> _notified_threads;

    public StreamThrottlerSupervisor(int maxBytesPerSecInput, int maxBytesPerSecOutput, int slice_size) {
        this._maxBytesPerSecInput = maxBytesPerSecInput;
        this._maxBytesPerSecOutput = maxBytesPerSecOutput;
        this._slice_size = slice_size;
        this._input_slice_queue = new ConcurrentLinkedQueue();
        this._output_slice_queue = new ConcurrentLinkedQueue();
        this._notified_threads = new ConcurrentHashMap();
    }

    public int getMaxBytesPerSecInput() {
        return this._maxBytesPerSecInput;
    }

    public void setMaxBytesPerSecInput(int maxBytesPerSecInput) {
        this._maxBytesPerSecInput = maxBytesPerSecInput;
    }

    public int getMaxBytesPerSecOutput() {
        return this._maxBytesPerSecOutput;
    }

    public void setMaxBytesPerSecOutput(int maxBytesPerSecOutput) {
        this._maxBytesPerSecOutput = maxBytesPerSecOutput;
    }

    public ConcurrentLinkedQueue<Integer> getInput_slice_queue() {
        return this._input_slice_queue;
    }

    public ConcurrentLinkedQueue<Integer> getOutput_slice_queue() {
        return this._output_slice_queue;
    }

    public boolean isQueue_swapping() {
        return this._queue_swapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            Thread current_thread = Thread.currentThread();
            if (!this._notified_threads.containsKey(current_thread)) {
                this._notified_threads.put(current_thread, false);
            }
            while (!this._notified_threads.get(current_thread).booleanValue()) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified_threads.put(current_thread, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotifyAll() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified_threads.entrySet().forEach(entry -> entry.setValue(true));
            this._secure_notify_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StreamThrottlerSupervisor.this._timer_lock;
                synchronized (object) {
                    StreamThrottlerSupervisor.this._timer_lock.notify();
                }
            }
        };
        ConcurrentLinkedQueue<Integer> old_input_queue = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueue<Integer> old_output_queue = new ConcurrentLinkedQueue<Integer>();
        ConcurrentLinkedQueue<Integer> new_input_queue = this._resetSliceQueue(old_input_queue, this._maxBytesPerSecInput);
        ConcurrentLinkedQueue<Integer> new_output_queue = this._resetSliceQueue(old_output_queue, this._maxBytesPerSecOutput);
        timer.schedule(task, 0L, 1000L);
        while (true) {
            this._queue_swapping = true;
            old_input_queue = this._input_slice_queue;
            old_output_queue = this._output_slice_queue;
            this._input_slice_queue = new_input_queue;
            this._output_slice_queue = new_output_queue;
            this._queue_swapping = false;
            this.secureNotifyAll();
            new_input_queue = this._resetSliceQueue(old_input_queue, this._maxBytesPerSecInput);
            new_output_queue = this._resetSliceQueue(old_output_queue, this._maxBytesPerSecOutput);
            Object object = this._timer_lock;
            synchronized (object) {
                try {
                    this._timer_lock.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
        }
    }

    private ConcurrentLinkedQueue<Integer> _resetSliceQueue(ConcurrentLinkedQueue<Integer> queue, int max_bytes) {
        if (max_bytes > 0) {
            queue.clear();
            int slice_num = (int)Math.floor((double)max_bytes / (double)this._slice_size);
            for (int i = 0; i < slice_num; ++i) {
                queue.add(this._slice_size);
            }
            if (max_bytes % this._slice_size != 0) {
                queue.add(max_bytes % this._slice_size);
            }
        }
        return queue;
    }
}

