/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.KissVideoStreamServer;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureMultiThreadNotifiable;
import com.tonikelope.megabasterd.StreamChunk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamChunkManager
implements Runnable,
SecureMultiThreadNotifiable {
    public static final int CHUNK_SIZE = 0x100000;
    public static final int BUFFER_CHUNKS_SIZE = 20;
    private static final Logger LOG = Logger.getLogger(StreamChunkManager.class.getName());
    private long _next_offset_required;
    private long _bytes_written;
    private final long _start_offset;
    private final long _end_offset;
    private final String _mega_account;
    private final ConcurrentHashMap<Long, StreamChunk> _chunk_queue;
    private final ConcurrentHashMap<Thread, Boolean> _notified_threads;
    private final PipedOutputStream _pipeos;
    private String _url;
    private final HashMap _file_info;
    private final String _link;
    private final Object _secure_notify_lock;
    private final Object _chunk_offset_lock;
    private final KissVideoStreamServer _server;
    private volatile boolean _exit;

    public StreamChunkManager(KissVideoStreamServer server, String link, HashMap file_info, String mega_account, PipedOutputStream pipeos, String url, long start_offset, long end_offset) {
        this._server = server;
        this._link = link;
        this._mega_account = mega_account;
        this._file_info = file_info;
        this._bytes_written = start_offset;
        this._pipeos = pipeos;
        this._start_offset = start_offset;
        this._end_offset = end_offset;
        this._next_offset_required = start_offset;
        this._chunk_queue = new ConcurrentHashMap();
        this._notified_threads = new ConcurrentHashMap();
        this._secure_notify_lock = new Object();
        this._chunk_offset_lock = new Object();
        this._url = url;
        this._exit = false;
    }

    public String getUrl() throws Exception {
        if (!MiscTools.checkMegaDownloadUrl(this._url)) {
            this._url = this._server.getMegaFileDownloadUrl(this._link, (String)this._file_info.get("pass_hash"), (String)this._file_info.get("noexpiretoken"), this._mega_account);
            this._file_info.put("url", this._url);
            this._server.getLink_cache().put(this._link, this._file_info);
        }
        return this._url;
    }

    public boolean isExit() {
        return this._exit;
    }

    public ConcurrentHashMap<Long, StreamChunk> getChunk_queue() {
        return this._chunk_queue;
    }

    public KissVideoStreamServer getServer() {
        return this._server;
    }

    @Override
    public void run() {
        try {
            LOG.log(Level.INFO, "{0} StreamChunkManager: let''s do some work! Start: {1}   End: {2}", new Object[]{Thread.currentThread().getName(), this._start_offset, this._end_offset});
            while (!this._exit && this._bytes_written < this._end_offset) {
                while (!this._exit && this._bytes_written < this._end_offset && this._chunk_queue.containsKey(this._bytes_written)) {
                    int reads;
                    StreamChunk current_chunk = this._chunk_queue.remove(this._bytes_written);
                    ByteArrayInputStream is = current_chunk.getInputStream();
                    byte[] buffer = new byte[16384];
                    while (!this._exit && (reads = is.read(buffer)) != -1) {
                        this._pipeos.write(buffer, 0, reads);
                        this._bytes_written += (long)reads;
                    }
                    this.secureNotifyAll();
                    LOG.log(Level.INFO, "{0} StreamChunkManager has written {1} / {2} ...", new Object[]{Thread.currentThread().getName(), this._bytes_written, this._end_offset});
                }
                if (this._exit || this._bytes_written >= this._end_offset) continue;
                LOG.log(Level.INFO, "{0} StreamChunkManager waiting for offset {1}...", new Object[]{Thread.currentThread().getName(), this._bytes_written});
                this.secureWait();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        try {
            this._pipeos.close();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        this._exit = true;
        this.secureNotifyAll();
        LOG.log(Level.INFO, "{0} StreamChunkManager: bye bye", Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextOffset() {
        Object object = this._chunk_offset_lock;
        synchronized (object) {
            long next_offset = this._next_offset_required;
            this._next_offset_required = this._next_offset_required + 0x100000L < this._end_offset ? this._next_offset_required + 0x100000L : -1L;
            return next_offset;
        }
    }

    public long calculateChunkSize(long offset) {
        return offset <= this._end_offset ? Math.min(0x100000L, this._end_offset - offset + 1L) : -1L;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            Thread current_thread = Thread.currentThread();
            if (!this._notified_threads.containsKey(current_thread)) {
                this._notified_threads.put(current_thread, false);
            }
            while (!this._notified_threads.get(current_thread).booleanValue()) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified_threads.put(current_thread, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotifyAll() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified_threads.entrySet().forEach(entry -> entry.setValue(true));
            this._secure_notify_lock.notifyAll();
        }
    }
}

