/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SmartMegaProxyManager;
import com.tonikelope.megabasterd.StreamChunk;
import com.tonikelope.megabasterd.StreamChunkManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamChunkDownloader
implements Runnable {
    private static final Logger LOG = Logger.getLogger(StreamChunkDownloader.class.getName());
    private final int _id;
    private final StreamChunkManager _chunkmanager;
    private volatile boolean _exit;

    public StreamChunkDownloader(int id, StreamChunkManager chunkmanager) {
        this._id = id;
        this._chunkmanager = chunkmanager;
        this._exit = false;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} Worker [{1}]: let''s do some work!", new Object[]{Thread.currentThread().getName(), this._id});
        HttpURLConnection con = null;
        try {
            String url = this._chunkmanager.getUrl();
            int http_error = 0;
            String current_smart_proxy = null;
            boolean smart_proxy_socks = false;
            long offset = -1L;
            SmartMegaProxyManager proxy_manager = MainPanel.getProxy_manager();
            ArrayList<String> excluded_proxy_list = new ArrayList<String>();
            if (MainPanel.isUse_smart_proxy() && proxy_manager != null && proxy_manager.isForce_smart_proxy()) {
                String[] smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                current_smart_proxy = smart_proxy[0];
                smart_proxy_socks = smart_proxy[1].equals("socks");
            }
            while (!this._exit && !this._chunkmanager.isExit()) {
                while (!this._exit && !this._chunkmanager.isExit() && this._chunkmanager.getChunk_queue().size() >= 20) {
                    LOG.log(Level.INFO, "{0} Worker [{1}]: Chunk buffer is full. I pause myself.", new Object[]{Thread.currentThread().getName(), this._id});
                    this._chunkmanager.secureWait();
                }
                if (http_error == 0) {
                    offset = this._chunkmanager.nextOffset();
                } else if (http_error == 403) {
                    url = this._chunkmanager.getUrl();
                }
                if (offset >= 0L) {
                    URL chunk_url;
                    StreamChunk chunk_stream = new StreamChunk(offset, this._chunkmanager.calculateChunkSize(offset), url);
                    if ((current_smart_proxy != null || http_error == 509) && MainPanel.isUse_smart_proxy() && !MainPanel.isUse_proxy()) {
                        if (current_smart_proxy != null && http_error != 0) {
                            proxy_manager.blockProxy(current_smart_proxy, "HTTP " + String.valueOf(http_error));
                            String[] smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                            current_smart_proxy = smart_proxy[0];
                            smart_proxy_socks = smart_proxy[1].equals("socks");
                        } else if (current_smart_proxy == null) {
                            String[] smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                            current_smart_proxy = smart_proxy[0];
                            smart_proxy_socks = smart_proxy[1].equals("socks");
                        }
                        if (current_smart_proxy != null) {
                            String[] proxy_info = current_smart_proxy.split(":");
                            Proxy proxy = new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(proxy_info[0], Integer.parseInt(proxy_info[1])));
                            URL chunk_url2 = new URL(chunk_stream.getUrl());
                            con = (HttpURLConnection)chunk_url2.openConnection(proxy);
                        } else {
                            chunk_url = new URL(chunk_stream.getUrl());
                            con = (HttpURLConnection)chunk_url.openConnection();
                        }
                    } else {
                        chunk_url = new URL(chunk_stream.getUrl());
                        if (MainPanel.isUse_proxy()) {
                            con = (HttpURLConnection)chunk_url.openConnection(new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                            if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                                con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                            }
                        } else if (current_smart_proxy != null) {
                            String[] proxy_info = current_smart_proxy.split(":");
                            Proxy proxy = new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(proxy_info[0], Integer.parseInt(proxy_info[1])));
                            con = (HttpURLConnection)chunk_url.openConnection(proxy);
                        } else {
                            con = (HttpURLConnection)chunk_url.openConnection();
                        }
                    }
                    if (current_smart_proxy != null && proxy_manager != null) {
                        con.setConnectTimeout(proxy_manager.getProxy_timeout());
                        con.setReadTimeout(proxy_manager.getProxy_timeout() * 2);
                    }
                    con.setUseCaches(false);
                    con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                    byte[] buffer = new byte[16384];
                    LOG.log(Level.INFO, "{0} Worker [{1}]: offset: {2} size: {3}", new Object[]{Thread.currentThread().getName(), this._id, offset, chunk_stream.getSize()});
                    http_error = 0;
                    try {
                        if (this._exit) continue;
                        int http_status = con.getResponseCode();
                        if (http_status != 200) {
                            LOG.log(Level.INFO, "{0} Failed : HTTP error code : {1}", new Object[]{Thread.currentThread().getName(), http_status});
                            http_error = http_status;
                            continue;
                        }
                        InputStream is = con.getInputStream();
                        try {
                            int reads;
                            int chunk_writes = 0;
                            while (!this._exit && !this._chunkmanager.isExit() && (long)chunk_writes < chunk_stream.getSize() && (reads = is.read(buffer, 0, Math.min((int)(chunk_stream.getSize() - (long)chunk_writes), buffer.length))) != -1) {
                                chunk_stream.getOutputStream().write(buffer, 0, reads);
                                chunk_writes += reads;
                            }
                            if (chunk_stream.getSize() != (long)chunk_writes) continue;
                            LOG.log(Level.INFO, "{0} Worker [{1}] has downloaded chunk [{2}]!", new Object[]{Thread.currentThread().getName(), this._id, chunk_stream.getOffset()});
                            this._chunkmanager.getChunk_queue().put(chunk_stream.getOffset(), chunk_stream);
                            this._chunkmanager.secureNotifyAll();
                            current_smart_proxy = null;
                            excluded_proxy_list.clear();
                            continue;
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            continue;
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, ex.getMessage());
                        continue;
                    }
                    finally {
                        con.disconnect();
                        continue;
                    }
                }
                this._exit = true;
            }
        }
        catch (ChunkInvalidException | IOException | InterruptedException | URISyntaxException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        catch (Exception | OutOfMemoryError ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        this._chunkmanager.secureNotifyAll();
        LOG.log(Level.INFO, "{0} Worker [{1}]: bye bye", new Object[]{Thread.currentThread().getName(), this._id});
    }
}

