/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class StreamChunk {
    private static final Logger LOG = Logger.getLogger(StreamChunk.class.getName());
    private final long _offset;
    private final long _size;
    private final String _url;
    private final ByteArrayOutInputStream _data_os;
    private boolean _writable;

    public StreamChunk(long offset, long size, String url) throws ChunkInvalidException, IOException {
        if (offset < 0L || size < 0L || url == null) {
            throw new ChunkInvalidException("Offset: " + offset + " Size: " + size);
        }
        this._offset = offset;
        this._size = size;
        this._url = url + "/" + this._offset + "-" + (this._offset + this._size - 1L);
        this._data_os = new ByteArrayOutInputStream((int)this._size);
        this._writable = true;
    }

    public ByteArrayInputStream getInputStream() {
        this._writable = false;
        return this._data_os.toInputStream();
    }

    public long getOffset() {
        return this._offset;
    }

    public long getSize() {
        return this._size;
    }

    public String getUrl() {
        return this._url;
    }

    public ByteArrayOutputStream getOutputStream() throws IOException {
        if (!this._writable) {
            throw new IOException("Chunk outputstream is not available!");
        }
        return this._data_os;
    }

    public class ByteArrayOutInputStream
    extends ByteArrayOutputStream {
        public ByteArrayOutInputStream(int size) {
            super(size);
        }

        public ByteArrayInputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

