/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.MainPanel;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SqliteSingleton {
    public static final String SQLITE_FILE = "megabasterd.db";
    public static final int VALIDATION_TIMEOUT = 15;
    private static final Logger LOG = Logger.getLogger(SqliteSingleton.class.getName());
    private final ConcurrentHashMap<Thread, Connection> _connections_map = new ConcurrentHashMap();

    public static SqliteSingleton getInstance() {
        return LazyHolder.INSTANCE;
    }

    private SqliteSingleton() {
        File database_path = new File(MainPanel.MEGABASTERD_HOME_DIR + "/.megabasterd" + "8.22");
        database_path.mkdirs();
    }

    public Connection getConn() {
        Connection conn = null;
        try {
            if (!this._connections_map.containsKey(Thread.currentThread()) || !(conn = this._connections_map.get(Thread.currentThread())).isValid(15)) {
                Class.forName("org.sqlite.JDBC");
                conn = DriverManager.getConnection("jdbc:sqlite:" + MainPanel.MEGABASTERD_HOME_DIR + "/.megabasterd" + "8.22" + "/" + SQLITE_FILE + "?journal_mode=WAL&synchronous=OFF&journal_size_limit=500");
                this._connections_map.put(Thread.currentThread(), conn);
            }
        }
        catch (ClassNotFoundException | SQLException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return conn;
    }

    private static class LazyHolder {
        private static final SqliteSingleton INSTANCE = new SqliteSingleton();

        private LazyHolder() {
        }
    }
}

