/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.Transference;
import com.tonikelope.megabasterd.TransferenceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;

public class SpeedMeter
implements Runnable {
    public static final int SLEEP = 3000;
    public static final int CHUNK_SPEED_QUEUE_MAX_SIZE = 20;
    private static final Logger LOG = Logger.getLogger(SpeedMeter.class.getName());
    private final JLabel _speed_label;
    private final JLabel _rem_label;
    private final TransferenceManager _trans_manager;
    private final ConcurrentHashMap<Transference, HashMap> _transferences;
    private long _speed_counter;
    private long _speed_acumulator;
    private volatile long _max_avg_global_speed;

    SpeedMeter(TransferenceManager trans_manager, JLabel sp_label, JLabel rem_label) {
        this._speed_label = sp_label;
        this._rem_label = rem_label;
        this._trans_manager = trans_manager;
        this._transferences = new ConcurrentHashMap();
        this._speed_counter = 0L;
        this._speed_acumulator = 0L;
        this._max_avg_global_speed = 0L;
    }

    private long _getAvgGlobalSpeed() {
        return Math.round((double)this._speed_acumulator / (double)this._speed_counter);
    }

    public void attachTransference(Transference transference) {
        HashMap<String, Number> properties = new HashMap<String, Number>();
        properties.put("last_progress", transference.getProgress());
        properties.put("no_data_count", 0);
        this._transferences.put(transference, properties);
    }

    public void detachTransference(Transference transference) {
        if (this._transferences.containsKey(transference)) {
            this._transferences.remove(transference);
        }
    }

    public long getMaxAvgGlobalSpeed() {
        return this._max_avg_global_speed;
    }

    private String calcRemTime(long seconds) {
        int days = (int)TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.DAYS.toMinutes(days) - TimeUnit.HOURS.toMinutes(hours);
        long secs = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.DAYS.toSeconds(days) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.MINUTES.toSeconds(minutes);
        return String.format("%dd %d:%02d:%02d", days, hours, minutes, secs);
    }

    private long calcTransferenceSpeed(Transference transference, HashMap properties) {
        long sp;
        long progress = transference.getProgress();
        long last_progress = (Long)properties.get("last_progress");
        int no_data_count = (Integer)properties.get("no_data_count");
        if (transference.isPaused()) {
            sp = 0L;
        } else if (progress > last_progress) {
            double sleep_time = 3000.0 * (double)(no_data_count + 1) / 1000.0;
            double current_speed = (double)(progress - last_progress) / sleep_time;
            sp = last_progress > 0L ? Math.round(current_speed) : 0L;
            last_progress = progress;
            no_data_count = 0;
        } else if (transference instanceof Download) {
            sp = -1L;
            ++no_data_count;
        } else {
            sp = 0L;
            ++no_data_count;
        }
        properties.put("last_progress", last_progress);
        properties.put("no_data_count", no_data_count);
        this._transferences.put(transference, properties);
        return sp;
    }

    @Override
    public void run() {
        boolean visible = false;
        this._speed_label.setVisible(true);
        this._rem_label.setVisible(true);
        this._speed_label.setText("");
        this._rem_label.setText("");
        while (true) {
            try {
                while (true) {
                    if (!this._transferences.isEmpty()) {
                        visible = true;
                        long global_speed = 0L;
                        for (Map.Entry<Transference, HashMap> trans_info : this._transferences.entrySet()) {
                            long trans_sp = this.calcTransferenceSpeed(trans_info.getKey(), trans_info.getValue());
                            if (trans_sp >= 0L) {
                                global_speed += trans_sp;
                            }
                            if (trans_sp > 0L) {
                                trans_info.getKey().getView().updateSpeed(MiscTools.formatBytes(trans_sp) + "/s", true);
                                continue;
                            }
                            trans_info.getKey().getView().updateSpeed("------", true);
                        }
                        long global_size = this._trans_manager.get_total_size();
                        long global_progress = this._trans_manager.get_total_progress();
                        if (global_speed > 0L) {
                            ++this._speed_counter;
                            this._speed_acumulator += global_speed;
                            long avg_global_speed = this._getAvgGlobalSpeed();
                            if (avg_global_speed > this._max_avg_global_speed) {
                                this._max_avg_global_speed = avg_global_speed;
                            }
                            this._speed_label.setText(MiscTools.formatBytes(global_speed) + "/s");
                            this._rem_label.setText(MiscTools.formatBytes(global_progress) + "/" + MiscTools.formatBytes(global_size) + " @ " + MiscTools.formatBytes(avg_global_speed) + "/s @ " + this.calcRemTime((long)Math.floor((global_size - global_progress) / avg_global_speed)));
                        } else {
                            this._speed_label.setText("------");
                            this._rem_label.setText(MiscTools.formatBytes(global_progress) + "/" + MiscTools.formatBytes(global_size) + " @ --d --:--:--");
                        }
                    } else if (visible) {
                        this._speed_label.setText("");
                        this._rem_label.setText("");
                        visible = false;
                    }
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
                continue;
            }
            break;
        }
    }
}

