/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SmartMegaProxyManager {
    public static String DEFAULT_SMART_PROXY_URL = null;
    public static final int PROXY_BLOCK_TIME = 300;
    public static final int PROXY_AUTO_REFRESH_TIME = 60;
    public static final int PROXY_AUTO_REFRESH_SLEEP_TIME = 30;
    public static final boolean RESET_SLOT_PROXY = true;
    public static final boolean RANDOM_SELECT = true;
    private static final Logger LOG = Logger.getLogger(SmartMegaProxyManager.class.getName());
    private volatile String _proxy_list_url;
    private final ConcurrentHashMap<String, Long[]> _proxy_list;
    private static final HashMap<String, String> PROXY_LIST_AUTH = new HashMap();
    private final MainPanel _main_panel;
    private volatile int _ban_time;
    private volatile int _proxy_timeout;
    private volatile boolean _force_smart_proxy;
    private volatile int _autorefresh_time;
    private volatile long _last_refresh_timestamp;
    private volatile boolean _random_select;
    private volatile boolean _reset_slot_proxy;

    public boolean isRandom_select() {
        return this._random_select;
    }

    public boolean isReset_slot_proxy() {
        return this._reset_slot_proxy;
    }

    public int getProxy_timeout() {
        return this._proxy_timeout;
    }

    public boolean isForce_smart_proxy() {
        return this._force_smart_proxy;
    }

    public SmartMegaProxyManager(String proxy_list_url, MainPanel main_panel) {
        this._proxy_list_url = proxy_list_url != null && !"".equals(proxy_list_url) ? proxy_list_url : DEFAULT_SMART_PROXY_URL;
        this._proxy_list = new ConcurrentHashMap();
        this._main_panel = main_panel;
        this.refreshSmartProxySettings();
        MainPanel.THREAD_POOL.execute(() -> {
            this.refreshProxyList();
            while (true) {
                if (System.currentTimeMillis() < this._last_refresh_timestamp + (long)(this._autorefresh_time * 60 * 1000)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SmartMegaProxyManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (!MainPanel.isUse_smart_proxy()) continue;
                this.refreshProxyList();
            }
        });
    }

    private synchronized int countBlockedProxies() {
        int i = 0;
        Long current_time = System.currentTimeMillis();
        for (String k : this._proxy_list.keySet()) {
            if (this._proxy_list.get(k)[0] == -1L || this._proxy_list.get(k)[0] <= current_time - (long)(this._ban_time * 1000)) continue;
            ++i;
        }
        return i;
    }

    public synchronized void refreshSmartProxySettings() {
        String smartproxy_ban_time = DBTools.selectSettingValue("smartproxy_ban_time");
        this._ban_time = smartproxy_ban_time != null ? Integer.parseInt(smartproxy_ban_time) : 300;
        String smartproxy_timeout = DBTools.selectSettingValue("smartproxy_timeout");
        this._proxy_timeout = smartproxy_timeout != null ? Integer.parseInt(smartproxy_timeout) * 1000 : 5000;
        String force_smart_proxy_string = DBTools.selectSettingValue("force_smart_proxy");
        this._force_smart_proxy = force_smart_proxy_string != null ? force_smart_proxy_string.equals("yes") : false;
        String autorefresh_smart_proxy_string = DBTools.selectSettingValue("smartproxy_autorefresh_time");
        this._autorefresh_time = autorefresh_smart_proxy_string != null ? Integer.parseInt(autorefresh_smart_proxy_string) : 60;
        String reset_slot_proxy = DBTools.selectSettingValue("reset_slot_proxy");
        this._reset_slot_proxy = reset_slot_proxy != null ? reset_slot_proxy.equals("yes") : true;
        String random_select = DBTools.selectSettingValue("random_proxy");
        this._random_select = random_select != null ? random_select.equals("yes") : true;
        LOG.log(Level.INFO, "SmartProxy BAN_TIME: " + String.valueOf(this._ban_time) + "   TIMEOUT: " + String.valueOf(this._proxy_timeout / 1000) + "   REFRESH: " + String.valueOf(this._autorefresh_time) + "   FORCE: " + String.valueOf(this._force_smart_proxy) + "   RANDOM: " + String.valueOf(this._random_select) + "   RESET-SLOT-PROXY: " + String.valueOf(this._reset_slot_proxy));
    }

    public synchronized int getProxyCount() {
        return this._proxy_list.size();
    }

    public synchronized String[] getProxy(ArrayList<String> excluded) {
        if (this._proxy_list.size() > 0) {
            Set keys = this._proxy_list.keySet();
            ArrayList keysList = new ArrayList(keys);
            if (this.isRandom_select()) {
                Collections.shuffle(keysList);
            }
            Long current_time = System.currentTimeMillis();
            for (String k : keysList) {
                if (this._proxy_list.get(k)[0] != -1L && this._proxy_list.get(k)[0] >= current_time - (long)(this._ban_time * 1000) || excluded != null && excluded.contains(k)) continue;
                return new String[]{k, this._proxy_list.get(k)[1] == -1L ? "http" : "socks"};
            }
        }
        LOG.log(Level.WARNING, "{0} Smart Proxy Manager: NO PROXYS AVAILABLE!! (Refreshing in " + String.valueOf(30) + " secs...)", new Object[]{Thread.currentThread().getName()});
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SmartMegaProxyManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.refreshProxyList();
        return this.getProxyCount() > 0 ? this.getProxy(excluded) : null;
    }

    public synchronized void blockProxy(String proxy, String cause) {
        if (this._proxy_list.containsKey(proxy)) {
            if (this._ban_time == 0) {
                this._proxy_list.remove(proxy);
                LOG.log(Level.WARNING, "[Smart Proxy] REMOVING PROXY {0} ({1})", new Object[]{proxy, cause});
            } else {
                Long[] proxy_data = this._proxy_list.get(proxy);
                proxy_data[0] = System.currentTimeMillis();
                this._proxy_list.put(proxy, proxy_data);
                LOG.log(Level.WARNING, "[Smart Proxy] BLOCKING PROXY {0} ({1} secs) ({2})", new Object[]{proxy, this._ban_time, cause});
            }
            this._main_panel.getView().updateSmartProxyStatus("SmartProxy: ON (" + String.valueOf(this.getProxyCount() - this.countBlockedProxies()) + ")" + (this.isForce_smart_proxy() ? " F!" : ""));
        }
    }

    public synchronized void refreshProxyList(String url_list) {
        this._proxy_list_url = url_list != null ? url_list : null;
        MainPanel.THREAD_POOL.execute(() -> this.refreshProxyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshProxyList() {
        block35: {
            HttpURLConnection con = null;
            try {
                String custom_proxy_list = this._proxy_list_url == null ? DBTools.selectSettingValue("custom_proxy_list") : null;
                LinkedHashMap<String, Long[]> custom_clean_list = new LinkedHashMap<String, Long[]>();
                HashMap<String, String> custom_clean_list_auth = new HashMap<String, String>();
                if (custom_proxy_list != null) {
                    ArrayList<String> custom_list = new ArrayList<String>(Arrays.asList(custom_proxy_list.split("\\r?\\n")));
                    if (!custom_list.isEmpty()) {
                        for (String proxy : custom_list) {
                            boolean socks = false;
                            if (proxy.trim().startsWith("*")) {
                                socks = true;
                                proxy = proxy.trim().substring(1);
                            }
                            if (proxy.trim().contains("@")) {
                                String[] proxy_parts = proxy.trim().split("@");
                                custom_clean_list_auth.put(proxy_parts[0], proxy_parts[1]);
                                Long[] proxy_data = new Long[]{-1L, socks ? 1L : -1L};
                                custom_clean_list.put(proxy_parts[0], proxy_data);
                                continue;
                            }
                            if (!proxy.trim().matches(".+?:[0-9]{1,5}")) continue;
                            Long[] proxy_data = new Long[]{-1L, socks ? 1L : -1L};
                            custom_clean_list.put(proxy, proxy_data);
                        }
                    }
                    if (!custom_clean_list.isEmpty()) {
                        this._proxy_list.clear();
                        this._proxy_list.putAll(custom_clean_list);
                    }
                    if (!custom_clean_list_auth.isEmpty()) {
                        PROXY_LIST_AUTH.clear();
                        PROXY_LIST_AUTH.putAll(custom_clean_list_auth);
                    }
                }
                if (custom_clean_list.isEmpty() && this._proxy_list_url != null && !"".equals(this._proxy_list_url)) {
                    String data;
                    URL url = new URL(this._proxy_list_url);
                    con = (HttpURLConnection)url.openConnection();
                    con.setUseCaches(false);
                    con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                    try (InputStream is = con.getInputStream();
                         ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                        int reads;
                        byte[] buffer = new byte[16384];
                        while ((reads = is.read(buffer)) != -1) {
                            byte_res.write(buffer, 0, reads);
                        }
                        data = new String(byte_res.toByteArray(), "UTF-8");
                    }
                    String[] proxy_list = data.split("\n");
                    if (proxy_list.length > 0) {
                        this._proxy_list.clear();
                        PROXY_LIST_AUTH.clear();
                        for (String proxy : proxy_list) {
                            boolean socks = false;
                            if (proxy.trim().startsWith("*")) {
                                socks = true;
                                proxy = proxy.trim().substring(1);
                            }
                            if (proxy.trim().contains("@")) {
                                String[] proxy_parts = proxy.trim().split("@");
                                PROXY_LIST_AUTH.put(proxy_parts[0], proxy_parts[1]);
                                Long[] proxy_data = new Long[]{-1L, socks ? 1L : -1L};
                                this._proxy_list.put(proxy_parts[0], proxy_data);
                                continue;
                            }
                            if (!proxy.trim().matches(".+?:[0-9]{1,5}")) continue;
                            Long[] proxy_data = new Long[]{-1L, socks ? 1L : -1L};
                            this._proxy_list.put(proxy, proxy_data);
                        }
                    }
                    this._main_panel.getView().updateSmartProxyStatus("SmartProxy: ON (" + String.valueOf(this.getProxyCount()) + ")" + (this.isForce_smart_proxy() ? " F!" : ""));
                    LOG.log(Level.INFO, "{0} Smart Proxy Manager: proxy list refreshed ({1})", new Object[]{Thread.currentThread().getName(), this._proxy_list.size()});
                    break block35;
                }
                if (!custom_clean_list.isEmpty()) {
                    this._main_panel.getView().updateSmartProxyStatus("SmartProxy: ON (" + String.valueOf(this.getProxyCount()) + ")" + (this.isForce_smart_proxy() ? " F!" : ""));
                    LOG.log(Level.INFO, "{0} Smart Proxy Manager: proxy list refreshed ({1})", new Object[]{Thread.currentThread().getName(), this._proxy_list.size()});
                } else {
                    this._main_panel.getView().updateSmartProxyStatus("SmartProxy: ON (0 proxies!)" + (this.isForce_smart_proxy() ? " F!" : ""));
                    LOG.log(Level.INFO, "{0} Smart Proxy Manager: NO PROXYS");
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        this._last_refresh_timestamp = System.currentTimeMillis();
    }

    public static class SmartProxyAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            String auth_data = (String)PROXY_LIST_AUTH.get(ipaddr.getHostAddress() + ":" + String.valueOf(port));
            if (auth_data != null) {
                try {
                    String[] auth_data_parts = auth_data.split(":");
                    String user = new String(MiscTools.BASE642Bin(auth_data_parts[0]), "UTF-8");
                    String password = new String(MiscTools.BASE642Bin(auth_data_parts[1]), "UTF-8");
                    return new PasswordAuthentication(user, password.toCharArray());
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(SmartMegaProxyManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return null;
        }
    }
}

