/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class SetMasterPasswordDialog
extends JDialog {
    private boolean _pass_ok = false;
    private String _new_pass_hash = null;
    private byte[] _new_pass = null;
    private final String _salt;
    private JButton cancel_button;
    private JLabel confirm_pass_label;
    private JPasswordField confirm_pass_textfield;
    private JLabel lock_label;
    private JLabel new_pass_label;
    private JPasswordField new_pass_textfield;
    private JButton ok_button;
    private JLabel status_label;
    private JLabel warning_label;
    private static final Logger LOG = Logger.getLogger(SetMasterPasswordDialog.class.getName());

    public boolean isPass_ok() {
        return this._pass_ok;
    }

    public byte[] getNew_pass() {
        return this._new_pass;
    }

    public void deleteNewPass() {
        if (this._new_pass != null) {
            Arrays.fill(this._new_pass, (byte)0);
        }
        this._new_pass = null;
    }

    public String getNew_pass_hash() {
        return this._new_pass_hash;
    }

    public SetMasterPasswordDialog(Frame parent, boolean modal, String salt, MainPanel main_panel) {
        super(parent, modal);
        this._salt = salt;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this.pack();
        });
    }

    private void initComponents() {
        this.confirm_pass_textfield = new JPasswordField();
        this.confirm_pass_label = new JLabel();
        this.cancel_button = new JButton();
        this.ok_button = new JButton();
        this.lock_label = new JLabel();
        this.warning_label = new JLabel();
        this.new_pass_label = new JLabel();
        this.new_pass_textfield = new JPasswordField();
        this.status_label = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Master password setup");
        this.setResizable(false);
        this.confirm_pass_textfield.setFont(new Font("Dialog", 0, 18));
        this.confirm_pass_textfield.setDoubleBuffered(true);
        this.confirm_pass_textfield.setMargin(new Insets(2, 2, 2, 2));
        this.confirm_pass_textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SetMasterPasswordDialog.this.confirm_pass_textfieldKeyPressed(evt);
            }
        });
        this.confirm_pass_label.setFont(new Font("Dialog", 1, 18));
        this.confirm_pass_label.setText("Confirm new:");
        this.confirm_pass_label.setDoubleBuffered(true);
        this.cancel_button.setFont(new Font("Dialog", 1, 18));
        this.cancel_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cancel-30.png")));
        this.cancel_button.setText("CANCEL");
        this.cancel_button.setDoubleBuffered(true);
        this.cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetMasterPasswordDialog.this.cancel_buttonActionPerformed(evt);
            }
        });
        this.ok_button.setFont(new Font("Dialog", 1, 18));
        this.ok_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
        this.ok_button.setText("OK");
        this.ok_button.setDoubleBuffered(true);
        this.ok_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetMasterPasswordDialog.this.ok_buttonActionPerformed(evt);
            }
        });
        this.lock_label.setIcon(new ImageIcon(this.getClass().getResource("/images/lock_medium.png")));
        this.lock_label.setDoubleBuffered(true);
        this.warning_label.setFont(new Font("Dialog", 0, 14));
        this.warning_label.setHorizontalAlignment(0);
        this.warning_label.setText("WARNING: if you forget this password, you will have to insert all your accounts again.");
        this.warning_label.setDoubleBuffered(true);
        this.new_pass_label.setFont(new Font("Dialog", 1, 18));
        this.new_pass_label.setText("New pass:");
        this.new_pass_label.setDoubleBuffered(true);
        this.new_pass_textfield.setFont(new Font("Dialog", 0, 18));
        this.new_pass_textfield.setDoubleBuffered(true);
        this.new_pass_textfield.setMargin(new Insets(2, 2, 2, 2));
        this.status_label.setFont(new Font("Dialog", 0, 14));
        this.status_label.setDoubleBuffered(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lock_label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.confirm_pass_label).addComponent(this.new_pass_label)).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.confirm_pass_textfield, -1, 459, Short.MAX_VALUE).addComponent(this.new_pass_textfield)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.warning_label, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.status_label, -1, -1, Short.MAX_VALUE).addGap(133, 133, 133)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.ok_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addComponent(this.cancel_button))).addGap(15, 15, 15)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lock_label).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.new_pass_textfield, -2, -1, -2).addComponent(this.new_pass_label)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confirm_pass_textfield, -2, -1, -2).addComponent(this.confirm_pass_label)))).addGap(18, 18, 18).addComponent(this.warning_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ok_button).addComponent(this.cancel_button)).addComponent(this.status_label, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    private void cancel_buttonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ok_buttonActionPerformed(ActionEvent evt) {
        this.status_label.setText(LabelTranslatorSingleton.getInstance().translate("Verifying your password, please wait..."));
        SetMasterPasswordDialog tthis = this;
        MainPanel.THREAD_POOL.execute(() -> {
            try {
                if (Arrays.equals(this.new_pass_textfield.getPassword(), this.confirm_pass_textfield.getPassword())) {
                    MiscTools.GUIRun(() -> this.status_label.setText(LabelTranslatorSingleton.getInstance().translate("Processing your password, please wait...")));
                    if (this.new_pass_textfield.getPassword().length > 0) {
                        this._new_pass = CryptTools.PBKDF2HMACSHA256(new String(this.new_pass_textfield.getPassword()), MiscTools.BASE642Bin(this._salt), 65536, 256);
                        this._new_pass_hash = MiscTools.Bin2BASE64(MiscTools.HashBin("SHA-1", this._new_pass));
                    }
                    this._pass_ok = true;
                    MiscTools.GUIRun(() -> tthis.setVisible(false));
                } else {
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("Passwords does not match!"), "Error", 0);
                        this.status_label.setText("");
                        this.new_pass_textfield.setText("");
                        this.confirm_pass_textfield.setText("");
                        this.new_pass_textfield.grabFocus();
                    });
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        });
    }

    private void confirm_pass_textfieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok_buttonActionPerformed(null);
        }
    }
}

