/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.Transference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProgressMeter
implements Runnable,
SecureSingleThreadNotifiable {
    private static final Logger LOG = Logger.getLogger(ProgressMeter.class.getName());
    private final Transference _transference;
    private volatile boolean _exit;
    private final Object _secure_notify_lock = new Object();
    private volatile boolean _notified = false;
    private long _progress;

    ProgressMeter(Transference transference) {
        this._transference = transference;
        this._progress = 0L;
        this._exit = false;
    }

    public void setExit(boolean value) {
        this._exit = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this._notified = false;
        }
    }

    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} ProgressMeter hello! {1}", new Object[]{Thread.currentThread().getName(), this._transference.getFile_name()});
        this._progress = this._transference.getProgress();
        while (!this._exit || !this._transference.getPartialProgress().isEmpty()) {
            Long reads;
            while ((reads = this._transference.getPartialProgress().poll()) != null) {
                this._progress += reads.longValue();
                this._transference.setProgress(this._progress);
            }
            if (this._exit) continue;
            this.secureWait();
        }
        LOG.log(Level.INFO, "{0} ProgressMeter bye bye! {1}", new Object[]{Thread.currentThread().getName(), this._transference.getFile_name()});
    }
}

