/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.Get2FACode;
import com.tonikelope.megabasterd.GetMasterPasswordDialog;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaAPIException;
import com.tonikelope.megabasterd.MegaMutableTreeNode;
import com.tonikelope.megabasterd.SmartMegaProxyManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public class MiscTools {
    public static final int EXP_BACKOFF_BASE = 2;
    public static final int EXP_BACKOFF_SECS_RETRY = 1;
    public static final int EXP_BACKOFF_MAX_WAIT_TIME = 8;
    public static final Object PASS_LOCK = new Object();
    public static final int HTTP_TIMEOUT = 30;
    public static final String UPLOAD_LOGS_DIR = System.getProperty("user.home") + File.separator + "MEGABASTERD_UPLOAD_LOGS";
    private static final Comparator<DefaultMutableTreeNode> TREE_NODE_COMPARATOR = (a, b) -> {
        if (a.isLeaf() && !b.isLeaf()) {
            return 1;
        }
        if (!a.isLeaf() && b.isLeaf()) {
            return -1;
        }
        Object ca = a.getUserObject();
        Object cb = b.getUserObject();
        if (ca instanceof String) {
            return MiscTools.naturalCompare((String)ca, (String)cb, true);
        }
        return MiscTools.naturalCompare((String)((Map)ca).get("name"), (String)((Map)cb).get("name"), true);
    };
    private static final Logger LOG = Logger.getLogger(MiscTools.class.getName());

    public static String computeFileSHA1(File file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            int n = 0;
            byte[] buffer = new byte[8192];
            while (n != -1) {
                n = fis.read(buffer);
                if (n <= 0) continue;
                digest.update(buffer, 0, n);
            }
            return new HexBinaryAdapter().marshal(digest.digest()).toLowerCase().trim();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void createUploadLogDir() {
        if (!Files.exists(Paths.get(UPLOAD_LOGS_DIR, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get(UPLOAD_LOGS_DIR, new String[0]), new FileAttribute[0]);
                File dir = new File(System.getProperty("user.home"));
                for (File file : dir.listFiles()) {
                    if (file.isDirectory() || !file.getName().startsWith("megabasterd_upload_")) continue;
                    Files.move(file.toPath(), Paths.get(UPLOAD_LOGS_DIR + File.separator + file.getName(), new String[0]), new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void purgeFolderCache() {
        File directory = new File(System.getProperty("java.io.tmpdir"));
        for (File f : directory.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith("megabasterd_folder_cache_")) continue;
            f.delete();
            Logger.getLogger(MiscTools.class.getName()).log(Level.INFO, "REMOVING FOLDER CACHE FILE {0}", f.getAbsolutePath());
        }
    }

    public static void containerSetEnabled(Container panel, boolean enabled) {
        for (Component cp : panel.getComponents()) {
            if (cp instanceof Container) {
                MiscTools.containerSetEnabled((Container)cp, enabled);
            }
            cp.setEnabled(enabled);
        }
    }

    public static String getFechaHoraActual() {
        String format = "dd-MM-yyyy HH:mm:ss";
        return MiscTools.getFechaHoraActual(format);
    }

    public static boolean isVideoFile(String filename) {
        try {
            String part_file = MiscTools.findFirstRegex("\\.part[0-9]+-[0-9]+$", filename, 0);
            return part_file == null && Files.probeContentType(Paths.get(filename, new String[0])).startsWith("video/");
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean isImageFile(String filename) {
        try {
            String part_file = MiscTools.findFirstRegex("\\.part[0-9]+-[0-9]+$", filename, 0);
            return part_file == null && Files.probeContentType(Paths.get(filename, new String[0])).startsWith("image/");
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static String getFechaHoraActual(String format) {
        Date currentDate = new Date(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(currentDate);
    }

    public static void deleteDirectoryRecursion(Path path) throws IOException {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    MiscTools.deleteDirectoryRecursion(entry);
                }
            }
        }
        Files.delete(path);
    }

    public static Font createAndRegisterFont(String name) {
        Font font = null;
        try {
            font = Font.createFont(0, MiscTools.class.getResourceAsStream(name));
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
        }
        catch (FontFormatException | IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        return font;
    }

    public static void setNimbusLookAndFeel(boolean dark) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                if (dark) {
                    UIManager.put("control", new Color(128, 128, 128));
                    UIManager.put("info", new Color(128, 128, 128));
                    UIManager.put("nimbusBase", new Color(18, 30, 49));
                    UIManager.put("nimbusAlertYellow", new Color(248, 187, 0));
                    UIManager.put("nimbusDisabledText", new Color(100, 100, 100));
                    UIManager.put("nimbusFocus", new Color(115, 164, 209));
                    UIManager.put("nimbusGreen", new Color(176, 179, 50));
                    UIManager.put("nimbusInfoBlue", new Color(66, 139, 221));
                    UIManager.put("nimbusLightBackground", new Color(18, 30, 49));
                    UIManager.put("nimbusOrange", new Color(191, 98, 4));
                    UIManager.put("nimbusRed", new Color(169, 46, 34));
                    UIManager.put("nimbusSelectedText", new Color(255, 255, 255));
                    UIManager.put("nimbusSelectionBackground", new Color(104, 93, 156));
                    UIManager.put("text", new Color(230, 230, 230));
                } else {
                    UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                    defaults.put("nimbusOrange", defaults.get("nimbusFocus"));
                }
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    public static int[] bin2i32a(byte[] bin) {
        int l = (int)(4.0 * Math.ceil((double)bin.length / 4.0));
        IntBuffer intBuf = ByteBuffer.wrap(bin, 0, l).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        int[] array = new int[intBuf.remaining()];
        intBuf.get(array);
        return array;
    }

    public static byte[] i32a2bin(int[] values) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (int i = 0; i < values.length; ++i) {
            try {
                dos.writeInt(values[i]);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return baos.toByteArray();
    }

    public static BigInteger mpi2big(byte[] s) {
        byte[] ns = Arrays.copyOfRange(s, 2, s.length);
        BigInteger bigi = new BigInteger(1, ns);
        return bigi;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static String genID(int length) {
        String pos = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        String res = "";
        Random randomno = new Random();
        for (int i = 0; i < length; ++i) {
            res = res + pos.charAt(randomno.nextInt(pos.length()));
        }
        return res;
    }

    public static byte[] long2bytearray(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        return b;
    }

    public static long bytearray2long(byte[] val) {
        long l = 0L;
        for (int i = 0; i <= 7; ++i) {
            l += (long)val[i];
            l <<= 8;
        }
        return l;
    }

    public static String findFirstRegex(String regex, String data, int group) {
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(data);
        return matcher.find() ? matcher.group(group) : null;
    }

    public static ArrayList<String> findAllRegex(String regex, String data, int group) {
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(data);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(group));
        }
        return matches;
    }

    public static void updateFonts(Component component, Font font, float zoom_factor) {
        if (component != null) {
            boolean error;
            if (component instanceof JMenu) {
                for (Component child : ((JMenu)component).getMenuComponents()) {
                    if (!(child instanceof JMenuItem)) continue;
                    MiscTools.updateFonts(child, font, zoom_factor);
                }
            } else if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    if (!(child instanceof Container)) continue;
                    MiscTools.updateFonts(child, font, zoom_factor);
                }
            }
            Font old_font = component.getFont();
            Font new_font = font.deriveFont(old_font.getStyle(), Math.round((float)old_font.getSize() * zoom_factor));
            do {
                try {
                    component.setFont(new_font);
                    error = false;
                }
                catch (Exception ex) {
                    error = true;
                }
            } while (error);
        }
    }

    public static void translateLabels(Component component) {
        if (component != null) {
            if (component instanceof JLabel) {
                ((JLabel)component).setText(LabelTranslatorSingleton.getInstance().translate(((JLabel)component).getText()));
            } else if (component instanceof JButton) {
                ((AbstractButton)component).setText(LabelTranslatorSingleton.getInstance().translate(((AbstractButton)component).getText()));
            } else if (component instanceof JCheckBox) {
                ((AbstractButton)component).setText(LabelTranslatorSingleton.getInstance().translate(((AbstractButton)component).getText()));
            } else if (component instanceof JMenuItem && !(component instanceof JMenu)) {
                ((AbstractButton)component).setText(LabelTranslatorSingleton.getInstance().translate(((AbstractButton)component).getText()));
            } else if (component instanceof JMenu) {
                for (Component child : ((JMenu)component).getMenuComponents()) {
                    if (!(child instanceof JMenuItem)) continue;
                    MiscTools.translateLabels(child);
                }
                ((AbstractButton)component).setText(LabelTranslatorSingleton.getInstance().translate(((AbstractButton)component).getText()));
            } else if (component instanceof Container) {
                for (Component child : ((Container)component).getComponents()) {
                    if (!(child instanceof Container)) continue;
                    MiscTools.translateLabels(child);
                }
                if (component instanceof JPanel && ((JComponent)component).getBorder() instanceof TitledBorder) {
                    ((TitledBorder)((JComponent)component).getBorder()).setTitle(LabelTranslatorSingleton.getInstance().translate(((TitledBorder)((JComponent)component).getBorder()).getTitle()));
                }
                if (component instanceof JDialog) {
                    ((Dialog)component).setTitle(LabelTranslatorSingleton.getInstance().translate(((Dialog)component).getTitle()));
                }
            }
        }
    }

    public static Sequencer midiLoopPlay(String midi, int volume) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer();
            if (sequencer == null) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, "MIDI Sequencer device not supported");
                return null;
            }
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            Sequence sequence = MidiSystem.getSequence(MiscTools.class.getResource(midi));
            for (Track t : sequence.getTracks()) {
                for (int k = 0; k < synthesizer.getChannels().length; ++k) {
                    t.add(new MidiEvent(new ShortMessage(176, k, 7, volume), t.ticks()));
                }
            }
            sequencer.open();
            sequencer.setSequence(sequence);
            sequencer.setLoopCount(-1);
            sequencer.start();
            return sequencer;
        }
        catch (IOException | InvalidMidiDataException | MidiUnavailableException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void updateTitledBorderFont(TitledBorder border, Font font, float zoom_factor) {
        Font old_title_font = border.getTitleFont();
        Font new_title_font = font.deriveFont(old_title_font.getStyle(), Math.round((float)old_title_font.getSize() * zoom_factor));
        border.setTitleFont(new_title_font);
    }

    public static String HashString(String algo, String data) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            byte[] thedigest = md.digest(data.getBytes("UTF-8"));
            return MiscTools.bin2hex(thedigest);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static String HashString(String algo, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algo);
        byte[] thedigest = md.digest(data);
        return MiscTools.bin2hex(thedigest);
    }

    public static byte[] HashBin(String algo, String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(algo);
        return md.digest(data.getBytes("UTF-8"));
    }

    public static byte[] HashBin(String algo, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algo);
        return md.digest(data);
    }

    public static byte[] BASE642Bin(String data) {
        return Base64.getDecoder().decode(data);
    }

    public static String Bin2BASE64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] UrlBASE642Bin(String data) {
        return Base64.getUrlDecoder().decode(data);
    }

    public static String Bin2UrlBASE64(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    public static void pausar(long pause) {
        try {
            Thread.sleep(pause);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void GUIRun(Runnable r) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }

    public static void GUIRunAndWait(Runnable r) {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(r);
            } else {
                r.run();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static FutureTask futureRun(Callable c) {
        FutureTask f = new FutureTask(c);
        Thread hilo = new Thread(f);
        hilo.start();
        return f;
    }

    public static long getWaitTimeExpBackOff(int retryCount) {
        long waitTime = (long)Math.pow(2.0, retryCount) * 1L;
        return Math.min(waitTime, 8L);
    }

    public static String bin2hex(byte[] b) {
        BigInteger bi = new BigInteger(1, b);
        return String.format("%0" + (b.length << 1) + "x", bi);
    }

    public static byte[] hex2bin(String s) {
        return DatatypeConverter.parseHexBinary(s);
    }

    public static void copyTextToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public static String formatBytes(Long bytes) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int pow = Math.min((int)(((bytes = Long.valueOf(Math.max(bytes, 0L))) > 0L ? Math.log(bytes.longValue()) : 0.0) / Math.log(1024.0)), units.length - 1);
        Double bytes_double = (double)bytes.longValue() / (double)(1L << 10 * pow);
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(bytes_double) + ' ' + units[pow];
    }

    public static MegaMutableTreeNode calculateTreeFolderSizes(MegaMutableTreeNode node) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (node.getChildAt(i).isLeaf()) {
                node.setMega_node_size(node.getMega_node_size() + ((MegaMutableTreeNode)node.getChildAt(i)).getMega_node_size());
                continue;
            }
            MiscTools.calculateTreeFolderSizes((MegaMutableTreeNode)node.getChildAt(i));
            node.setMega_node_size(node.getMega_node_size() + ((MegaMutableTreeNode)node.getChildAt(i)).getMega_node_size());
        }
        return node;
    }

    public static MegaMutableTreeNode resetTreeFolderSizes(MegaMutableTreeNode node) {
        if (!node.isLeaf()) {
            node.setMega_node_size(0L);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (node.getChildAt(i).isLeaf()) continue;
                MiscTools.resetTreeFolderSizes((MegaMutableTreeNode)node.getChildAt(i));
            }
        }
        return node;
    }

    public static MegaMutableTreeNode findMegaTreeNodeByID(MegaMutableTreeNode root, String node_id) {
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            MegaMutableTreeNode node = (MegaMutableTreeNode)e.nextElement();
            HashMap mega_node = (HashMap)node.getUserObject();
            if (!mega_node.get("h").equals(node_id)) continue;
            return node;
        }
        return null;
    }

    public static DefaultMutableTreeNode sortTree(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            MiscTools._sortTreeNode(node);
        }
        return root;
    }

    private static void _sortTreeNode(DefaultMutableTreeNode parent) {
        int n = parent.getChildCount();
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>(n);
        for (int i = 0; i < n; ++i) {
            children.add((DefaultMutableTreeNode)parent.getChildAt(i));
        }
        Collections.sort(children, TREE_NODE_COMPARATOR);
        parent.removeAllChildren();
        children.forEach(node -> parent.add((MutableTreeNode)node));
    }

    public static boolean deleteSelectedTreeItems(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            DefaultTreeModel tree_model = (DefaultTreeModel)tree.getModel();
            for (TreePath path : paths) {
                MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
                if (node == null) continue;
                if (node != tree_model.getRoot()) {
                    MutableTreeNode parent = (MutableTreeNode)node.getParent();
                    tree_model.removeNodeFromParent(node);
                    while (parent != null && parent.isLeaf()) {
                        if (parent != tree_model.getRoot()) {
                            MutableTreeNode parent_aux = (MutableTreeNode)parent.getParent();
                            tree_model.removeNodeFromParent(parent);
                            parent = parent_aux;
                            continue;
                        }
                        parent = null;
                    }
                    continue;
                }
                try {
                    MutableTreeNode new_root = (MutableTreeNode)tree_model.getRoot().getClass().newInstance();
                    tree.setModel(new DefaultTreeModel(new_root));
                    tree.setRootVisible(new_root.getChildCount() > 0);
                    tree.setEnabled(true);
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
                return true;
            }
            tree.setRootVisible(((TreeNode)tree_model.getRoot()).getChildCount() > 0);
            tree.setEnabled(true);
            return true;
        }
        return false;
    }

    public static boolean isDirEmpty(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                DirectoryStream<Path> directory = Files.newDirectoryStream(path);
                try {
                    boolean bl2 = bl = !directory.iterator().hasNext();
                    if (directory == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (directory != null) {
                            try {
                                directory.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                directory.close();
            }
            return bl;
        }
        return false;
    }

    public static boolean deleteAllExceptSelectedTreeItems(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        HashMap<DefaultMutableTreeNode, DefaultMutableTreeNode> hashmap_old = new HashMap<DefaultMutableTreeNode, DefaultMutableTreeNode>();
        DefaultTreeModel tree_model = (DefaultTreeModel)tree.getModel();
        if (paths != null) {
            Class<?> node_class = tree_model.getRoot().getClass();
            Object new_root = null;
            try {
                new_root = node_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((DefaultMutableTreeNode)new_root).setUserObject(((DefaultMutableTreeNode)tree_model.getRoot()).getUserObject());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (TreePath path : paths) {
                if ((MutableTreeNode)path.getLastPathComponent() != (MutableTreeNode)tree_model.getRoot()) {
                    Object parent = new_root;
                    for (Object path_element : path.getPath()) {
                        if ((DefaultMutableTreeNode)path_element == (DefaultMutableTreeNode)tree_model.getRoot()) continue;
                        if (hashmap_old.get(path_element) == null) {
                            Object node = null;
                            if ((DefaultMutableTreeNode)path_element == (DefaultMutableTreeNode)path.getLastPathComponent()) {
                                node = path_element;
                            } else {
                                try {
                                    node = node_class.newInstance();
                                    ((DefaultMutableTreeNode)node).setUserObject(((DefaultMutableTreeNode)path_element).getUserObject());
                                }
                                catch (IllegalAccessException | InstantiationException ex) {
                                    Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
                                }
                            }
                            if (parent == null) continue;
                            ((DefaultMutableTreeNode)parent).add((DefaultMutableTreeNode)node);
                            if (((TreeNode)path_element).isLeaf()) continue;
                            hashmap_old.put((DefaultMutableTreeNode)path_element, (DefaultMutableTreeNode)node);
                            parent = node;
                            continue;
                        }
                        parent = hashmap_old.get(path_element);
                    }
                    continue;
                }
                return false;
            }
            tree.setModel(new DefaultTreeModel(MiscTools.sortTree((DefaultMutableTreeNode)new_root)));
            tree.setRootVisible(new_root != null ? ((TreeNode)new_root).getChildCount() > 0 : false);
            tree.setEnabled(true);
            return true;
        }
        return false;
    }

    public static String truncateText(String text, int max_length) {
        String separator = " ... ";
        if ((max_length -= separator.length()) % 2 != 0) {
            --max_length;
        }
        return text.length() > max_length ? text.replaceAll("^(.{1," + max_length / 2 + "}).*?(.{1," + max_length / 2 + "})$", "$1" + separator + "$2") : text;
    }

    public static String cleanFilename(String filename) {
        return (System.getProperty("os.name").toLowerCase().contains("win") ? filename.replaceAll("[<>:\"/\\\\\\|\\?\\*\t]+", "") : filename).replaceAll("\\" + File.separator, "").replaceAll("\\.\\.+", "__").replaceAll("[\\x00-\\x1F]", "").trim();
    }

    public static String cleanFilePath(String path) {
        return !path.equals(".") ? (System.getProperty("os.name").toLowerCase().contains("win") ? path.replaceAll("[<>:\"\\|\\?\\*\t]+", "") : path).replaceAll(" +\\" + File.separator, "\\" + File.separator).replaceAll("\\.\\.+", "__").replaceAll("[\\x00-\\x1F]", "").trim() : path;
    }

    public static byte[] genRandomByteArray(int length) {
        byte[] the_array = new byte[length];
        Random randomno = new Random();
        randomno.nextBytes(the_array);
        return the_array;
    }

    public static String extractStringFromClipboardContents(Transferable contents) {
        String ret = null;
        if (contents != null) {
            try {
                Object o = contents.getTransferData(DataFlavor.stringFlavor);
                if (o instanceof String) {
                    ret = (String)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String extractMegaLinksFromString(String data) {
        String res = "";
        if (data != null) {
            String url_decoded;
            if (data.startsWith("moz-extension") || data.startsWith("chrome-extension")) {
                data = MiscTools.extensionURL2NormalLink(data);
            }
            ArrayList<String> links = new ArrayList<String>();
            try {
                url_decoded = URLDecoder.decode(data, "UTF-8");
            }
            catch (Exception ex) {
                url_decoded = data;
            }
            ArrayList<String> base64_chunks = MiscTools.findAllRegex("[A-Za-z0-9+/_-]+=*", url_decoded, 0);
            if (!base64_chunks.isEmpty()) {
                for (String chunk : base64_chunks) {
                    try {
                        String clean_data = MiscTools.newMegaLinks2Legacy(new String(Base64.getDecoder().decode(chunk)));
                        String decoded = MiscTools.findFirstRegex("(?:https?|mega)://[^\r\n]+(#[^\r\n!]*?)?![^\r\n!]+![^\\?\r\n/]+", clean_data, 0);
                        if (decoded == null) continue;
                        links.add(decoded);
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                url_decoded = URLDecoder.decode(data, "UTF-8");
            }
            catch (Exception ex) {
                url_decoded = data;
            }
            String clean_data = MiscTools.newMegaLinks2Legacy(url_decoded);
            links.addAll(MiscTools.findAllRegex("(?:https?|mega)://[^\r\n]+(#[^\r\n!]*?)?![^\r\n!]+![^\\?\r\n/]+", clean_data, 0));
            links.addAll(MiscTools.findAllRegex("mega://e(n|l)c[^\r\n]+", clean_data, 0));
            res = links.stream().map(s -> s + "\n").reduce(res, String::concat);
        }
        return res.trim();
    }

    public static String extractFirstMegaLinkFromString(String data) {
        String res = "";
        if (data != null) {
            try {
                String clean_data = MiscTools.newMegaLinks2Legacy(URLDecoder.decode(data, "UTF-8"));
                ArrayList<String> links = MiscTools.findAllRegex("(?:https?|mega)://[^\r\n]+(#[^\r\n!]*?)?![^\r\n!]+![^\\?\r\n/]+", clean_data, 0);
                links.addAll(MiscTools.findAllRegex("mega://e(n|l)c[^\r\n]+", clean_data, 0));
                if (links.size() > 0) {
                    res = links.get(0);
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkMegaDownloadUrl(String string_url) {
        if (string_url == null || "".equals(string_url)) {
            return false;
        }
        HttpURLConnection con = null;
        int http_status = 0;
        int http_error = 0;
        String current_smart_proxy = null;
        boolean smart_proxy_socks = false;
        ArrayList<String> excluded_proxy_list = new ArrayList<String>();
        do {
            SmartMegaProxyManager proxy_manager = MainPanel.getProxy_manager();
            if (MainPanel.isUse_smart_proxy() && proxy_manager != null && proxy_manager.isForce_smart_proxy()) {
                String[] smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                current_smart_proxy = smart_proxy[0];
                smart_proxy_socks = smart_proxy[1].equals("socks");
            }
            try {
                URL url = new URL(string_url + "/0-0");
                if ((current_smart_proxy != null || http_error == 509) && MainPanel.isUse_smart_proxy() && proxy_manager != null && !MainPanel.isUse_proxy()) {
                    String[] smart_proxy;
                    if (current_smart_proxy != null && http_error != 0) {
                        proxy_manager.blockProxy(current_smart_proxy, "HTTP " + String.valueOf(http_error));
                        smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                        current_smart_proxy = smart_proxy[0];
                        smart_proxy_socks = smart_proxy[1].equals("socks");
                    } else if (current_smart_proxy == null) {
                        smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                        current_smart_proxy = smart_proxy[0];
                        smart_proxy_socks = smart_proxy[1].equals("socks");
                    }
                    if (current_smart_proxy != null) {
                        String[] proxy_info = current_smart_proxy.split(":");
                        Proxy proxy = new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(proxy_info[0], Integer.parseInt(proxy_info[1])));
                        con = (HttpURLConnection)url.openConnection(proxy);
                    } else if (MainPanel.isUse_proxy()) {
                        con = (HttpURLConnection)url.openConnection(new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                        if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                            con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                        }
                    } else {
                        con = (HttpURLConnection)url.openConnection();
                    }
                } else if (MainPanel.isUse_proxy()) {
                    con = (HttpURLConnection)url.openConnection(new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                    if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                        con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                    }
                } else {
                    con = (HttpURLConnection)url.openConnection();
                }
                if (current_smart_proxy != null && proxy_manager != null) {
                    con.setConnectTimeout(proxy_manager.getProxy_timeout());
                    con.setReadTimeout(proxy_manager.getProxy_timeout() * 2);
                }
                con.setUseCaches(false);
                con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                http_status = con.getResponseCode();
                if (http_status != 200) {
                    http_error = http_status;
                    continue;
                }
                http_error = 0;
            }
            catch (Exception ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        } while (http_error == 509);
        return http_status != 403;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMyPublicIP() {
        String public_ip = null;
        HttpURLConnection con = null;
        try {
            URL url_api = new URL("http://whatismyip.akamai.com/");
            if (MainPanel.isUse_proxy()) {
                con = (HttpURLConnection)url_api.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                    con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                }
            } else {
                con = (HttpURLConnection)url_api.openConnection();
            }
            con.setUseCaches(false);
            try (InputStream is = con.getInputStream();
                 ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                int reads;
                byte[] buffer = new byte[16384];
                while ((reads = is.read(buffer)) != -1) {
                    byte_res.write(buffer, 0, reads);
                }
                public_ip = new String(byte_res.toByteArray(), "UTF-8");
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return public_ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkNewVersion(String url) {
        String new_version_major = null;
        String new_version_minor = null;
        String current_version_major = null;
        String current_version_minor = null;
        HttpURLConnection con = null;
        try {
            URL mb_url = new URL(url);
            if (MainPanel.isUse_proxy()) {
                con = (HttpURLConnection)mb_url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                    con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                }
            } else {
                con = (HttpURLConnection)mb_url.openConnection();
            }
            con.setUseCaches(false);
            try (InputStream is = con.getInputStream();
                 ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                int reads;
                byte[] buffer = new byte[16384];
                while ((reads = is.read(buffer)) != -1) {
                    byte_res.write(buffer, 0, reads);
                }
                String latest_version_res = new String(byte_res.toByteArray(), "UTF-8");
                String latest_version = MiscTools.findFirstRegex("releases\\/tag\\/v?([0-9]+\\.[0-9]+)", latest_version_res, 1);
                new_version_major = MiscTools.findFirstRegex("([0-9]+)\\.[0-9]+", latest_version, 1);
                new_version_minor = MiscTools.findFirstRegex("[0-9]+\\.([0-9]+)", latest_version, 1);
                current_version_major = MiscTools.findFirstRegex("([0-9]+)\\.[0-9]+$", "8.22", 1);
                current_version_minor = MiscTools.findFirstRegex("[0-9]+\\.([0-9]+)$", "8.22", 1);
                if (new_version_major != null && (Integer.parseInt(current_version_major) < Integer.parseInt(new_version_major) || Integer.parseInt(current_version_major) == Integer.parseInt(new_version_major) && Integer.parseInt(current_version_minor) < Integer.parseInt(new_version_minor))) {
                    String string = new_version_major + "." + new_version_minor;
                    return string;
                }
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return null;
    }

    public static void openBrowserURL(String url) {
        MainPanel.THREAD_POOL.execute(() -> {
            try {
                Logger.getLogger(MiscTools.class.getName()).log(Level.INFO, "Trying to open URL in external browser: {0}", url);
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(url));
                    return;
                }
                if (System.getProperty("os.name").toLowerCase().contains("nux")) {
                    Process p = Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                    p.waitFor();
                    p.destroy();
                    return;
                }
                Logger.getLogger(MiscTools.class.getName()).log(Level.WARNING, "Unable to open URL: Unsupported platform.", url);
            }
            catch (Exception ex) {
                Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        });
    }

    public static byte[] recReverseArray(byte[] arr, int start, int end) {
        if (start < end) {
            byte temp = arr[start];
            arr[start] = arr[end];
            arr[end] = temp;
            return MiscTools.recReverseArray(arr, start + 1, end - 1);
        }
        return arr;
    }

    public static String getCurrentJarParentPath() {
        try {
            CodeSource codeSource = MainPanel.class.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            return jarFile.getParentFile().getAbsolutePath();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void restartApplication() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(System.getProperty("java.home")).append(File.separator).append("bin").append(File.separator).append("java ");
        ManagementFactory.getRuntimeMXBean().getInputArguments().forEach(jvmArg -> cmd.append((String)jvmArg).append(" "));
        cmd.append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
        cmd.append(MainPanel.class.getName()).append(" native 1");
        try {
            Runtime.getRuntime().exec(cmd.toString());
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTools.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        System.exit(2);
    }

    public static int naturalCompare(String a, String b, boolean ignoreCase) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if (ignoreCase) {
            a = a.toLowerCase();
            b = b.toLowerCase();
        }
        int aLength = a.length();
        int bLength = b.length();
        int minSize = Math.min(aLength, bLength);
        boolean asNumeric = false;
        int lastNumericCompare = 0;
        for (int i = 0; i < minSize; ++i) {
            boolean bNumber;
            char aChar = a.charAt(i);
            char bChar = b.charAt(i);
            boolean aNumber = aChar >= '0' && aChar <= '9';
            boolean bl = bNumber = bChar >= '0' && bChar <= '9';
            if (asNumeric) {
                if (aNumber && bNumber) {
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aNumber) {
                    return 1;
                }
                if (bNumber) {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    if (aChar != bChar) {
                        return aChar - bChar;
                    }
                    asNumeric = false;
                    continue;
                }
                return lastNumericCompare;
            }
            if (aNumber && bNumber) {
                asNumeric = true;
                if (lastNumericCompare != 0) continue;
                lastNumericCompare = aChar - bChar;
                continue;
            }
            if (aChar == bChar) continue;
            return aChar - bChar;
        }
        if (asNumeric) {
            if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                return 1;
            }
            if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                return -1;
            }
            if (lastNumericCompare == 0) {
                return aLength - bLength;
            }
            return lastNumericCompare;
        }
        return aLength - bLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MegaAPI checkMegaAccountLoginAndShowMasterPassDialog(MainPanel main_panel, Container container, String email) throws Exception {
        boolean remember_master_pass = true;
        HashMap account_info = (HashMap)main_panel.getMega_accounts().get(email);
        MegaAPI ma = main_panel.getMega_active_accounts().get(email);
        if (ma == null) {
            ma = new MegaAPI();
            Object object = PASS_LOCK;
            synchronized (object) {
                String user_hash;
                String password_aes;
                if (main_panel.getMaster_pass_hash() != null) {
                    if (main_panel.getMaster_pass() == null) {
                        GetMasterPasswordDialog pdialog = new GetMasterPasswordDialog((Frame)container.getParent(), true, main_panel.getMaster_pass_hash(), main_panel.getMaster_pass_salt(), main_panel);
                        pdialog.setLocationRelativeTo(container);
                        pdialog.setVisible(true);
                        if (!pdialog.isPass_ok()) {
                            pdialog.dispose();
                            return null;
                        }
                        main_panel.setMaster_pass(pdialog.getPass());
                        pdialog.deletePass();
                        remember_master_pass = pdialog.getRemember_checkbox().isSelected();
                        pdialog.dispose();
                        password_aes = MiscTools.Bin2BASE64(CryptTools.aes_cbc_decrypt_pkcs7(MiscTools.BASE642Bin((String)account_info.get("password_aes")), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV));
                        user_hash = MiscTools.Bin2BASE64(CryptTools.aes_cbc_decrypt_pkcs7(MiscTools.BASE642Bin((String)account_info.get("user_hash")), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV));
                    } else {
                        password_aes = MiscTools.Bin2BASE64(CryptTools.aes_cbc_decrypt_pkcs7(MiscTools.BASE642Bin((String)account_info.get("password_aes")), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV));
                        user_hash = MiscTools.Bin2BASE64(CryptTools.aes_cbc_decrypt_pkcs7(MiscTools.BASE642Bin((String)account_info.get("user_hash")), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV));
                    }
                } else {
                    password_aes = (String)account_info.get("password_aes");
                    user_hash = (String)account_info.get("user_hash");
                }
                try {
                    Closeable bs;
                    HashMap<String, Object> old_session_data = DBTools.selectMegaSession(email);
                    boolean unserialization_error = false;
                    if (old_session_data != null) {
                        ObjectInputStream is;
                        Logger.getLogger(MiscTools.class.getName()).log(Level.INFO, "Reutilizando sesi\u00f3n de MEGA guardada para {0}", email);
                        MegaAPI old_ma = new MegaAPI();
                        if (((Boolean)old_session_data.get("crypt")).booleanValue()) {
                            bs = new ByteArrayInputStream(CryptTools.aes_cbc_decrypt_pkcs7((byte[])old_session_data.get("ma"), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV));
                            try {
                                is = new ObjectInputStream((InputStream)bs);
                                try {
                                    old_ma = (MegaAPI)is.readObject();
                                }
                                finally {
                                    is.close();
                                }
                            }
                            catch (Exception ex) {
                                unserialization_error = true;
                            }
                        } else {
                            bs = new ByteArrayInputStream((byte[])old_session_data.get("ma"));
                            try {
                                is = new ObjectInputStream((InputStream)bs);
                                try {
                                    old_ma = (MegaAPI)is.readObject();
                                }
                                finally {
                                    is.close();
                                }
                            }
                            catch (Exception ex) {
                                unserialization_error = true;
                            }
                        }
                        if (old_ma.getQuota() == null) {
                            unserialization_error = true;
                        } else {
                            ma = old_ma;
                        }
                    }
                    if (old_session_data == null || unserialization_error) {
                        String pincode = null;
                        if (ma.check2FA(email)) {
                            Get2FACode dialog = new Get2FACode((Frame)container.getParent(), true, email, main_panel);
                            dialog.setLocationRelativeTo(container);
                            dialog.setVisible(true);
                            if (!dialog.isCode_ok()) {
                                throw new MegaAPIException(-26);
                            }
                            pincode = dialog.getPin_code();
                        }
                        ma.fastLogin(email, MiscTools.bin2i32a(MiscTools.BASE642Bin(password_aes)), user_hash, pincode);
                        bs = new ByteArrayOutputStream();
                        try (ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);){
                            os.writeObject(ma);
                        }
                        if (main_panel.getMaster_pass() != null) {
                            DBTools.insertMegaSession(email, CryptTools.aes_cbc_encrypt_pkcs7(((ByteArrayOutputStream)bs).toByteArray(), main_panel.getMaster_pass(), CryptTools.AES_ZERO_IV), true);
                        } else {
                            DBTools.insertMegaSession(email, ((ByteArrayOutputStream)bs).toByteArray(), false);
                        }
                    }
                    main_panel.getMega_active_accounts().put(email, ma);
                }
                catch (MegaAPIException exception) {
                    if (exception.getCode() == -6) {
                        JOptionPane.showMessageDialog(container.getParent(), LabelTranslatorSingleton.getInstance().translate("You've tried to login too many times. Wait an hour."), "Error", 0);
                    }
                    throw exception;
                }
            }
        }
        if (!remember_master_pass) {
            main_panel.setMaster_pass(null);
        }
        return ma;
    }

    public static String newMegaLinks2Legacy(String data) {
        data = MiscTools.addBackSlashToLinks(MiscTools.addHTTPSToMegaLinks(data));
        data = data.replaceAll("(?:https://)?mega(?:\\.co)?\\.nz/folder/([^#]+)#([^\r\n/]+)/file/([^\r\n/]+)", "https://mega.nz/#F*$3!$1!$2");
        data = data.replaceAll("(?:https://)?mega(?:\\.co)?\\.nz/folder/([^#]+)#([^\r\n/]+)/folder/([^\r\n/]+)", "https://mega.nz/#F!$1@$3!$2");
        return data.replaceAll("(?:https://)?mega(?:\\.co)?\\.nz/folder/([^#]+)#([^\r\n]+)", "https://mega.nz/#F!$1!$2").replaceAll("(?:https://)?mega(?:\\.co)?\\.nz/file/([^#]+)#([^\r\n]+)", "https://mega.nz/#!$1!$2");
    }

    public static String addHTTPSToMegaLinks(String data) {
        return data.replaceAll("(?<!https?://)mega(?:\\.co)?\\.nz", "https://mega.nz");
    }

    public static String addBackSlashToLinks(String data) {
        return data.replaceAll("https?://", "\n$0");
    }

    public static String extensionURL2NormalLink(String data) {
        String toReplace = data.substring(0, data.indexOf(35) + 1);
        return data.replace(toReplace, "https://mega.nz");
    }

    private MiscTools() {
    }
}

