/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MegaProxyServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(MegaProxyServer.class.getName());
    private final String _password;
    private final int _port;
    private ServerSocket _serverSocket;
    private final MainPanel _main_panel;

    public MegaProxyServer(MainPanel main_panel, String password, int port) {
        this._main_panel = main_panel;
        this._password = password;
        this._port = port;
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public synchronized void stopServer() throws IOException {
        this._serverSocket.close();
    }

    @Override
    public void run() {
        try {
            this._serverSocket = new ServerSocket(this._port);
            try {
                Socket socket;
                while ((socket = this._serverSocket.accept()) != null) {
                    new Handler(socket, this._password).start();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        finally {
            if (!this._serverSocket.isClosed()) {
                try {
                    this._serverSocket.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
        }
    }

    public static class Handler
    extends Thread {
        public static final Pattern CONNECT_PATTERN = Pattern.compile("CONNECT (.*mega(?:\\.co)?\\.nz):(443) HTTP/(1\\.[01])", 2);
        public static final Pattern AUTH_PATTERN = Pattern.compile("Proxy-Authorization: Basic +(.+)", 2);
        private final Socket _clientSocket;
        private boolean _previousWasR = false;
        private final String _password;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void forwardData(Socket inputSocket, Socket outputSocket) {
            try {
                InputStream inputStream = inputSocket.getInputStream();
                try {
                    OutputStream outputStream = outputSocket.getOutputStream();
                    try {
                        int read;
                        byte[] buffer = new byte[4096];
                        do {
                            if ((read = inputStream.read(buffer)) <= 0) continue;
                            outputStream.write(buffer, 0, read);
                            if (inputStream.available() >= 1) continue;
                            outputStream.flush();
                        } while (read >= 0);
                    }
                    finally {
                        if (!outputSocket.isOutputShutdown()) {
                            outputSocket.shutdownOutput();
                        }
                    }
                }
                finally {
                    if (!inputSocket.isInputShutdown()) {
                        inputSocket.shutdownInput();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Handler(Socket clientSocket, String password) {
            this._clientSocket = clientSocket;
            this._password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                try {
                    String request = this.readLine(this._clientSocket);
                    LOG.log(Level.INFO, request);
                    Matcher matcher = CONNECT_PATTERN.matcher(request);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this._clientSocket.getOutputStream(), "UTF-8");
                    if (matcher.matches()) {
                        String header;
                        String proxy_auth = null;
                        do {
                            Matcher matcher_auth;
                            if ((matcher_auth = AUTH_PATTERN.matcher(header = this.readLine(this._clientSocket))).matches()) {
                                proxy_auth = new String(MiscTools.BASE642Bin(matcher_auth.group(1).trim()), "UTF-8");
                            }
                            LOG.log(Level.INFO, header);
                        } while (!"".equals(header));
                        if (proxy_auth != null && proxy_auth.matches(".*?: *?" + this._password)) {
                            Socket forwardSocket;
                            try {
                                forwardSocket = new Socket(matcher.group(1), Integer.parseInt(matcher.group(2)));
                            }
                            catch (IOException | NumberFormatException e) {
                                outputStreamWriter.write("HTTP/" + matcher.group(3) + " 502 Bad Gateway\r\n");
                                outputStreamWriter.write("Proxy-agent: MegaBasterd/0.1\r\n");
                                outputStreamWriter.write("\r\n");
                                outputStreamWriter.flush();
                                try {
                                    this._clientSocket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                            try {
                                outputStreamWriter.write("HTTP/" + matcher.group(3) + " 200 Connection established\r\n");
                                outputStreamWriter.write("Proxy-agent: MegaBasterd/0.1\r\n");
                                outputStreamWriter.write("\r\n");
                                outputStreamWriter.flush();
                                Thread remoteToClient = new Thread(){

                                    @Override
                                    public void run() {
                                        Handler.forwardData(forwardSocket, _clientSocket);
                                    }
                                };
                                remoteToClient.start();
                                try {
                                    if (this._previousWasR) {
                                        int read = this._clientSocket.getInputStream().read();
                                        if (read != -1) {
                                            if (read != 10) {
                                                forwardSocket.getOutputStream().write(read);
                                            }
                                            Handler.forwardData(this._clientSocket, forwardSocket);
                                        } else {
                                            if (!forwardSocket.isOutputShutdown()) {
                                                forwardSocket.shutdownOutput();
                                            }
                                            if (!this._clientSocket.isInputShutdown()) {
                                                this._clientSocket.shutdownInput();
                                            }
                                        }
                                    } else {
                                        Handler.forwardData(this._clientSocket, forwardSocket);
                                    }
                                    break block36;
                                }
                                finally {
                                    try {
                                        remoteToClient.join();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            finally {
                                forwardSocket.close();
                            }
                        }
                        outputStreamWriter.write("HTTP/1.1 403 Unauthorized\r\n");
                        outputStreamWriter.write("Proxy-agent: MegaBasterd/0.1\r\n");
                        outputStreamWriter.write("\r\n");
                        outputStreamWriter.flush();
                        break block36;
                    }
                    outputStreamWriter.write("HTTP/1.1 403 Unauthorized\r\n");
                    outputStreamWriter.write("Proxy-agent: MegaBasterd/0.1\r\n");
                    outputStreamWriter.write("\r\n");
                    outputStreamWriter.flush();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        this._clientSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private String readLine(Socket socket) throws IOException {
            int next;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            block4: while ((next = socket.getInputStream().read()) != -1) {
                if (this._previousWasR && next == 10) {
                    this._previousWasR = false;
                    continue;
                }
                this._previousWasR = false;
                switch (next) {
                    case 13: {
                        this._previousWasR = true;
                        break block4;
                    }
                    case 10: {
                        break block4;
                    }
                    default: {
                        byteArrayOutputStream.write(next);
                        continue block4;
                    }
                }
            }
            return byteArrayOutputStream.toString("UTF-8");
        }
    }
}

