/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPIException;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SmartMegaProxyManager;
import com.tonikelope.megabasterd.ThrottledOutputStream;
import com.tonikelope.megabasterd.Upload;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class MegaAPI
implements Serializable {
    public static final String API_URL = "https://g.api.mega.co.nz";
    public static String API_KEY = null;
    public static final int REQ_ID_LENGTH = 10;
    public static final Integer[] MEGA_ERROR_NO_EXCEPTION_CODES = new Integer[]{-1, -3};
    public static final int PBKDF2_ITERATIONS = 100000;
    public static final int PBKDF2_OUTPUT_BIT_LENGTH = 256;
    private static final Logger LOG = Logger.getLogger(MegaAPI.class.getName());
    private long _seqno;
    private String _sid = null;
    private int[] _master_key = null;
    private BigInteger[] _rsa_priv_key = null;
    private int[] _password_aes = null;
    private String _user_hash = null;
    private String _root_id = null;
    private String _inbox_id = null;
    private String _email = null;
    private String _full_email = null;
    private String _trashbin_id = null;
    private String _req_id = MiscTools.genID(10);
    private int _account_version = -1;
    private String _salt = null;

    public static int checkMEGAError(String data) {
        String error = MiscTools.findFirstRegex("^\\[?(\\-[0-9]+)\\]?$", data, 1);
        return error != null ? Integer.parseInt(error) : 0;
    }

    public MegaAPI() {
        Random randomno = new Random();
        this._seqno = randomno.nextLong() & 0xFFFFFFFFL;
    }

    public int getAccount_version() {
        return this._account_version;
    }

    public String getFull_email() {
        return this._full_email;
    }

    public String getEmail() {
        return this._email;
    }

    public int[] getPassword_aes() {
        return this._password_aes;
    }

    public String getUser_hash() {
        return this._user_hash;
    }

    public String getSid() {
        return this._sid;
    }

    public int[] getMaster_key() {
        return this._master_key;
    }

    public BigInteger[] getRsa_priv_key() {
        return this._rsa_priv_key;
    }

    public String getRoot_id() {
        return this._root_id;
    }

    public String getInbox_id() {
        return this._inbox_id;
    }

    public String getTrashbin_id() {
        return this._trashbin_id;
    }

    private void _realLogin(String pincode) throws Exception {
        String request = pincode != null ? "[{\"a\":\"us\", \"mfa\":\"" + pincode + "\", \"user\":\"" + this._email + "\",\"uh\":\"" + this._user_hash + "\"}]" : "[{\"a\":\"us\",\"user\":\"" + this._email + "\",\"uh\":\"" + this._user_hash + "\"}]";
        URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno));
        String res = this.RAW_REQUEST(request, url_api);
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
        String k = (String)res_map[0].get("k");
        String privk = (String)res_map[0].get("privk");
        this._master_key = MiscTools.bin2i32a(this.decryptKey(MiscTools.UrlBASE642Bin(k), MiscTools.i32a2bin(this._password_aes)));
        String csid = (String)res_map[0].get("csid");
        if (csid != null) {
            int[] enc_rsa_priv_key = MiscTools.bin2i32a(MiscTools.UrlBASE642Bin(privk));
            byte[] privk_byte = this.decryptKey(MiscTools.i32a2bin(enc_rsa_priv_key), MiscTools.i32a2bin(this._master_key));
            this._rsa_priv_key = this._extractRSAPrivKey(privk_byte);
            byte[] raw_sid = CryptTools.rsaDecrypt(MiscTools.mpi2big(MiscTools.UrlBASE642Bin(csid)), this._rsa_priv_key[0], this._rsa_priv_key[1], this._rsa_priv_key[2]);
            this._sid = MiscTools.Bin2UrlBASE64(Arrays.copyOfRange(raw_sid, 0, 43));
        }
        this.fetchNodes();
    }

    private void _readAccountVersionAndSalt() throws Exception {
        String request = "[{\"a\":\"us0\",\"user\":\"" + this._email + "\"}]";
        URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno));
        String res = this.RAW_REQUEST(request, url_api);
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
        this._account_version = (Integer)res_map[0].get("v");
        this._salt = (String)res_map[0].get("s");
    }

    public boolean check2FA(String email) throws Exception {
        URL url_api;
        ObjectMapper objectMapper = new ObjectMapper();
        String request = "[{\"a\":\"mfag\",\"e\":\"" + email + "\"}]";
        String res = this.RAW_REQUEST(request, url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno)));
        Integer[] res_map = objectMapper.readValue(res, Integer[].class);
        return res_map[0] == 1;
    }

    public void login(String email, String password, String pincode) throws Exception {
        this._full_email = email;
        String[] email_split = email.split(" *# *");
        this._email = email_split[0];
        if (this._account_version == -1) {
            this._readAccountVersionAndSalt();
        }
        if (this._account_version == 1) {
            this._password_aes = CryptTools.MEGAPrepareMasterKey(MiscTools.bin2i32a(password.getBytes("UTF-8")));
            this._user_hash = CryptTools.MEGAUserHash(this._email.toLowerCase().getBytes("UTF-8"), this._password_aes);
        } else {
            byte[] pbkdf2_key = CryptTools.PBKDF2HMACSHA512(password, MiscTools.UrlBASE642Bin(this._salt), 100000, 256);
            this._password_aes = MiscTools.bin2i32a(Arrays.copyOfRange(pbkdf2_key, 0, 16));
            this._user_hash = MiscTools.Bin2UrlBASE64(Arrays.copyOfRange(pbkdf2_key, 16, 32));
        }
        this._realLogin(pincode);
    }

    public void fastLogin(String email, int[] password_aes, String user_hash, String pincode) throws Exception {
        this._full_email = email;
        String[] email_split = email.split(" *# *");
        this._email = email_split[0];
        if (this._account_version == -1) {
            this._readAccountVersionAndSalt();
        }
        this._password_aes = password_aes;
        this._user_hash = user_hash;
        this._realLogin(pincode);
    }

    public Long[] getQuota() {
        Long[] quota = null;
        try {
            String request = "[{\"a\": \"uq\", \"xfer\": 1, \"strg\": 1}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            quota = new Long[2];
            if (res_map[0].get("cstrg") instanceof Integer) {
                quota[0] = ((Number)res_map[0].get("cstrg")).longValue();
            } else if (res_map[0].get("cstrg") instanceof Long) {
                quota[0] = (Long)res_map[0].get("cstrg");
            }
            if (res_map[0].get("mstrg") instanceof Integer) {
                quota[1] = ((Number)res_map[0].get("mstrg")).longValue();
            } else if (res_map[0].get("mstrg") instanceof Long) {
                quota[1] = (Long)res_map[0].get("mstrg");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return quota;
    }

    public void fetchNodes() throws IOException {
        String request = "[{\"a\":\"f\", \"c\":1}]";
        try {
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            for (Object o : (Iterable)res_map[0].get("f")) {
                HashMap element = (HashMap)o;
                int file_type = (Integer)element.get("t");
                switch (file_type) {
                    case 2: {
                        this._root_id = (String)element.get("h");
                        break;
                    }
                    case 3: {
                        this._inbox_id = (String)element.get("h");
                        break;
                    }
                    case 4: {
                        this._trashbin_id = (String)element.get("h");
                        break;
                    }
                }
            }
        }
        catch (MegaAPIException | IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String RAW_REQUEST(String request, URL url_api) throws MegaAPIException {
        String response = null;
        String current_smart_proxy = null;
        int mega_error = 0;
        int http_error = 0;
        int conta_error = 0;
        boolean empty_response = false;
        boolean smart_proxy_socks = false;
        HttpURLConnection con = null;
        ArrayList<String> excluded_proxy_list = new ArrayList<String>();
        do {
            block37: {
                SmartMegaProxyManager proxy_manager = MainPanel.getProxy_manager();
                try {
                    if ((current_smart_proxy != null || http_error == 509) && MainPanel.isUse_smart_proxy() && proxy_manager != null && !MainPanel.isUse_proxy()) {
                        String[] smart_proxy;
                        if (current_smart_proxy != null && (http_error != 0 || empty_response)) {
                            proxy_manager.blockProxy(current_smart_proxy, "HTTP " + String.valueOf(http_error));
                            smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                            current_smart_proxy = smart_proxy[0];
                            smart_proxy_socks = smart_proxy[1].equals("socks");
                        } else if (current_smart_proxy == null) {
                            smart_proxy = proxy_manager.getProxy(excluded_proxy_list);
                            current_smart_proxy = smart_proxy[0];
                            smart_proxy_socks = smart_proxy[1].equals("socks");
                        }
                        if (current_smart_proxy != null) {
                            String[] proxy_info = current_smart_proxy.split(":");
                            Proxy proxy = new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(proxy_info[0], Integer.parseInt(proxy_info[1])));
                            con = (HttpsURLConnection)url_api.openConnection(proxy);
                        } else {
                            con = (HttpsURLConnection)url_api.openConnection();
                        }
                    } else if (MainPanel.isUse_proxy()) {
                        con = (HttpsURLConnection)url_api.openConnection(new Proxy(smart_proxy_socks ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                        if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                            con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                        }
                    } else {
                        con = (HttpsURLConnection)url_api.openConnection();
                    }
                    http_error = 0;
                    mega_error = 0;
                    empty_response = false;
                    con.setRequestProperty("Content-type", "text/plain;charset=UTF-8");
                    con.setRequestProperty("Accept-Encoding", "gzip");
                    con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                    con.setUseCaches(false);
                    con.setRequestMethod("POST");
                    con.setDoOutput(true);
                    con.getOutputStream().write(request.getBytes("UTF-8"));
                    con.getOutputStream().close();
                    int http_status = con.getResponseCode();
                    if (http_status != 200) {
                        LOG.log(Level.WARNING, "{0} {1} {2}", new Object[]{Thread.currentThread().getName(), request, url_api.toString()});
                        LOG.log(Level.WARNING, "{0} Failed : HTTP error code : {1}", new Object[]{Thread.currentThread().getName(), http_status});
                        http_error = http_status;
                        break block37;
                    }
                    try (InputStream is = "gzip".equals(con.getContentEncoding()) ? new GZIPInputStream(con.getInputStream()) : con.getInputStream();
                         ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                        int reads;
                        byte[] buffer = new byte[16384];
                        while ((reads = is.read(buffer)) != -1) {
                            byte_res.write(buffer, 0, reads);
                        }
                        response = new String(byte_res.toByteArray(), "UTF-8");
                        if (response.length() > 0) {
                            mega_error = MegaAPI.checkMEGAError(response);
                            if (mega_error != 0 && !Arrays.asList(MEGA_ERROR_NO_EXCEPTION_CODES).contains(mega_error)) {
                                throw new MegaAPIException(mega_error);
                            }
                        } else {
                            empty_response = true;
                        }
                    }
                }
                catch (SSLException ssl_ex) {
                    empty_response = true;
                    Logger.getLogger(MegaAPI.class.getName()).log(Level.SEVERE, ssl_ex.getMessage());
                }
                catch (IOException ex) {
                    Logger.getLogger(MegaAPI.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
                finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
            }
            if (!empty_response && mega_error == 0 && http_error == 0 || http_error == 509) continue;
            LOG.log(Level.WARNING, "{0} MegaAPI ERROR {1} Waiting for retry...", new Object[]{Thread.currentThread().getName(), String.valueOf(mega_error)});
            try {
                Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error++) * 1000L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        } while (http_error == 500 || empty_response || mega_error != 0 || http_error == 509 && MainPanel.isUse_smart_proxy() && !MainPanel.isUse_proxy());
        ++this._seqno;
        return response;
    }

    public String getMegaFileDownloadUrl(String link) throws MegaAPIException, MalformedURLException, IOException {
        URL url_api;
        String request;
        String file_id = MiscTools.findFirstRegex("#.*?!([^!]+)", link, 1);
        if (MiscTools.findFirstRegex("#N!", link, 0) != null) {
            String folder_id = MiscTools.findFirstRegex("###n=(.+)$", link, 1);
            request = "[{\"a\":\"g\", \"g\":\"1\", \"n\":\"" + file_id + "\"}]";
            url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : "") + "&n=" + folder_id);
        } else {
            request = "[{\"a\":\"g\", \"g\":\"1\", \"p\":\"" + file_id + "\"}]";
            url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
        }
        String data = this.RAW_REQUEST(request, url_api);
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap[] res_map = objectMapper.readValue(data, HashMap[].class);
        String download_url = (String)res_map[0].get("g");
        if (download_url == null || "".equals(download_url)) {
            throw new MegaAPIException(-101);
        }
        return download_url;
    }

    public String[] getMegaFileMetadata(String link) throws MegaAPIException, MalformedURLException, IOException {
        URL url_api;
        String request;
        String file_id = MiscTools.findFirstRegex("#.*?!([^!]+)", link, 1);
        String file_key = MiscTools.findFirstRegex("#.*?![^!]+!([^!#]+)", link, 1);
        if (MiscTools.findFirstRegex("#N!", link, 0) != null) {
            String folder_id = MiscTools.findFirstRegex("###n=(.+)$", link, 1);
            request = "[{\"a\":\"g\", \"g\":\"1\", \"n\":\"" + file_id + "\"}]";
            url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : "") + "&n=" + folder_id);
        } else {
            request = "[{\"a\":\"g\", \"p\":\"" + file_id + "\"}]";
            url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
        }
        String data = this.RAW_REQUEST(request, url_api);
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap[] res_map = objectMapper.readValue(data, HashMap[].class);
        String fsize = String.valueOf(res_map[0].get("s"));
        String at = (String)res_map[0].get("at");
        String[] file_data = null;
        HashMap att_map = this._decAttr(at, CryptTools.initMEGALinkKey(file_key));
        if (att_map == null) {
            throw new MegaAPIException(-14);
        }
        String fname = MiscTools.cleanFilename((String)att_map.get("n"));
        file_data = new String[]{fname, fsize, file_key};
        return file_data;
    }

    private byte[] _encThumbAttr(byte[] attr_byte, byte[] key) {
        try {
            return CryptTools.aes_cbc_encrypt_pkcs7(attr_byte, key, CryptTools.AES_ZERO_IV);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }

    private byte[] _encAttr(String attr, byte[] key) {
        byte[] ret = null;
        try {
            byte[] attr_byte = ("MEGA" + attr).getBytes("UTF-8");
            int l = (int)(16.0 * Math.ceil((double)attr_byte.length / 16.0));
            byte[] new_attr_byte = Arrays.copyOfRange(attr_byte, 0, l);
            ret = CryptTools.aes_cbc_encrypt_nopadding(new_attr_byte, key, CryptTools.AES_ZERO_IV);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return ret;
    }

    private HashMap _decAttr(String encAttr, byte[] key) {
        HashMap res_map = null;
        try {
            byte[] decrypted_at = CryptTools.aes_cbc_decrypt_nopadding(MiscTools.UrlBASE642Bin(encAttr), key, CryptTools.AES_ZERO_IV);
            String att = new String(decrypted_at, "UTF-8").replaceAll("\u0000+$", "").replaceAll("^MEGA", "");
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            res_map = objectMapper.readValue(att, HashMap.class);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return res_map;
    }

    public String initUploadFile(String filename) throws MegaAPIException {
        String ul_url = null;
        try {
            File f = new File(filename);
            String request = "[{\"a\":\"u\", \"s\":" + String.valueOf(f.length()) + "}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            ul_url = (String)res_map[0].get("p");
        }
        catch (MegaAPIException mae) {
            throw mae;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return ul_url;
    }

    public String uploadThumbnails(Upload upload, String node_handle, String filename0, String filename1) throws MegaAPIException {
        String[] ul_url = new String[2];
        String[] hash = new String[2];
        try {
            File[] files = new File[2];
            files[0] = new File(filename0);
            byte[][] file_bytes = new byte[2][];
            file_bytes[0] = this._encThumbAttr(Files.readAllBytes(files[0].toPath()), upload.getByte_file_key());
            files[1] = new File(filename1);
            file_bytes[1] = this._encThumbAttr(Files.readAllBytes(files[1].toPath()), upload.getByte_file_key());
            String request = "[{\"a\":\"ufa\", \"s\":" + String.valueOf(file_bytes[0].length) + ", \"ssl\":1}, {\"a\":\"ufa\", \"s\":" + String.valueOf(file_bytes[1].length) + ", \"ssl\":1}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            ul_url[0] = (String)res_map[0].get("p");
            ul_url[1] = (String)res_map[1].get("p");
            int h = 0;
            for (String u : ul_url) {
                URL url = new URL(u);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setConnectTimeout(60000);
                con.setReadTimeout(60000);
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                byte[] buffer = new byte[8192];
                try (ThrottledOutputStream out = new ThrottledOutputStream(con.getOutputStream(), upload.getMain_panel().getStream_supervisor());){
                    out.write(file_bytes[h]);
                }
                try (InputStream is = con.getInputStream();
                     ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                    int reads;
                    while ((reads = is.read(buffer)) != -1) {
                        byte_res.write(buffer, 0, reads);
                    }
                    hash[h] = MiscTools.Bin2UrlBASE64(byte_res.toByteArray());
                }
                ++h;
            }
            request = "[{\"a\":\"pfa\", \"fa\":\"0*" + hash[0] + "/1*" + hash[1] + "\", \"n\":\"" + node_handle + "\"}]";
            url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            res = this.RAW_REQUEST(request, url_api);
            objectMapper = new ObjectMapper();
            String[] resp = objectMapper.readValue(res, String[].class);
            return resp[0];
        }
        catch (MegaAPIException mae) {
            throw mae;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
            return "";
        }
    }

    public HashMap<String, Object> finishUploadFile(String fbasename, int[] ul_key, int[] fkey, int[] meta_mac, String completion_handle, String mega_parent, byte[] master_key, String root_node, byte[] share_key) throws MegaAPIException {
        HashMap[] res_map = null;
        try {
            byte[] enc_att = this._encAttr("{\"n\":\"" + fbasename + "\"}", MiscTools.i32a2bin(Arrays.copyOfRange(ul_key, 0, 4)));
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String request = "[{\"a\":\"p\", \"t\":\"" + mega_parent + "\", \"n\":[{\"h\":\"" + completion_handle + "\", \"t\":0, \"a\":\"" + MiscTools.Bin2UrlBASE64(enc_att) + "\", \"k\":\"" + MiscTools.Bin2UrlBASE64(this.encryptKey(MiscTools.i32a2bin(fkey), master_key)) + "\"}], \"i\":\"" + this._req_id + "\", \"cr\" : [ [\"" + root_node + "\"] , [\"" + completion_handle + "\"] , [0,0, \"" + MiscTools.Bin2UrlBASE64(this.encryptKey(MiscTools.i32a2bin(fkey), share_key)) + "\"]]}]";
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            res_map = objectMapper.readValue(res, HashMap[].class);
        }
        catch (MegaAPIException mae) {
            throw mae;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return res_map != null ? res_map[0] : null;
    }

    public byte[] encryptKey(byte[] a, byte[] key) throws Exception {
        return CryptTools.aes_ecb_encrypt_nopadding(a, key);
    }

    public byte[] decryptKey(byte[] a, byte[] key) throws Exception {
        return CryptTools.aes_ecb_decrypt_nopadding(a, key);
    }

    private BigInteger[] _extractRSAPrivKey(byte[] rsa_data) {
        BigInteger[] rsa_key = new BigInteger[4];
        int offset = 0;
        for (int i = 0; i < 4; ++i) {
            int l = (256 * (rsa_data[offset] & 0xFF) + (rsa_data[offset + 1] & 0xFF) + 7) / 8 + 2;
            rsa_key[i] = MiscTools.mpi2big(Arrays.copyOfRange(rsa_data, offset, offset + l));
            offset += l;
        }
        return rsa_key;
    }

    public HashMap<String, Object> createDir(String name, String parent_node, byte[] node_key, byte[] master_key) {
        HashMap[] res_map = null;
        try {
            byte[] enc_att = this._encAttr("{\"n\":\"" + name + "\"}", node_key);
            byte[] enc_node_key = this.encryptKey(node_key, master_key);
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String request = "[{\"a\":\"p\", \"t\":\"" + parent_node + "\", \"n\":[{\"h\":\"xxxxxxxx\",\"t\":1,\"a\":\"" + MiscTools.Bin2UrlBASE64(enc_att) + "\",\"k\":\"" + MiscTools.Bin2UrlBASE64(enc_node_key) + "\"}],\"i\":\"" + this._req_id + "\"}]";
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            res_map = objectMapper.readValue(res, HashMap[].class);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return res_map != null ? res_map[0] : null;
    }

    public HashMap<String, Object> createDirInsideAnotherSharedDir(String name, String parent_node, byte[] node_key, byte[] master_key, String root_node, byte[] share_key) {
        HashMap[] res_map = null;
        try {
            byte[] enc_att = this._encAttr("{\"n\":\"" + name + "\"}", node_key);
            byte[] enc_node_key = this.encryptKey(node_key, master_key);
            byte[] enc_node_key_s = this.encryptKey(node_key, share_key);
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String request = "[{\"a\":\"p\", \"t\":\"" + parent_node + "\", \"n\":[{\"h\":\"xxxxxxxx\",\"t\":1,\"a\":\"" + MiscTools.Bin2UrlBASE64(enc_att) + "\",\"k\":\"" + MiscTools.Bin2UrlBASE64(enc_node_key) + "\"}],\"i\":\"" + this._req_id + "\", \"cr\" : [ [\"" + root_node + "\"] , [\"xxxxxxxx\"] , [0,0, \"" + MiscTools.Bin2UrlBASE64(enc_node_key_s) + "\"]]}]";
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            res_map = objectMapper.readValue(res, HashMap[].class);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return res_map != null ? res_map[0] : null;
    }

    public String getPublicFileLink(String node, byte[] node_key) {
        String public_link = null;
        try {
            String request = "[{\"a\":\"l\", \"n\":\"" + node + "\"}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            List res_map = objectMapper.readValue(res, List.class);
            String file_id = (String)res_map.get(0);
            public_link = "https://mega.nz/#!" + file_id + "!" + MiscTools.Bin2UrlBASE64(node_key);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return public_link;
    }

    public String getPublicFolderLink(String node, byte[] node_key) {
        String public_link = null;
        try {
            String request = "[{\"a\":\"l\", \"n\":\"" + node + "\", \"i\":\"" + this._req_id + "\"}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            String res = this.RAW_REQUEST(request, url_api);
            ObjectMapper objectMapper = new ObjectMapper();
            List res_map = objectMapper.readValue(res, List.class);
            String folder_id = (String)res_map.get(0);
            public_link = "https://mega.nz/#F!" + folder_id + "!" + MiscTools.Bin2UrlBASE64(node_key);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return public_link;
    }

    public int[] genUploadKey() {
        return MiscTools.bin2i32a(MiscTools.genRandomByteArray(24));
    }

    public byte[] genFolderKey() {
        return MiscTools.genRandomByteArray(16);
    }

    public byte[] genShareKey() {
        return MiscTools.genRandomByteArray(16);
    }

    public String shareFolder(String node, byte[] node_key, byte[] share_key) {
        try {
            String ok = MiscTools.Bin2UrlBASE64(this.encryptKey(share_key, MiscTools.i32a2bin(this.getMaster_key())));
            String enc_nk = MiscTools.Bin2UrlBASE64(this.encryptKey(node_key, share_key));
            String ha = this.cryptoHandleauth(node);
            String request = "[{\"a\":\"s2\",\"n\":\"" + node + "\",\"s\":[{\"u\":\"EXP\",\"r\":0}],\"i\":\"" + this._req_id + "\",\"ok\":\"AAAAAAAAAAAAAAAAAAAAAA\",\"ha\":\"AAAAAAAAAAAAAAAAAAAAAA\",\"cr\":[[\"" + node + "\"],[\"" + node + "\"],[0,0,\"" + enc_nk + "\"]]}]";
            URL url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + (this._sid != null ? "&sid=" + this._sid : ""));
            return this.RAW_REQUEST(request, url_api);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }

    public String cryptoHandleauth(String h) {
        String ch = null;
        try {
            ch = MiscTools.Bin2UrlBASE64(this.encryptKey((h + h).getBytes("UTF-8"), MiscTools.i32a2bin(this.getMaster_key())));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
        }
        return ch;
    }

    public boolean existsCachedFolderNodes(String folder_id) {
        return Files.exists(Paths.get(System.getProperty("java.io.tmpdir") + File.separator + "megabasterd_folder_cache_" + folder_id, new String[0]), new LinkOption[0]);
    }

    private String getCachedFolderNodes(String folder_id) {
        String file_path = System.getProperty("java.io.tmpdir") + File.separator + "megabasterd_folder_cache_" + folder_id;
        if (Files.exists(Paths.get(file_path, new String[0]), new LinkOption[0])) {
            LOG.log(Level.INFO, "MEGA FOLDER {0} USING CACHED JSON FILE TREE", new Object[]{folder_id});
            try {
                return new String(Files.readAllBytes(Paths.get(file_path, new String[0])), "UTF-8");
            }
            catch (IOException ex) {
                Logger.getLogger(MegaAPI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private void writeCachedFolderNodes(String folder_id, String res) {
        String file_path = System.getProperty("java.io.tmpdir") + File.separator + "megabasterd_folder_cache_" + folder_id;
        try {
            Files.write(Paths.get(file_path, new String[0]), res.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            Logger.getLogger(MegaAPI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public HashMap<String, Object> getFolderNodes(String folder_id, String folder_key, JProgressBar bar, boolean cache) throws Exception {
        URL url_api;
        String request;
        HashMap<String, Object> folder_nodes = null;
        String res = null;
        if (cache) {
            res = this.getCachedFolderNodes(folder_id);
        }
        if (res == null && (res = this.RAW_REQUEST(request = "[{\"a\":\"f\", \"c\":\"1\", \"r\":\"1\", \"ca\":\"1\"}]", url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + "&n=" + folder_id))) != null) {
            this.writeCachedFolderNodes(folder_id, res);
        }
        LOG.log(Level.INFO, "MEGA FOLDER {0} JSON FILE TREE SIZE -> {1}", new Object[]{folder_id, MiscTools.formatBytes(Long.valueOf(res.length()))});
        if (res != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            folder_nodes = new HashMap<String, Object>();
            int s = ((List)res_map[0].get("f")).size();
            if (bar != null) {
                MiscTools.GUIRun(() -> {
                    bar.setIndeterminate(false);
                    bar.setMaximum(s);
                    bar.setValue(0);
                });
            }
            int conta_nodo = 0;
            for (Object o : (Iterable)res_map[0].get("f")) {
                HashMap node;
                String[] node_k;
                int c = ++conta_nodo;
                if (bar != null) {
                    MiscTools.GUIRun(() -> bar.setValue(c));
                }
                if ((node_k = ((String)(node = (HashMap)o).get("k")).split(":")).length == 2 && node_k[0] != "" && node_k[1] != "") {
                    try {
                        String dec_node_k = MiscTools.Bin2UrlBASE64(this.decryptKey(MiscTools.UrlBASE642Bin(node_k[1]), this._urlBase64KeyDecode(folder_key)));
                        HashMap at = this._decAttr((String)node.get("a"), this._urlBase64KeyDecode(dec_node_k));
                        HashMap the_node = new HashMap();
                        the_node.put("type", node.get("t"));
                        the_node.put("parent", node.get("p"));
                        the_node.put("key", dec_node_k);
                        if (node.get("s") != null) {
                            long size;
                            if (node.get("s") instanceof Integer) {
                                size = ((Number)node.get("s")).longValue();
                                the_node.put("size", size);
                            } else if (node.get("s") instanceof Long) {
                                size = (Long)node.get("s");
                                the_node.put("size", size);
                            }
                        } else {
                            the_node.put("size", 0L);
                        }
                        the_node.put("name", at.get("n"));
                        the_node.put("h", node.get("h"));
                        folder_nodes.put((String)node.get("h"), the_node);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "WARNING: node key is not valid " + (String)node.get("k") + " " + folder_key);
                    }
                    continue;
                }
                LOG.log(Level.WARNING, "WARNING: node key is not valid " + (String)node.get("k") + " " + folder_key);
            }
        } else {
            throw new Exception();
        }
        return folder_nodes;
    }

    public ArrayList<String> GENERATE_N_LINKS(Set<String> links) {
        HashMap map = new HashMap();
        ArrayList<String> nlinks = new ArrayList<String>();
        for (String string : links) {
            String folder_id = MiscTools.findFirstRegex("#F\\*[^!]+!([^!]+)", string, 1);
            String folder_key = MiscTools.findFirstRegex("#F\\*[^!]+![^!]+!([^!]+)", string, 1);
            String file_id = MiscTools.findFirstRegex("#F\\*([^!]+)", string, 1);
            if (!map.containsKey(folder_id + ":" + folder_key)) {
                ArrayList<String> lista = new ArrayList<String>();
                lista.add(file_id);
                map.put(folder_id + ":" + folder_key, lista);
                continue;
            }
            ((ArrayList)map.get(folder_id + ":" + folder_key)).add(file_id);
        }
        for (Map.Entry entry : map.entrySet()) {
            String[] folder_parts = ((String)entry.getKey()).split(":");
            int r = -1;
            if (this.existsCachedFolderNodes(folder_parts[0])) {
                r = JOptionPane.showConfirmDialog(MainPanelView.getINSTANCE(), "Do you want to use FOLDER [" + folder_parts[0] + "] CACHED VERSION?\n\n(It could speed up the loading of very large folders)", "FOLDER CACHE", 0);
            }
            try {
                nlinks.addAll(this.getNLinksFromFolder(folder_parts[0], folder_parts[1], (ArrayList)entry.getValue(), r == 0));
            }
            catch (Exception ex) {
                Logger.getLogger(MegaAPI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return nlinks;
    }

    public ArrayList<String> getNLinksFromFolder(String folder_id, String folder_key, ArrayList<String> file_ids, boolean cache) throws Exception {
        URL url_api;
        String request;
        ArrayList<String> nlinks = new ArrayList<String>();
        String res = null;
        if (cache) {
            res = this.getCachedFolderNodes(folder_id);
        }
        if (res == null && (res = this.RAW_REQUEST(request = "[{\"a\":\"f\", \"c\":\"1\", \"r\":\"1\", \"ca\":\"1\"}]", url_api = new URL("https://g.api.mega.co.nz/cs?id=" + String.valueOf(this._seqno) + "&n=" + folder_id))) != null) {
            this.writeCachedFolderNodes(folder_id, res);
        }
        LOG.log(Level.INFO, "MEGA FOLDER {0} JSON FILE TREE SIZE -> {1}", new Object[]{folder_id, MiscTools.formatBytes(Long.valueOf(res.length()))});
        if (res != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap[] res_map = objectMapper.readValue(res, HashMap[].class);
            for (Object o : (Iterable)res_map[0].get("f")) {
                HashMap node = (HashMap)o;
                String[] node_k = ((String)node.get("k")).split(":");
                if (node_k.length == 2 && node_k[0] != "" && node_k[1] != "") {
                    try {
                        String dec_node_k = MiscTools.Bin2UrlBASE64(this.decryptKey(MiscTools.UrlBASE642Bin(node_k[1]), this._urlBase64KeyDecode(folder_key)));
                        if (!file_ids.contains((String)node.get("h"))) continue;
                        nlinks.add("https://mega.nz/#N!" + (String)node.get("h") + "!" + dec_node_k + "###n=" + folder_id);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "WARNING: node key is not valid " + (String)node.get("k") + " " + folder_key);
                    }
                    continue;
                }
                LOG.log(Level.WARNING, "WARNING: node key is not valid " + (String)node.get("k") + " " + folder_key);
            }
        } else {
            throw new Exception();
        }
        return nlinks;
    }

    private byte[] _urlBase64KeyDecode(String key) {
        try {
            byte[] key_bin = MiscTools.UrlBASE642Bin(key);
            if (key_bin.length < 32) {
                return Arrays.copyOfRange(key_bin, 0, 16);
            }
            int[] key_i32a = MiscTools.bin2i32a(Arrays.copyOfRange(key_bin, 0, 32));
            int[] k = new int[]{key_i32a[0] ^ key_i32a[4], key_i32a[1] ^ key_i32a[5], key_i32a[2] ^ key_i32a[6], key_i32a[3] ^ key_i32a[7]};
            return MiscTools.i32a2bin(k);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage());
            return null;
        }
    }
}

