/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.AboutDialog;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.FileGrabberDialog;
import com.tonikelope.megabasterd.FileMergerDialog;
import com.tonikelope.megabasterd.FileSplitterDialog;
import com.tonikelope.megabasterd.FolderLinkDialog;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.LinkGrabberDialog;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaDirNode;
import com.tonikelope.megabasterd.MegaProxyServer;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SettingsDialog;
import com.tonikelope.megabasterd.SmartMegaProxyManager;
import com.tonikelope.megabasterd.StreamerDialog;
import com.tonikelope.megabasterd.Upload;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public final class MainPanelView
extends JFrame {
    private final MainPanel _main_panel;
    private static volatile MainPanelView INSTANCE = null;
    private JMenuItem about_menu;
    private JCheckBoxMenuItem auto_close_menu;
    private JMenuItem cancel_all_downloads_menu;
    private JMenuItem clean_all_down_menu;
    private JMenuItem clean_all_up_menu;
    private JButton close_all_finished_down_button;
    private JButton close_all_finished_up_button;
    private JButton copy_all_uploads;
    private JLabel down_remtime_label;
    private JProgressBar download_status_bar;
    private JPanel downloads_panel;
    private JMenu edit_menu;
    private JMenuItem exit_menu;
    private JMenu file_menu;
    private JButton force_chunk_reset_button;
    private JLabel global_speed_down_label;
    private JLabel global_speed_up_label;
    private JMenu help_menu;
    private JMenuItem hide_tray_menu;
    private JButton jButton1;
    private JPanel jPanel_scroll_down;
    private JPanel jPanel_scroll_up;
    private JScrollPane jScrollPane_down;
    private JScrollPane jScrollPane_up;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JLabel kiss_server_status;
    private JLabel logo_label;
    private JMenuBar main_menubar;
    private JLabel memory_status;
    private JMenuItem merge_file_menu;
    private JMenuItem new_download_menu;
    private JMenuItem new_stream_menu;
    private JMenuItem new_upload_menu;
    private JButton pause_all_down_button;
    private JButton pause_all_up_button;
    private JMenuItem settings_menu;
    private JLabel smart_proxy_status;
    private JMenuItem split_file_menu;
    private JLabel status_down_label;
    private JLabel status_up_label;
    private JButton unfreeze_transferences_button;
    private JLabel up_remtime_label;
    private JProgressBar upload_status_bar;
    private JPanel uploads_panel;
    private static final Logger LOG = Logger.getLogger(MainPanelView.class.getName());

    public JProgressBar getDownload_status_bar() {
        return this.download_status_bar;
    }

    public JProgressBar getUpload_status_bar() {
        return this.upload_status_bar;
    }

    public static MainPanelView getINSTANCE() {
        return INSTANCE;
    }

    public JMenuItem getMerge_file_menu() {
        return this.merge_file_menu;
    }

    public JMenuItem getSplit_file_menu() {
        return this.split_file_menu;
    }

    public JLabel getKiss_server_status() {
        return this.kiss_server_status;
    }

    public JMenuItem getClean_all_down_menu() {
        return this.clean_all_down_menu;
    }

    public JMenuItem getClean_all_up_menu() {
        return this.clean_all_up_menu;
    }

    public JButton getClose_all_finished_down_button() {
        return this.close_all_finished_down_button;
    }

    public JButton getClose_all_finished_up_button() {
        return this.close_all_finished_up_button;
    }

    public JLabel getMemory_status() {
        return this.memory_status;
    }

    public JLabel getGlobal_speed_down_label() {
        return this.global_speed_down_label;
    }

    public JLabel getDown_remtime_label() {
        return this.down_remtime_label;
    }

    public JLabel getUp_remtime_label() {
        return this.up_remtime_label;
    }

    public JLabel getGlobal_speed_up_label() {
        return this.global_speed_up_label;
    }

    public JPanel getjPanel_scroll_down() {
        return this.jPanel_scroll_down;
    }

    public JPanel getjPanel_scroll_up() {
        return this.jPanel_scroll_up;
    }

    public JMenuItem getNew_download_menu() {
        return this.new_download_menu;
    }

    public JMenuItem getNew_upload_menu() {
        return this.new_upload_menu;
    }

    public JButton getPause_all_down_button() {
        return this.pause_all_down_button;
    }

    public JButton getPause_all_up_button() {
        return this.pause_all_up_button;
    }

    public JLabel getStatus_down_label() {
        return this.status_down_label;
    }

    public JLabel getStatus_up_label() {
        return this.status_up_label;
    }

    public JButton getForce_chunk_reset_button() {
        return this.force_chunk_reset_button;
    }

    public JButton getUnfreeze_transferences_button() {
        return this.unfreeze_transferences_button;
    }

    public MainPanel getMain_panel() {
        return this._main_panel;
    }

    public JTabbedPane getjTabbedPane1() {
        return this.jTabbedPane1;
    }

    public JLabel getSmart_proxy_status() {
        return this.smart_proxy_status;
    }

    public JCheckBoxMenuItem getAuto_close_menu() {
        return this.auto_close_menu;
    }

    public JMenuItem getCancel_all_downloads_menu() {
        return this.cancel_all_downloads_menu;
    }

    public void updateKissStreamServerStatus(String status) {
        MiscTools.GUIRun(() -> {
            String old_status = this.getKiss_server_status().getText();
            if (!old_status.equals(status + " ")) {
                this.getKiss_server_status().setText(status + " ");
            }
        });
    }

    public void updateSmartProxyStatus(String status) {
        MiscTools.GUIRun(() -> {
            String old_status = this.getSmart_proxy_status().getText();
            if (!old_status.equals(status + " ")) {
                this.getSmart_proxy_status().setText(status + " ");
            }
        });
    }

    private void _new_upload_dialog(FileGrabberDialog dialog) {
        try {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isUpload() && dialog.getFiles().size() > 0) {
                this.getMain_panel().resumeUploads();
                this.getMain_panel().getUpload_manager().getTransference_preprocess_global_queue().addAll(dialog.getFiles());
                this.getMain_panel().getUpload_manager().secureNotify();
                MiscTools.GUIRun(() -> {
                    this.upload_status_bar.setIndeterminate(true);
                    this.upload_status_bar.setValue(this.upload_status_bar.getMinimum());
                    this.upload_status_bar.setMaximum(this.getMain_panel().getUpload_manager().getTransference_preprocess_global_queue().size() + this.getMain_panel().getUpload_manager().getTransference_preprocess_queue().size() + this.getMain_panel().getUpload_manager().getTransference_provision_queue().size());
                    this.upload_status_bar.setVisible(true);
                });
                String mega_account = (String)dialog.getAccount_combobox().getSelectedItem();
                String base_path = dialog.getBase_path();
                String dir_name = dialog.getDir_name_textfield().getText();
                this.jTabbedPane1.setSelectedIndex(1);
                Runnable run = () -> {
                    MegaAPI ma = this.getMain_panel().getMega_active_accounts().get(mega_account);
                    try {
                        byte[] parent_key = ma.genFolderKey();
                        byte[] share_key = ma.genShareKey();
                        String root_name = dir_name != null ? dir_name : dialog.getFiles().get(0).getName() + "_" + MiscTools.genID(10);
                        HashMap<String, Object> res = ma.createDir(root_name, ma.getRoot_id(), parent_key, MiscTools.i32a2bin(ma.getMaster_key()));
                        String parent_node = (String)((Map)((List)res.get("f")).get(0)).get("h");
                        LOG.log(Level.INFO, "{0} Dir {1} created", new Object[]{Thread.currentThread().getName(), parent_node});
                        String upload_folder_string = DBTools.selectSettingValue("upload_public_folder");
                        boolean folder_share = "yes".equals(upload_folder_string);
                        String folder_link = null;
                        if (folder_share) {
                            ma.shareFolder(parent_node, parent_key, share_key);
                            folder_link = ma.getPublicFolderLink(parent_node, share_key);
                        }
                        if (dialog.getUpload_log_checkbox().isSelected()) {
                            MiscTools.createUploadLogDir();
                            File upload_log = new File(MiscTools.UPLOAD_LOGS_DIR + "/megabasterd_upload_" + parent_node + ".log");
                            upload_log.createNewFile();
                            try {
                                FileWriter fr = new FileWriter(upload_log, true);
                                fr.write("***** MegaBasterd UPLOAD LOG FILE *****\n\n");
                                fr.write(MiscTools.getFechaHoraActual() + "\n\n");
                                fr.write(ma.getEmail() + "\n\n");
                                fr.write(dir_name + "   " + folder_link + "\n\n");
                                fr.close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(Upload.class.getName()).log(Level.SEVERE, ex.getMessage());
                            }
                        }
                        res = folder_share ? ma.createDirInsideAnotherSharedDir(root_name, parent_node, ma.genFolderKey(), MiscTools.i32a2bin(ma.getMaster_key()), parent_node, share_key) : ma.createDir(root_name, parent_node, ma.genFolderKey(), MiscTools.i32a2bin(ma.getMaster_key()));
                        String file_paths_2_node = (String)((Map)((List)res.get("f")).get(0)).get("h");
                        MegaDirNode file_paths = new MegaDirNode(parent_node);
                        MegaDirNode file_paths_2 = new MegaDirNode(file_paths_2_node);
                        file_paths.getChildren().put(root_name, file_paths_2);
                        file_paths = file_paths_2;
                        for (File f : dialog.getFiles()) {
                            String file_path = f.getParentFile().getAbsolutePath().replace(base_path, "");
                            try {
                                if (!file_path.isEmpty()) {
                                    LOG.log(Level.INFO, "{0} FILE_PATH -> {1}", new Object[]{Thread.currentThread().getName(), file_path});
                                }
                                String[] dirs = file_path.split("\\" + File.separator);
                                MegaDirNode current_node = file_paths;
                                String file_parent = current_node.getNode_id();
                                for (String d : dirs) {
                                    if (d.isEmpty()) continue;
                                    LOG.log(Level.INFO, "{0} DIR -> {1}", new Object[]{Thread.currentThread().getName(), d});
                                    if (current_node.getChildren().get(d) != null) {
                                        current_node = current_node.getChildren().get(d);
                                        file_parent = current_node.getNode_id();
                                        continue;
                                    }
                                    res = folder_share ? ma.createDirInsideAnotherSharedDir(d, current_node.getNode_id(), ma.genFolderKey(), MiscTools.i32a2bin(ma.getMaster_key()), parent_node, share_key) : ma.createDir(d, current_node.getNode_id(), ma.genFolderKey(), MiscTools.i32a2bin(ma.getMaster_key()));
                                    file_parent = (String)((Map)((List)res.get("f")).get(0)).get("h");
                                    current_node.getChildren().put(d, new MegaDirNode(file_parent));
                                    current_node = current_node.getChildren().get(d);
                                }
                                while (this.getMain_panel().getUpload_manager().getTransference_waitstart_queue().size() >= 10000 || this.getMain_panel().getUpload_manager().getTransference_waitstart_aux_queue().size() >= 10000) {
                                    Object object = this.getMain_panel().getUpload_manager().getWait_queue_lock();
                                    synchronized (object) {
                                        this.getMain_panel().getUpload_manager().getWait_queue_lock().wait(1000L);
                                    }
                                }
                                Upload object = new Upload(this.getMain_panel(), ma, f.getAbsolutePath(), file_parent, null, null, parent_node, share_key, folder_link, dialog.getPriority_checkbox().isSelected());
                                this.getMain_panel().getUpload_manager().getTransference_provision_queue().add(object);
                                this.getMain_panel().getUpload_manager().getTransference_preprocess_global_queue().remove(f);
                                this.getMain_panel().getUpload_manager().secureNotify();
                            }
                            catch (Exception ex) {
                                this.getMain_panel().getUpload_manager().getTransference_preprocess_global_queue().remove(f);
                                this.getMain_panel().getUpload_manager().secureNotify();
                                LOG.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                };
                this.getMain_panel().getUpload_manager().getTransference_preprocess_queue().add(run);
                this.getMain_panel().getUpload_manager().secureNotify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!dialog.isRemember_master_pass()) {
            this._main_panel.setMaster_pass(null);
        }
        dialog.dispose();
    }

    private void _file_drop_notify(List<File> files) {
        MainPanelView tthis = this;
        MainPanel.THREAD_POOL.execute(() -> {
            int n;
            if (files.size() > 1) {
                Object[] options = new Object[]{LabelTranslatorSingleton.getInstance().translate("Split content in different uploads"), LabelTranslatorSingleton.getInstance().translate("Merge content in the same upload")};
                n = JOptionPane.showOptionDialog(this._main_panel.getView(), LabelTranslatorSingleton.getInstance().translate("How do you want to proceed?"), LabelTranslatorSingleton.getInstance().translate("File Grabber"), -1, 1, null, options, null);
            } else {
                n = 1;
            }
            if (n == 0) {
                files.stream().map(file -> {
                    ArrayList<File> aux = new ArrayList<File>();
                    aux.add((File)file);
                    return aux;
                }).map(aux -> new FileGrabberDialog(tthis, true, (List<File>)aux)).forEachOrdered(dialog -> this._new_upload_dialog((FileGrabberDialog)dialog));
            } else if (n == 1) {
                FileGrabberDialog dialog2 = new FileGrabberDialog(tthis, true, files);
                this._new_upload_dialog(dialog2);
            }
        });
    }

    public MainPanelView(final MainPanel main_panel) {
        this._main_panel = main_panel;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, this._main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            for (JComponent c : new JComponent[]{this.download_status_bar, this.upload_status_bar, this.force_chunk_reset_button, this.unfreeze_transferences_button, this.global_speed_down_label, this.global_speed_up_label, this.down_remtime_label, this.up_remtime_label, this.close_all_finished_down_button, this.close_all_finished_up_button, this.pause_all_down_button, this.pause_all_up_button}) {
                c.setVisible(false);
            }
            this.download_status_bar.setMinimum(0);
            this.upload_status_bar.setMinimum(0);
            this.download_status_bar.setValue(this.download_status_bar.getMinimum());
            this.upload_status_bar.setValue(this.upload_status_bar.getMinimum());
            this.clean_all_down_menu.setEnabled(false);
            this.clean_all_up_menu.setEnabled(false);
            this.cancel_all_downloads_menu.setEnabled(false);
            this.jScrollPane_down.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane_up.getVerticalScrollBar().setUnitIncrement(20);
            this.jTabbedPane1.setTitleAt(0, LabelTranslatorSingleton.getInstance().translate("Downloads"));
            this.jTabbedPane1.setTitleAt(1, LabelTranslatorSingleton.getInstance().translate("Uploads"));
            this.jTabbedPane1.setDropTarget(new DropTarget(){

                public boolean canImport(DataFlavor[] flavors) {
                    for (DataFlavor flavor : flavors) {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public synchronized void drop(DropTargetDropEvent dtde) {
                    this.changeToNormal();
                    dtde.acceptDrop(3);
                    try {
                        if (this.canImport(dtde.getTransferable().getTransferDataFlavors())) {
                            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                            MainPanel.THREAD_POOL.execute(() -> MainPanelView.this._file_drop_notify(files));
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(main_panel.getView(), LabelTranslatorSingleton.getInstance().translate("ERROR DOING DRAG AND DROP WITH THIS FILE (use button method)"), "Error", 0);
                    }
                }

                @Override
                public synchronized void dragEnter(DropTargetDragEvent dtde) {
                    this.changeToDrop();
                }

                @Override
                public synchronized void dragExit(DropTargetEvent dtde) {
                    this.changeToNormal();
                }

                private void changeToDrop() {
                    MainPanelView.this.jTabbedPane1.setBorder(BorderFactory.createLineBorder(Color.green, 5));
                }

                private void changeToNormal() {
                    MainPanelView.this.jTabbedPane1.setBorder(null);
                }
            });
            String auto_close = DBTools.selectSettingValue("auto_close");
            if (auto_close != null) {
                this.getAuto_close_menu().setSelected(auto_close.equals("yes"));
            } else {
                this.getAuto_close_menu().setSelected(false);
            }
            this.pack();
        });
        INSTANCE = this;
    }

    private void initComponents() {
        this.logo_label = new JLabel();
        this.kiss_server_status = new JLabel();
        this.smart_proxy_status = new JLabel();
        this.memory_status = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.downloads_panel = new JPanel();
        this.global_speed_down_label = new JLabel();
        this.status_down_label = new JLabel();
        this.close_all_finished_down_button = new JButton();
        this.jScrollPane_down = new JScrollPane();
        this.jPanel_scroll_down = new JPanel();
        this.pause_all_down_button = new JButton();
        this.down_remtime_label = new JLabel();
        this.jButton1 = new JButton();
        this.force_chunk_reset_button = new JButton();
        this.download_status_bar = new JProgressBar();
        this.uploads_panel = new JPanel();
        this.global_speed_up_label = new JLabel();
        this.status_up_label = new JLabel();
        this.close_all_finished_up_button = new JButton();
        this.jScrollPane_up = new JScrollPane();
        this.jPanel_scroll_up = new JPanel();
        this.pause_all_up_button = new JButton();
        this.up_remtime_label = new JLabel();
        this.upload_status_bar = new JProgressBar();
        this.copy_all_uploads = new JButton();
        this.unfreeze_transferences_button = new JButton();
        this.main_menubar = new JMenuBar();
        this.file_menu = new JMenu();
        this.new_download_menu = new JMenuItem();
        this.new_upload_menu = new JMenuItem();
        this.new_stream_menu = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.split_file_menu = new JMenuItem();
        this.merge_file_menu = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.clean_all_down_menu = new JMenuItem();
        this.clean_all_up_menu = new JMenuItem();
        this.cancel_all_downloads_menu = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.hide_tray_menu = new JMenuItem();
        this.auto_close_menu = new JCheckBoxMenuItem();
        this.exit_menu = new JMenuItem();
        this.edit_menu = new JMenu();
        this.settings_menu = new JMenuItem();
        this.help_menu = new JMenu();
        this.about_menu = new JMenuItem();
        this.setTitle("MegaBasterd 8.22");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/images/pica_roja_big.png")).getImage());
        this.setPreferredSize(new Dimension(1024, 650));
        this.setSize(new Dimension(1024, 650));
        this.logo_label.setIcon(new ImageIcon(this.getClass().getResource("/images/mbasterd_logo_nuevo-picsay.png")));
        this.logo_label.setDoubleBuffered(true);
        this.kiss_server_status.setFont(new Font("Dialog", 0, 14));
        this.kiss_server_status.setForeground(new Color(102, 102, 102));
        this.kiss_server_status.setDoubleBuffered(true);
        this.smart_proxy_status.setFont(new Font("Dialog", 0, 14));
        this.smart_proxy_status.setForeground(new Color(102, 102, 102));
        this.smart_proxy_status.setDoubleBuffered(true);
        this.memory_status.setFont(new Font("Dialog", 0, 14));
        this.memory_status.setForeground(new Color(102, 102, 102));
        this.memory_status.setDoubleBuffered(true);
        this.jTabbedPane1.setDoubleBuffered(true);
        this.jTabbedPane1.setFont(new Font("Dialog", 1, 24));
        this.global_speed_down_label.setFont(new Font("Dialog", 1, 54));
        this.global_speed_down_label.setText("Speed");
        this.global_speed_down_label.setDoubleBuffered(true);
        this.status_down_label.setFont(new Font("Dialog", 0, 16));
        this.status_down_label.setForeground(new Color(102, 102, 102));
        this.status_down_label.setDoubleBuffered(true);
        this.close_all_finished_down_button.setFont(new Font("Dialog", 1, 16));
        this.close_all_finished_down_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
        this.close_all_finished_down_button.setText("Clear finished");
        this.close_all_finished_down_button.setDoubleBuffered(true);
        this.close_all_finished_down_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.close_all_finished_down_buttonActionPerformed(evt);
            }
        });
        this.jScrollPane_down.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel_scroll_down.setLayout(new BoxLayout(this.jPanel_scroll_down, 1));
        this.jScrollPane_down.setViewportView(this.jPanel_scroll_down);
        this.pause_all_down_button.setBackground(new Color(255, 153, 0));
        this.pause_all_down_button.setFont(new Font("Dialog", 1, 18));
        this.pause_all_down_button.setForeground(new Color(255, 255, 255));
        this.pause_all_down_button.setText("PAUSE ALL");
        this.pause_all_down_button.setDoubleBuffered(true);
        this.pause_all_down_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.pause_all_down_buttonActionPerformed(evt);
            }
        });
        this.down_remtime_label.setFont(new Font("Dialog", 1, 20));
        this.jButton1.setFont(new Font("Dialog", 1, 16));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.jButton1.setText("COPY ALL DOWNLOAD LINKS");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.jButton1ActionPerformed(evt);
            }
        });
        this.force_chunk_reset_button.setBackground(new Color(255, 0, 153));
        this.force_chunk_reset_button.setFont(new Font("Dialog", 1, 18));
        this.force_chunk_reset_button.setForeground(new Color(255, 255, 255));
        this.force_chunk_reset_button.setText("FORCE ALL CURRENT CHUNKS RESET");
        this.force_chunk_reset_button.setDoubleBuffered(true);
        this.force_chunk_reset_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.force_chunk_reset_buttonActionPerformed(evt);
            }
        });
        GroupLayout downloads_panelLayout = new GroupLayout(this.downloads_panel);
        this.downloads_panel.setLayout(downloads_panelLayout);
        downloads_panelLayout.setHorizontalGroup(downloads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downloads_panelLayout.createSequentialGroup().addComponent(this.global_speed_down_label, -1, 474, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.force_chunk_reset_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pause_all_down_button)).addGroup(downloads_panelLayout.createSequentialGroup().addComponent(this.status_down_label, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.close_all_finished_down_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()).addComponent(this.jScrollPane_down).addComponent(this.down_remtime_label, -1, -1, Short.MAX_VALUE).addComponent(this.download_status_bar, -1, -1, Short.MAX_VALUE));
        downloads_panelLayout.setVerticalGroup(downloads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, downloads_panelLayout.createSequentialGroup().addContainerGap().addGroup(downloads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(downloads_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close_all_finished_down_button, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addComponent(this.status_down_label, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.download_status_bar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane_down, -1, 277, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.down_remtime_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(downloads_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.global_speed_down_label).addComponent(this.pause_all_down_button).addComponent(this.force_chunk_reset_button))));
        this.jTabbedPane1.addTab("Downloads", new ImageIcon(this.getClass().getResource("/images/icons8-download-from-ftp-30.png")), this.downloads_panel);
        this.global_speed_up_label.setFont(new Font("Dialog", 1, 54));
        this.global_speed_up_label.setText("Speed");
        this.global_speed_up_label.setDoubleBuffered(true);
        this.status_up_label.setFont(new Font("Dialog", 0, 16));
        this.status_up_label.setForeground(new Color(102, 102, 102));
        this.close_all_finished_up_button.setFont(new Font("Dialog", 1, 16));
        this.close_all_finished_up_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
        this.close_all_finished_up_button.setText("Clear finished");
        this.close_all_finished_up_button.setDoubleBuffered(true);
        this.close_all_finished_up_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.close_all_finished_up_buttonActionPerformed(evt);
            }
        });
        this.jScrollPane_up.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel_scroll_up.setLayout(new BoxLayout(this.jPanel_scroll_up, 1));
        this.jScrollPane_up.setViewportView(this.jPanel_scroll_up);
        this.pause_all_up_button.setBackground(new Color(255, 153, 0));
        this.pause_all_up_button.setFont(new Font("Dialog", 1, 18));
        this.pause_all_up_button.setForeground(new Color(255, 255, 255));
        this.pause_all_up_button.setText("PAUSE ALL");
        this.pause_all_up_button.setDoubleBuffered(true);
        this.pause_all_up_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.pause_all_up_buttonActionPerformed(evt);
            }
        });
        this.up_remtime_label.setFont(new Font("Dialog", 1, 20));
        this.copy_all_uploads.setFont(new Font("Dialog", 1, 16));
        this.copy_all_uploads.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.copy_all_uploads.setText("COPY ALL UPLOAD LINKS");
        this.copy_all_uploads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.copy_all_uploadsActionPerformed(evt);
            }
        });
        GroupLayout uploads_panelLayout = new GroupLayout(this.uploads_panel);
        this.uploads_panel.setLayout(uploads_panelLayout);
        uploads_panelLayout.setHorizontalGroup(uploads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uploads_panelLayout.createSequentialGroup().addComponent(this.global_speed_up_label, -1, 839, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pause_all_up_button)).addGroup(uploads_panelLayout.createSequentialGroup().addComponent(this.status_up_label, -1, -1, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.close_all_finished_up_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copy_all_uploads).addContainerGap()).addComponent(this.jScrollPane_up).addComponent(this.up_remtime_label, -1, -1, Short.MAX_VALUE).addComponent(this.upload_status_bar, -1, -1, Short.MAX_VALUE));
        uploads_panelLayout.setVerticalGroup(uploads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, uploads_panelLayout.createSequentialGroup().addContainerGap().addGroup(uploads_panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(uploads_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close_all_finished_up_button, -1, -1, Short.MAX_VALUE).addComponent(this.copy_all_uploads)).addComponent(this.status_up_label, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upload_status_bar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane_up, -1, 277, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.up_remtime_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(uploads_panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.global_speed_up_label).addComponent(this.pause_all_up_button))));
        this.jTabbedPane1.addTab("Uploads", new ImageIcon(this.getClass().getResource("/images/icons8-upload-to-ftp-30.png")), this.uploads_panel);
        this.unfreeze_transferences_button.setBackground(new Color(255, 255, 204));
        this.unfreeze_transferences_button.setFont(new Font("Dialog", 1, 24));
        this.unfreeze_transferences_button.setForeground(new Color(0, 153, 255));
        this.unfreeze_transferences_button.setText("UNFREEZE WAITING TRANSFERENCES");
        this.unfreeze_transferences_button.setDoubleBuffered(true);
        this.unfreeze_transferences_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.unfreeze_transferences_buttonActionPerformed(evt);
            }
        });
        this.file_menu.setText("File");
        this.file_menu.setDoubleBuffered(true);
        this.file_menu.setFont(new Font("Dialog", 0, 18));
        this.new_download_menu.setFont(new Font("Dialog", 0, 18));
        this.new_download_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-download-from-ftp-30.png")));
        this.new_download_menu.setText("New download");
        this.new_download_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.new_download_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.new_download_menu);
        this.new_upload_menu.setFont(new Font("Dialog", 0, 18));
        this.new_upload_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-upload-to-ftp-30.png")));
        this.new_upload_menu.setText("New upload");
        this.new_upload_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.new_upload_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.new_upload_menu);
        this.new_stream_menu.setFont(new Font("Dialog", 0, 18));
        this.new_stream_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-video-playlist-30.png")));
        this.new_stream_menu.setText("New streaming");
        this.new_stream_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.new_stream_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.new_stream_menu);
        this.file_menu.add(this.jSeparator5);
        this.split_file_menu.setFont(new Font("Dialog", 0, 18));
        this.split_file_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cut-30.png")));
        this.split_file_menu.setText("Split file");
        this.split_file_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.split_file_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.split_file_menu);
        this.merge_file_menu.setFont(new Font("Dialog", 0, 18));
        this.merge_file_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-glue-30.png")));
        this.merge_file_menu.setText("Merge file");
        this.merge_file_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.merge_file_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.merge_file_menu);
        this.file_menu.add(this.jSeparator4);
        this.clean_all_down_menu.setFont(new Font("Dialog", 0, 18));
        this.clean_all_down_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.clean_all_down_menu.setText("Remove all no running downloads");
        this.clean_all_down_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.clean_all_down_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.clean_all_down_menu);
        this.clean_all_up_menu.setFont(new Font("Dialog", 0, 18));
        this.clean_all_up_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.clean_all_up_menu.setText("Remove all no running uploads");
        this.clean_all_up_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.clean_all_up_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.clean_all_up_menu);
        this.cancel_all_downloads_menu.setFont(new Font("Dialog", 0, 18));
        this.cancel_all_downloads_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-minus-30.png")));
        this.cancel_all_downloads_menu.setText("CANCEL ALL DOWNLOADS");
        this.cancel_all_downloads_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.cancel_all_downloads_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.cancel_all_downloads_menu);
        this.file_menu.add(this.jSeparator2);
        this.hide_tray_menu.setFont(new Font("Dialog", 0, 18));
        this.hide_tray_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/pica_roja_menu.png")));
        this.hide_tray_menu.setText("Hide to tray");
        this.hide_tray_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.hide_tray_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.hide_tray_menu);
        this.auto_close_menu.setFont(new Font("Dialog", 0, 18));
        this.auto_close_menu.setText("Close MegaBasterd when all transfers finish");
        this.auto_close_menu.setDoubleBuffered(true);
        this.auto_close_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cancel-30.png")));
        this.auto_close_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.auto_close_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.auto_close_menu);
        this.exit_menu.setFont(new Font("Dialog", 0, 18));
        this.exit_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-shutdown-30.png")));
        this.exit_menu.setText("Exit");
        this.exit_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.exit_menuActionPerformed(evt);
            }
        });
        this.file_menu.add(this.exit_menu);
        this.main_menubar.add(this.file_menu);
        this.edit_menu.setText("Edit");
        this.edit_menu.setDoubleBuffered(true);
        this.edit_menu.setFont(new Font("Dialog", 0, 18));
        this.settings_menu.setFont(new Font("Dialog", 0, 18));
        this.settings_menu.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-services-30.png")));
        this.settings_menu.setText("Settings");
        this.settings_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.settings_menuActionPerformed(evt);
            }
        });
        this.edit_menu.add(this.settings_menu);
        this.main_menubar.add(this.edit_menu);
        this.help_menu.setText("Help");
        this.help_menu.setDoubleBuffered(true);
        this.help_menu.setFont(new Font("Dialog", 0, 18));
        this.about_menu.setFont(new Font("Dialog", 0, 18));
        this.about_menu.setText("About");
        this.about_menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelView.this.about_menuActionPerformed(evt);
            }
        });
        this.help_menu.add(this.about_menu);
        this.main_menubar.add(this.help_menu);
        this.setJMenuBar(this.main_menubar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.unfreeze_transferences_button).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.kiss_server_status, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.smart_proxy_status, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.memory_status, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logo_label))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.unfreeze_transferences_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.logo_label).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.smart_proxy_status).addComponent(this.memory_status)).addComponent(this.kiss_server_status))).addGap(2, 2, 2)));
        this.pack();
    }

    private void new_download_menuActionPerformed(ActionEvent evt) {
        String mega_account;
        LinkGrabberDialog dialog = new LinkGrabberDialog(this, true, this._main_panel.getDefault_download_path(), this._main_panel.getClipboardspy());
        this._main_panel.getClipboardspy().attachObserver(dialog);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this._main_panel.getClipboardspy().detachObserver(dialog);
        String dl_path = dialog.getDownload_path();
        MegaAPI ma = this.getMain_panel().isUse_mega_account_down() ? ("".equals(mega_account = (String)dialog.getUse_mega_account_down_combobox().getSelectedItem()) ? new MegaAPI() : this.getMain_panel().getMega_active_accounts().get(mega_account)) : new MegaAPI();
        this.jTabbedPane1.setSelectedIndex(0);
        if (dialog.isDownload()) {
            this.getMain_panel().resumeDownloads();
            MainPanelView tthis = this;
            Runnable run = () -> {
                String link_data = MiscTools.extractMegaLinksFromString(dialog.getLinks_textarea().getText());
                HashSet<String> urls = new HashSet<String>(MiscTools.findAllRegex("(?:https?|mega)://[^\r\n]+(#[^\r\n!]*?)?![^\r\n!]+![^\\?\r\n/]+", link_data, 0));
                HashSet<String> megadownloader = new HashSet<String>(MiscTools.findAllRegex("mega://enc[^\r\n]+", link_data, 0));
                megadownloader.forEach(link -> {
                    try {
                        urls.add(CryptTools.decryptMegaDownloaderLink(link));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                });
                HashSet<String> elc = new HashSet<String>(MiscTools.findAllRegex("mega://elc[^\r\n]+", link_data, 0));
                elc.forEach(link -> {
                    try {
                        urls.addAll(CryptTools.decryptELC(link, this.getMain_panel()));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                });
                HashSet<String> dlc = new HashSet<String>(MiscTools.findAllRegex("dlc://([^\r\n]+)", link_data, 1));
                dlc.stream().map(d -> CryptTools.decryptDLC(d, this._main_panel)).forEachOrdered(links -> links.stream().filter(link -> MiscTools.findFirstRegex("(?:https?|mega)://[^\r\n](#[^\r\n!]*?)?![^\r\n!]+![^\\?\r\n/]+", link, 0) != null).forEachOrdered(link -> urls.add((String)link)));
                if (!urls.isEmpty()) {
                    HashSet<String> folder_file_links = new HashSet<String>(MiscTools.findAllRegex("(?:https?|mega)://[^\r\n]+#F\\*[^\r\n!]*?![^\r\n!]+![^\\?\r\n/]+", link_data, 0));
                    this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().addAll(folder_file_links);
                    this.getMain_panel().getDownload_manager().secureNotify();
                    MiscTools.GUIRun(() -> {
                        this.download_status_bar.setIndeterminate(true);
                        this.download_status_bar.setValue(this.download_status_bar.getMinimum());
                        this.download_status_bar.setMaximum(this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().size() + this.getMain_panel().getDownload_manager().getTransference_preprocess_queue().size() + this.getMain_panel().getDownload_manager().getTransference_provision_queue().size());
                        this.download_status_bar.setVisible(true);
                    });
                    if (!folder_file_links.isEmpty()) {
                        ArrayList<String> nlinks = ma.GENERATE_N_LINKS(folder_file_links);
                        urls.removeAll(folder_file_links);
                        urls.addAll(nlinks);
                    }
                    this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().removeAll(folder_file_links);
                    this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().addAll(urls);
                    this.getMain_panel().getDownload_manager().secureNotify();
                    for (String url : urls) {
                        try {
                            Download download;
                            boolean link_warning = false;
                            url = URLDecoder.decode(url, "UTF-8").replaceAll("^mega://", "https://mega.nz").trim();
                            if (MiscTools.findFirstRegex("#F!", url, 0) != null) {
                                FolderLinkDialog fdialog = new FolderLinkDialog(this._main_panel.getView(), true, url);
                                if (fdialog.isMega_error() == 0) {
                                    fdialog.setLocationRelativeTo(this._main_panel.getView());
                                    fdialog.setVisible(true);
                                    if (fdialog.isDownload()) {
                                        List<HashMap> folder_links = fdialog.getDownload_links();
                                        fdialog.dispose();
                                        for (HashMap folder_link : folder_links) {
                                            while (this.getMain_panel().getDownload_manager().getTransference_waitstart_queue().size() >= 10000 || this.getMain_panel().getDownload_manager().getTransference_waitstart_aux_queue().size() >= 10000) {
                                                if (!link_warning) {
                                                    link_warning = true;
                                                    JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("There are a lot of files in this folder.\nNot all links will be provisioned at once to avoid saturating MegaBasterd"), "Warning", 2);
                                                }
                                                Object object = this.getMain_panel().getDownload_manager().getWait_queue_lock();
                                                synchronized (object) {
                                                    this.getMain_panel().getDownload_manager().getWait_queue_lock().wait(1000L);
                                                }
                                            }
                                            if (this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().isEmpty()) break;
                                            if (!((String)folder_link.get("url")).equals("*")) {
                                                download = new Download(this.getMain_panel(), ma, (String)folder_link.get("url"), dl_path, (String)folder_link.get("filename"), (String)folder_link.get("filekey"), (long)((Long)folder_link.get("filesize")), null, null, this.getMain_panel().isUse_slots_down(), false, this.getMain_panel().isUse_custom_chunks_dir() ? this.getMain_panel().getCustom_chunks_dir() : null, dialog.getPriority_checkbox().isSelected());
                                                this.getMain_panel().getDownload_manager().getTransference_provision_queue().add(download);
                                                this.getMain_panel().getDownload_manager().secureNotify();
                                                continue;
                                            }
                                            String filename = dl_path + "/" + (String)folder_link.get("filename");
                                            File file = new File(filename);
                                            if (file.getParent() != null) {
                                                File path = new File(file.getParent());
                                                path.mkdirs();
                                            }
                                            if ((Integer)folder_link.get("type") == 1) {
                                                file.mkdir();
                                                continue;
                                            }
                                            try {
                                                file.createNewFile();
                                            }
                                            catch (IOException ex) {
                                                Logger.getLogger(MainPanelView.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                    }
                                }
                                fdialog.dispose();
                            } else {
                                while (this.getMain_panel().getDownload_manager().getTransference_waitstart_queue().size() >= 10000 || this.getMain_panel().getDownload_manager().getTransference_waitstart_aux_queue().size() >= 10000) {
                                    Object object = this.getMain_panel().getDownload_manager().getWait_queue_lock();
                                    synchronized (object) {
                                        this.getMain_panel().getDownload_manager().getWait_queue_lock().wait(1000L);
                                    }
                                }
                                download = new Download(this.getMain_panel(), ma, url, dl_path, null, null, null, null, null, this.getMain_panel().isUse_slots_down(), false, this.getMain_panel().isUse_custom_chunks_dir() ? this.getMain_panel().getCustom_chunks_dir() : null, dialog.getPriority_checkbox().isSelected());
                                this.getMain_panel().getDownload_manager().getTransference_provision_queue().add(download);
                                this.getMain_panel().getDownload_manager().secureNotify();
                            }
                            this.getMain_panel().getDownload_manager().getTransference_preprocess_global_queue().remove(url);
                            this.getMain_panel().getDownload_manager().secureNotify();
                        }
                        catch (UnsupportedEncodingException ex) {
                            LOG.log(Level.SEVERE, ex.getMessage());
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(MainPanelView.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                    }
                }
            };
            this.getMain_panel().getDownload_manager().getTransference_preprocess_queue().add(run);
            this.getMain_panel().getDownload_manager().secureNotify();
        }
        dialog.dispose();
    }

    private void settings_menuActionPerformed(ActionEvent evt) {
        SettingsDialog dialog = new SettingsDialog(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isSettings_ok()) {
            dialog.getDeleted_mega_accounts().stream().map(email -> {
                try {
                    DBTools.deleteMegaAccount(email);
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                return email;
            }).map(email -> {
                this._main_panel.getMega_accounts().remove(email);
                return email;
            }).forEachOrdered(email -> this._main_panel.getMega_active_accounts().remove(email));
            dialog.getDeleted_elc_accounts().stream().map(host -> {
                try {
                    DBTools.deleteELCAccount(host);
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                return host;
            }).forEachOrdered(host -> this._main_panel.getElc_accounts().remove(host));
            if (this._main_panel.isRestart()) {
                this._main_panel.byebye(true);
            } else {
                this._main_panel.loadUserSettings();
                if (this._main_panel.isLimit_download_speed()) {
                    this._main_panel.getStream_supervisor().setMaxBytesPerSecInput(this._main_panel.getMax_dl_speed() * 1024);
                    this.global_speed_down_label.setForeground(new Color(255, 0, 0));
                } else {
                    this._main_panel.getStream_supervisor().setMaxBytesPerSecInput(0);
                    this.global_speed_down_label.setForeground(new Color(0, 128, 255));
                }
                if (this._main_panel.isLimit_upload_speed()) {
                    this._main_panel.getStream_supervisor().setMaxBytesPerSecOutput(this._main_panel.getMax_up_speed() * 1024);
                    this.global_speed_up_label.setForeground(new Color(255, 0, 0));
                } else {
                    this._main_panel.getStream_supervisor().setMaxBytesPerSecOutput(0);
                    this.global_speed_up_label.setForeground(new Color(0, 128, 255));
                }
                this._main_panel.getDownload_manager().setMax_running_trans(this._main_panel.getMax_dl());
                this._main_panel.getUpload_manager().setMax_running_trans(this._main_panel.getMax_ul());
                this._main_panel.getDownload_manager().secureNotify();
                this._main_panel.getUpload_manager().secureNotify();
                if (this._main_panel.isMegacrypter_reverse()) {
                    if (this._main_panel.getMega_proxy_server() == null) {
                        this._main_panel.setMega_proxy_server(new MegaProxyServer(this._main_panel, UUID.randomUUID().toString(), this._main_panel.getMegacrypter_reverse_port()));
                        MainPanel.THREAD_POOL.execute(this._main_panel.getMega_proxy_server());
                    } else if (this._main_panel.getMega_proxy_server().getPort() != this._main_panel.getMegacrypter_reverse_port()) {
                        try {
                            this._main_panel.getMega_proxy_server().stopServer();
                            this._main_panel.setMega_proxy_server(new MegaProxyServer(this._main_panel, UUID.randomUUID().toString(), this._main_panel.getMegacrypter_reverse_port()));
                            MainPanel.THREAD_POOL.execute(this._main_panel.getMega_proxy_server());
                        }
                        catch (IOException ex) {
                            LOG.log(Level.SEVERE, ex.getMessage());
                        }
                    }
                } else {
                    if (this._main_panel.getMega_proxy_server() != null) {
                        try {
                            this._main_panel.getMega_proxy_server().stopServer();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.SEVERE, ex.getMessage());
                        }
                    }
                    this._main_panel.setMega_proxy_server(null);
                }
                this.force_chunk_reset_button.setVisible(MainPanel.isUse_smart_proxy());
                if (MainPanel.isUse_smart_proxy()) {
                    String lista_proxy;
                    if (MainPanel.getProxy_manager() == null) {
                        lista_proxy = DBTools.selectSettingValue("custom_proxy_list");
                        String url_list = MiscTools.findFirstRegex("^#(http.+)$", lista_proxy.trim(), 1);
                        MainPanel.setProxy_manager(new SmartMegaProxyManager(url_list, this._main_panel));
                    } else {
                        lista_proxy = DBTools.selectSettingValue("custom_proxy_list");
                        String url_list = MiscTools.findFirstRegex("^#(http.+)$", lista_proxy.trim(), 1);
                        MainPanel.getProxy_manager().refreshProxyList(url_list);
                    }
                    MainPanel.getProxy_manager().refreshSmartProxySettings();
                } else {
                    this.updateSmartProxyStatus("SmartProxy: OFF");
                }
            }
            if (!dialog.isRemember_master_pass()) {
                this._main_panel.setMaster_pass(null);
            }
            dialog.dispose();
        }
    }

    private void hide_tray_menuActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void about_menuActionPerformed(ActionEvent evt) {
        AboutDialog dialog = new AboutDialog(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void exit_menuActionPerformed(ActionEvent evt) {
        this._main_panel.byebye(false);
    }

    private void close_all_finished_down_buttonActionPerformed(ActionEvent evt) {
        this._main_panel.getDownload_manager().closeAllFinished();
    }

    private void clean_all_down_menuActionPerformed(ActionEvent evt) {
        Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
        int n = JOptionPane.showOptionDialog(this._main_panel.getView(), LabelTranslatorSingleton.getInstance().translate("Remove all no running downloads?"), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 3, null, options, options[0]);
        if (n == 1) {
            this._main_panel.getDownload_manager().closeAllPreProWaiting();
        }
    }

    private void pause_all_down_buttonActionPerformed(ActionEvent evt) {
        this.pause_all_down_button.setEnabled(false);
        if (!this._main_panel.getDownload_manager().isPaused_all()) {
            this._main_panel.getDownload_manager().pauseAll();
        } else {
            this._main_panel.getDownload_manager().resumeAll();
        }
    }

    private void new_stream_menuActionPerformed(ActionEvent evt) {
        StreamerDialog dialog = new StreamerDialog(this, true, this._main_panel.getClipboardspy());
        this._main_panel.getClipboardspy().attachObserver(dialog);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this._main_panel.getClipboardspy().detachObserver(dialog);
    }

    private void new_upload_menuActionPerformed(ActionEvent evt) {
        FileGrabberDialog dialog = new FileGrabberDialog(this, true, null);
        this._new_upload_dialog(dialog);
    }

    private void close_all_finished_up_buttonActionPerformed(ActionEvent evt) {
        this._main_panel.getUpload_manager().closeAllFinished();
    }

    private void pause_all_up_buttonActionPerformed(ActionEvent evt) {
        this.pause_all_up_button.setEnabled(false);
        if (!this._main_panel.getUpload_manager().isPaused_all()) {
            this._main_panel.getUpload_manager().pauseAll();
        } else {
            this._main_panel.getUpload_manager().resumeAll();
        }
    }

    private void clean_all_up_menuActionPerformed(ActionEvent evt) {
        Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
        int n = JOptionPane.showOptionDialog(this._main_panel.getView(), LabelTranslatorSingleton.getInstance().translate("Remove all no running uploads?"), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 3, null, options, options[0]);
        if (n == 1) {
            this._main_panel.getUpload_manager().closeAllPreProWaiting();
        }
    }

    private void split_file_menuActionPerformed(ActionEvent evt) {
        FileSplitterDialog dialog = new FileSplitterDialog(this, false);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void merge_file_menuActionPerformed(ActionEvent evt) {
        FileMergerDialog dialog = new FileMergerDialog(this, false);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void auto_close_menuActionPerformed(ActionEvent evt) {
        try {
            DBTools.insertSettingValue("auto_close", this.getAuto_close_menu().isSelected() ? "yes" : "no");
        }
        catch (SQLException ex) {
            Logger.getLogger(MainPanelView.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    private void unfreeze_transferences_buttonActionPerformed(ActionEvent evt) {
        this.unfreeze_transferences_button.setVisible(false);
        MainPanel.THREAD_POOL.execute(this._main_panel.getDownload_manager()::unfreezeTransferenceWaitStartQueue);
        MainPanel.THREAD_POOL.execute(this._main_panel.getUpload_manager()::unfreezeTransferenceWaitStartQueue);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int total = this._main_panel.getDownload_manager().copyAllLinksToClipboard();
        JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate(total > 0 ? "ALL DOWNLOAD LINKS COPIED!" : "NO DOWNLOAD LINKS TO COPY"));
    }

    private void cancel_all_downloads_menuActionPerformed(ActionEvent evt) {
        Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
        int n = JOptionPane.showOptionDialog(this._main_panel.getView(), LabelTranslatorSingleton.getInstance().translate("CANCEL ALL DOWNLOADS?"), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 3, null, options, options[0]);
        if (n == 1) {
            this._main_panel.getDownload_manager().closeAllPreProWaiting();
            this._main_panel.getDownload_manager().cancelAllTransferences();
        }
    }

    private void force_chunk_reset_buttonActionPerformed(ActionEvent evt) {
        this.force_chunk_reset_button.setEnabled(false);
        this._main_panel.getDownload_manager().forceResetAllChunks();
    }

    private void copy_all_uploadsActionPerformed(ActionEvent evt) {
        int total = this._main_panel.getUpload_manager().copyAllLinksToClipboard();
        JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate(total > 0 ? "ALL UPLOAD LINKS COPIED!" : "NO UPLOAD LINKS TO COPY"));
    }
}

