/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ClipboardSpy;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.DownloadManager;
import com.tonikelope.megabasterd.KissVideoStreamServer;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaProxyServer;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SmartMegaProxyManager;
import com.tonikelope.megabasterd.SpeedMeter;
import com.tonikelope.megabasterd.StreamThrottlerSupervisor;
import com.tonikelope.megabasterd.Transference;
import com.tonikelope.megabasterd.Upload;
import com.tonikelope.megabasterd.UploadManager;
import com.tonikelope.megabasterd.WarningExitMessage;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class MainPanel {
    public static final String VERSION = "8.22";
    public static final boolean FORCE_SMART_PROXY = false;
    public static final int THROTTLE_SLICE_SIZE = 16384;
    public static final int DEFAULT_BYTE_BUFFER_SIZE = 16384;
    public static final int STREAMER_PORT = 1337;
    public static final int WATCHDOG_PORT = 1338;
    public static final int DEFAULT_MEGA_PROXY_PORT = 9999;
    public static final int RUN_COMMAND_TIME = 120;
    public static final String DEFAULT_LANGUAGE = "EN";
    public static final boolean DEFAULT_SMART_PROXY = false;
    public static final double FORCE_GARBAGE_COLLECTION_MAX_MEMORY_PERCENT = 0.7;
    public static Font GUI_FONT = new JLabel().getFont();
    public static final float ZOOM_FACTOR = 0.8f;
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0";
    public static final String ICON_FILE = "/images/pica_roja_big.png";
    public static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    public static volatile String MEGABASTERD_HOME_DIR = System.getProperty("user.home");
    private static String _proxy_host;
    private static int _proxy_port;
    private static boolean _use_proxy;
    private static String _proxy_user;
    private static String _proxy_pass;
    private static boolean _use_smart_proxy;
    private static boolean _run_command;
    private static String _run_command_path;
    private static String _font;
    private static SmartMegaProxyManager _proxy_manager;
    private static String _language;
    private static String _new_version;
    private static Boolean _resume_uploads;
    private static Boolean _resume_downloads;
    public static volatile long LAST_EXTERNAL_COMMAND_TIMESTAMP;
    private static final Logger LOG;
    private static volatile boolean CHECK_RUNNING;
    private volatile MainPanelView _view;
    private final SpeedMeter _global_dl_speed;
    private final SpeedMeter _global_up_speed;
    private final DownloadManager _download_manager;
    private final UploadManager _upload_manager;
    private final StreamThrottlerSupervisor _stream_supervisor;
    private int _max_dl;
    private int _max_ul;
    private int _default_slots_down;
    private int _default_slots_up;
    private int _max_dl_speed;
    private int _max_up_speed;
    private boolean _use_slots_down;
    private boolean _limit_download_speed;
    private boolean _limit_upload_speed;
    private boolean _use_mega_account_down;
    private boolean _init_paused;
    private boolean _debug_file;
    private String _mega_account_down;
    private String _default_download_path;
    private boolean _use_custom_chunks_dir;
    private String _custom_chunks_dir;
    private HashMap<String, Object> _mega_accounts;
    private HashMap<String, Object> _elc_accounts;
    private final HashMap<String, MegaAPI> _mega_active_accounts;
    private TrayIcon _trayicon;
    private final ClipboardSpy _clipboardspy;
    private KissVideoStreamServer _streamserver;
    private byte[] _master_pass;
    private String _master_pass_hash;
    private String _master_pass_salt;
    private boolean _restart;
    private MegaProxyServer _mega_proxy_server;
    private int _megacrypter_reverse_port;
    private boolean _megacrypter_reverse;
    private float _zoom_factor;
    private volatile boolean _exit;

    public static void main(String[] args) {
        File f;
        if (args.length > 0 && args.length > 1) {
            try {
                Logger.getLogger(MainPanel.class.getName()).log(Level.INFO, "{0} Waiting {1} seconds before start...", new Object[]{Thread.currentThread().getName(), args[1]});
                if (Long.parseLong(args[1]) >= 0L) {
                    Thread.sleep(Long.parseLong(args[1]) * 1000L);
                } else {
                    CHECK_RUNNING = false;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        if ((f = new File(MiscTools.getCurrentJarParentPath() + "/.megabasterd_portable")).exists()) {
            MEGABASTERD_HOME_DIR = f.getParentFile().getAbsolutePath();
        }
        try {
            DBTools.setupSqliteTables();
        }
        catch (SQLException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        MiscTools.setNimbusLookAndFeel("yes".equals(DBTools.selectSettingValue("dark_mode")));
        if ("yes".equals(DBTools.selectSettingValue("upload_log"))) {
            MiscTools.createUploadLogDir();
        }
        MainPanel main_panel = new MainPanel();
        EventQueue.invokeLater(() -> main_panel.getView().setVisible(true));
    }

    public static boolean isRun_command() {
        return _run_command;
    }

    public static String getRun_command_path() {
        return _run_command_path;
    }

    public static String getFont() {
        return _font;
    }

    public static String getNew_version() {
        return _new_version;
    }

    public static String getLanguage() {
        return _language;
    }

    public static String getProxy_user() {
        return _proxy_user;
    }

    public static String getProxy_pass() {
        return _proxy_pass;
    }

    public static void setProxy_manager(SmartMegaProxyManager proxy_manager) {
        _proxy_manager = proxy_manager;
    }

    public static String getProxy_host() {
        return _proxy_host;
    }

    public static int getProxy_port() {
        return _proxy_port;
    }

    public static boolean isUse_proxy() {
        return _use_proxy;
    }

    public static boolean isUse_smart_proxy() {
        return _use_smart_proxy;
    }

    public static SmartMegaProxyManager getProxy_manager() {
        return _proxy_manager;
    }

    public MainPanel() {
        _new_version = null;
        this._exit = false;
        LAST_EXTERNAL_COMMAND_TIMESTAMP = -1L;
        this._restart = false;
        this._elc_accounts = new HashMap();
        this._master_pass = null;
        this._mega_active_accounts = new HashMap();
        _proxy_host = null;
        _proxy_port = 3128;
        _proxy_user = null;
        _proxy_pass = null;
        _use_proxy = false;
        _use_smart_proxy = false;
        _proxy_manager = null;
        _resume_uploads = false;
        _resume_downloads = false;
        this.loadUserSettings();
        if (this._debug_file) {
            try {
                PrintStream fileOut = new PrintStream(new FileOutputStream(MEGABASTERD_HOME_DIR + "/MEGABASTERD_DEBUG.log"));
                System.setOut(fileOut);
                System.setErr(fileOut);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println(System.getProperty("os.name") + "" + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + " " + System.getProperty("java.home"));
        UIManager.put("OptionPane.messageFont", GUI_FONT.deriveFont(15.0f * this.getZoom_factor()));
        UIManager.put("OptionPane.buttonFont", GUI_FONT.deriveFont(15.0f * this.getZoom_factor()));
        UIManager.put("OptionPane.cancelButtonText", LabelTranslatorSingleton.getInstance().translate("Cancel"));
        UIManager.put("OptionPane.yesButtonText", LabelTranslatorSingleton.getInstance().translate("Yes"));
        UIManager.put("OptionPane.okButtonText", LabelTranslatorSingleton.getInstance().translate("OK"));
        this._view = new MainPanelView(this);
        if (CHECK_RUNNING && this.checkAppIsRunning()) {
            System.exit(0);
        }
        try {
            this.trayIcon();
        }
        catch (AWTException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
        this._download_manager = new DownloadManager(this);
        THREAD_POOL.execute(this._download_manager);
        this._upload_manager = new UploadManager(this);
        THREAD_POOL.execute(this._upload_manager);
        this._global_dl_speed = new SpeedMeter(this._download_manager, this.getView().getGlobal_speed_down_label(), this.getView().getDown_remtime_label());
        THREAD_POOL.execute(this._global_dl_speed);
        this._global_up_speed = new SpeedMeter(this._upload_manager, this.getView().getGlobal_speed_up_label(), this.getView().getUp_remtime_label());
        THREAD_POOL.execute(this._global_up_speed);
        this._stream_supervisor = new StreamThrottlerSupervisor(this._limit_download_speed ? this._max_dl_speed * 1024 : 0, this._limit_upload_speed ? this._max_up_speed * 1024 : 0, 16384);
        THREAD_POOL.execute(this._stream_supervisor);
        this._clipboardspy = new ClipboardSpy();
        THREAD_POOL.execute(this._clipboardspy);
        try {
            this._streamserver = new KissVideoStreamServer(this);
            this._streamserver.start(1337, "/video");
        }
        catch (IOException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this._check_old_version();
        THREAD_POOL.execute(() -> {
            _new_version = MiscTools.checkNewVersion("https://github.com/tonikelope/megabasterd/releases/latest");
            if (_new_version != null) {
                JOptionPane.showMessageDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("MegaBasterd NEW VERSION is available! -> ") + _new_version);
            }
        });
        if (this._megacrypter_reverse) {
            this._mega_proxy_server = new MegaProxyServer(this, UUID.randomUUID().toString(), this._megacrypter_reverse_port);
            THREAD_POOL.execute(this._mega_proxy_server);
        } else {
            this._mega_proxy_server = null;
        }
        if (_use_smart_proxy) {
            MainPanel tthis = this;
            THREAD_POOL.execute(() -> {
                Authenticator.setDefault(new SmartMegaProxyManager.SmartProxyAuthenticator());
                String lista_proxy = DBTools.selectSettingValue("custom_proxy_list");
                String url_list = MiscTools.findFirstRegex("^#(http.+)$", lista_proxy.trim(), 1);
                _proxy_manager = new SmartMegaProxyManager(url_list, tthis);
            });
        } else {
            this.getView().updateSmartProxyStatus("SmartProxy: OFF");
        }
        MiscTools.GUIRun(() -> {
            this.getView().getGlobal_speed_down_label().setForeground(this._limit_download_speed ? new Color(255, 0, 0) : new Color(0, 128, 255));
            this.getView().getGlobal_speed_up_label().setForeground(this._limit_upload_speed ? new Color(255, 0, 0) : new Color(0, 128, 255));
        });
        THREAD_POOL.execute(() -> {
            Runtime instance = Runtime.getRuntime();
            while (true) {
                long used_memory = instance.totalMemory() - instance.freeMemory();
                long max_memory = instance.maxMemory();
                MiscTools.GUIRun(() -> this._view.getMemory_status().setText("JVM-RAM used: " + MiscTools.formatBytes(used_memory) + " / " + MiscTools.formatBytes(max_memory)));
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(MainPanelView.class.getName()).log(Level.SEVERE, ex.getMessage());
                    continue;
                }
                break;
            }
        });
        this.resumeDownloads();
        this.resumeUploads();
    }

    public static Boolean getResume_uploads() {
        return _resume_uploads;
    }

    public static void setResume_uploads(Boolean resume_uploads) {
        _resume_uploads = resume_uploads;
    }

    public static Boolean getResume_downloads() {
        return _resume_downloads;
    }

    public static void setResume_downloads(Boolean resume_downloads) {
        _resume_downloads = resume_downloads;
    }

    public boolean isUse_custom_chunks_dir() {
        return this._use_custom_chunks_dir;
    }

    public String getCustom_chunks_dir() {
        return this._custom_chunks_dir;
    }

    public boolean isExit() {
        return this._exit;
    }

    public void setExit(boolean _exit) {
        this._exit = _exit;
    }

    public float getZoom_factor() {
        return this._zoom_factor;
    }

    public MegaProxyServer getMega_proxy_server() {
        return this._mega_proxy_server;
    }

    public boolean isMegacrypter_reverse() {
        return this._megacrypter_reverse;
    }

    public int getMegacrypter_reverse_port() {
        return this._megacrypter_reverse_port;
    }

    public void setMega_proxy_server(MegaProxyServer mega_proxy_server) {
        this._mega_proxy_server = mega_proxy_server;
    }

    public boolean isUse_mega_account_down() {
        return this._use_mega_account_down;
    }

    public String getMega_account_down() {
        return this._mega_account_down;
    }

    public boolean isRestart() {
        return this._restart;
    }

    public void setRestart(boolean restart) {
        this._restart = restart;
    }

    public HashMap<String, Object> getElc_accounts() {
        return this._elc_accounts;
    }

    public TrayIcon getTrayicon() {
        return this._trayicon;
    }

    public String getMaster_pass_hash() {
        return this._master_pass_hash;
    }

    public void setMaster_pass_hash(String master_pass_hash) {
        this._master_pass_hash = master_pass_hash;
    }

    public String getMaster_pass_salt() {
        return this._master_pass_salt;
    }

    public byte[] getMaster_pass() {
        return this._master_pass;
    }

    public void setMaster_pass(byte[] pass) {
        if (this._master_pass != null) {
            Arrays.fill(this._master_pass, (byte)0);
            this._master_pass = null;
        }
        if (pass != null) {
            this._master_pass = new byte[pass.length];
            System.arraycopy(pass, 0, this._master_pass, 0, pass.length);
        }
    }

    public MainPanelView getView() {
        while (this._view == null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        return this._view;
    }

    public SpeedMeter getGlobal_dl_speed() {
        return this._global_dl_speed;
    }

    public SpeedMeter getGlobal_up_speed() {
        return this._global_up_speed;
    }

    public DownloadManager getDownload_manager() {
        return this._download_manager;
    }

    public UploadManager getUpload_manager() {
        return this._upload_manager;
    }

    public StreamThrottlerSupervisor getStream_supervisor() {
        return this._stream_supervisor;
    }

    public int getMax_dl() {
        return this._max_dl;
    }

    public int getMax_ul() {
        return this._max_ul;
    }

    public int getDefault_slots_down() {
        return this._default_slots_down;
    }

    public int getDefault_slots_up() {
        return this._default_slots_up;
    }

    public boolean isUse_slots_down() {
        return this._use_slots_down;
    }

    public String getDefault_download_path() {
        return this._default_download_path;
    }

    public HashMap<String, Object> getMega_accounts() {
        return this._mega_accounts;
    }

    public HashMap<String, MegaAPI> getMega_active_accounts() {
        return this._mega_active_accounts;
    }

    public TrayIcon getIcon() {
        return this._trayicon;
    }

    public ClipboardSpy getClipboardspy() {
        return this._clipboardspy;
    }

    public KissVideoStreamServer getStreamserver() {
        return this._streamserver;
    }

    public int getMax_dl_speed() {
        return this._max_dl_speed;
    }

    public int getMax_up_speed() {
        return this._max_up_speed;
    }

    public boolean isLimit_download_speed() {
        return this._limit_download_speed;
    }

    public boolean isLimit_upload_speed() {
        return this._limit_upload_speed;
    }

    public boolean isInit_paused() {
        return this._init_paused;
    }

    public void loadUserSettings() {
        String debug_file;
        String use_smart_proxy;
        String use_megacrypter_reverse;
        String run_command_string;
        String use_proxy;
        String limit_dl_speed;
        String use_custom_chunks_dir = DBTools.selectSettingValue("use_custom_chunks_dir");
        if (use_custom_chunks_dir != null) {
            if (use_custom_chunks_dir.equals("yes")) {
                this._use_custom_chunks_dir = true;
                this._custom_chunks_dir = DBTools.selectSettingValue("custom_chunks_dir");
            } else {
                this._use_custom_chunks_dir = false;
                this._custom_chunks_dir = DBTools.selectSettingValue("custom_chunks_dir");
            }
        } else {
            this._custom_chunks_dir = null;
        }
        String zoom_factor = DBTools.selectSettingValue("font_zoom");
        this._zoom_factor = zoom_factor != null ? Float.parseFloat(zoom_factor) / 100.0f : 0.8f;
        String _font = DBTools.selectSettingValue("font");
        GUI_FONT = _font != null ? (_font.equals("DEFAULT") ? new JLabel().getFont() : MiscTools.createAndRegisterFont("/fonts/NotoSansCJK-Regular.ttc")) : MiscTools.createAndRegisterFont("/fonts/NotoSansCJK-Regular.ttc");
        String def_slots = DBTools.selectSettingValue("default_slots_down");
        this._default_slots_down = def_slots != null ? Integer.parseInt(def_slots) : 6;
        def_slots = DBTools.selectSettingValue("default_slots_up");
        this._default_slots_up = def_slots != null ? Integer.parseInt(def_slots) : 6;
        String use_slots = DBTools.selectSettingValue("use_slots_down");
        this._use_slots_down = use_slots != null ? use_slots.equals("yes") : true;
        String max_downloads = DBTools.selectSettingValue("max_downloads");
        this._max_dl = max_downloads != null ? Integer.parseInt(max_downloads) : 4;
        String max_uploads = DBTools.selectSettingValue("max_uploads");
        this._max_ul = max_uploads != null ? Integer.parseInt(max_uploads) : 4;
        this._default_download_path = DBTools.selectSettingValue("default_down_dir");
        if (this._default_download_path == null) {
            this._default_download_path = ".";
        }
        this._limit_download_speed = (limit_dl_speed = DBTools.selectSettingValue("limit_download_speed")) != null ? limit_dl_speed.equals("yes") : false;
        String limit_ul_speed = DBTools.selectSettingValue("limit_upload_speed");
        this._limit_upload_speed = limit_ul_speed != null ? limit_ul_speed.equals("yes") : false;
        String max_download_speed = DBTools.selectSettingValue("max_download_speed");
        this._max_dl_speed = max_download_speed != null ? Integer.parseInt(max_download_speed) : 5;
        String max_upload_speed = DBTools.selectSettingValue("max_upload_speed");
        this._max_up_speed = max_upload_speed != null ? Integer.parseInt(max_upload_speed) : 5;
        String init_paused_string = DBTools.selectSettingValue("start_frozen");
        this._init_paused = init_paused_string != null ? init_paused_string.equals("yes") : false;
        try {
            this._mega_accounts = DBTools.selectMegaAccounts();
            this._elc_accounts = DBTools.selectELCAccounts();
        }
        catch (SQLException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this._mega_account_down = DBTools.selectSettingValue("mega_account_down");
        String use_account = DBTools.selectSettingValue("use_mega_account_down");
        this._use_mega_account_down = use_account != null && use_account.equals("yes");
        this._master_pass_hash = DBTools.selectSettingValue("master_pass_hash");
        this._master_pass_salt = DBTools.selectSettingValue("master_pass_salt");
        if (this._master_pass_salt == null) {
            try {
                this._master_pass_salt = MiscTools.Bin2BASE64(MiscTools.genRandomByteArray(16));
                DBTools.insertSettingValue("master_pass_salt", this._master_pass_salt);
            }
            catch (SQLException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        if (_use_proxy = (use_proxy = DBTools.selectSettingValue("use_proxy")) != null ? use_proxy.equals("yes") : false) {
            _proxy_host = DBTools.selectSettingValue("proxy_host");
            String proxy_port = DBTools.selectSettingValue("proxy_port");
            _proxy_port = proxy_port == null || proxy_port.isEmpty() ? 8080 : Integer.parseInt(proxy_port);
            _proxy_user = DBTools.selectSettingValue("proxy_user");
            _proxy_pass = DBTools.selectSettingValue("proxy_pass");
        }
        if ((run_command_string = DBTools.selectSettingValue("run_command")) != null) {
            _run_command = run_command_string.equals("yes");
        }
        String old_run_command_path = _run_command_path;
        _run_command_path = DBTools.selectSettingValue("run_command_path");
        if (_run_command && old_run_command_path != null && !old_run_command_path.equals(_run_command_path)) {
            LAST_EXTERNAL_COMMAND_TIMESTAMP = -1L;
        }
        this._megacrypter_reverse = (use_megacrypter_reverse = DBTools.selectSettingValue("megacrypter_reverse")) != null ? use_megacrypter_reverse.equals("yes") : false;
        if (this._megacrypter_reverse) {
            String reverse_port = DBTools.selectSettingValue("megacrypter_reverse_port");
            this._megacrypter_reverse_port = reverse_port == null || reverse_port.isEmpty() ? 9999 : Integer.parseInt(reverse_port);
        }
        _use_smart_proxy = (use_smart_proxy = DBTools.selectSettingValue("smart_proxy")) != null ? use_smart_proxy.equals("yes") : false;
        _language = DBTools.selectSettingValue("language");
        if (_language == null) {
            _language = DEFAULT_LANGUAGE;
        }
        this._debug_file = (debug_file = DBTools.selectSettingValue("debug_file")) != null ? debug_file.equals("yes") : false;
        String api_key = DBTools.selectSettingValue("mega_api_key");
        MegaAPI.API_KEY = api_key != null && !"".equals(api_key) ? api_key.trim() : null;
    }

    public static synchronized void run_external_command() {
        if (_run_command && (LAST_EXTERNAL_COMMAND_TIMESTAMP == -1L || LAST_EXTERNAL_COMMAND_TIMESTAMP + 120000L < System.currentTimeMillis()) && _run_command_path != null && !_run_command_path.equals("")) {
            try {
                Runtime.getRuntime().exec(_run_command_path);
            }
            catch (IOException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            LAST_EXTERNAL_COMMAND_TIMESTAMP = System.currentTimeMillis();
        }
    }

    public boolean checkByeBye() {
        boolean exit = true;
        if (!this._streamserver.getWorking_threads().isEmpty()) {
            Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
            int n = JOptionPane.showOptionDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("It seems MegaBasterd is streaming video. Do you want to exit?"), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 3, null, options, options[0]);
            if (n == 0) {
                exit = false;
            }
        } else if (!(this.getDownload_manager().getTransference_preprocess_global_queue().isEmpty() && this.getDownload_manager().getTransference_provision_queue().isEmpty() && this.getUpload_manager().getTransference_preprocess_global_queue().isEmpty() && this.getUpload_manager().getTransference_provision_queue().isEmpty())) {
            Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
            int n = JOptionPane.showOptionDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("It seems MegaBasterd is provisioning down/uploads.\n\nIf you exit now, unprovisioned down/uploads will be lost.\n\nDo you want to continue?"), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 2, null, options, options[0]);
            if (n == 0) {
                exit = false;
            }
        }
        return exit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void byebyenow(boolean restart) {
        MiscTools.purgeFolderCache();
        Class<DBTools> clazz = DBTools.class;
        synchronized (DBTools.class) {
            try {
                DBTools.vaccum();
            }
            catch (SQLException ex) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            if (restart) {
                MiscTools.restartApplication();
            } else {
                System.exit(0);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void byebyenow(boolean restart, boolean delete_db) {
        Class<DBTools> clazz = DBTools.class;
        synchronized (DBTools.class) {
            if (delete_db) {
                File db_file = new File(MEGABASTERD_HOME_DIR + "/.megabasterd" + VERSION + "/" + "megabasterd.db");
                db_file.delete();
            } else {
                try {
                    DBTools.vaccum();
                }
                catch (SQLException ex) {
                    Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            }
            if (restart) {
                MiscTools.restartApplication();
            } else {
                System.exit(0);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void _check_old_version() {
        try {
            if (!new File(MEGABASTERD_HOME_DIR + "/.megabasterd" + VERSION + "/.old_version_check").exists()) {
                new File(MEGABASTERD_HOME_DIR + "/.megabasterd" + VERSION + "/.old_version_check").createNewFile();
                File directory = new File(MEGABASTERD_HOME_DIR);
                String version_major = MiscTools.findFirstRegex("([0-9]+)\\.[0-9]+$", VERSION, 1);
                String version_minor = MiscTools.findFirstRegex("[0-9]+\\.([0-9]+)$", VERSION, 1);
                String old_version_major = null;
                String old_version_minor = null;
                String old_version = "0.0";
                File old_backups_dir = new File(MEGABASTERD_HOME_DIR + "/.megabasterd_old_backups");
                if (!old_backups_dir.exists()) {
                    old_backups_dir.mkdir();
                }
                for (File file : directory.listFiles()) {
                    try {
                        String current_dir_version;
                        if (!file.isDirectory() || !file.canRead() || !file.getName().startsWith(".megabasterd") || file.getName().endsWith("backups") || (current_dir_version = MiscTools.findFirstRegex("[0-9.]+$", file.getName(), 0)) == null || current_dir_version.equals(VERSION)) continue;
                        old_version_major = MiscTools.findFirstRegex("([0-9]+)\\.[0-9]+$", old_version, 1);
                        old_version_major = MiscTools.findFirstRegex("[0-9]+\\.([0-9]+)$", old_version, 1);
                        String current_dir_major = MiscTools.findFirstRegex("([0-9]+)\\.[0-9]+$", current_dir_version, 1);
                        String current_dir_minor = MiscTools.findFirstRegex("[0-9]+\\.([0-9]+)$", current_dir_version, 1);
                        if (Integer.parseInt(current_dir_major) > Integer.parseInt(old_version_major) || Integer.parseInt(current_dir_major) == Integer.parseInt(old_version_major) && Integer.parseInt(current_dir_minor) > Integer.parseInt(old_version_minor)) {
                            old_version = current_dir_version;
                            old_version_major = current_dir_major;
                            old_version_minor = current_dir_minor;
                        }
                        Files.move(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(old_backups_dir.getAbsolutePath() + "/" + file.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!old_version.equals("0.0") && (Integer.parseInt(version_major) > Integer.parseInt(old_version_major) || Integer.parseInt(version_major) == Integer.parseInt(old_version_major) && Integer.parseInt(version_minor) > Integer.parseInt(old_version_minor))) {
                    Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
                    int n = JOptionPane.showOptionDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("An older version (" + old_version + ") of MegaBasterd has been detected.\nDo you want to import all current settings and transfers from the previous version?\nWARNING: INCOMPATIBILITIES MAY EXIST BETWEEN VERSIONS."), LabelTranslatorSingleton.getInstance().translate("Warning!"), 1, 1, null, options, options[0]);
                    if (n == 1) {
                        Files.copy(Paths.get(MEGABASTERD_HOME_DIR + "/.megabasterd_old_backups/.megabasterd" + old_version + "/" + "megabasterd.db", new String[0]), Paths.get(MEGABASTERD_HOME_DIR + "/.megabasterd" + VERSION + "/" + "megabasterd.db", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        JOptionPane.showMessageDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("MegaBasterd will restart"), LabelTranslatorSingleton.getInstance().translate("Restart required"), 2);
                        MiscTools.restartApplication();
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    public void byebye(boolean restart) {
        this._byebye(restart, true);
    }

    public void byebye(boolean restart, boolean restart_warning) {
        this._byebye(restart, restart_warning);
    }

    private void _byebye(boolean restart, boolean restart_warning) {
        if (!this._exit && this.checkByeBye()) {
            if (restart && restart_warning) {
                JOptionPane.showMessageDialog(this.getView(), LabelTranslatorSingleton.getInstance().translate("MegaBasterd will restart"), LabelTranslatorSingleton.getInstance().translate("Restart required"), 2);
            }
            this._exit = true;
            this.getView().getPause_all_down_button().setEnabled(false);
            this.getView().getPause_all_up_button().setEnabled(false);
            this.getView().setEnabled(false);
            if (!(this._download_manager.getTransference_running_list().isEmpty() && this._upload_manager.getTransference_running_list().isEmpty() && this._download_manager.getTransference_waitstart_queue().isEmpty() && this._upload_manager.getTransference_waitstart_queue().isEmpty())) {
                THREAD_POOL.execute(() -> {
                    boolean wait;
                    do {
                        wait = false;
                        if (!this._download_manager.getTransference_running_list().isEmpty()) {
                            for (Transference trans : this._download_manager.getTransference_running_list()) {
                                Download download = (Download)trans;
                                if (download.isPaused()) {
                                    download.pause();
                                }
                                if (download.getChunkworkers().isEmpty()) continue;
                                wait = true;
                                MiscTools.GUIRun(() -> {
                                    download.getView().printStatusNormal("Stopping download safely before exit MegaBasterd, please wait...");
                                    download.getView().getSlots_spinner().setEnabled(false);
                                    download.getView().getPause_button().setEnabled(false);
                                    download.getView().getCopy_link_button().setEnabled(false);
                                    download.getView().getOpen_folder_button().setEnabled(false);
                                    download.getView().getFile_size_label().setEnabled(false);
                                    download.getView().getFile_name_label().setEnabled(false);
                                    download.getView().getSpeed_label().setEnabled(false);
                                    download.getView().getSlots_label().setEnabled(false);
                                    download.getView().getProgress_pbar().setEnabled(false);
                                });
                            }
                        }
                        if (!this._upload_manager.getTransference_running_list().isEmpty()) {
                            for (Transference trans : this._upload_manager.getTransference_running_list()) {
                                Iterator<Transference> upload = (Upload)trans;
                                ((Upload)((Object)upload)).getMac_generator().secureNotify();
                                if (((Upload)((Object)upload)).isPaused()) {
                                    ((Upload)((Object)upload)).pause();
                                }
                                if (!((Upload)((Object)upload)).getChunkworkers().isEmpty()) {
                                    wait = true;
                                    MiscTools.GUIRun(() -> {
                                        upload.getView().printStatusNormal("Stopping upload safely before exit MegaBasterd, please wait...");
                                        upload.getView().getSlots_spinner().setEnabled(false);
                                        upload.getView().getPause_button().setEnabled(false);
                                        upload.getView().getFolder_link_button().setEnabled(false);
                                        upload.getView().getFile_link_button().setEnabled(false);
                                        upload.getView().getFile_size_label().setEnabled(false);
                                        upload.getView().getFile_name_label().setEnabled(false);
                                        upload.getView().getSpeed_label().setEnabled(false);
                                        upload.getView().getSlots_label().setEnabled(false);
                                        upload.getView().getProgress_pbar().setEnabled(false);
                                    });
                                    continue;
                                }
                                try {
                                    DBTools.updateUploadProgress(((Upload)((Object)upload)).getFile_name(), ((Upload)((Object)upload)).getMa().getFull_email(), ((Upload)((Object)upload)).getProgress(), ((Upload)((Object)upload)).getTemp_mac_data() != null ? ((Upload)((Object)upload)).getTemp_mac_data() : null);
                                }
                                catch (SQLException ex) {
                                    Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
                                }
                            }
                        }
                        ArrayList<String> downloads_queue = new ArrayList<String>();
                        ArrayList<String> uploads_queue = new ArrayList<String>();
                        for (Transference t : this._download_manager.getTransference_running_list()) {
                            downloads_queue.add(((Download)t).getUrl());
                        }
                        for (Transference t : this._download_manager.getTransference_waitstart_queue()) {
                            downloads_queue.add(((Download)t).getUrl());
                        }
                        for (Transference t : this._upload_manager.getTransference_running_list()) {
                            uploads_queue.add(t.getFile_name());
                        }
                        for (Transference t : this._upload_manager.getTransference_waitstart_queue()) {
                            uploads_queue.add(t.getFile_name());
                        }
                        try {
                            DBTools.truncateDownloadsQueue();
                            DBTools.insertDownloadsQueue(downloads_queue);
                            DBTools.truncateUploadsQueue();
                            DBTools.insertUploadsQueue(uploads_queue);
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        if (!wait) continue;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                    } while (wait);
                    this.byebyenow(restart);
                });
                WarningExitMessage exit_message = new WarningExitMessage((Frame)this.getView(), true, this, restart);
                exit_message.setLocationRelativeTo(this.getView());
                exit_message.setVisible(true);
            } else {
                this.byebyenow(restart);
            }
        }
    }

    private boolean checkAppIsRunning() {
        boolean app_is_running = true;
        try {
            Socket clientSocket = new Socket(InetAddress.getLoopbackAddress(), 1338);
            clientSocket.close();
        }
        catch (Exception ex) {
            app_is_running = false;
            try {
                ServerSocket serverSocket = new ServerSocket(1338, 0, InetAddress.getLoopbackAddress());
                THREAD_POOL.execute(() -> {
                    ServerSocket socket = serverSocket;
                    while (true) {
                        try {
                            while (true) {
                                socket.accept();
                                MiscTools.GUIRun(() -> {
                                    this.getView().setExtendedState(0);
                                    this.getView().setVisible(true);
                                });
                            }
                        }
                        catch (Exception ex1) {
                            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex1.getMessage());
                            continue;
                        }
                        break;
                    }
                });
            }
            catch (Exception ex2) {
                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, ex2.getMessage());
            }
        }
        return app_is_running;
    }

    public void resumeDownloads() {
        if (!MainPanel.getResume_downloads().booleanValue()) {
            MiscTools.GUIRun(() -> this.getView().getStatus_down_label().setText(LabelTranslatorSingleton.getInstance().translate("Checking if there are previous downloads, please wait...")));
            MainPanel tthis = this;
            THREAD_POOL.execute(() -> {
                int conta_downloads = 0;
                int tot_downloads = -1;
                try {
                    Download download;
                    MegaAPI ma;
                    String email;
                    ArrayList<String> downloads_queue = DBTools.selectDownloadsQueue();
                    HashMap<String, HashMap<String, Object>> res = DBTools.selectDownloads();
                    tot_downloads = res.size();
                    Iterator<String> downloads_queue_iterator = downloads_queue.iterator();
                    while (downloads_queue_iterator.hasNext()) {
                        try {
                            String url = downloads_queue_iterator.next();
                            HashMap<String, Object> o = res.remove(url);
                            if (o == null) continue;
                            email = (String)o.get("email");
                            if (this._mega_accounts.get(email) == null) {
                                email = null;
                            }
                            ma = new MegaAPI();
                            if (email == null || !tthis.isUse_mega_account_down() || (ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(tthis, this.getView(), email)) != null) {
                                download = new Download(tthis, ma, url, (String)o.get("path"), (String)o.get("filename"), (String)o.get("filekey"), (Long)o.get("filesize"), (String)o.get("filepass"), (String)o.get("filenoexpire"), this._use_slots_down, false, (String)o.get("custom_chunks_dir"), false);
                                this.getDownload_manager().getTransference_provision_queue().add(download);
                                ++conta_downloads;
                                downloads_queue_iterator.remove();
                                continue;
                            }
                            --tot_downloads;
                        }
                        catch (Exception ex) {
                            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    DBTools.truncateDownloadsQueue();
                    if (!downloads_queue.isEmpty()) {
                        DBTools.insertDownloadsQueue(downloads_queue);
                    }
                    if (!res.isEmpty()) {
                        for (Map.Entry<String, HashMap<String, Object>> entry : res.entrySet()) {
                            try {
                                email = (String)entry.getValue().get("email");
                                if (this._mega_accounts.get(email) == null) {
                                    email = null;
                                }
                                ma = new MegaAPI();
                                if (email == null || !tthis.isUse_mega_account_down() || (ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(tthis, this.getView(), email)) != null) {
                                    download = new Download(tthis, ma, entry.getKey(), (String)entry.getValue().get("path"), (String)entry.getValue().get("filename"), (String)entry.getValue().get("filekey"), (Long)entry.getValue().get("filesize"), (String)entry.getValue().get("filepass"), (String)entry.getValue().get("filenoexpire"), this._use_slots_down, false, (String)entry.getValue().get("custom_chunks_dir"), false);
                                    this.getDownload_manager().getTransference_provision_queue().add(download);
                                    ++conta_downloads;
                                    continue;
                                }
                                --tot_downloads;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (conta_downloads > 0) {
                    if (conta_downloads == tot_downloads) {
                        MainPanel.setResume_downloads(true);
                    }
                    this._download_manager.setSort_wait_start_queue(false);
                    this.getDownload_manager().secureNotify();
                    MiscTools.GUIRun(() -> this.getView().getjTabbedPane1().setSelectedIndex(0));
                } else {
                    MainPanel.setResume_downloads(true);
                }
                MiscTools.GUIRun(() -> this.getView().getStatus_down_label().setText(""));
            });
        }
    }

    public void trayIcon() throws AWTException {
        if (SystemTray.isSupported()) {
            final JPopupMenu menu = new JPopupMenu();
            Font new_font = GUI_FONT;
            menu.setFont(new_font.deriveFont(1, Math.round(11.2f)));
            JMenuItem messageItem = new JMenuItem(LabelTranslatorSingleton.getInstance().translate("Restore window"));
            messageItem.addActionListener(e -> {
                this.getView().setExtendedState(0);
                this.getView().setVisible(true);
                this.getView().revalidate();
                this.getView().repaint();
            });
            menu.add(messageItem);
            JMenuItem closeItem = new JMenuItem(LabelTranslatorSingleton.getInstance().translate("EXIT"));
            closeItem.addActionListener(e -> {
                if (!this.getView().isVisible()) {
                    this.getView().setExtendedState(0);
                    this.getView().setVisible(true);
                    this.getView().revalidate();
                    this.getView().repaint();
                }
                this.byebye(false);
            });
            menu.add(closeItem);
            this._trayicon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(ICON_FILE)), "MegaBasterd", null);
            this._trayicon.setToolTip("MegaBasterd 8.22");
            this._trayicon.setImageAutoSize(true);
            this._trayicon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        menu.setLocation(e.getX(), e.getY());
                        menu.setInvoker(menu);
                        menu.setVisible(true);
                    } else if (!MainPanel.this.getView().isVisible()) {
                        MainPanel.this.getView().setExtendedState(0);
                        MainPanel.this.getView().setVisible(true);
                        MainPanel.this.getView().revalidate();
                        MainPanel.this.getView().repaint();
                    } else {
                        MainPanel.this.getView().dispatchEvent(new WindowEvent(MainPanel.this.getView(), 201));
                    }
                }
            });
            SystemTray.getSystemTray().add(this._trayicon);
        }
    }

    public void resumeUploads() {
        if (!MainPanel.getResume_uploads().booleanValue()) {
            MiscTools.GUIRun(() -> this.getView().getStatus_up_label().setText(LabelTranslatorSingleton.getInstance().translate("Checking if there are previous uploads, please wait...")));
            MainPanel tthis = this;
            THREAD_POOL.execute(() -> {
                int conta_uploads = 0;
                int tot_uploads = -1;
                try {
                    Upload upload;
                    MegaAPI ma;
                    String email;
                    ArrayList<String> uploads_queue = DBTools.selectUploadsQueue();
                    HashMap<String, HashMap<String, Object>> res = DBTools.selectUploads();
                    tot_uploads = res.size();
                    Iterator<String> uploads_queue_iterator = uploads_queue.iterator();
                    while (uploads_queue_iterator.hasNext()) {
                        try {
                            String filename = uploads_queue_iterator.next();
                            HashMap<String, Object> o = res.remove(filename);
                            if (o == null) continue;
                            email = (String)o.get("email");
                            if (this._mega_accounts.get(email) != null) {
                                ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(tthis, this.getView(), email);
                                if (ma == null) continue;
                                upload = new Upload(tthis, ma, filename, (String)o.get("parent_node"), (String)o.get("ul_key") != null ? MiscTools.bin2i32a(MiscTools.BASE642Bin((String)o.get("ul_key"))) : null, (String)o.get("url"), (String)o.get("root_node"), MiscTools.BASE642Bin((String)o.get("share_key")), (String)o.get("folder_link"), false);
                                this.getUpload_manager().getTransference_provision_queue().add(upload);
                                ++conta_uploads;
                                uploads_queue_iterator.remove();
                                continue;
                            }
                            DBTools.deleteUpload((String)o.get("filename"), email);
                            --tot_uploads;
                            uploads_queue_iterator.remove();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    DBTools.truncateUploadsQueue();
                    if (!uploads_queue.isEmpty()) {
                        DBTools.insertUploadsQueue(uploads_queue);
                    }
                    if (!res.isEmpty()) {
                        for (Map.Entry<String, HashMap<String, Object>> entry : res.entrySet()) {
                            try {
                                email = (String)entry.getValue().get("email");
                                if (this._mega_accounts.get(email) != null) {
                                    ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(tthis, this.getView(), email);
                                    if (ma == null) continue;
                                    upload = new Upload(tthis, ma, entry.getKey(), (String)entry.getValue().get("parent_node"), (String)entry.getValue().get("ul_key") != null ? MiscTools.bin2i32a(MiscTools.BASE642Bin((String)entry.getValue().get("ul_key"))) : null, (String)entry.getValue().get("url"), (String)entry.getValue().get("root_node"), MiscTools.BASE642Bin((String)entry.getValue().get("share_key")), (String)entry.getValue().get("folder_link"), false);
                                    this.getUpload_manager().getTransference_provision_queue().add(upload);
                                    ++conta_uploads;
                                    continue;
                                }
                                DBTools.deleteUpload((String)entry.getValue().get("filename"), email);
                                --tot_uploads;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (conta_uploads > 0) {
                    if (conta_uploads == tot_uploads) {
                        MainPanel.setResume_uploads(true);
                    }
                    this._upload_manager.setSort_wait_start_queue(false);
                    this.getUpload_manager().secureNotify();
                    MiscTools.GUIRun(() -> this.getView().getjTabbedPane1().setSelectedIndex(1));
                } else {
                    MainPanel.setResume_uploads(true);
                }
                MiscTools.GUIRun(() -> this.getView().getStatus_up_label().setText(""));
            });
        }
    }

    static {
        LOG = Logger.getLogger(MainPanel.class.getName());
        CHECK_RUNNING = true;
    }
}

