/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.tonikelope.megabasterd.APIException;
import com.tonikelope.megabasterd.ContentType;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaCrypterAPI;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.StreamChunkDownloader;
import com.tonikelope.megabasterd.StreamChunkManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.CipherInputStream;

public class KissVideoStreamServer
implements HttpHandler,
SecureSingleThreadNotifiable {
    public static final int THREAD_START = 1;
    public static final int THREAD_STOP = 2;
    public static final int DEFAULT_WORKERS = 10;
    private static final Logger LOG = Logger.getLogger(KissVideoStreamServer.class.getName());
    private final MainPanel _main_panel;
    private final ConcurrentHashMap<String, HashMap<String, Object>> _link_cache;
    private final ConcurrentLinkedQueue<Thread> _working_threads;
    private final ContentType _ctype;
    private volatile boolean _notified;
    private final Object _secure_notify_lock;

    public KissVideoStreamServer(MainPanel panel) {
        this._main_panel = panel;
        this._link_cache = new ConcurrentHashMap();
        this._working_threads = new ConcurrentLinkedQueue();
        this._ctype = new ContentType();
        this._notified = false;
        this._secure_notify_lock = new Object();
    }

    public MainPanel getMain_panel() {
        return this._main_panel;
    }

    public ConcurrentHashMap<String, HashMap<String, Object>> getLink_cache() {
        return this._link_cache;
    }

    public ConcurrentLinkedQueue<Thread> getWorking_threads() {
        return this._working_threads;
    }

    public ContentType getCtype() {
        return this._ctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this._notified = false;
        }
    }

    public void start(int port, String context) throws IOException {
        this._main_panel.getView().updateKissStreamServerStatus(LabelTranslatorSingleton.getInstance().translate("Streaming server: ON (port ") + 1337 + ")");
        HttpServer httpserver = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), 0);
        httpserver.createContext(context, this);
        httpserver.setExecutor(MainPanel.THREAD_POOL);
        httpserver.start();
    }

    private void _updateStatus(Integer status) {
        if (status == 1 && !this.getWorking_threads().contains(Thread.currentThread())) {
            this.getWorking_threads().add(Thread.currentThread());
        } else {
            this.getWorking_threads().remove(Thread.currentThread());
        }
        this._updateStatusView();
    }

    private void _updateStatusView() {
        String status = this.getWorking_threads().size() > 0 ? LabelTranslatorSingleton.getInstance().translate("Streaming server: ON (port ") + 1337 + " [" + this.getWorking_threads().size() + "])" : LabelTranslatorSingleton.getInstance().translate("Streaming server: ON (port ") + 1337 + ")";
        this._main_panel.getView().updateKissStreamServerStatus(status);
    }

    private String[] _getMegaFileMetadata(String link, MainPanelView panel) throws IOException {
        boolean error;
        String[] file_info = null;
        int conta_error = 0;
        do {
            error = false;
            try {
                if (MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/", link, 0) != null) {
                    MegaAPI ma = new MegaAPI();
                    file_info = ma.getMegaFileMetadata(link);
                    continue;
                }
                file_info = MegaCrypterAPI.getMegaFileMetadata(link, panel, this.getMain_panel().getMega_proxy_server() != null ? this.getMain_panel().getMega_proxy_server().getPort() + ":" + MiscTools.Bin2BASE64(("megacrypter:" + this.getMain_panel().getMega_proxy_server().getPassword()).getBytes("UTF-8")) : null);
            }
            catch (APIException ex) {
                error = true;
                LOG.log(Level.SEVERE, ex.getMessage());
                try {
                    Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error++) * 1000L);
                }
                catch (InterruptedException ex2) {
                    LOG.log(Level.SEVERE, ex2.getMessage());
                }
            }
        } while (error);
        return file_info;
    }

    public String getMegaFileDownloadUrl(String link, String pass_hash, String noexpire_token, String mega_account) throws Exception {
        boolean error;
        String dl_url = null;
        int conta_error = 0;
        do {
            error = false;
            try {
                MegaAPI ma = new MegaAPI();
                if (mega_account != null) {
                    ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(this._main_panel, this._main_panel.getView(), mega_account);
                }
                if (MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/", link, 0) != null) {
                    dl_url = ma.getMegaFileDownloadUrl(link);
                    continue;
                }
                dl_url = MegaCrypterAPI.getMegaFileDownloadUrl(link, pass_hash, noexpire_token, ma.getSid(), this.getMain_panel().getMega_proxy_server() != null ? this.getMain_panel().getMega_proxy_server().getPort() + ":" + MiscTools.Bin2BASE64(("megacrypter:" + this.getMain_panel().getMega_proxy_server().getPassword()).getBytes("UTF-8")) + ":" + MiscTools.getMyPublicIP() : null);
            }
            catch (APIException ex) {
                error = true;
                LOG.log(Level.SEVERE, ex.getMessage());
                try {
                    Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error++) * 1000L);
                }
                catch (InterruptedException ex2) {
                    LOG.log(Level.SEVERE, ex2.getMessage());
                }
            }
        } while (error);
        return dl_url;
    }

    private long[] _parseRangeHeader(String header) {
        Pattern pattern = Pattern.compile("bytes *\\= *([0-9]+) *\\- *([0-9]+)?");
        Matcher matcher = pattern.matcher(header);
        long[] ranges = new long[2];
        if (matcher.find()) {
            ranges[0] = Long.valueOf(matcher.group(1));
            ranges[1] = matcher.group(2) != null ? Long.valueOf(matcher.group(2)) : -1L;
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange xchg) throws IOException {
        this._updateStatus(1);
        StreamChunkManager chunkwriter = null;
        ArrayList<StreamChunkDownloader> chunkworkers = new ArrayList<StreamChunkDownloader>();
        PipedOutputStream pipeout = new PipedOutputStream();
        PipedInputStream pipein = new PipedInputStream(pipeout);
        String httpmethod = xchg.getRequestMethod();
        try {
            HashMap<String, Object> file_info;
            Headers reqheaders = xchg.getRequestHeaders();
            Headers resheaders = xchg.getResponseHeaders();
            String url_path = xchg.getRequestURI().getPath();
            String[] url_parts = new String(MiscTools.UrlBASE642Bin(url_path.substring(url_path.indexOf("/video/") + 7)), "UTF-8").split("\\|");
            String mega_account = url_parts[0];
            if (mega_account.isEmpty()) {
                mega_account = null;
            }
            String link = url_parts[1];
            LOG.log(Level.INFO, "{0} {1} {2}", new Object[]{Thread.currentThread().getName(), link, mega_account});
            HashMap<String, Object> cache_info = this.getLink_cache().get(link);
            if (cache_info != null) {
                file_info = cache_info;
            } else {
                String[] finfo = this._getMegaFileMetadata(link, this._main_panel.getView());
                file_info = new HashMap();
                file_info.put("file_name", finfo[0]);
                file_info.put("file_size", Long.parseLong(finfo[1]));
                file_info.put("file_key", finfo[2]);
                file_info.put("pass_hash", finfo.length >= 5 ? finfo[3] : null);
                file_info.put("noexpiretoken", finfo.length >= 5 ? finfo[4] : null);
                file_info.put("url", null);
            }
            String file_name = (String)file_info.get("file_name");
            long file_size = (Long)file_info.get("file_size");
            String file_key = (String)file_info.get("file_key");
            String pass_hash = (String)file_info.get("pass_hash");
            String noexpire_token = (String)file_info.get("noexpiretoken");
            String file_ext = file_name.substring(file_name.lastIndexOf(46) + 1).toLowerCase();
            if (httpmethod.equals("HEAD")) {
                resheaders.add("Accept-Ranges", "bytes");
                resheaders.add("transferMode.dlna.org", "Streaming");
                resheaders.add("contentFeatures.dlna.org", "DLNA.ORG_OP=01;DLNA.ORG_CI=0;DLNA.ORG_FLAGS=01700000000000000000000000000000");
                resheaders.add("Content-Type", this.getCtype().getMIME(file_ext));
                resheaders.add("Content-Length", String.valueOf(file_size));
                resheaders.add("Connection", "close");
                xchg.sendResponseHeaders(200, 0L);
            } else if (httpmethod.equals("GET")) {
                int reads;
                String temp_url;
                resheaders.add("Accept-Ranges", "bytes");
                resheaders.add("transferMode.dlna.org", "Streaming");
                resheaders.add("contentFeatures.dlna.org", "DLNA.ORG_OP=01;DLNA.ORG_CI=0;DLNA.ORG_FLAGS=01700000000000000000000000000000");
                resheaders.add("Content-Type", this.getCtype().getMIME(file_ext));
                resheaders.add("Connection", "close");
                byte[] buffer = new byte[16384];
                if (file_info.get("url") != null) {
                    temp_url = (String)file_info.get("url");
                    if (!MiscTools.checkMegaDownloadUrl(temp_url)) {
                        temp_url = this.getMegaFileDownloadUrl(link, pass_hash, noexpire_token, mega_account);
                        file_info.put("url", temp_url);
                    }
                } else {
                    temp_url = this.getMegaFileDownloadUrl(link, pass_hash, noexpire_token, mega_account);
                    file_info.put("url", temp_url);
                }
                this.getLink_cache().put(link, file_info);
                long[] ranges = new long[2];
                int sync_bytes = 0;
                String header_range = null;
                if (reqheaders.containsKey("Range")) {
                    header_range = "Range";
                } else if (reqheaders.containsKey("range")) {
                    header_range = "range";
                }
                if (header_range != null) {
                    Object ranges_raw = reqheaders.get(header_range);
                    String range_header = (String)ranges_raw.get(0);
                    ranges = this._parseRangeHeader(range_header);
                    sync_bytes = (int)ranges[0] % 16;
                    long clength = ranges[1] >= 0L && ranges[1] >= ranges[0] ? ranges[1] - ranges[0] + 1L : file_size - ranges[0];
                    resheaders.add("Content-Range", "bytes " + ranges[0] + "-" + (ranges[1] >= 0L ? ranges[1] : file_size - 1L) + "/" + file_size);
                    xchg.sendResponseHeaders(206, clength);
                    chunkwriter = new StreamChunkManager(this, link, file_info, mega_account, pipeout, temp_url, ranges[0] - (long)sync_bytes, ranges[1] >= 0L ? ranges[1] : file_size - 1L);
                } else {
                    xchg.sendResponseHeaders(200, file_size);
                    chunkwriter = new StreamChunkManager(this, link, file_info, mega_account, pipeout, temp_url, 0L, file_size - 1L);
                }
                MainPanel.THREAD_POOL.execute(chunkwriter);
                for (int i = 0; i < 10; ++i) {
                    StreamChunkDownloader worker = new StreamChunkDownloader(i + 1, chunkwriter);
                    chunkworkers.add(worker);
                    MainPanel.THREAD_POOL.execute(worker);
                }
                PipedInputStream is = pipein;
                byte[] iv = CryptTools.initMEGALinkKeyIV(file_key);
                CipherInputStream cis = new CipherInputStream(is, CryptTools.genDecrypter("AES", "AES/CTR/NoPadding", CryptTools.initMEGALinkKey(file_key), header_range != null && ranges[0] - (long)sync_bytes > 0L ? CryptTools.forwardMEGALinkKeyIV(iv, ranges[0] - (long)sync_bytes) : iv));
                OutputStream os = xchg.getResponseBody();
                cis.skip(sync_bytes);
                while ((reads = cis.read(buffer)) != -1) {
                    os.write(buffer, 0, reads);
                }
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof IOException)) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        }
        finally {
            LOG.log(Level.INFO, "{0} KissVideoStreamerHandle: bye bye", Thread.currentThread().getName());
            if (chunkwriter != null) {
                pipeout.close();
                chunkworkers.forEach(d -> d.setExit(true));
                chunkwriter.setExit(true);
                chunkwriter.secureNotifyAll();
            }
            xchg.close();
        }
        this._updateStatus(2);
    }
}

