/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class GetMasterPasswordDialog
extends JDialog {
    private boolean _pass_ok;
    private String _current_pass_hash;
    private final String _salt;
    private byte[] _pass;
    private JButton cancel_button;
    private JPasswordField current_pass_textfield;
    private JLabel lock_label;
    private JButton ok_button;
    private JLabel please_label;
    private JCheckBox remember_checkbox;
    private JLabel status_label;
    private static final Logger LOG = Logger.getLogger(GetMasterPasswordDialog.class.getName());

    public JPasswordField getNew_pass_textfield() {
        return this.current_pass_textfield;
    }

    public JCheckBox getRemember_checkbox() {
        return this.remember_checkbox;
    }

    public boolean isPass_ok() {
        return this._pass_ok;
    }

    public byte[] getPass() {
        return this._pass;
    }

    public void deletePass() {
        if (this._pass != null) {
            Arrays.fill(this._pass, (byte)0);
        }
        this._pass = null;
    }

    public GetMasterPasswordDialog(Frame parent, boolean modal, String current_pass_hash, String salt, MainPanel main_panel) {
        super(parent, modal);
        this._current_pass_hash = current_pass_hash;
        this._pass_ok = false;
        this._pass = null;
        this._salt = salt;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this.pack();
        });
    }

    private void initComponents() {
        this.current_pass_textfield = new JPasswordField();
        this.cancel_button = new JButton();
        this.ok_button = new JButton();
        this.lock_label = new JLabel();
        this.please_label = new JLabel();
        this.status_label = new JLabel();
        this.remember_checkbox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Master password unlock");
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.current_pass_textfield.setFont(new Font("Dialog", 0, 18));
        this.current_pass_textfield.setDoubleBuffered(true);
        this.current_pass_textfield.setMargin(new Insets(2, 2, 2, 2));
        this.current_pass_textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GetMasterPasswordDialog.this.current_pass_textfieldKeyPressed(evt);
            }
        });
        this.cancel_button.setFont(new Font("Dialog", 1, 18));
        this.cancel_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cancel-30.png")));
        this.cancel_button.setText("CANCEL");
        this.cancel_button.setDoubleBuffered(true);
        this.cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetMasterPasswordDialog.this.cancel_buttonActionPerformed(evt);
            }
        });
        this.ok_button.setFont(new Font("Dialog", 1, 18));
        this.ok_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
        this.ok_button.setText("OK");
        this.ok_button.setDoubleBuffered(true);
        this.ok_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetMasterPasswordDialog.this.ok_buttonActionPerformed(evt);
            }
        });
        this.lock_label.setIcon(new ImageIcon(this.getClass().getResource("/images/lock_medium.png")));
        this.lock_label.setDoubleBuffered(true);
        this.please_label.setFont(new Font("Dialog", 1, 24));
        this.please_label.setText("Please, enter your master password");
        this.please_label.setDoubleBuffered(true);
        this.status_label.setFont(new Font("Dialog", 0, 14));
        this.status_label.setDoubleBuffered(true);
        this.remember_checkbox.setFont(new Font("Dialog", 0, 14));
        this.remember_checkbox.setSelected(true);
        this.remember_checkbox.setText("Remember for this session");
        this.remember_checkbox.setDoubleBuffered(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.status_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ok_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancel_button)).addGroup(layout.createSequentialGroup().addComponent(this.lock_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.current_pass_textfield).addGroup(layout.createSequentialGroup().addComponent(this.remember_checkbox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.please_label, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.please_label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.current_pass_textfield, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.remember_checkbox)).addComponent(this.lock_label)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ok_button).addComponent(this.cancel_button)).addComponent(this.status_label, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    private void cancel_buttonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ok_buttonActionPerformed(ActionEvent evt) {
        this.status_label.setText(LabelTranslatorSingleton.getInstance().translate("Verifying your password, please wait..."));
        this.pack();
        GetMasterPasswordDialog tthis = this;
        MainPanel.THREAD_POOL.execute(() -> {
            try {
                byte[] pass = CryptTools.PBKDF2HMACSHA256(new String(this.current_pass_textfield.getPassword()), MiscTools.BASE642Bin(this._salt), 65536, 256);
                String pass_hash = MiscTools.Bin2BASE64(MiscTools.HashBin("SHA-1", pass));
                MiscTools.GUIRun(() -> {
                    if (!pass_hash.equals(this._current_pass_hash)) {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("BAD PASSWORD!"), "Error", 0);
                        this.status_label.setText("");
                        this.pack();
                        this.current_pass_textfield.setText("");
                        this.current_pass_textfield.grabFocus();
                    } else {
                        this._pass = pass;
                        this._current_pass_hash = pass_hash;
                        this._pass_ok = true;
                        tthis.setVisible(false);
                    }
                });
            }
            catch (HeadlessException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        });
    }

    private void current_pass_textfieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.ok_buttonActionPerformed(null);
        }
    }
}

