/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class Get2FACode
extends JDialog {
    private boolean _code_ok;
    private String _pin_code;
    private static final int MAX_CODE_LENGTH = 6;
    private JButton cancel_button;
    private JTextField current_code_textfield;
    private JLabel email_label;
    private JLabel lock_label;
    private JButton ok_button;
    private JLabel please_label;
    private JLabel status_label;
    private static final Logger LOG = Logger.getLogger(Get2FACode.class.getName());

    public boolean isCode_ok() {
        return this._code_ok;
    }

    public String getPin_code() {
        return this._pin_code;
    }

    public Get2FACode(Frame parent, boolean modal, String email, MainPanel main_panel) {
        super(parent, modal);
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this._code_ok = false;
            this.email_label.setText(email);
            this.ok_button.setEnabled(false);
            this.pack();
        });
    }

    private void initComponents() {
        this.cancel_button = new JButton();
        this.ok_button = new JButton();
        this.lock_label = new JLabel();
        this.email_label = new JLabel();
        this.status_label = new JLabel();
        this.please_label = new JLabel();
        this.current_code_textfield = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("2FA CODE");
        this.cancel_button.setFont(new Font("Dialog", 1, 18));
        this.cancel_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cancel-30.png")));
        this.cancel_button.setText("CANCEL");
        this.cancel_button.setDoubleBuffered(true);
        this.cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Get2FACode.this.cancel_buttonActionPerformed(evt);
            }
        });
        this.ok_button.setFont(new Font("Dialog", 1, 18));
        this.ok_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
        this.ok_button.setText("OK");
        this.ok_button.setDoubleBuffered(true);
        this.ok_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Get2FACode.this.ok_buttonActionPerformed(evt);
            }
        });
        this.lock_label.setIcon(new ImageIcon(this.getClass().getResource("/images/lock_medium.png")));
        this.lock_label.setDoubleBuffered(true);
        this.email_label.setFont(new Font("Dialog", 1, 24));
        this.email_label.setForeground(new Color(255, 102, 0));
        this.email_label.setDoubleBuffered(true);
        this.status_label.setFont(new Font("Dialog", 0, 14));
        this.status_label.setDoubleBuffered(true);
        this.please_label.setFont(new Font("Dialog", 1, 24));
        this.please_label.setText(LabelTranslatorSingleton.getInstance().translate("Please enter 2FA PIN CODE"));
        this.please_label.setDoubleBuffered(true);
        this.current_code_textfield.setBackground(new Color(0, 153, 255));
        this.current_code_textfield.setFont(new Font("Dialog", 0, 24));
        this.current_code_textfield.setForeground(new Color(255, 255, 255));
        this.current_code_textfield.setHorizontalAlignment(0);
        this.current_code_textfield.setDoubleBuffered(true);
        this.current_code_textfield.setMargin(new Insets(2, 2, 2, 2));
        this.current_code_textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Get2FACode.this.current_code_textfieldKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                Get2FACode.this.current_code_textfieldKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                Get2FACode.this.current_code_textfieldKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.status_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ok_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancel_button)).addGroup(layout.createSequentialGroup().addComponent(this.lock_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.email_label, -1, -1, Short.MAX_VALUE).addComponent(this.current_code_textfield).addComponent(this.please_label, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.email_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.please_label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.current_code_textfield, -2, -1, -2)).addComponent(this.lock_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ok_button).addComponent(this.cancel_button)).addComponent(this.status_label, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        this.pack();
    }

    private void cancel_buttonActionPerformed(ActionEvent evt) {
        this._code_ok = false;
        this.setVisible(false);
    }

    private void ok_buttonActionPerformed(ActionEvent evt) {
        this._code_ok = true;
        this._pin_code = this.current_code_textfield.getText();
        this.setVisible(false);
    }

    private void current_code_textfieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.ok_button.isEnabled()) {
            this.ok_buttonActionPerformed(null);
        }
    }

    private void current_code_textfieldKeyTyped(KeyEvent evt) {
        if (this.current_code_textfield.getText().length() == 6 || !Character.isDigit(evt.getKeyChar()) && evt.getKeyCode() != 8 && evt.getKeyCode() != 127) {
            evt.consume();
        }
    }

    private void current_code_textfieldKeyReleased(KeyEvent evt) {
        this.ok_button.setEnabled(this.current_code_textfield.getText().length() >= 6);
    }
}

