/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaAPIException;
import com.tonikelope.megabasterd.MegaMutableTreeNode;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FolderLinkDialog
extends JDialog {
    private final String _link;
    private boolean _download = false;
    private final List<HashMap> _download_links;
    private long _total_space = 0L;
    private int _mega_error = 0;
    private volatile boolean working = false;
    private volatile boolean exit = false;
    private JButton dance_button;
    private final JTree file_tree = new JTree();
    private JScrollPane file_tree_scrollpane;
    private JLabel folder_link_label;
    private JLabel link_detected_label;
    private JProgressBar node_bar;
    private JButton restore_button;
    private JButton skip_button;
    private JButton skip_rest_button;
    private JLabel total_space_label;
    private JLabel warning_label;
    private static final Logger LOG = Logger.getLogger(FolderLinkDialog.class.getName());

    @Override
    public void dispose() {
        this.file_tree.setModel(null);
        super.dispose();
    }

    public List<HashMap> getDownload_links() {
        return Collections.unmodifiableList(this._download_links);
    }

    public boolean isDownload() {
        return this._download;
    }

    public int isMega_error() {
        return this._mega_error;
    }

    public FolderLinkDialog(MainPanelView parent, boolean modal, String link) {
        super((Frame)parent, modal);
        this._download_links = new ArrayList<HashMap>();
        this._link = link;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, parent.getMain_panel().getZoom_factor());
            MiscTools.translateLabels(this);
            this.file_tree.setRootVisible(false);
            this.node_bar.setIndeterminate(true);
            this.folder_link_label.setText(link);
            this.restore_button.setVisible(false);
            FolderLinkDialog tthis = this;
            MainPanel.THREAD_POOL.execute(() -> {
                this._loadMegaDirTree();
                if (this._mega_error == 0) {
                    this._genDownloadLiks();
                    MiscTools.GUIRun(() -> {
                        this.dance_button.setText(LabelTranslatorSingleton.getInstance().translate("Let's dance, baby"));
                        this.pack();
                    });
                } else if (this._mega_error == -18) {
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("MEGA FOLDER TEMPORARILY UNAVAILABLE!"), "Error", 0);
                        this.setVisible(false);
                    });
                } else if (this._mega_error == -16) {
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("MEGA FOLDER BLOCKED/DELETED"), "Error", 0);
                        this.setVisible(false);
                    });
                } else {
                    MiscTools.GUIRun(() -> {
                        JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("MEGA FOLDER LINK ERROR!"), "Error", 0);
                        this.setVisible(false);
                    });
                }
            });
            this.pack();
        });
    }

    private void initComponents() {
        this.file_tree_scrollpane = new JScrollPane();
        this.skip_button = new JButton();
        this.link_detected_label = new JLabel();
        this.dance_button = new JButton();
        this.folder_link_label = new JLabel();
        this.warning_label = new JLabel();
        this.skip_rest_button = new JButton();
        this.restore_button = new JButton();
        this.total_space_label = new JLabel();
        this.node_bar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("FolderLink");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FolderLinkDialog.this.formWindowClosing(evt);
            }
        });
        this.file_tree.setFont(new Font("Dialog", 0, 18));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.file_tree.setModel(new DefaultTreeModel(treeNode1));
        this.file_tree.setDoubleBuffered(true);
        this.file_tree.setEnabled(false);
        this.file_tree_scrollpane.setViewportView(this.file_tree);
        this.skip_button.setFont(new Font("Dialog", 1, 18));
        this.skip_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.skip_button.setText("REMOVE THIS");
        this.skip_button.setDoubleBuffered(true);
        this.skip_button.setEnabled(false);
        this.skip_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderLinkDialog.this.skip_buttonActionPerformed(evt);
            }
        });
        this.link_detected_label.setFont(new Font("Dialog", 1, 24));
        this.link_detected_label.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-folder-30.png")));
        this.link_detected_label.setText("Folder link detected!");
        this.link_detected_label.setDoubleBuffered(true);
        this.dance_button.setBackground(new Color(102, 204, 255));
        this.dance_button.setFont(new Font("Dialog", 1, 22));
        this.dance_button.setForeground(new Color(255, 255, 255));
        this.dance_button.setText("Loading...");
        this.dance_button.setDoubleBuffered(true);
        this.dance_button.setEnabled(false);
        this.dance_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderLinkDialog.this.dance_buttonActionPerformed(evt);
            }
        });
        this.folder_link_label.setFont(new Font("Dialog", 1, 18));
        this.folder_link_label.setText("jLabel2");
        this.folder_link_label.setDoubleBuffered(true);
        this.warning_label.setFont(new Font("Dialog", 0, 16));
        this.warning_label.setText("If you DO NOT want to transfer some folder or file you can REMOVE it (to select several items at the same time use CTRL + LMOUSE).");
        this.warning_label.setDoubleBuffered(true);
        this.warning_label.setEnabled(false);
        this.skip_rest_button.setFont(new Font("Dialog", 1, 18));
        this.skip_rest_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.skip_rest_button.setText("REMOVE ALL EXCEPT THIS");
        this.skip_rest_button.setDoubleBuffered(true);
        this.skip_rest_button.setEnabled(false);
        this.skip_rest_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderLinkDialog.this.skip_rest_buttonActionPerformed(evt);
            }
        });
        this.restore_button.setFont(new Font("Dialog", 1, 14));
        this.restore_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-undelete-30.png")));
        this.restore_button.setText("Restore folder data");
        this.restore_button.setDoubleBuffered(true);
        this.restore_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderLinkDialog.this.restore_buttonActionPerformed(evt);
            }
        });
        this.total_space_label.setFont(new Font("Dialog", 1, 32));
        this.total_space_label.setForeground(new Color(0, 0, 255));
        this.total_space_label.setText("[---]");
        this.total_space_label.setDoubleBuffered(true);
        this.total_space_label.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.link_detected_label, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.folder_link_label, -1, -1, Short.MAX_VALUE).addGap(29, 29, 29).addComponent(this.restore_button)).addComponent(this.node_bar, -1, -1, Short.MAX_VALUE).addComponent(this.file_tree_scrollpane, GroupLayout.Alignment.TRAILING).addComponent(this.warning_label, -1, -1, Short.MAX_VALUE).addComponent(this.total_space_label, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.skip_rest_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.skip_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dance_button))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.link_detected_label).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folder_link_label).addComponent(this.restore_button)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.file_tree_scrollpane, -1, 289, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.node_bar, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.total_space_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skip_rest_button).addComponent(this.skip_button).addComponent(this.dance_button)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.warning_label).addGap(49, 49, 49))).addContainerGap()));
        this.pack();
    }

    private void skip_buttonActionPerformed(ActionEvent evt) {
        if (MiscTools.deleteSelectedTreeItems(this.file_tree)) {
            this.file_tree.setEnabled(false);
            this.node_bar.setVisible(true);
            this.skip_rest_button.setEnabled(false);
            this.skip_button.setEnabled(false);
            MainPanel.THREAD_POOL.execute(() -> {
                MiscTools.resetTreeFolderSizes((MegaMutableTreeNode)this.file_tree.getModel().getRoot());
                MiscTools.calculateTreeFolderSizes((MegaMutableTreeNode)this.file_tree.getModel().getRoot());
                this._genDownloadLiks();
                MiscTools.GUIRun(() -> {
                    this.restore_button.setVisible(true);
                    this.file_tree.setEnabled(true);
                    this.file_tree.setModel(new DefaultTreeModel((TreeNode)this.file_tree.getModel().getRoot()));
                    boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
                    this.dance_button.setEnabled(root_childs);
                    this.skip_button.setEnabled(root_childs);
                    this.skip_rest_button.setEnabled(root_childs);
                });
            });
        }
    }

    private void dance_buttonActionPerformed(ActionEvent evt) {
        this._download = true;
        this.dispose();
    }

    private void skip_rest_buttonActionPerformed(ActionEvent evt) {
        if (MiscTools.deleteAllExceptSelectedTreeItems(this.file_tree)) {
            this.file_tree.setEnabled(false);
            this.node_bar.setVisible(true);
            this.skip_rest_button.setEnabled(false);
            this.skip_button.setEnabled(false);
            MainPanel.THREAD_POOL.execute(() -> {
                MiscTools.resetTreeFolderSizes((MegaMutableTreeNode)this.file_tree.getModel().getRoot());
                MiscTools.calculateTreeFolderSizes((MegaMutableTreeNode)this.file_tree.getModel().getRoot());
                this._genDownloadLiks();
                MiscTools.GUIRunAndWait(() -> {
                    this.restore_button.setVisible(true);
                    this.file_tree.setEnabled(true);
                    this.file_tree.setModel(new DefaultTreeModel((TreeNode)this.file_tree.getModel().getRoot()));
                    boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
                    this.dance_button.setEnabled(root_childs);
                    this.skip_button.setEnabled(root_childs);
                    this.skip_rest_button.setEnabled(root_childs);
                });
            });
        }
    }

    private void restore_buttonActionPerformed(ActionEvent evt) {
        this.restore_button.setText(LabelTranslatorSingleton.getInstance().translate("Restoring data, please wait..."));
        this.file_tree.setEnabled(false);
        this.restore_button.setEnabled(false);
        this.dance_button.setEnabled(false);
        this.node_bar.setVisible(true);
        this.node_bar.setIndeterminate(true);
        this.skip_button.setEnabled(false);
        this.skip_rest_button.setEnabled(false);
        MainPanel.THREAD_POOL.execute(() -> {
            this._loadMegaDirTree();
            this._genDownloadLiks();
            MiscTools.GUIRun(() -> {
                this.restore_button.setVisible(false);
                this.restore_button.setText(LabelTranslatorSingleton.getInstance().translate("Restore folder data"));
                boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
                for (JComponent c : new JComponent[]{this.restore_button, this.dance_button, this.skip_button, this.skip_rest_button, this.file_tree}) {
                    c.setEnabled(root_childs);
                }
                this.skip_button.setEnabled(root_childs);
                this.skip_rest_button.setEnabled(root_childs);
            });
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.working && JOptionPane.showConfirmDialog(this, "EXIT?") == 0) {
            this.dispose();
            this.exit = true;
        } else if (!this.working) {
            this.dispose();
            this.exit = true;
        }
    }

    private int _loadMegaDirTree() {
        try {
            this.working = true;
            MegaAPI ma = new MegaAPI();
            String folder_id = MiscTools.findFirstRegex("#F!([^!]+)", this._link, 1);
            String subfolder_id = null;
            if (folder_id.contains("@")) {
                String[] fids = folder_id.split("@");
                folder_id = fids[0];
                subfolder_id = fids[1];
            }
            int r = -1;
            if (ma.existsCachedFolderNodes(folder_id)) {
                r = JOptionPane.showConfirmDialog(this, "Do you want to use FOLDER CACHED VERSION?\n\n(It could speed up the loading of very large folders)", "FOLDER CACHE", 0);
            }
            if (r == 0) {
                MiscTools.GUIRun(() -> this.folder_link_label.setText(this._link + " (CACHED VERSION)"));
            }
            String folder_key = MiscTools.findFirstRegex("#F![^!]+!(.+)", this._link, 1);
            HashMap<String, Object> folder_nodes = ma.getFolderNodes(folder_id, folder_key, this.node_bar, r == 0);
            DefaultMutableTreeNode root = null;
            int nodos_totales = folder_nodes.size();
            MiscTools.GUIRun(() -> {
                this.node_bar.setIndeterminate(false);
                this.node_bar.setMaximum(nodos_totales);
                this.node_bar.setValue(0);
            });
            int conta_nodo = 0;
            for (Object o : folder_nodes.values()) {
                MegaMutableTreeNode current_node;
                if (this.exit) {
                    return 1;
                }
                int c = ++conta_nodo;
                MiscTools.GUIRun(() -> this.node_bar.setValue(c));
                HashMap current_hashmap_node = (HashMap)o;
                if (current_hashmap_node.get("jtree_node") == null) {
                    current_node = new MegaMutableTreeNode(current_hashmap_node);
                    current_hashmap_node.put("jtree_node", current_node);
                } else {
                    current_node = (MegaMutableTreeNode)current_hashmap_node.get("jtree_node");
                }
                String parent_id = (String)current_hashmap_node.get("parent");
                String current_id = (String)current_hashmap_node.get("h");
                boolean ignore_node = false;
                do {
                    if (subfolder_id == null && folder_nodes.get(parent_id) != null || subfolder_id != null && !subfolder_id.equals(current_id) && folder_nodes.get(parent_id) != null) {
                        MegaMutableTreeNode parent_node;
                        HashMap parent_hashmap_node = (HashMap)folder_nodes.get(parent_id);
                        if (parent_hashmap_node.get("jtree_node") == null) {
                            parent_node = new MegaMutableTreeNode(parent_hashmap_node);
                            parent_hashmap_node.put("jtree_node", parent_node);
                        } else {
                            parent_node = (MegaMutableTreeNode)parent_hashmap_node.get("jtree_node");
                        }
                        parent_node.add(current_node);
                        parent_id = (String)parent_hashmap_node.get("parent");
                        current_node = parent_node;
                        continue;
                    }
                    if (subfolder_id != null && subfolder_id.equals(current_id)) {
                        root = current_node;
                        continue;
                    }
                    if (subfolder_id != null && folder_nodes.get(parent_id) == null) {
                        ignore_node = true;
                        continue;
                    }
                    if (subfolder_id != null || folder_nodes.get(parent_id) != null) continue;
                    root = current_node;
                } while (current_node != root && !ignore_node);
            }
            MiscTools.GUIRun(() -> this.node_bar.setIndeterminate(true));
            if (root != null) {
                MiscTools.sortTree(root);
                MiscTools.calculateTreeFolderSizes(root);
            }
            if (root == null) {
                LOG.log(Level.SEVERE, null, "MEGA FOLDER ERROR (EMPTY?)");
                this._mega_error = 2;
            } else {
                root.setParent(null);
                JTree ftree = this.file_tree;
                DefaultMutableTreeNode roott = root;
                MiscTools.GUIRunAndWait(() -> this.lambda$_loadMegaDirTree$16(ftree, (MegaMutableTreeNode)roott));
            }
        }
        catch (MegaAPIException mex) {
            LOG.log(Level.SEVERE, null, mex);
            this._mega_error = mex.getCode();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            this._mega_error = 1;
        }
        this.working = false;
        return 0;
    }

    private void _genDownloadLiks() {
        MiscTools.GUIRun(() -> {
            this.working = true;
            this._download_links.clear();
            MegaMutableTreeNode root = (MegaMutableTreeNode)this.file_tree.getModel().getRoot();
            Enumeration<TreeNode> files_tree = root.depthFirstEnumeration();
            this.total_space_label.setText("[---]");
            MainPanel.THREAD_POOL.execute(() -> {
                String folder_id = MiscTools.findFirstRegex("#F!([^!]+)", this._link, 1);
                if (folder_id.contains("@")) {
                    String[] fids = folder_id.split("@");
                    folder_id = fids[0];
                }
                this._total_space = 0L;
                while (files_tree.hasMoreElements()) {
                    Object url;
                    Object p;
                    int n;
                    Object[] object_path;
                    String path;
                    MegaMutableTreeNode node = (MegaMutableTreeNode)files_tree.nextElement();
                    if (node.isLeaf() && node != root && ((HashMap)node.getUserObject()).get("size") != null) {
                        path = "";
                        Object[] objectArray = object_path = node.getUserObjectPath();
                        int n2 = objectArray.length;
                        for (n = 0; n < n2; ++n) {
                            p = objectArray[n];
                            path = path + File.separator + ((Map)p).get("name");
                        }
                        path = path.replaceAll("^/+", "").replaceAll("^\\+", "").trim();
                        url = "https://mega.nz/#N!" + ((Map)node.getUserObject()).get("h") + "!" + ((Map)node.getUserObject()).get("key") + "###n=" + folder_id;
                        HashMap<String, Object> download_link = new HashMap<String, Object>();
                        download_link.put("url", url);
                        download_link.put("filename", MiscTools.cleanFilePath(path));
                        download_link.put("filekey", ((Map)node.getUserObject()).get("key"));
                        download_link.put("filesize", ((Map)node.getUserObject()).get("size"));
                        this._total_space += ((Long)download_link.get("filesize")).longValue();
                        this._download_links.add(download_link);
                        continue;
                    }
                    if (!node.isLeaf() || node == root) continue;
                    path = "";
                    url = object_path = node.getUserObjectPath();
                    int n3 = ((Object[])url).length;
                    for (n = 0; n < n3; ++n) {
                        p = url[n];
                        path = path + File.separator + ((Map)p).get("name");
                    }
                    path = path.replaceAll("^/+", "").replaceAll("^\\+", "").trim();
                    HashMap<String, String> download_link = new HashMap<String, String>();
                    download_link.put("url", "*");
                    download_link.put("filename", MiscTools.cleanFilePath(path));
                    download_link.put("type", (String)((HashMap)node.getUserObject()).get("type"));
                    this._download_links.add(download_link);
                }
                MiscTools.GUIRunAndWait(() -> {
                    this.total_space_label.setText("[" + MiscTools.formatBytes(this._total_space) + "]");
                    for (JComponent c : new JComponent[]{this.dance_button, this.warning_label, this.skip_button, this.skip_rest_button, this.total_space_label}) {
                        c.setEnabled(root.getChildCount() > 0);
                    }
                    this.node_bar.setVisible(false);
                    this.working = false;
                });
            });
        });
    }

    private /* synthetic */ void lambda$_loadMegaDirTree$16(JTree ftree, MegaMutableTreeNode roott) {
        this.node_bar.setIndeterminate(true);
        ftree.setModel(new DefaultTreeModel(roott));
        ftree.setRootVisible(roott != null ? roott.getChildCount() > 0 : false);
        ftree.setEnabled(true);
    }
}

