/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class FileSplitterDialog
extends JDialog {
    private final MainPanel _main_panel;
    private File[] _files = null;
    private File _output_dir = null;
    private volatile long _progress = 0L;
    private volatile Path _current_part = null;
    private volatile int _current_file = 0;
    private volatile boolean _exit = false;
    private JButton file_button;
    private JLabel file_name_label;
    private JLabel file_size_label;
    private JProgressBar jProgressBar2;
    private JButton output_button;
    private JLabel output_folder_label;
    private JButton split_button;
    private JLabel split_size_label;
    private JTextField split_size_text;
    private static final Logger LOG = Logger.getLogger(FileSplitterDialog.class.getName());

    public FileSplitterDialog(MainPanelView parent, boolean modal) {
        super((Frame)parent, modal);
        this._main_panel = parent.getMain_panel();
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, this._main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this.jProgressBar2.setMinimum(0);
            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
            this.jProgressBar2.setStringPainted(true);
            this.jProgressBar2.setValue(0);
            this.jProgressBar2.setVisible(false);
            this.split_size_text.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    try {
                        Integer.parseInt(FileSplitterDialog.this.split_size_text.getText());
                    }
                    catch (Exception e) {
                        FileSplitterDialog.this.split_size_text.setText(FileSplitterDialog.this.split_size_text.getText().substring(0, Math.max(0, FileSplitterDialog.this.split_size_text.getText().length() - 1)));
                    }
                }
            });
            this.split_size_text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pack();
        });
    }

    private boolean _splitFile(int i) throws IOException {
        this._progress = 0L;
        int mBperSplit = Integer.parseInt(this.split_size_text.getText());
        if (mBperSplit <= 0) {
            throw new IllegalArgumentException("mBperSplit must be more than zero");
        }
        long sourceSize = Files.size(Paths.get(this._files[i].getAbsolutePath(), new String[0]));
        long bytesPerSplit = 0x100000L * (long)mBperSplit;
        long numSplits = sourceSize / bytesPerSplit;
        long remainingBytes = sourceSize % bytesPerSplit;
        int position = 0;
        int conta_split = 1;
        MiscTools.GUIRunAndWait(() -> {
            this.jProgressBar2.setMinimum(0);
            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
            this.jProgressBar2.setStringPainted(true);
            this.jProgressBar2.setValue(0);
            this.file_name_label.setText(MiscTools.truncateText(this._files[i].getName(), 150));
            this.file_name_label.setToolTipText(this._files[i].getAbsolutePath());
            this.file_size_label.setText(MiscTools.formatBytes(this._files[i].length()));
            this.pack();
        });
        try (RandomAccessFile sourceFile = new RandomAccessFile(this._files[i].getAbsolutePath(), "r");
             FileChannel sourceChannel = sourceFile.getChannel();){
            while ((long)position < numSplits && !this._exit) {
                this._writePartToFile(i, bytesPerSplit, (long)position * bytesPerSplit, sourceChannel, conta_split, numSplits + (long)(remainingBytes > 0L ? 1 : 0));
                ++position;
                ++conta_split;
            }
            if (remainingBytes > 0L && !this._exit) {
                this._writePartToFile(i, remainingBytes, (long)position * bytesPerSplit, sourceChannel, conta_split, numSplits + (long)(remainingBytes > 0L ? 1 : 0));
            }
        }
        return true;
    }

    private void monitorProgress(int f, long part_size) {
        MainPanel.THREAD_POOL.execute(() -> {
            long p = 0L;
            Path file = this._current_part;
            while (!this._exit && f == this._current_file && file == this._current_part && p < part_size) {
                try {
                    if (Files.exists(this._current_part, new LinkOption[0])) {
                        p = Files.size(file);
                        long fp = this._progress + p;
                        MiscTools.GUIRunAndWait(() -> {
                            if (this.jProgressBar2.getValue() < this.jProgressBar2.getMaximum()) {
                                this.jProgressBar2.setValue((int)Math.floor(2.147483647E9 / (double)this._files[f].length() * (double)fp));
                            }
                        });
                    }
                    MiscTools.pausar(2000L);
                }
                catch (IOException ex) {
                    Logger.getLogger(FileSplitterDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void _writePartToFile(int f, long byteSize, long position, FileChannel sourceChannel, int conta_split, long num_splits) throws IOException {
        Path fileName;
        this._current_part = fileName = Paths.get(this._output_dir.getAbsolutePath() + "/" + this._files[f].getName() + ".part" + String.valueOf(conta_split) + "-" + String.valueOf(num_splits), new String[0]);
        this._current_file = f;
        this.monitorProgress(f, byteSize);
        if (!this._exit) {
            try (RandomAccessFile toFile = new RandomAccessFile(fileName.toFile(), "rw");
                 FileChannel toChannel = toFile.getChannel();){
                for (long dest_bytes_copied = Files.exists(fileName, new LinkOption[0]) ? Files.size(fileName) : 0L; dest_bytes_copied < byteSize; dest_bytes_copied += toChannel.transferFrom(sourceChannel, dest_bytes_copied, byteSize - dest_bytes_copied)) {
                    sourceChannel.position(position + dest_bytes_copied);
                }
            }
        }
        this._progress += byteSize;
    }

    private void initComponents() {
        this.file_button = new JButton();
        this.file_name_label = new JLabel();
        this.output_button = new JButton();
        this.file_size_label = new JLabel();
        this.output_folder_label = new JLabel();
        this.split_size_label = new JLabel();
        this.split_size_text = new JTextField();
        this.jProgressBar2 = new JProgressBar();
        this.split_button = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("File Splitter");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileSplitterDialog.this.formWindowClosing(evt);
            }
        });
        this.file_button.setFont(new Font("Dialog", 0, 18));
        this.file_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-file-30.png")));
        this.file_button.setText("Select file/s");
        this.file_button.setDoubleBuffered(true);
        this.file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSplitterDialog.this.file_buttonActionPerformed(evt);
            }
        });
        this.file_name_label.setFont(new Font("Dialog", 0, 18));
        this.file_name_label.setDoubleBuffered(true);
        this.output_button.setFont(new Font("Dialog", 0, 18));
        this.output_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-folder-30.png")));
        this.output_button.setText("Change output folder");
        this.output_button.setDoubleBuffered(true);
        this.output_button.setEnabled(false);
        this.output_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSplitterDialog.this.output_buttonActionPerformed(evt);
            }
        });
        this.file_size_label.setFont(new Font("Dialog", 1, 18));
        this.file_size_label.setDoubleBuffered(true);
        this.output_folder_label.setFont(new Font("Dialog", 0, 18));
        this.output_folder_label.setDoubleBuffered(true);
        this.split_size_label.setFont(new Font("Dialog", 1, 18));
        this.split_size_label.setText("Split size (MBs):");
        this.split_size_label.setDoubleBuffered(true);
        this.split_size_label.setEnabled(false);
        this.split_size_text.setFont(new Font("Dialog", 0, 18));
        this.split_size_text.setBorder(null);
        this.split_size_text.setDoubleBuffered(true);
        this.split_size_text.setEnabled(false);
        this.jProgressBar2.setFont(new Font("Dialog", 0, 18));
        this.jProgressBar2.setDoubleBuffered(true);
        this.split_button.setBackground(new Color(102, 204, 255));
        this.split_button.setFont(new Font("Dialog", 1, 24));
        this.split_button.setForeground(new Color(255, 255, 255));
        this.split_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-cut-30.png")));
        this.split_button.setText("SPLIT FILE/s");
        this.split_button.setDoubleBuffered(true);
        this.split_button.setEnabled(false);
        this.split_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSplitterDialog.this.split_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.file_button, -1, -1, Short.MAX_VALUE).addComponent(this.file_name_label, -1, -1, Short.MAX_VALUE).addComponent(this.output_button, -1, 576, Short.MAX_VALUE).addComponent(this.file_size_label, -1, -1, Short.MAX_VALUE).addComponent(this.output_folder_label, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBar2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.split_size_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.split_size_text)).addComponent(this.split_button, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.file_button).addGap(9, 9, 9).addComponent(this.file_name_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.file_size_label).addGap(18, 18, 18).addComponent(this.output_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.output_folder_label).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.split_size_label).addComponent(this.split_size_text, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jProgressBar2, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.split_button).addContainerGap()));
        this.pack();
    }

    private void file_buttonActionPerformed(ActionEvent evt) {
        this.file_button.setText(LabelTranslatorSingleton.getInstance().translate("Opening file..."));
        this.file_button.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        filechooser.setMultiSelectionEnabled(true);
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.25));
        filechooser.setDialogTitle("Select file/s");
        filechooser.setAcceptAllFileFilterUsed(false);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            this._files = filechooser.getSelectedFiles();
            this.file_name_label.setText(MiscTools.truncateText(this._files[0].getName(), 150));
            this.file_name_label.setToolTipText(this._files[0].getAbsolutePath());
            this.file_size_label.setText(MiscTools.formatBytes(this._files[0].length()));
            this.output_folder_label.setText(MiscTools.truncateText(this._files[0].getParentFile().getAbsolutePath(), 150));
            this.output_folder_label.setToolTipText(this._files[0].getParentFile().getAbsolutePath());
            this._output_dir = new File(this._files[0].getParentFile().getAbsolutePath());
            this.jProgressBar2.setMinimum(0);
            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
            this.jProgressBar2.setStringPainted(true);
            this.jProgressBar2.setValue(0);
            this.output_button.setEnabled(true);
            this.split_size_label.setEnabled(true);
            this.split_size_text.setEnabled(true);
            this.split_button.setEnabled(true);
        }
        this.file_button.setText(LabelTranslatorSingleton.getInstance().translate("Select file/s"));
        this.file_button.setEnabled(true);
        this.pack();
    }

    private void output_buttonActionPerformed(ActionEvent evt) {
        this.output_button.setText(LabelTranslatorSingleton.getInstance().translate("Changing output folder..."));
        this.file_button.setEnabled(false);
        this.output_button.setEnabled(false);
        this.split_button.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.25));
        filechooser.setDialogTitle("Add directory");
        filechooser.setFileSelectionMode(1);
        filechooser.setAcceptAllFileFilterUsed(false);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            this._output_dir = filechooser.getSelectedFile();
            this.output_folder_label.setText(MiscTools.truncateText(this._output_dir.getAbsolutePath(), 100));
            this.output_folder_label.setToolTipText(this._output_dir.getAbsolutePath());
        }
        this.output_button.setText(LabelTranslatorSingleton.getInstance().translate("Change output folder"));
        this.file_button.setEnabled(true);
        this.output_button.setEnabled(true);
        this.split_button.setEnabled(true);
        this.pack();
    }

    private void split_buttonActionPerformed(ActionEvent evt) {
        if (this._output_dir != null && !"".equals(this.split_size_text.getText())) {
            this.split_button.setText(LabelTranslatorSingleton.getInstance().translate("SPLITTING FILE..."));
            this.file_button.setEnabled(false);
            this.output_button.setEnabled(false);
            this.split_button.setEnabled(false);
            this.split_size_text.setEnabled(false);
            this.jProgressBar2.setVisible(true);
            this.pack();
            FileSplitterDialog tthis = this;
            MainPanel.THREAD_POOL.execute(() -> {
                try {
                    for (int i = 0; i < this._files.length && !this._exit; ++i) {
                        if (this._splitFile(i)) {
                            if (i != this._files.length - 1 || this._exit) continue;
                            MiscTools.GUIRun(() -> {
                                JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("File/s successfully splitted!"));
                                if (Desktop.isDesktopSupported()) {
                                    try {
                                        Desktop.getDesktop().open(this._output_dir);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(FileSplitterDialog.class.getName()).log(Level.SEVERE, ex.getMessage());
                                    }
                                }
                                this._exit = true;
                                this.dispose();
                            });
                            continue;
                        }
                        this._files = null;
                        this._output_dir = null;
                        MiscTools.GUIRun(() -> {
                            this.file_name_label.setText("");
                            this.output_folder_label.setText("");
                            this.split_size_text.setText("");
                            this.file_size_label.setText("");
                            this.jProgressBar2.setMinimum(0);
                            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
                            this.jProgressBar2.setStringPainted(true);
                            this.jProgressBar2.setValue(0);
                            this.jProgressBar2.setVisible(false);
                            this.split_button.setText(LabelTranslatorSingleton.getInstance().translate("SPLIT FILE"));
                            this.file_button.setEnabled(true);
                            this.output_button.setEnabled(true);
                            this.split_button.setEnabled(true);
                            this.split_size_text.setEnabled(true);
                            this.pack();
                        });
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FileSplitterDialog.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            });
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
        int n = 1;
        if (!this.file_button.isEnabled()) {
            n = JOptionPane.showOptionDialog(this, LabelTranslatorSingleton.getInstance().translate("SURE?"), LabelTranslatorSingleton.getInstance().translate("EXIT"), 1, 2, null, options, options[0]);
        }
        if (n == 1) {
            this._exit = true;
            this._main_panel.getView().getSplit_file_menu().setEnabled(this.file_button.isEnabled());
            this.dispose();
        }
    }
}

