/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.FileSplitterDialog;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class FileMergerDialog
extends JDialog {
    private final MainPanel _main_panel;
    private File _output_dir = null;
    private volatile long _progress = 0L;
    private final ArrayList<String> _file_parts = new ArrayList();
    private String _file_name = null;
    private long _file_size = 0L;
    private volatile boolean _exit = false;
    private volatile String _file_name_full;
    private JCheckBox delete_parts_checkbox;
    private JButton file_button;
    private JLabel file_name_label;
    private JLabel file_size_label;
    private JProgressBar jProgressBar2;
    private JButton merge_button;
    private JButton output_button;
    private JLabel output_folder_label;
    private static final Logger LOG = Logger.getLogger(FileMergerDialog.class.getName());

    public FileMergerDialog(MainPanelView parent, boolean modal) {
        super((Frame)parent, modal);
        this._main_panel = parent.getMain_panel();
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, this._main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this.jProgressBar2.setMinimum(0);
            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
            this.jProgressBar2.setStringPainted(true);
            this.jProgressBar2.setValue(0);
            this.jProgressBar2.setVisible(false);
            this.pack();
        });
    }

    private void monitorProgress(Path file) {
        MainPanel.THREAD_POOL.execute(() -> {
            long p = 0L;
            while (!this._exit && p < this._file_size) {
                try {
                    if (Files.exists(file, new LinkOption[0])) {
                        long fp = p = Files.size(file);
                        MiscTools.GUIRunAndWait(() -> {
                            if (this.jProgressBar2.getValue() < this.jProgressBar2.getMaximum()) {
                                this.jProgressBar2.setValue((int)Math.floor(2.147483647E9 / (double)this._file_size * (double)fp));
                            }
                        });
                    }
                    MiscTools.pausar(2000L);
                }
                catch (IOException ex) {
                    Logger.getLogger(FileSplitterDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private boolean _mergeFile() throws IOException {
        try (RandomAccessFile targetFile = new RandomAccessFile(this._file_name_full, "rw");){
            FileChannel targetChannel = targetFile.getChannel();
            this.monitorProgress(Paths.get(this._file_name, new String[0]));
            for (String file_path : this._file_parts) {
                if (this._exit) {
                    break;
                }
                RandomAccessFile rfile = new RandomAccessFile(file_path, "r");
                targetChannel.transferFrom(rfile.getChannel(), this._progress, rfile.length());
                this._progress += rfile.length();
                MiscTools.GUIRun(() -> this.jProgressBar2.setValue((int)Math.floor(2.147483647E9 / (double)this._file_size * (double)this._progress)));
            }
        }
        if (Files.exists(Paths.get(this._file_name_full + ".sha1", new String[0]), new LinkOption[0])) {
            String sha1 = Files.readString(Paths.get(this._file_name_full + ".sha1", new String[0])).toLowerCase().trim();
            MiscTools.GUIRunAndWait(() -> this.merge_button.setText(LabelTranslatorSingleton.getInstance().translate("CHECKING FILE INTEGRITY, please wait...")));
            if (sha1.equals(MiscTools.computeFileSHA1(new File(this._file_name_full)))) {
                JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate("FILE INTEGRITY IS OK"));
                return true;
            }
            JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate("FILE INTEGRITY CHECK FAILED"), "ERROR", 0);
            return false;
        }
        return true;
    }

    private void _deleteParts() {
        try {
            this._file_parts.stream().map(file_path -> new File((String)file_path)).forEachOrdered(file -> file.delete());
            Files.deleteIfExists(Paths.get(this._file_name_full + ".sha1", new String[0]));
        }
        catch (IOException ex) {
            Logger.getLogger(FileMergerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.file_button = new JButton();
        this.file_name_label = new JLabel();
        this.output_button = new JButton();
        this.file_size_label = new JLabel();
        this.output_folder_label = new JLabel();
        this.jProgressBar2 = new JProgressBar();
        this.merge_button = new JButton();
        this.delete_parts_checkbox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("File Merger");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileMergerDialog.this.formWindowClosing(evt);
            }
        });
        this.file_button.setFont(new Font("Dialog", 0, 18));
        this.file_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-file-30.png")));
        this.file_button.setText("Select (any) file part");
        this.file_button.setDoubleBuffered(true);
        this.file_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileMergerDialog.this.file_buttonActionPerformed(evt);
            }
        });
        this.file_name_label.setFont(new Font("Dialog", 0, 18));
        this.file_name_label.setDoubleBuffered(true);
        this.output_button.setFont(new Font("Dialog", 0, 18));
        this.output_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-folder-30.png")));
        this.output_button.setText("Change output folder");
        this.output_button.setDoubleBuffered(true);
        this.output_button.setEnabled(false);
        this.output_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileMergerDialog.this.output_buttonActionPerformed(evt);
            }
        });
        this.file_size_label.setFont(new Font("Dialog", 1, 18));
        this.file_size_label.setDoubleBuffered(true);
        this.output_folder_label.setFont(new Font("Dialog", 0, 18));
        this.output_folder_label.setDoubleBuffered(true);
        this.jProgressBar2.setFont(new Font("Dialog", 0, 18));
        this.jProgressBar2.setDoubleBuffered(true);
        this.merge_button.setBackground(new Color(102, 204, 255));
        this.merge_button.setFont(new Font("Dialog", 1, 24));
        this.merge_button.setForeground(new Color(255, 255, 255));
        this.merge_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-glue-30.png")));
        this.merge_button.setText("MERGE FILE");
        this.merge_button.setDoubleBuffered(true);
        this.merge_button.setEnabled(false);
        this.merge_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileMergerDialog.this.merge_buttonActionPerformed(evt);
            }
        });
        this.delete_parts_checkbox.setFont(new Font("Dialog", 0, 14));
        this.delete_parts_checkbox.setSelected(true);
        this.delete_parts_checkbox.setText("Delete parts after merge");
        this.delete_parts_checkbox.setDoubleBuffered(true);
        this.delete_parts_checkbox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.delete_parts_checkbox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.file_button, -1, -1, Short.MAX_VALUE).addComponent(this.file_name_label, -1, -1, Short.MAX_VALUE).addComponent(this.output_button, -1, 576, Short.MAX_VALUE).addComponent(this.file_size_label, -1, -1, Short.MAX_VALUE).addComponent(this.output_folder_label, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBar2, -1, -1, Short.MAX_VALUE).addComponent(this.merge_button, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.file_button).addGap(9, 9, 9).addComponent(this.file_name_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.file_size_label).addGap(18, 18, 18).addComponent(this.output_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.output_folder_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar2, -2, 36, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.delete_parts_checkbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.merge_button).addContainerGap()));
        this.pack();
    }

    private void file_buttonActionPerformed(ActionEvent evt) {
        this.file_button.setText(LabelTranslatorSingleton.getInstance().translate("Selecting file..."));
        this.file_button.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.25));
        filechooser.setDialogTitle("Select any part of the original file");
        filechooser.setAcceptAllFileFilterUsed(false);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            this._file_name = MiscTools.findFirstRegex("^(.+)\\.part[0-9]+\\-[0-9]+$", filechooser.getSelectedFile().getName(), 1);
            this._file_name_full = MiscTools.findFirstRegex("^(.+)\\.part[0-9]+\\-[0-9]+$", filechooser.getSelectedFile().getAbsolutePath(), 1);
            if (this._file_name != null) {
                this.file_name_label.setText(MiscTools.truncateText(this._file_name, 150));
                this.file_name_label.setToolTipText(filechooser.getSelectedFile().getParentFile().getAbsolutePath() + "/" + this._file_name);
                this.output_folder_label.setText(MiscTools.truncateText(filechooser.getSelectedFile().getParentFile().getAbsolutePath(), 150));
                this.output_folder_label.setToolTipText(filechooser.getSelectedFile().getParentFile().getAbsolutePath());
                this._output_dir = new File(filechooser.getSelectedFile().getParentFile().getAbsolutePath());
                File directory = filechooser.getSelectedFile().getParentFile();
                File[] fList = directory.listFiles();
                this._file_size = 0L;
                for (File file : fList) {
                    if (!file.isFile() || !file.canRead() || !file.getName().startsWith(this._file_name + ".part")) continue;
                    this._file_parts.add(file.getAbsolutePath());
                    this._file_size += file.length();
                }
                Collections.sort(this._file_parts);
                this.file_size_label.setText(MiscTools.formatBytes(this._file_size));
                this.output_button.setEnabled(true);
                this.delete_parts_checkbox.setEnabled(true);
                this.merge_button.setEnabled(true);
            }
        }
        this.file_button.setText(LabelTranslatorSingleton.getInstance().translate("Select (any) file part"));
        this.file_button.setEnabled(true);
        this.pack();
    }

    private void output_buttonActionPerformed(ActionEvent evt) {
        this.output_button.setText(LabelTranslatorSingleton.getInstance().translate("Changing output folder..."));
        this.file_button.setEnabled(false);
        this.output_button.setEnabled(false);
        this.merge_button.setEnabled(false);
        this.delete_parts_checkbox.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.25));
        filechooser.setDialogTitle("Add directory");
        filechooser.setFileSelectionMode(1);
        filechooser.setAcceptAllFileFilterUsed(false);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            this._output_dir = filechooser.getSelectedFile();
            this.output_folder_label.setText(MiscTools.truncateText(this._output_dir.getAbsolutePath(), 100));
            this.output_folder_label.setToolTipText(this._output_dir.getAbsolutePath());
        }
        this.output_button.setText(LabelTranslatorSingleton.getInstance().translate("Change output folder"));
        this.file_button.setEnabled(true);
        this.output_button.setEnabled(true);
        this.merge_button.setEnabled(true);
        this.delete_parts_checkbox.setEnabled(true);
        this.pack();
    }

    private void merge_buttonActionPerformed(ActionEvent evt) {
        if (this._output_dir != null) {
            this.setDefaultCloseOperation(0);
            this.merge_button.setText(LabelTranslatorSingleton.getInstance().translate("MERGING FILE..."));
            this.file_button.setEnabled(false);
            this.output_button.setEnabled(false);
            this.merge_button.setEnabled(false);
            this.delete_parts_checkbox.setEnabled(false);
            this.jProgressBar2.setVisible(true);
            this.pack();
            FileMergerDialog tthis = this;
            MainPanel.THREAD_POOL.execute(() -> {
                try {
                    if (this._mergeFile()) {
                        if (this.delete_parts_checkbox.isSelected()) {
                            this._deleteParts();
                        }
                        if (!this._exit) {
                            MiscTools.GUIRun(() -> {
                                this.jProgressBar2.setValue(this.jProgressBar2.getMaximum());
                                JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("File successfully merged!"));
                                if (Desktop.isDesktopSupported()) {
                                    try {
                                        Desktop.getDesktop().open(this._output_dir);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(FileMergerDialog.class.getName()).log(Level.SEVERE, ex.getMessage());
                                    }
                                }
                                this._exit = true;
                                this.dispose();
                            });
                        }
                    } else {
                        this._file_parts.clear();
                        MiscTools.GUIRun(() -> {
                            this.file_name_label.setText("");
                            this.file_size_label.setText("");
                            this.output_folder_label.setText("");
                            this._output_dir = null;
                            this._file_name = null;
                            this._file_size = 0L;
                            this._progress = 0L;
                            this.jProgressBar2.setMinimum(0);
                            this.jProgressBar2.setMaximum(Integer.MAX_VALUE);
                            this.jProgressBar2.setStringPainted(true);
                            this.jProgressBar2.setValue(0);
                            this.jProgressBar2.setVisible(false);
                            this.merge_button.setText(LabelTranslatorSingleton.getInstance().translate("MERGE FILE"));
                            this.file_button.setEnabled(true);
                            this.output_button.setEnabled(true);
                            this.merge_button.setEnabled(true);
                            this.delete_parts_checkbox.setEnabled(true);
                            this.setDefaultCloseOperation(2);
                            this.pack();
                        });
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FileMergerDialog.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            });
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        Object[] options = new Object[]{"No", LabelTranslatorSingleton.getInstance().translate("Yes")};
        int n = 1;
        if (!this.file_button.isEnabled()) {
            n = JOptionPane.showOptionDialog(this, LabelTranslatorSingleton.getInstance().translate("SURE?"), LabelTranslatorSingleton.getInstance().translate("EXIT"), 1, 2, null, options, options[0]);
        }
        if (n == 1) {
            this._exit = true;
            this._main_panel.getView().getMerge_file_menu().setEnabled(this.file_button.isEnabled());
            this.dispose();
        }
    }
}

