/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ContextMenuMouseListener;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FileGrabberDialog
extends JDialog {
    private boolean _upload;
    private final ArrayList<File> _files;
    private String _base_path;
    private long _total_space;
    private final MainPanel _main_panel;
    private final boolean _remember_master_pass;
    private boolean _inserting_mega_accounts;
    private boolean _quota_ok;
    private int _last_selected_index;
    private List<File> _drag_drop_files;
    private JComboBox<String> account_combobox;
    private JLabel account_label;
    private JButton add_files_button;
    private JButton add_folder_button;
    private JButton copy_email_button;
    private JButton dance_button;
    private JLabel dir_name_label;
    private JTextField dir_name_textfield;
    private JTree file_tree;
    private JScrollPane file_tree_scrollpane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox priority_checkbox;
    private JButton skip_button;
    private JButton skip_rest_button;
    private JLabel total_file_size_label;
    private JCheckBox upload_log_checkbox;
    private JLabel used_space_label;
    private JLabel warning_label;
    private static final Logger LOG = Logger.getLogger(FileGrabberDialog.class.getName());

    @Override
    public void dispose() {
        this.file_tree.setModel(null);
        super.dispose();
    }

    public JCheckBox getPriority_checkbox() {
        return this.priority_checkbox;
    }

    public JCheckBox getUpload_log_checkbox() {
        return this.upload_log_checkbox;
    }

    public boolean isUpload() {
        return this._upload;
    }

    public ArrayList<File> getFiles() {
        return this._files;
    }

    public String getBase_path() {
        return this._base_path;
    }

    public JComboBox<String> getAccount_combobox() {
        return this.account_combobox;
    }

    public JTextField getDir_name_textfield() {
        return this.dir_name_textfield;
    }

    public boolean isRemember_master_pass() {
        return this._remember_master_pass;
    }

    public FileGrabberDialog(final MainPanelView parent, boolean modal, List<File> files) {
        super((Frame)parent, modal);
        this._main_panel = parent.getMain_panel();
        this._drag_drop_files = files;
        this._quota_ok = false;
        this._total_space = 0L;
        this._base_path = null;
        this._upload = false;
        this._inserting_mega_accounts = false;
        this._remember_master_pass = true;
        this._files = new ArrayList();
        this._last_selected_index = -1;
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            String upload_log_string = DBTools.selectSettingValue("upload_log");
            this.upload_log_checkbox.setSelected("yes".equals(upload_log_string));
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, this._main_panel.getZoom_factor());
            MiscTools.translateLabels(this);
            this.jPanel1.setDropTarget(new DropTarget(){

                public boolean canImport(DataFlavor[] flavors) {
                    for (DataFlavor flavor : flavors) {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public synchronized void drop(DropTargetDropEvent dtde) {
                    this.changeToNormal();
                    dtde.acceptDrop(3);
                    try {
                        if (this.canImport(dtde.getTransferable().getTransferDataFlavors())) {
                            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                            MainPanel.THREAD_POOL.execute(() -> FileGrabberDialog.this._file_drop_notify(files));
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(parent, LabelTranslatorSingleton.getInstance().translate("ERROR DOING DRAG AND DROP WITH THIS FILE (use button method)"), "Error", 0);
                    }
                }

                @Override
                public synchronized void dragEnter(DropTargetDragEvent dtde) {
                    this.changeToDrop();
                }

                @Override
                public synchronized void dragExit(DropTargetEvent dtde) {
                    this.changeToNormal();
                }

                private void changeToDrop() {
                    FileGrabberDialog.this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.green, 5));
                }

                private void changeToNormal() {
                    FileGrabberDialog.this.jPanel1.setBorder(null);
                }
            });
            this.dir_name_textfield.addMouseListener(new ContextMenuMouseListener());
            this.pack();
        });
        MainPanel.THREAD_POOL.execute(() -> {
            if (this._drag_drop_files != null) {
                this._file_drop_notify(this._drag_drop_files);
            }
            if (this._main_panel.getMega_accounts().size() > 0) {
                ArrayList cuentas = new ArrayList();
                this._main_panel.getMega_accounts().keySet().forEach(o -> cuentas.add(o));
                Collections.sort(cuentas);
                MiscTools.GUIRunAndWait(() -> {
                    if (!this._main_panel.getMega_active_accounts().isEmpty()) {
                        this._inserting_mega_accounts = true;
                        cuentas.forEach(o -> this.account_combobox.addItem((String)o));
                        this._inserting_mega_accounts = false;
                        Iterator<String> iterator = this._main_panel.getMega_active_accounts().keySet().iterator();
                        if (iterator.hasNext()) {
                            String o2 = iterator.next();
                            this.account_combobox.setSelectedItem(o2);
                            this.account_comboboxItemStateChanged(null);
                        }
                    } else {
                        cuentas.forEach(o -> this.account_combobox.addItem((String)o));
                    }
                    this.pack();
                });
            } else {
                MiscTools.GUIRunAndWait(() -> {
                    this.used_space_label.setForeground(Color.red);
                    this.used_space_label.setEnabled(true);
                    this.used_space_label.setText(LabelTranslatorSingleton.getInstance().translate("No MEGA accounts available (Go to Settings > Accounts)"));
                });
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.file_tree_scrollpane = new JScrollPane();
        this.file_tree = new JTree();
        this.jPanel2 = new JPanel();
        this.dir_name_label = new JLabel();
        this.dir_name_textfield = new JTextField();
        this.account_label = new JLabel();
        this.account_combobox = new JComboBox();
        this.used_space_label = new JLabel();
        this.add_folder_button = new JButton();
        this.add_files_button = new JButton();
        this.upload_log_checkbox = new JCheckBox();
        this.priority_checkbox = new JCheckBox();
        this.copy_email_button = new JButton();
        this.dance_button = new JButton();
        this.total_file_size_label = new JLabel();
        this.warning_label = new JLabel();
        this.skip_rest_button = new JButton();
        this.skip_button = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Grabber");
        this.file_tree.setBorder(null);
        this.file_tree.setFont(new Font("Dialog", 0, 18));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.file_tree.setModel(new DefaultTreeModel(treeNode1));
        this.file_tree.setDoubleBuffered(true);
        this.file_tree.setEnabled(false);
        this.file_tree.setRootVisible(false);
        this.file_tree_scrollpane.setViewportView(this.file_tree);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.file_tree_scrollpane));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.file_tree_scrollpane, -1, 236, Short.MAX_VALUE));
        this.dir_name_label.setFont(new Font("Dialog", 1, 18));
        this.dir_name_label.setText("Upload name:");
        this.dir_name_label.setDoubleBuffered(true);
        this.dir_name_label.setEnabled(false);
        this.dir_name_textfield.setFont(new Font("Dialog", 0, 18));
        this.dir_name_textfield.setDoubleBuffered(true);
        this.dir_name_textfield.setEnabled(false);
        this.dir_name_textfield.setMargin(new Insets(2, 2, 2, 2));
        this.account_label.setFont(new Font("Dialog", 1, 18));
        this.account_label.setText("Account:");
        this.account_label.setDoubleBuffered(true);
        this.account_label.setEnabled(false);
        this.account_combobox.setFont(new Font("Dialog", 0, 18));
        this.account_combobox.setDoubleBuffered(true);
        this.account_combobox.setEnabled(false);
        this.account_combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FileGrabberDialog.this.account_comboboxItemStateChanged(evt);
            }
        });
        this.used_space_label.setFont(new Font("Dialog", 1, 18));
        this.used_space_label.setText("Used space: 0.00GB");
        this.used_space_label.setDoubleBuffered(true);
        this.used_space_label.setEnabled(false);
        this.add_folder_button.setFont(new Font("Dialog", 1, 18));
        this.add_folder_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-folder-30.png")));
        this.add_folder_button.setText("Add folder");
        this.add_folder_button.setDoubleBuffered(true);
        this.add_folder_button.setEnabled(false);
        this.add_folder_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.add_folder_buttonActionPerformed(evt);
            }
        });
        this.add_files_button.setFont(new Font("Dialog", 1, 18));
        this.add_files_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-add-file-30.png")));
        this.add_files_button.setText("Add files");
        this.add_files_button.setDoubleBuffered(true);
        this.add_files_button.setEnabled(false);
        this.add_files_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.add_files_buttonActionPerformed(evt);
            }
        });
        this.upload_log_checkbox.setFont(new Font("Dialog", 1, 16));
        this.upload_log_checkbox.setText("Enable log file");
        this.upload_log_checkbox.setDoubleBuffered(true);
        this.upload_log_checkbox.setEnabled(false);
        this.priority_checkbox.setFont(new Font("Dialog", 1, 16));
        this.priority_checkbox.setText("Put on TOP of waiting queue");
        this.priority_checkbox.setDoubleBuffered(true);
        this.priority_checkbox.setEnabled(false);
        this.copy_email_button.setFont(new Font("Dialog", 1, 18));
        this.copy_email_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.copy_email_button.setText("Copy email");
        this.copy_email_button.setEnabled(false);
        this.copy_email_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.copy_email_buttonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.upload_log_checkbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.priority_checkbox)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dir_name_label).addComponent(this.account_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.add_files_button, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.add_folder_button, -1, -1, Short.MAX_VALUE)).addComponent(this.dir_name_textfield).addComponent(this.used_space_label, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.account_combobox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copy_email_button))))).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dir_name_label).addComponent(this.dir_name_textfield, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.account_label).addComponent(this.account_combobox).addComponent(this.copy_email_button, -2, 38, -2)).addGap(18, 18, 18).addComponent(this.used_space_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.add_files_button).addComponent(this.add_folder_button)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upload_log_checkbox).addComponent(this.priority_checkbox)).addContainerGap()));
        this.dance_button.setBackground(new Color(102, 204, 255));
        this.dance_button.setFont(new Font("Dialog", 1, 22));
        this.dance_button.setForeground(new Color(255, 255, 255));
        this.dance_button.setText("Let's dance, baby");
        this.dance_button.setDoubleBuffered(true);
        this.dance_button.setEnabled(false);
        this.dance_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.dance_buttonActionPerformed(evt);
            }
        });
        this.total_file_size_label.setFont(new Font("Dialog", 1, 32));
        this.total_file_size_label.setForeground(new Color(0, 0, 255));
        this.total_file_size_label.setText("[---]");
        this.total_file_size_label.setDoubleBuffered(true);
        this.total_file_size_label.setEnabled(false);
        this.warning_label.setFont(new Font("Dialog", 0, 16));
        this.warning_label.setText("If you DO NOT want to transfer some folder or file you can REMOVE it (to select several items at the same time use CTRL + LMOUSE).");
        this.warning_label.setDoubleBuffered(true);
        this.warning_label.setEnabled(false);
        this.skip_rest_button.setFont(new Font("Dialog", 1, 18));
        this.skip_rest_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.skip_rest_button.setText("REMOVE ALL EXCEPT THIS");
        this.skip_rest_button.setDoubleBuffered(true);
        this.skip_rest_button.setEnabled(false);
        this.skip_rest_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.skip_rest_buttonActionPerformed(evt);
            }
        });
        this.skip_button.setFont(new Font("Dialog", 1, 18));
        this.skip_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-trash-can-30.png")));
        this.skip_button.setText("REMOVE THIS");
        this.skip_button.setDoubleBuffered(true);
        this.skip_button.setEnabled(false);
        this.skip_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileGrabberDialog.this.skip_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.warning_label).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.total_file_size_label, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.skip_rest_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.skip_button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dance_button))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.total_file_size_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warning_label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dance_button).addComponent(this.skip_rest_button).addComponent(this.skip_button)).addContainerGap()));
        this.pack();
    }

    private void add_files_buttonActionPerformed(ActionEvent evt) {
        this.add_files_button.setText(LabelTranslatorSingleton.getInstance().translate("Adding files, please wait..."));
        this.add_files_button.setEnabled(false);
        this.add_folder_button.setEnabled(false);
        this.warning_label.setEnabled(false);
        this.skip_button.setEnabled(false);
        this.skip_rest_button.setEnabled(false);
        this.dance_button.setEnabled(false);
        this.dir_name_textfield.setEnabled(false);
        this.dir_name_label.setEnabled(false);
        this.upload_log_checkbox.setEnabled(false);
        this.priority_checkbox.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.25));
        filechooser.setDialogTitle("Add files");
        filechooser.setAcceptAllFileFilterUsed(false);
        filechooser.setMultiSelectionEnabled(true);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            this.total_file_size_label.setText("[0 B]");
            File[] files_selected = filechooser.getSelectedFiles();
            this._base_path = files_selected[0].getParentFile().getAbsolutePath();
            this.dir_name_textfield.setText(files_selected[0].getParentFile().getName());
            this.dir_name_textfield.setEnabled(true);
            this.dir_name_label.setEnabled(true);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(filechooser.getSelectedFile().getParent());
            for (File file : files_selected) {
                DefaultMutableTreeNode current_file = new DefaultMutableTreeNode(file.getName() + (file.isFile() ? " [" + MiscTools.formatBytes(file.length()) + "]" : ""));
                root.add(current_file);
            }
            DefaultTreeModel tree_model = new DefaultTreeModel(MiscTools.sortTree(root));
            this.file_tree.setModel(tree_model);
            MainPanel.THREAD_POOL.execute(() -> {
                this._genFileList();
                MiscTools.GUIRun(() -> {
                    this.add_files_button.setEnabled(true);
                    this.add_folder_button.setEnabled(true);
                    this.add_files_button.setText(LabelTranslatorSingleton.getInstance().translate("Add files"));
                    boolean root_childs = ((TreeNode)tree_model.getRoot()).getChildCount() > 0;
                    this.file_tree.setRootVisible(root_childs);
                    this.file_tree.setEnabled(root_childs);
                    this.warning_label.setEnabled(root_childs);
                    this.dance_button.setEnabled(root_childs);
                    this.total_file_size_label.setEnabled(root_childs);
                    this.skip_button.setEnabled(root_childs);
                    this.skip_rest_button.setEnabled(root_childs);
                    this.upload_log_checkbox.setEnabled(root_childs);
                    this.priority_checkbox.setEnabled(root_childs);
                });
            });
        } else {
            if (filechooser.getSelectedFile() != null && !filechooser.getSelectedFile().canRead()) {
                JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate("File is not readable!"), "Error", 0);
            }
            boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
            this.add_files_button.setText(LabelTranslatorSingleton.getInstance().translate("Add files"));
            this.add_files_button.setEnabled(true);
            this.add_folder_button.setEnabled(true);
            this.file_tree.setRootVisible(root_childs);
            this.file_tree.setEnabled(root_childs);
            this.warning_label.setEnabled(root_childs);
            this.dance_button.setEnabled(root_childs);
            this.total_file_size_label.setEnabled(root_childs);
            this.skip_button.setEnabled(root_childs);
            this.skip_rest_button.setEnabled(root_childs);
            this.dir_name_textfield.setEnabled(root_childs);
            this.dir_name_label.setEnabled(root_childs);
            this.upload_log_checkbox.setEnabled(root_childs);
            this.priority_checkbox.setEnabled(root_childs);
        }
    }

    private void add_folder_buttonActionPerformed(ActionEvent evt) {
        this.add_folder_button.setText(LabelTranslatorSingleton.getInstance().translate("Adding folder, please wait..."));
        this.add_files_button.setEnabled(false);
        this.add_folder_button.setEnabled(false);
        this.warning_label.setEnabled(false);
        this.skip_button.setEnabled(false);
        this.skip_rest_button.setEnabled(false);
        this.dance_button.setEnabled(false);
        this.dir_name_textfield.setEnabled(false);
        this.dir_name_label.setEnabled(false);
        this.upload_log_checkbox.setEnabled(false);
        this.priority_checkbox.setEnabled(false);
        JFileChooser filechooser = new JFileChooser();
        MiscTools.updateFonts(filechooser, MainPanel.GUI_FONT, (float)((double)this._main_panel.getZoom_factor() * 1.2));
        filechooser.setDialogTitle("Add directory");
        filechooser.setFileSelectionMode(1);
        filechooser.setAcceptAllFileFilterUsed(false);
        if (filechooser.showOpenDialog(this) == 0 && filechooser.getSelectedFile().canRead()) {
            MainPanel.THREAD_POOL.execute(() -> {
                MiscTools.GUIRunAndWait(() -> {
                    this.total_file_size_label.setText("[0 B]");
                    this._base_path = filechooser.getSelectedFile().getAbsolutePath();
                    this.dir_name_textfield.setText(filechooser.getSelectedFile().getName());
                    this.dir_name_textfield.setEnabled(true);
                    this.dir_name_label.setEnabled(true);
                });
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(filechooser.getSelectedFile().getAbsolutePath());
                this._genFileTree(filechooser.getSelectedFile().getAbsolutePath(), root, null);
                DefaultTreeModel tree_model = new DefaultTreeModel(MiscTools.sortTree(root));
                MiscTools.GUIRunAndWait(() -> this.file_tree.setModel(tree_model));
                this._genFileList();
                MiscTools.GUIRunAndWait(() -> {
                    this.add_files_button.setEnabled(true);
                    this.add_folder_button.setEnabled(true);
                    this.add_folder_button.setText(LabelTranslatorSingleton.getInstance().translate("Add folder"));
                    boolean root_childs = ((TreeNode)tree_model.getRoot()).getChildCount() > 0;
                    this.file_tree.setRootVisible(root_childs);
                    this.file_tree.setEnabled(root_childs);
                    this.warning_label.setEnabled(root_childs);
                    this.dance_button.setEnabled(root_childs);
                    this.total_file_size_label.setEnabled(root_childs);
                    this.skip_button.setEnabled(root_childs);
                    this.skip_rest_button.setEnabled(root_childs);
                    this.upload_log_checkbox.setEnabled(root_childs);
                    this.priority_checkbox.setEnabled(root_childs);
                });
            });
        } else {
            if (filechooser.getSelectedFile() != null && !filechooser.getSelectedFile().canRead()) {
                JOptionPane.showMessageDialog(this, LabelTranslatorSingleton.getInstance().translate("Folder is not readable!"), "Error", 0);
            }
            boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
            this.add_folder_button.setText(LabelTranslatorSingleton.getInstance().translate("Add folder"));
            this.add_files_button.setEnabled(true);
            this.add_folder_button.setEnabled(true);
            this.file_tree.setRootVisible(root_childs);
            this.file_tree.setEnabled(root_childs);
            this.warning_label.setEnabled(root_childs);
            this.dance_button.setEnabled(root_childs);
            this.total_file_size_label.setEnabled(root_childs);
            this.skip_button.setEnabled(root_childs);
            this.skip_rest_button.setEnabled(root_childs);
            this.dir_name_textfield.setEnabled(root_childs);
            this.dir_name_label.setEnabled(root_childs);
            this.upload_log_checkbox.setEnabled(root_childs);
            this.priority_checkbox.setEnabled(root_childs);
        }
    }

    private void dance_buttonActionPerformed(ActionEvent evt) {
        this._upload = true;
        this.setVisible(false);
    }

    private void account_comboboxItemStateChanged(ItemEvent evt) {
        String selected_item = (String)this.account_combobox.getSelectedItem();
        if (!this._inserting_mega_accounts && selected_item != null && this.account_combobox.getSelectedIndex() != this._last_selected_index) {
            this._last_selected_index = this.account_combobox.getSelectedIndex();
            String email = selected_item;
            FileGrabberDialog tthis = this;
            this.used_space_label.setForeground(new Color(102, 102, 102));
            this.used_space_label.setText(LabelTranslatorSingleton.getInstance().translate("Checking account quota, please wait..."));
            this.account_combobox.setEnabled(false);
            this.copy_email_button.setEnabled(false);
            this.account_label.setEnabled(false);
            this.dance_button.setEnabled(false);
            this.add_files_button.setEnabled(false);
            this.add_folder_button.setEnabled(false);
            this.dir_name_textfield.setEnabled(false);
            this.dir_name_label.setEnabled(false);
            this.total_file_size_label.setEnabled(false);
            this.skip_button.setEnabled(false);
            this.skip_rest_button.setEnabled(false);
            this.warning_label.setEnabled(false);
            this.file_tree.setEnabled(false);
            MainPanel.THREAD_POOL.execute(() -> {
                MegaAPI ma = null;
                try {
                    this._quota_ok = false;
                    ma = MiscTools.checkMegaAccountLoginAndShowMasterPassDialog(this._main_panel, tthis, email);
                    Long[] quota = ma.getQuota();
                    if (this.isDisplayable()) {
                        if (quota != null) {
                            Color used_space_color = quota[0] <= Math.round((double)quota[1].longValue() / 2.0) ? new Color(0, 170, 0) : (quota[0] < quota[1] ? new Color(230, 115, 0) : Color.red);
                            String quota_m = LabelTranslatorSingleton.getInstance().translate("Quota used: ") + MiscTools.formatBytes(quota[0]) + "/" + MiscTools.formatBytes(quota[1]);
                            this._quota_ok = true;
                            MiscTools.GUIRun(() -> {
                                boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
                                this.used_space_label.setText(quota_m);
                                this.used_space_label.setForeground(used_space_color);
                                for (JComponent c : new JComponent[]{this.copy_email_button, this.used_space_label, this.add_files_button, this.add_folder_button, this.account_combobox, this.account_label, this.upload_log_checkbox, this.priority_checkbox}) {
                                    c.setEnabled(true);
                                }
                                for (JComponent c : new JComponent[]{this.dir_name_textfield, this.dir_name_label, this.warning_label, this.dance_button, this.file_tree, this.total_file_size_label, this.skip_button, this.skip_rest_button}) {
                                    c.setEnabled(root_childs);
                                }
                            });
                        } else {
                            MiscTools.GUIRun(() -> {
                                this.account_combobox.setEnabled(true);
                                this.account_label.setEnabled(true);
                                this.account_combobox.setSelectedIndex(-1);
                                this.copy_email_button.setEnabled(true);
                                this.used_space_label.setForeground(Color.red);
                                this.used_space_label.setText(LabelTranslatorSingleton.getInstance().translate("ERROR checking account quota!"));
                                this.used_space_label.setEnabled(true);
                                this._last_selected_index = this.account_combobox.getSelectedIndex();
                                this.dance_button.setEnabled(false);
                                this.total_file_size_label.setEnabled(false);
                                this.skip_button.setEnabled(false);
                                this.skip_rest_button.setEnabled(false);
                                this.warning_label.setEnabled(false);
                                this.file_tree.setEnabled(false);
                                this.add_files_button.setEnabled(false);
                                this.add_folder_button.setEnabled(false);
                                this.upload_log_checkbox.setEnabled(false);
                                this.priority_checkbox.setEnabled(false);
                                this.dir_name_textfield.setEnabled(false);
                                this.dir_name_label.setEnabled(false);
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    MiscTools.GUIRun(() -> {
                        this.account_combobox.setEnabled(true);
                        this.account_label.setEnabled(true);
                        this.account_combobox.setSelectedIndex(-1);
                        this.copy_email_button.setEnabled(true);
                        this.used_space_label.setForeground(Color.red);
                        this.used_space_label.setText(LabelTranslatorSingleton.getInstance().translate("ERROR checking account quota!"));
                        this.used_space_label.setEnabled(true);
                        this._last_selected_index = this.account_combobox.getSelectedIndex();
                        this.dance_button.setEnabled(false);
                        this.total_file_size_label.setEnabled(false);
                        this.skip_button.setEnabled(false);
                        this.skip_rest_button.setEnabled(false);
                        this.warning_label.setEnabled(false);
                        this.file_tree.setEnabled(false);
                        this.add_files_button.setEnabled(false);
                        this.add_folder_button.setEnabled(false);
                        this.upload_log_checkbox.setEnabled(false);
                        this.priority_checkbox.setEnabled(false);
                        this.dir_name_textfield.setEnabled(false);
                        this.dir_name_label.setEnabled(false);
                    });
                }
            });
        }
    }

    private void skip_rest_buttonActionPerformed(ActionEvent evt) {
        if (MiscTools.deleteAllExceptSelectedTreeItems(this.file_tree)) {
            this._genFileList();
            this.warning_label.setEnabled(true);
            this.dance_button.setEnabled(true);
            this.total_file_size_label.setEnabled(true);
            this.skip_button.setEnabled(true);
            this.skip_rest_button.setEnabled(true);
            this.dir_name_textfield.setEnabled(true);
            this.dir_name_label.setEnabled(true);
        }
    }

    private void skip_buttonActionPerformed(ActionEvent evt) {
        if (MiscTools.deleteSelectedTreeItems(this.file_tree)) {
            this._genFileList();
            boolean root_childs = ((TreeNode)this.file_tree.getModel().getRoot()).getChildCount() > 0;
            this.warning_label.setEnabled(root_childs);
            this.dance_button.setEnabled(root_childs);
            this.total_file_size_label.setEnabled(root_childs);
            this.skip_button.setEnabled(root_childs);
            this.skip_rest_button.setEnabled(root_childs);
            this.dir_name_textfield.setEnabled(root_childs);
            this.dir_name_label.setEnabled(root_childs);
            if (!root_childs) {
                this.dir_name_textfield.setText("");
            }
        }
    }

    private void copy_email_buttonActionPerformed(ActionEvent evt) {
        if (this.account_combobox.getSelectedIndex() >= 0) {
            this.copy_email_button.setEnabled(false);
            this.copy_email_button.setText(LabelTranslatorSingleton.getInstance().translate("Please wait..."));
            MiscTools.copyTextToClipboard((String)this.account_combobox.getSelectedItem());
            this.copy_email_button.setText(LabelTranslatorSingleton.getInstance().translate("Copy email"));
            this.copy_email_button.setEnabled(true);
        }
    }

    private void _genFileTree(String directoryName, DefaultMutableTreeNode root, File[] files) {
        File[] fList;
        File directory = new File(directoryName);
        File[] fileArray = fList = files == null ? directory.listFiles() : files;
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.canRead()) {
                    DefaultMutableTreeNode current_file = new DefaultMutableTreeNode(file.getName() + " [" + MiscTools.formatBytes(file.length()) + "]");
                    root.add(current_file);
                    continue;
                }
                if (!file.isDirectory() || !file.canRead() || file.listFiles().length <= 0) continue;
                if (files == null || files.length > 1) {
                    DefaultMutableTreeNode current_dir = new DefaultMutableTreeNode(file.getName());
                    root.add(current_dir);
                    this._genFileTree(file.getAbsolutePath(), current_dir, null);
                    continue;
                }
                this._genFileTree(file.getAbsolutePath(), root, null);
            }
        }
    }

    private void _genFileList() {
        try {
            this._files.clear();
            this._total_space = 0L;
            DefaultTreeModel tree_model = (DefaultTreeModel)MiscTools.futureRun(this.file_tree::getModel).get();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree_model.getRoot();
            Enumeration<TreeNode> files_tree = root.depthFirstEnumeration();
            while (files_tree.hasMoreElements()) {
                Object[] object_path;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)files_tree.nextElement();
                if (!node.isLeaf() || node == root) continue;
                String path = "";
                for (Object p : object_path = node.getUserObjectPath()) {
                    path = path + File.separator + p;
                }
                File file = new File(path = path.replaceAll("^/+", "/").replaceAll("^\\+", "\\").trim().replaceAll(" \\[[0-9,.]+ [A-Z]+\\]$", ""));
                if (!file.isFile()) continue;
                this._total_space += file.length();
                this._files.add(file);
            }
            MiscTools.GUIRun(() -> this.total_file_size_label.setText("[" + MiscTools.formatBytes(this._total_space) + "]"));
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FileGrabberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FileGrabberDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void _file_drop_notify(List<File> files) {
        MiscTools.GUIRunAndWait(() -> {
            this.add_files_button.setEnabled(false);
            this.add_folder_button.setEnabled(false);
            this.warning_label.setEnabled(false);
            this.skip_button.setEnabled(false);
            this.skip_rest_button.setEnabled(false);
            this.dance_button.setEnabled(false);
            this.dir_name_textfield.setEnabled(false);
            this.dir_name_label.setEnabled(false);
            this.upload_log_checkbox.setEnabled(false);
            this.priority_checkbox.setEnabled(false);
            this.total_file_size_label.setText("[0 B]");
        });
        this._base_path = files.size() == 1 && files.get(0).isDirectory() ? files.get(0).getAbsolutePath() : files.get(0).getParentFile().getAbsolutePath();
        MiscTools.GUIRunAndWait(() -> {
            this.dir_name_textfield.setText(files.size() == 1 && ((File)files.get(0)).isDirectory() ? ((File)files.get(0)).getName() : ((File)files.get(0)).getParentFile().getName());
            this.dir_name_textfield.setEnabled(true);
            this.dir_name_label.setEnabled(true);
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this._base_path);
        MiscTools.GUIRunAndWait(() -> this.dance_button.setText(LabelTranslatorSingleton.getInstance().translate("Loading files, please wait...")));
        this._genFileTree(this._base_path, root, files.toArray(new File[files.size()]));
        DefaultTreeModel tree_model = new DefaultTreeModel(MiscTools.sortTree(root));
        MiscTools.GUIRunAndWait(() -> this.file_tree.setModel(tree_model));
        this._genFileList();
        MiscTools.GUIRunAndWait(() -> {
            this.dance_button.setText(LabelTranslatorSingleton.getInstance().translate("Let's dance, baby"));
            if (this._last_selected_index != -1 && this._quota_ok) {
                this.add_files_button.setEnabled(true);
                this.add_folder_button.setEnabled(true);
                this.file_tree.setRootVisible(true);
                this.file_tree.setEnabled(true);
                this.warning_label.setEnabled(true);
                this.dance_button.setEnabled(true);
                this.total_file_size_label.setEnabled(true);
                this.skip_button.setEnabled(true);
                this.skip_rest_button.setEnabled(true);
                this.dir_name_textfield.setEnabled(true);
                this.dir_name_label.setEnabled(true);
                this.upload_log_checkbox.setEnabled(true);
                this.priority_checkbox.setEnabled(true);
            }
        });
    }
}

