/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.APIException;
import com.tonikelope.megabasterd.ChunkDownloader;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.Transference;
import com.tonikelope.megabasterd.TransferenceManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class DownloadManager
extends TransferenceManager {
    private static final Logger LOG = Logger.getLogger(DownloadManager.class.getName());

    public DownloadManager(MainPanel main_panel) {
        super(main_panel, main_panel.getMax_dl(), main_panel.getView().getStatus_down_label(), main_panel.getView().getjPanel_scroll_down(), main_panel.getView().getClose_all_finished_down_button(), main_panel.getView().getPause_all_down_button(), main_panel.getView().getClean_all_down_menu());
    }

    public synchronized void forceResetAllChunks() {
        MainPanel.THREAD_POOL.execute(() -> {
            ConcurrentLinkedQueue<Transference> transference_running_list = this.getMain_panel().getDownload_manager().getTransference_running_list();
            if (!transference_running_list.isEmpty()) {
                transference_running_list.forEach(transference -> {
                    ArrayList<ChunkDownloader> chunkworkers = ((Download)transference).getChunkworkers();
                    chunkworkers.forEach(worker -> worker.RESET_CURRENT_CHUNK());
                });
                MiscTools.GUIRun(() -> this.getMain_panel().getView().getForce_chunk_reset_button().setEnabled(true));
                JOptionPane.showMessageDialog(this.getMain_panel().getView(), LabelTranslatorSingleton.getInstance().translate("CURRENT DOWNLOAD CHUNKS RESET!"));
            }
        });
    }

    @Override
    public void closeAllFinished() {
        this._transference_finished_queue.stream().filter(t -> !t.isCanceled()).map(t -> {
            this._transference_finished_queue.remove(t);
            return t;
        }).forEachOrdered(t -> this._transference_remove_queue.add(t));
        this.secureNotify();
    }

    public int copyAllLinksToClipboard() {
        int total = 0;
        ArrayList<String> links = new ArrayList<String>();
        String out = "***PROVISIONING DOWNLOADS***\r\n\r\n";
        for (Transference t : this._transference_provision_queue) {
            links.add(((Download)t).getUrl());
        }
        out = out + String.join((CharSequence)"\r\n", links);
        total += links.size();
        links.clear();
        out = out + "\r\n\r\n***WAITING DOWNLOADS***\r\n\r\n";
        for (Transference t : this._transference_waitstart_aux_queue) {
            links.add(((Download)t).getUrl());
        }
        for (Transference t : this._transference_waitstart_queue) {
            links.add(((Download)t).getUrl());
        }
        out = out + String.join((CharSequence)"\r\n", links);
        total += links.size();
        links.clear();
        out = out + "\r\n\r\n***RUNNING DOWNLOADS***\r\n\r\n";
        for (Transference t : this._transference_running_list) {
            links.add(((Download)t).getUrl());
        }
        out = out + String.join((CharSequence)"\r\n", links);
        total += links.size();
        links.clear();
        out = out + "\r\n\r\n***FINISHED DOWNLOADS***\r\n\r\n";
        for (Transference t : this._transference_finished_queue) {
            links.add(((Download)t).getUrl());
        }
        out = out + String.join((CharSequence)"\r\n", links);
        MiscTools.copyTextToClipboard(out);
        return total += links.size();
    }

    @Override
    public void remove(Transference[] downloads) {
        ArrayList<String> delete_down = new ArrayList<String>();
        for (Transference d : downloads) {
            MiscTools.GUIRun(() -> this.getScroll_panel().remove(((Download)d).getView()));
            this.getTransference_waitstart_queue().remove(d);
            this.getTransference_running_list().remove(d);
            this.getTransference_finished_queue().remove(d);
            if (!((Download)d).isProvision_ok()) continue;
            this.increment_total_size(-1L * d.getFile_size());
            this.increment_total_progress(-1L * d.getProgress());
            if (d.isCanceled() && !d.isClosed()) continue;
            delete_down.add(((Download)d).getUrl());
        }
        try {
            DBTools.deleteDownloads(delete_down.toArray(new String[delete_down.size()]));
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.secureNotify();
    }

    @Override
    public void provision(Transference download) {
        MiscTools.GUIRun(() -> this.getScroll_panel().add(((Download)download).getView()));
        try {
            this._provision((Download)download, false);
            this.secureNotify();
        }
        catch (APIException ex) {
            LOG.log(Level.INFO, "{0} Provision failed! Retrying in separated thread...", Thread.currentThread().getName());
            MainPanel.THREAD_POOL.execute(() -> {
                try {
                    this._provision((Download)download, true);
                }
                catch (APIException ex1) {
                    LOG.log(Level.SEVERE, null, ex1);
                }
                this.secureNotify();
            });
        }
    }

    private void _provision(Download download, boolean retry) throws APIException {
        download.provisionIt(retry);
        if (download.isProvision_ok()) {
            this.increment_total_size(download.getFile_size());
            this.getTransference_waitstart_aux_queue().add(download);
        } else {
            this.getTransference_finished_queue().add(download);
        }
    }
}

