/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.APIException;
import com.tonikelope.megabasterd.ChunkDownloader;
import com.tonikelope.megabasterd.ChunkDownloaderMono;
import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.ChunkWriterManager;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.DownloadView;
import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MegaCrypterAPI;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.ProgressMeter;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.Transference;
import com.tonikelope.megabasterd.Upload;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class Download
implements Transference,
Runnable,
SecureSingleThreadNotifiable {
    public static final boolean VERIFY_CBC_MAC_DEFAULT = false;
    public static final boolean USE_SLOTS_DEFAULT = true;
    public static final int WORKERS_DEFAULT = 6;
    public static final boolean USE_MEGA_ACCOUNT_DOWN = false;
    public static final boolean DEFAULT_CLIPBOARD_LINK_MONITOR = true;
    public static final int CHUNK_SIZE_MULTI = 20;
    private static final Logger LOG = Logger.getLogger(Download.class.getName());
    private final MainPanel _main_panel;
    private volatile DownloadView _view;
    private volatile ProgressMeter _progress_meter;
    private final Object _secure_notify_lock;
    private final Object _progress_lock;
    private final Object _workers_lock;
    private final Object _chunkid_lock;
    private final Object _dl_url_lock;
    private final Object _turbo_proxy_lock;
    private volatile boolean _notified;
    private final String _url;
    private final String _download_path;
    private final String _custom_chunks_dir;
    private String _file_name;
    private String _file_key;
    private Long _file_size;
    private String _file_pass;
    private String _file_noexpire;
    private volatile boolean _frozen;
    private final boolean _use_slots;
    private int _slots;
    private final boolean _restart;
    private final ArrayList<ChunkDownloader> _chunkworkers;
    private final ExecutorService _thread_pool;
    private volatile boolean _exit;
    private volatile boolean _pause;
    private final ConcurrentLinkedQueue<Long> _partialProgressQueue;
    private volatile long _progress;
    private ChunkWriterManager _chunkmanager;
    private String _last_download_url;
    private boolean _provision_ok;
    private boolean _auto_retry_on_error;
    private int _paused_workers;
    private File _file;
    private boolean _checking_cbc;
    private boolean _retrying_request;
    private Double _progress_bar_rate;
    private OutputStream _output_stream;
    private String _status_error;
    private final ConcurrentLinkedQueue<Long> _rejectedChunkIds;
    private long _last_chunk_id_dispatched;
    private final MegaAPI _ma;
    private volatile boolean _canceled;
    private volatile boolean _turbo;
    private volatile boolean _closed;
    private volatile boolean _finalizing;
    private final Object _progress_watchdog_lock;
    private final boolean _priority;
    private volatile boolean global_cancel = false;

    public void setGlobal_cancel(boolean global_cancel) {
        this.global_cancel = global_cancel;
    }

    public String getStatus_error() {
        return this._status_error;
    }

    public Download(MainPanel main_panel, MegaAPI ma, String url, String download_path, String file_name, String file_key, Long file_size, String file_pass, String file_noexpire, boolean use_slots, boolean restart, String custom_chunks_dir, boolean priority) {
        this._priority = priority;
        this._paused_workers = 0;
        this._ma = ma;
        this._frozen = main_panel.isInit_paused();
        this._last_chunk_id_dispatched = 0L;
        this._canceled = false;
        this._auto_retry_on_error = true;
        this._status_error = null;
        this._retrying_request = false;
        this._checking_cbc = false;
        this._finalizing = false;
        this._closed = false;
        this._pause = false;
        this._exit = false;
        this._progress_watchdog_lock = new Object();
        this._last_download_url = null;
        this._provision_ok = false;
        this._progress = 0L;
        this._notified = false;
        this._main_panel = main_panel;
        this._url = url;
        this._download_path = download_path;
        this._file_name = file_name;
        this._file_key = file_key;
        this._file_size = file_size;
        this._file_pass = file_pass;
        this._file_noexpire = file_noexpire;
        this._use_slots = use_slots;
        this._restart = restart;
        this._secure_notify_lock = new Object();
        this._progress_lock = new Object();
        this._workers_lock = new Object();
        this._chunkid_lock = new Object();
        this._dl_url_lock = new Object();
        this._turbo_proxy_lock = new Object();
        this._chunkworkers = new ArrayList();
        this._partialProgressQueue = new ConcurrentLinkedQueue();
        this._rejectedChunkIds = new ConcurrentLinkedQueue();
        this._thread_pool = Executors.newCachedThreadPool();
        this._view = new DownloadView(this);
        this._progress_meter = new ProgressMeter(this);
        this._custom_chunks_dir = custom_chunks_dir;
        this._turbo = false;
    }

    public Download(Download download) {
        this._priority = download.isPriority();
        this._paused_workers = 0;
        this._ma = download.getMa();
        this._last_chunk_id_dispatched = 0L;
        this._canceled = false;
        this._status_error = null;
        this._finalizing = false;
        this._retrying_request = false;
        this._auto_retry_on_error = true;
        this._closed = false;
        this._checking_cbc = false;
        this._pause = false;
        this._exit = false;
        this._progress_watchdog_lock = new Object();
        this._last_download_url = null;
        this._provision_ok = false;
        this._progress = 0L;
        this._notified = false;
        this._main_panel = download.getMain_panel();
        this._url = download.getUrl();
        this._download_path = download.getDownload_path();
        this._file_name = download.getFile_name();
        this._file_key = download.getFile_key();
        this._file_size = download.getFile_size();
        this._file_pass = download.getFile_pass();
        this._file_noexpire = download.getFile_noexpire();
        this._use_slots = download.getMain_panel().isUse_slots_down();
        this._restart = true;
        this._secure_notify_lock = new Object();
        this._progress_lock = new Object();
        this._workers_lock = new Object();
        this._chunkid_lock = new Object();
        this._dl_url_lock = new Object();
        this._turbo_proxy_lock = new Object();
        this._chunkworkers = new ArrayList();
        this._partialProgressQueue = new ConcurrentLinkedQueue();
        this._rejectedChunkIds = new ConcurrentLinkedQueue();
        this._thread_pool = Executors.newCachedThreadPool();
        this._view = new DownloadView(this);
        this._progress_meter = new ProgressMeter(this);
        this._custom_chunks_dir = download.getCustom_chunks_dir();
        this._turbo = false;
    }

    @Override
    public boolean isPriority() {
        return this._priority;
    }

    @Override
    public boolean isCanceled() {
        return this._canceled && !this.global_cancel;
    }

    public boolean isTurbo() {
        return this._turbo;
    }

    public String getCustom_chunks_dir() {
        return this._custom_chunks_dir;
    }

    public long getLast_chunk_id_dispatched() {
        return this._last_chunk_id_dispatched;
    }

    public long calculateLastWrittenChunk(long temp_file_size) {
        if (temp_file_size > 0x380000L) {
            return 7L + (long)Math.floor((float)(temp_file_size - 0x380000L) / (float)(0x100000 * (this.isUse_slots() ? 20 : 1)));
        }
        long i = 0L;
        for (long tot = 0L; tot < temp_file_size; tot += ++i * 128L * 1024L) {
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTurboMode() {
        Object object = this._turbo_proxy_lock;
        synchronized (object) {
            if (this._turbo) {
                this._turbo = false;
                MiscTools.GUIRun(() -> this.getView().getSpeed_label().setForeground(new Color(0, 128, 255)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableTurboMode() {
        Object object = this._turbo_proxy_lock;
        synchronized (object) {
            if (!this._turbo) {
                this._turbo = true;
                if (!this._finalizing) {
                    Download tthis = this;
                    MiscTools.GUIRun(() -> this.getView().getSpeed_label().setForeground(new Color(255, 102, 0)));
                    Object object2 = this._workers_lock;
                    synchronized (object2) {
                        for (int t = this.getChunkworkers().size(); t <= 20; ++t) {
                            ChunkDownloader c = new ChunkDownloader(t, tthis);
                            this._chunkworkers.add(c);
                            this._thread_pool.execute(c);
                        }
                    }
                    MiscTools.GUIRun(() -> {
                        this.getView().getSlots_spinner().setValue(20);
                        this.getView().getSlots_spinner().setEnabled(true);
                    });
                }
            }
        }
    }

    public ConcurrentLinkedQueue<Long> getRejectedChunkIds() {
        return this._rejectedChunkIds;
    }

    public Object getWorkers_lock() {
        return this._workers_lock;
    }

    public boolean isChecking_cbc() {
        return this._checking_cbc;
    }

    public boolean isRetrying_request() {
        return this._retrying_request;
    }

    public boolean isExit() {
        return this._exit;
    }

    public boolean isPause() {
        return this._pause;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    public void setPause(boolean pause) {
        this._pause = pause;
    }

    public ChunkWriterManager getChunkmanager() {
        return this._chunkmanager;
    }

    public String getFile_key() {
        return this._file_key;
    }

    @Override
    public long getProgress() {
        return this._progress;
    }

    public OutputStream getOutput_stream() {
        return this._output_stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChunkDownloader> getChunkworkers() {
        Object object = this._workers_lock;
        synchronized (object) {
            return this._chunkworkers;
        }
    }

    public void setPaused_workers(int paused_workers) {
        this._paused_workers = paused_workers;
    }

    public String getUrl() {
        return this._url;
    }

    public String getDownload_path() {
        return this._download_path;
    }

    @Override
    public String getFile_name() {
        return this._file_name;
    }

    public String getFile_pass() {
        return this._file_pass;
    }

    public String getFile_noexpire() {
        return this._file_noexpire;
    }

    public boolean isUse_slots() {
        return this._use_slots;
    }

    public int getSlots() {
        return this._slots;
    }

    public void setLast_chunk_id_dispatched(long last_chunk_id_dispatched) {
        this._last_chunk_id_dispatched = last_chunk_id_dispatched;
    }

    public boolean isProvision_ok() {
        return this._provision_ok;
    }

    @Override
    public ProgressMeter getProgress_meter() {
        while (this._progress_meter == null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        }
        return this._progress_meter;
    }

    @Override
    public DownloadView getView() {
        while (this._view == null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        }
        return this._view;
    }

    @Override
    public MainPanel getMain_panel() {
        return this._main_panel;
    }

    @Override
    public void start() {
        MainPanel.THREAD_POOL.execute(this);
    }

    @Override
    public void stop() {
        if (!this.isExit()) {
            this._canceled = true;
            this.stopDownloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        if (this.isPause()) {
            this.setPause(false);
            this.setPaused_workers(0);
            Object object = this._workers_lock;
            synchronized (object) {
                this.getChunkworkers().forEach(downloader -> downloader.secureNotify());
            }
            this.getView().resume();
            this._main_panel.getDownload_manager().setPaused_all(false);
        } else {
            this.setPause(true);
            this.getView().pause();
        }
        this._main_panel.getDownload_manager().secureNotify();
    }

    public MegaAPI getMa() {
        return this._ma;
    }

    @Override
    public void restart() {
        Download new_download = new Download(this);
        this.getMain_panel().getDownload_manager().getTransference_remove_queue().add(this);
        this.getMain_panel().getDownload_manager().getTransference_provision_queue().add(new_download);
        this.getMain_panel().getDownload_manager().secureNotify();
    }

    @Override
    public boolean isPaused() {
        return this.isPause();
    }

    @Override
    public boolean isStopped() {
        return this.isExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkSlotsAndWorkers() {
        if (!this.isExit() && !this._finalizing) {
            Object object = this._workers_lock;
            synchronized (object) {
                int sl = this.getView().getSlots();
                int cworkers = this.getChunkworkers().size();
                if (sl != cworkers) {
                    if (sl > cworkers) {
                        this.startSlot();
                    } else {
                        this.stopLastStartedSlot();
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this._closed = true;
        if (this._provision_ok) {
            try {
                DBTools.deleteDownload(this._url);
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        this._main_panel.getDownload_manager().getTransference_remove_queue().add(this);
        this._main_panel.getDownload_manager().secureNotify();
    }

    @Override
    public ConcurrentLinkedQueue<Long> getPartialProgress() {
        return this._partialProgressQueue;
    }

    @Override
    public long getFile_size() {
        return this._file_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block64: {
            MiscTools.GUIRun(() -> {
                this.getView().getQueue_down_button().setVisible(false);
                this.getView().getQueue_up_button().setVisible(false);
                this.getView().getQueue_top_button().setVisible(false);
                this.getView().getQueue_bottom_button().setVisible(false);
                this.getView().getClose_button().setVisible(false);
                this.getView().getCopy_link_button().setVisible(true);
                this.getView().getOpen_folder_button().setVisible(true);
            });
            this.getView().printStatusNormal("Starting download, please wait...");
            try {
                FileStore fs = Files.getFileStore(Paths.get(this._download_path, new String[0]));
                if (fs.getUsableSpace() < this._file_size) {
                    this._status_error = "NO DISK SPACE AVAILABLE!";
                    this._exit = true;
                }
                if (!this._exit) {
                    String filename = this._download_path + "/" + this._file_name;
                    this._file = new File(filename);
                    if (this._file.getParent() != null) {
                        File path = new File(this._file.getParent());
                        path.mkdirs();
                    }
                    if (!this._file.exists() || this._file.length() != this._file_size.longValue()) {
                        if (this._file.exists()) {
                            this._file_name = this._file_name.replaceFirst("\\..*$", "_" + MiscTools.genID(8) + "_$0");
                            filename = this._download_path + "/" + this._file_name;
                            this._file = new File(filename);
                        }
                        this.getView().printStatusNormal("Starting download (retrieving MEGA temp link), please wait...");
                        this._last_download_url = this.getMegaFileDownloadUrl(this._url);
                        if (!this._exit) {
                            String temp_filename = (this.getCustom_chunks_dir() != null ? this.getCustom_chunks_dir() : this._download_path) + "/" + this._file_name + ".mctemp";
                            this._file = new File(temp_filename);
                            if (this._file.getParent() != null) {
                                File path = new File(this._file.getParent());
                                path.mkdirs();
                            }
                            if (this._file.exists()) {
                                this.getView().printStatusNormal("File exists, resuming download...");
                                long max_size = this.calculateMaxTempFileSize(this._file.length());
                                if (max_size != this._file.length()) {
                                    LOG.log(Level.INFO, "{0} Downloader truncating mctemp file {1} -> {2} ", new Object[]{Thread.currentThread().getName(), this._file.length(), max_size});
                                    this.getView().printStatusNormal("Truncating temp file...");
                                    try (FileChannel out_truncate = new FileOutputStream(temp_filename, true).getChannel();){
                                        out_truncate.truncate(max_size);
                                    }
                                }
                                this.setProgress(this._file.length());
                                this._last_chunk_id_dispatched = this.calculateLastWrittenChunk(this._progress);
                            } else {
                                this.setProgress(0L);
                            }
                            this._output_stream = new BufferedOutputStream(new FileOutputStream(this._file, this._progress > 0L));
                            this._thread_pool.execute(this.getProgress_meter());
                            this.getMain_panel().getGlobal_dl_speed().attachTransference(this);
                            Object max_size = this._workers_lock;
                            synchronized (max_size) {
                                if (this._use_slots) {
                                    this._chunkmanager = new ChunkWriterManager(this);
                                    this._thread_pool.execute(this._chunkmanager);
                                    this._slots = this.getMain_panel().getDefault_slots_down();
                                    this._view.getSlots_spinner().setValue(this._slots);
                                    for (int t = 1; t <= this._slots; ++t) {
                                        ChunkDownloader c = new ChunkDownloader(t, this);
                                        this._chunkworkers.add(c);
                                        this._thread_pool.execute(c);
                                    }
                                    MiscTools.GUIRun(() -> {
                                        for (JComponent c : new JComponent[]{this.getView().getSlots_label(), this.getView().getSlots_spinner(), this.getView().getSlot_status_label()}) {
                                            c.setVisible(true);
                                        }
                                    });
                                } else {
                                    ChunkDownloaderMono c = new ChunkDownloaderMono(this);
                                    this._chunkworkers.add(c);
                                    this._thread_pool.execute(c);
                                    MiscTools.GUIRun(() -> {
                                        for (JComponent c1 : new JComponent[]{this.getView().getSlots_label(), this.getView().getSlots_spinner(), this.getView().getSlot_status_label()}) {
                                            c1.setVisible(false);
                                        }
                                    });
                                }
                            }
                            this.getView().printStatusNormal(LabelTranslatorSingleton.getInstance().translate("Downloading file from mega ") + (this._ma.getFull_email() != null ? "(" + this._ma.getFull_email() + ")" : "") + " ...");
                            MiscTools.GUIRun(() -> {
                                for (JComponent c : new JComponent[]{this.getView().getPause_button(), this.getView().getProgress_pbar()}) {
                                    c.setVisible(true);
                                }
                            });
                            MainPanel.THREAD_POOL.execute(() -> {
                                long last_progress;
                                LOG.log(Level.INFO, "{0} PROGRESS WATCHDOG HELLO!", Thread.currentThread().getName());
                                long progress = this.getProgress();
                                do {
                                    last_progress = progress;
                                    Object object = this._progress_watchdog_lock;
                                    synchronized (object) {
                                        try {
                                            this._progress_watchdog_lock.wait(600000L);
                                            progress = this.getProgress();
                                        }
                                        catch (InterruptedException ex) {
                                            progress = -1L;
                                            Logger.getLogger(Download.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                } while (!this.isExit() && !this._thread_pool.isShutdown() && progress < this.getFile_size() && (this.isPaused() || progress > last_progress));
                                if (!this.isExit() && !this._thread_pool.isShutdown() && this._status_error == null && progress < this.getFile_size() && progress <= last_progress) {
                                    this.stopDownloader("PROGRESS WATCHDOG TIMEOUT!");
                                }
                                LOG.log(Level.INFO, "{0} PROGRESS WATCHDOG BYE BYE!", Thread.currentThread().getName());
                            });
                            this.secureWait();
                            LOG.log(Level.INFO, "{0} Chunkdownloaders finished!", Thread.currentThread().getName());
                            this.getProgress_meter().setExit(true);
                            this.getProgress_meter().secureNotify();
                            try {
                                this._thread_pool.shutdown();
                                LOG.log(Level.INFO, "{0} Waiting all threads to finish...", Thread.currentThread().getName());
                                this._thread_pool.awaitTermination(15L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex) {
                                LOG.log(Level.SEVERE, ex.getMessage());
                            }
                            if (!this._thread_pool.isTerminated()) {
                                LOG.log(Level.INFO, "{0} Closing thread pool ''mecag\u00fcen'' style...", Thread.currentThread().getName());
                                this._thread_pool.shutdownNow();
                            }
                            LOG.log(Level.INFO, "{0} Downloader thread pool finished!", Thread.currentThread().getName());
                            this.getMain_panel().getGlobal_dl_speed().detachTransference(this);
                            this._output_stream.close();
                            MiscTools.GUIRun(() -> {
                                for (JComponent c : new JComponent[]{this.getView().getSpeed_label(), this.getView().getPause_button(), this.getView().getStop_button(), this.getView().getSlots_label(), this.getView().getSlots_spinner(), this.getView().getKeep_temp_checkbox()}) {
                                    c.setVisible(false);
                                }
                            });
                            if (this._progress == this._file_size) {
                                String verify_file;
                                if (this._file.length() != this._file_size.longValue()) {
                                    throw new IOException("El tama\u00f1o del fichero es incorrecto!");
                                }
                                Files.move(Paths.get(this._file.getAbsolutePath(), new String[0]), Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                                if (this._custom_chunks_dir != null) {
                                    File temp_parent_download_dir = new File(temp_filename).getParentFile();
                                    while (!temp_parent_download_dir.getAbsolutePath().equals(this._custom_chunks_dir) && temp_parent_download_dir.listFiles().length == 0) {
                                        temp_parent_download_dir.delete();
                                        temp_parent_download_dir = temp_parent_download_dir.getParentFile();
                                    }
                                }
                                if ((verify_file = DBTools.selectSettingValue("verify_down_file")) != null && verify_file.equals("yes")) {
                                    this._checking_cbc = true;
                                    this.getView().printStatusNormal("Waiting to check file integrity...");
                                    this.setProgress(0L);
                                    this.getView().printStatusNormal("Checking file integrity, please wait...");
                                    MiscTools.GUIRun(() -> {
                                        this.getView().getStop_button().setVisible(true);
                                        this.getView().getStop_button().setText(LabelTranslatorSingleton.getInstance().translate("CANCEL CHECK"));
                                    });
                                    this.getMain_panel().getDownload_manager().getTransference_running_list().remove(this);
                                    this.getMain_panel().getDownload_manager().secureNotify();
                                    if (this.verifyFileCBCMAC(filename)) {
                                        this.getView().printStatusOK("File successfully downloaded! (Integrity check PASSED)");
                                    } else if (!this._exit) {
                                        this._status_error = "BAD NEWS :( File is DAMAGED!";
                                        this.getView().printStatusError(this._status_error);
                                    } else {
                                        this.getView().printStatusOK("File successfully downloaded! (but integrity check CANCELED)");
                                    }
                                    MiscTools.GUIRun(() -> this.getView().getStop_button().setVisible(false));
                                } else {
                                    this.getView().printStatusOK("File successfully downloaded!");
                                }
                            } else if (this._status_error != null) {
                                this.getView().hideAllExceptStatus();
                                this.getView().printStatusError(this._status_error);
                            } else if (this._canceled) {
                                this.getView().hideAllExceptStatus();
                                this.getView().printStatusNormal("Download CANCELED!");
                            } else {
                                this.getView().hideAllExceptStatus();
                                this._status_error = "UNEXPECTED ERROR!";
                                this.getView().printStatusError(this._status_error);
                            }
                            break block64;
                        }
                        if (this._status_error != null) {
                            this.getView().hideAllExceptStatus();
                            this.getView().printStatusError(this._status_error != null ? this._status_error : "ERROR");
                        } else if (this._canceled) {
                            this.getView().hideAllExceptStatus();
                            this.getView().printStatusNormal("Download CANCELED!");
                        } else {
                            this.getView().hideAllExceptStatus();
                            this._status_error = "UNEXPECTED ERROR!";
                            this.getView().printStatusError(this._status_error);
                        }
                        break block64;
                    }
                    this.getView().hideAllExceptStatus();
                    this._status_error = "FILE WITH SAME NAME AND SIZE ALREADY EXISTS";
                    this._auto_retry_on_error = false;
                    this.getView().printStatusError(this._status_error);
                    break block64;
                }
                if (this._status_error != null) {
                    this.getView().hideAllExceptStatus();
                    this.getView().printStatusError(this._status_error);
                } else if (this._canceled) {
                    this.getView().hideAllExceptStatus();
                    this.getView().printStatusNormal("Download CANCELED!");
                } else {
                    this.getView().hideAllExceptStatus();
                    this._status_error = "UNEXPECTED ERROR!";
                    this.getView().printStatusError(this._status_error);
                }
            }
            catch (Exception ex) {
                this._status_error = "I/O ERROR " + ex.getMessage();
                this.getView().printStatusError(this._status_error);
                LOG.log(Level.SEVERE, ex.getMessage());
            }
        }
        if (this._file != null && !this.getView().isKeepTempFileSelected()) {
            this._file.delete();
            if (this.getChunkmanager() != null) {
                this.getChunkmanager().delete_chunks_temp_dir();
                File parent_download_dir = new File(this.getDownload_path() + "/" + this.getFile_name()).getParentFile();
                while (!parent_download_dir.getAbsolutePath().equals(this.getDownload_path()) && parent_download_dir.listFiles().length == 0) {
                    parent_download_dir.delete();
                    parent_download_dir = parent_download_dir.getParentFile();
                }
                if (!new File(this.getDownload_path() + "/" + this.getFile_name()).getParentFile().exists()) {
                    this.getView().getOpen_folder_button().setEnabled(false);
                }
            }
        }
        if (this._status_error == null && !this._canceled || this.global_cancel || !this._auto_retry_on_error) {
            try {
                DBTools.deleteDownload(this._url);
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        this.getMain_panel().getDownload_manager().getTransference_running_list().remove(this);
        this.getMain_panel().getDownload_manager().getTransference_finished_queue().add(this);
        MiscTools.GUIRun(() -> {
            this.getMain_panel().getDownload_manager().getScroll_panel().remove(this.getView());
            this.getMain_panel().getDownload_manager().getScroll_panel().add(this.getView());
        });
        this.getMain_panel().getDownload_manager().secureNotify();
        MiscTools.GUIRun(() -> {
            this.getView().getClose_button().setVisible(true);
            if ((this._status_error != null || this._canceled) && this.isProvision_ok() && !this.global_cancel) {
                this.getView().getRestart_button().setVisible(true);
            } else if (!this.global_cancel) {
                this.getView().getClose_button().setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-ok-30.png")));
            }
        });
        if (this._status_error != null && !this._canceled && this._auto_retry_on_error) {
            MainPanel.THREAD_POOL.execute(() -> {
                for (int i = 3; !this._closed && i > 0; --i) {
                    int j = i;
                    MiscTools.GUIRun(() -> this.getView().getRestart_button().setText("Restart (" + String.valueOf(j) + " secs...)"));
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Upload.class.getName()).log(Level.SEVERE, ex.getMessage());
                    }
                }
                if (!this._closed) {
                    LOG.log(Level.INFO, "{0} Downloader {1} AUTO RESTARTING DOWNLOAD...", new Object[]{Thread.currentThread().getName(), this.getFile_name()});
                    this.restart();
                }
            });
        } else {
            this.getMain_panel().getDownload_manager().setAll_finished(false);
        }
        this._exit = true;
        if (this._status_error != null && !this._canceled && this.getMain_panel().getDownload_manager().no_transferences() && this.getMain_panel().getUpload_manager().no_transferences() && (!this.getMain_panel().getDownload_manager().getTransference_finished_queue().isEmpty() || !this.getMain_panel().getUpload_manager().getTransference_finished_queue().isEmpty()) && this.getMain_panel().getView().getAuto_close_menu().isSelected()) {
            System.exit(0);
        }
        Object object = this._progress_watchdog_lock;
        synchronized (object) {
            this._progress_watchdog_lock.notifyAll();
        }
        LOG.log(Level.INFO, "{0}{1} Downloader: bye bye", new Object[]{Thread.currentThread().getName(), this._file_name});
    }

    public void provisionIt(boolean retry) throws APIException {
        this.getView().printStatusNormal("Provisioning download, please wait...");
        MiscTools.GUIRun(() -> {
            this.getView().getCopy_link_button().setVisible(true);
            this.getView().getOpen_folder_button().setVisible(true);
        });
        this._provision_ok = false;
        try {
            if (this._file_name == null) {
                String[] file_info = this.getMegaFileMetadata(this._url, this.getMain_panel().getView(), retry);
                if (file_info != null) {
                    String filename;
                    File file;
                    this._file_name = file_info[0];
                    this._file_size = Long.valueOf(file_info[1]);
                    this._file_key = file_info[2];
                    if (file_info.length == 5) {
                        this._file_pass = file_info[3];
                        this._file_noexpire = file_info[4];
                    }
                    if ((file = new File(filename = this._download_path + "/" + this._file_name)).exists() && file.length() != this._file_size.longValue()) {
                        this._file_name = this._file_name.replaceFirst("\\..*$", "_" + MiscTools.genID(8) + "_$0");
                    }
                    try {
                        DBTools.insertDownload(this._url, this._ma.getFull_email(), this._download_path, this._file_name, this._file_key, this._file_size, this._file_pass, this._file_noexpire, this._custom_chunks_dir);
                        this._provision_ok = true;
                    }
                    catch (SQLException ex) {
                        this._status_error = "Error registering download: " + ex.getMessage() + " file is already downloading?";
                    }
                }
            } else {
                String filename = this._download_path + "/" + this._file_name;
                File file = new File(filename);
                File temp_file = new File(filename + ".mctemp");
                if (file.exists() && !temp_file.exists() && file.length() != this._file_size.longValue()) {
                    this._file_name = this._file_name.replaceFirst("\\..*$", "_" + MiscTools.genID(8) + "_$0");
                }
                try {
                    DBTools.deleteDownload(this._url);
                    DBTools.insertDownload(this._url, this._ma.getFull_email(), this._download_path, this._file_name, this._file_key, this._file_size, this._file_pass, this._file_noexpire, this._custom_chunks_dir);
                    this._provision_ok = true;
                }
                catch (SQLException ex) {
                    this._status_error = "Error registering download: " + ex.getMessage();
                }
            }
        }
        catch (APIException ex) {
            throw ex;
        }
        catch (NumberFormatException ex) {
            this._status_error = ex.getMessage();
        }
        if (!this._provision_ok) {
            if (this._status_error == null) {
                this._status_error = "PROVISION FAILED";
            }
            if (this._file_name != null) {
                MiscTools.GUIRun(() -> {
                    this.getView().getFile_name_label().setVisible(true);
                    this.getView().getFile_name_label().setText(MiscTools.truncateText(new File(this._download_path + "/" + this._file_name).getName(), 150));
                    this.getView().getFile_name_label().setToolTipText(this._download_path + "/" + this._file_name);
                    this.getView().getFile_size_label().setVisible(true);
                    this.getView().getFile_size_label().setText(MiscTools.formatBytes(this._file_size));
                });
            }
            this.getView().hideAllExceptStatus();
            this.getView().printStatusError(this._status_error);
            MiscTools.GUIRun(() -> this.getView().getClose_button().setVisible(true));
        } else {
            this._progress_bar_rate = 2.147483647E9 / (double)this._file_size.longValue();
            this.getView().printStatusNormal(this._frozen ? "(FROZEN) Waiting to start..." : "Waiting to start...");
            MiscTools.GUIRun(() -> {
                this.getView().getFile_name_label().setVisible(true);
                this.getView().getFile_name_label().setText(MiscTools.truncateText(new File(this._download_path + "/" + this._file_name).getName(), 150));
                this.getView().getFile_name_label().setToolTipText(this._download_path + "/" + this._file_name);
                this.getView().getFile_size_label().setVisible(true);
                this.getView().getFile_size_label().setText(MiscTools.formatBytes(this._file_size));
            });
            MiscTools.GUIRun(() -> {
                this.getView().getClose_button().setVisible(true);
                this.getView().getQueue_up_button().setVisible(true);
                this.getView().getQueue_down_button().setVisible(true);
                this.getView().getQueue_top_button().setVisible(true);
                this.getView().getQueue_bottom_button().setVisible(true);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause_worker() {
        Object object = this._workers_lock;
        synchronized (object) {
            if (++this._paused_workers == this._chunkworkers.size() && !this._exit) {
                this.getView().printStatusNormal("Download paused!");
                MiscTools.GUIRun(() -> {
                    this.getView().getPause_button().setText(LabelTranslatorSingleton.getInstance().translate("RESUME DOWNLOAD"));
                    this.getView().getPause_button().setEnabled(true);
                });
            }
        }
    }

    public void pause_worker_mono() {
        this.getView().printStatusNormal("Download paused!");
        MiscTools.GUIRun(() -> {
            this.getView().getPause_button().setText(LabelTranslatorSingleton.getInstance().translate("RESUME DOWNLOAD"));
            this.getView().getPause_button().setEnabled(true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDownloadUrlForWorker() {
        Object object = this._dl_url_lock;
        synchronized (object) {
            boolean error;
            if (this._last_download_url != null && MiscTools.checkMegaDownloadUrl(this._last_download_url)) {
                return this._last_download_url;
            }
            int conta_error = 0;
            do {
                error = false;
                try {
                    String download_url = MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/", this._url, 0) != null ? this._ma.getMegaFileDownloadUrl(this._url) : MegaCrypterAPI.getMegaFileDownloadUrl(this._url, this._file_pass, this._file_noexpire, this._ma.getSid(), this.getMain_panel().getMega_proxy_server() != null ? this.getMain_panel().getMega_proxy_server().getPort() + ":" + MiscTools.Bin2BASE64(("megacrypter:" + this.getMain_panel().getMega_proxy_server().getPassword()).getBytes("UTF-8")) + ":" + MiscTools.getMyPublicIP() : null);
                    if (MiscTools.checkMegaDownloadUrl(download_url)) {
                        this._last_download_url = download_url;
                        continue;
                    }
                    error = true;
                }
                catch (Exception ex) {
                    error = true;
                    try {
                        Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error++) * 1000L);
                    }
                    catch (InterruptedException ex2) {
                        LOG.log(Level.SEVERE, ex2.getMessage());
                    }
                }
            } while (error);
            return this._last_download_url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSlot() {
        if (!this._exit) {
            Object object = this._workers_lock;
            synchronized (object) {
                int chunk_id = this._chunkworkers.size() + 1;
                ChunkDownloader c = new ChunkDownloader(chunk_id, this);
                this._chunkworkers.add(c);
                try {
                    this._thread_pool.execute(c);
                }
                catch (RejectedExecutionException e) {
                    LOG.log(Level.INFO, e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLastStartedSlot() {
        if (!this._exit) {
            Object object = this._workers_lock;
            synchronized (object) {
                if (!this._chunkworkers.isEmpty()) {
                    MiscTools.GUIRun(() -> this.getView().getSlots_spinner().setEnabled(false));
                    for (int i = this._chunkworkers.size() - 1; i >= 0; --i) {
                        ChunkDownloader chundownloader = this._chunkworkers.get(i);
                        if (chundownloader.isExit()) continue;
                        chundownloader.setExit(true);
                        chundownloader.secureNotify();
                        this._view.updateSlotsStatus();
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThisSlot(ChunkDownloader chunkdownloader) {
        Object object = this._workers_lock;
        synchronized (object) {
            if (this._chunkworkers.remove(chunkdownloader) && !this._exit) {
                if (this._use_slots) {
                    if (chunkdownloader.isChunk_exception() || this.getMain_panel().isExit()) {
                        this._finalizing = true;
                        MiscTools.GUIRun(() -> {
                            this.getView().getSlots_spinner().setEnabled(false);
                            this.getView().getSlots_spinner().setValue((Integer)this.getView().getSlots_spinner().getValue() - 1);
                        });
                    } else if (!this._finalizing) {
                        MiscTools.GUIRun(() -> this.getView().getSlots_spinner().setEnabled(true));
                    }
                    this.getView().updateSlotsStatus();
                }
                if (!this._exit && this.isPause() && this._paused_workers == this._chunkworkers.size()) {
                    this.getView().printStatusNormal("Download paused!");
                    MiscTools.GUIRun(() -> {
                        this.getView().getPause_button().setText(LabelTranslatorSingleton.getInstance().translate("RESUME DOWNLOAD"));
                        this.getView().getPause_button().setEnabled(true);
                    });
                }
            }
        }
    }

    private boolean verifyFileCBCMAC(String filename) throws FileNotFoundException, Exception, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        int old_thread_priority = Thread.currentThread().getPriority();
        int[] int_key = MiscTools.bin2i32a(MiscTools.UrlBASE642Bin(this._file_key));
        int[] iv = new int[]{int_key[4], int_key[5]};
        int[] meta_mac = new int[]{int_key[6], int_key[7]};
        int[] file_mac = new int[]{0, 0, 0, 0};
        int[] cbc_iv = new int[]{0, 0, 0, 0};
        byte[] byte_file_key = CryptTools.initMEGALinkKey(this.getFile_key());
        Cipher cryptor = CryptTools.genCrypter("AES", "AES/CBC/NoPadding", byte_file_key, MiscTools.i32a2bin(cbc_iv));
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));){
            int[] cbc;
            long chunk_id = 1L;
            long tot = 0L;
            byte[] byte_block = new byte[16];
            int[] chunk_mac = new int[4];
            try {
                while (!this._exit) {
                    int i;
                    int reads;
                    long chunk_offset = ChunkWriterManager.calculateChunkOffset(chunk_id, 1);
                    long chunk_size = ChunkWriterManager.calculateChunkSize(chunk_id, this.getFile_size(), chunk_offset, 1);
                    ChunkWriterManager.checkChunkID(chunk_id, this.getFile_size(), chunk_offset);
                    tot += chunk_size;
                    chunk_mac[0] = iv[0];
                    chunk_mac[1] = iv[1];
                    chunk_mac[2] = iv[0];
                    chunk_mac[3] = iv[1];
                    for (long conta_chunk = 0L; conta_chunk < chunk_size && (reads = is.read(byte_block)) != -1; conta_chunk += (long)reads) {
                        if (reads < byte_block.length) {
                            for (i = reads; i < byte_block.length; ++i) {
                                byte_block[i] = 0;
                            }
                        }
                        int[] int_block = MiscTools.bin2i32a(byte_block);
                        for (i = 0; i < chunk_mac.length; ++i) {
                            int n = i;
                            chunk_mac[n] = chunk_mac[n] ^ int_block[i];
                        }
                        chunk_mac = MiscTools.bin2i32a(cryptor.doFinal(MiscTools.i32a2bin(chunk_mac)));
                    }
                    for (i = 0; i < file_mac.length; ++i) {
                        int n = i;
                        file_mac[n] = file_mac[n] ^ chunk_mac[i];
                    }
                    file_mac = MiscTools.bin2i32a(cryptor.doFinal(MiscTools.i32a2bin(file_mac)));
                    this.setProgress(tot);
                    ++chunk_id;
                }
            }
            catch (ChunkInvalidException chunk_offset) {
                // empty catch block
            }
            boolean bl = (cbc = new int[]{file_mac[0] ^ file_mac[1], file_mac[2] ^ file_mac[3]})[0] == meta_mac[0] && cbc[1] == meta_mac[1];
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownloader() {
        if (!this._exit) {
            this._exit = true;
            if (this.isRetrying_request()) {
                this.getView().stop("Retrying cancelled! " + MiscTools.truncateText(this._url, 80));
            } else if (this.isChecking_cbc()) {
                this.getView().stop("Verification cancelled! " + MiscTools.truncateText(this._file_name, 80));
            } else {
                this.getView().stop("Stopping download, please wait...");
                Object object = this._workers_lock;
                synchronized (object) {
                    this._chunkworkers.forEach(downloader -> downloader.secureNotify());
                }
                this.secureNotify();
            }
        }
    }

    public void stopDownloader(String reason) {
        this._status_error = reason != null ? LabelTranslatorSingleton.getInstance().translate("FATAL ERROR! ") + reason : LabelTranslatorSingleton.getInstance().translate("FATAL ERROR! ");
        this.stopDownloader();
    }

    public long calculateMaxTempFileSize(long size) {
        long tot;
        if (size > 0x380000L) {
            long reminder = (size - 0x380000L) % (long)(0x100000 * (this.isUse_slots() ? 20 : 1));
            return reminder == 0L ? size : size - reminder;
        }
        long i = 0L;
        for (tot = 0L; tot < size; tot += ++i * 128L * 1024L) {
        }
        return tot == size ? size : tot - i * 128L * 1024L;
    }

    public String[] getMegaFileMetadata(String link, MainPanelView panel, boolean retry_request) throws APIException {
        boolean error;
        String[] file_info = null;
        int retry = 0;
        do {
            error = false;
            try {
                if (MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/", link, 0) != null) {
                    file_info = this._ma.getMegaFileMetadata(link);
                    continue;
                }
                file_info = MegaCrypterAPI.getMegaFileMetadata(link, panel, this.getMain_panel().getMega_proxy_server() != null ? this.getMain_panel().getMega_proxy_server().getPort() + ":" + MiscTools.Bin2BASE64(("megacrypter:" + this.getMain_panel().getMega_proxy_server().getPassword()).getBytes("UTF-8")) : null);
            }
            catch (APIException ex) {
                error = true;
                this._status_error = ex.getMessage();
                int error_code = ex.getCode();
                if (error_code == -16) {
                    this._status_error = "ERROR: MEGA FILE BLOCKED/DELETED";
                }
                if (Arrays.asList(FATAL_API_ERROR_CODES).contains(error_code)) {
                    this._auto_retry_on_error = Arrays.asList(FATAL_API_ERROR_CODES_WITH_RETRY).contains(error_code);
                    this.stopDownloader(error_code == -16 ? this._status_error : ex.getMessage() + " " + MiscTools.truncateText(link, 80));
                    continue;
                }
                if (!retry_request) {
                    throw ex;
                }
                this._retrying_request = true;
                MiscTools.GUIRun(() -> {
                    this.getView().getStop_button().setVisible(true);
                    this.getView().getStop_button().setText(LabelTranslatorSingleton.getInstance().translate("CANCEL RETRY"));
                });
                for (long i = MiscTools.getWaitTimeExpBackOff(retry++); i > 0L && !this._exit; --i) {
                    if (error_code == -18) {
                        this.getView().printStatusError(LabelTranslatorSingleton.getInstance().translate("File temporarily unavailable! (Retrying in ") + i + LabelTranslatorSingleton.getInstance().translate(" secs...)"));
                    } else {
                        this.getView().printStatusError("Mega/MC APIException error " + ex.getMessage() + LabelTranslatorSingleton.getInstance().translate(" (Retrying in ") + i + LabelTranslatorSingleton.getInstance().translate(" secs...)"));
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof APIException) continue;
                this.stopDownloader("Mega link is not valid! " + MiscTools.truncateText(link, 80));
            }
        } while (!this._exit && error);
        if (!this._exit && !error) {
            this._auto_retry_on_error = true;
            MiscTools.GUIRun(() -> {
                this.getView().getStop_button().setText(LabelTranslatorSingleton.getInstance().translate("CANCEL DOWNLOAD"));
                this.getView().getStop_button().setVisible(false);
            });
        }
        this._retrying_request = false;
        return file_info;
    }

    public String getMegaFileDownloadUrl(String link) throws IOException, InterruptedException {
        boolean error;
        String dl_url = null;
        int retry = 0;
        do {
            error = false;
            try {
                if (MiscTools.findFirstRegex("://mega(\\.co)?\\.nz/", this._url, 0) != null) {
                    dl_url = this._ma.getMegaFileDownloadUrl(link);
                    continue;
                }
                dl_url = MegaCrypterAPI.getMegaFileDownloadUrl(link, this._file_pass, this._file_noexpire, this._ma.getSid(), this.getMain_panel().getMega_proxy_server() != null ? this.getMain_panel().getMega_proxy_server().getPort() + ":" + MiscTools.Bin2BASE64(("megacrypter:" + this.getMain_panel().getMega_proxy_server().getPassword()).getBytes("UTF-8")) + ":" + MiscTools.getMyPublicIP() : null);
            }
            catch (APIException ex) {
                error = true;
                int error_code = ex.getCode();
                if (error_code == -16) {
                    this._status_error = "ERROR: MEGA FILE BLOCKED/DELETED";
                }
                if (Arrays.asList(FATAL_API_ERROR_CODES).contains(error_code)) {
                    this._auto_retry_on_error = Arrays.asList(FATAL_API_ERROR_CODES_WITH_RETRY).contains(error_code);
                    this.stopDownloader(error_code == -16 ? this._status_error : ex.getMessage() + " " + MiscTools.truncateText(link, 80));
                    continue;
                }
                this._retrying_request = true;
                MiscTools.GUIRun(() -> {
                    this.getView().getStop_button().setVisible(true);
                    this.getView().getStop_button().setText(LabelTranslatorSingleton.getInstance().translate("CANCEL RETRY"));
                });
                for (long i = MiscTools.getWaitTimeExpBackOff(retry++); i > 0L && !this._exit; --i) {
                    if (error_code == -18) {
                        this.getView().printStatusError("File temporarily unavailable! (Retrying in " + i + " secs...)");
                    } else {
                        this.getView().printStatusError("Mega/MC APIException error " + ex.getMessage() + " (Retrying in " + i + " secs...)");
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (!this._exit && error);
        if (!this._exit && !error) {
            this._auto_retry_on_error = true;
            MiscTools.GUIRun(() -> {
                this.getView().getStop_button().setText(LabelTranslatorSingleton.getInstance().translate("CANCEL DOWNLOAD"));
                this.getView().getStop_button().setVisible(false);
            });
        }
        this._retrying_request = false;
        return dl_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextChunkId() throws ChunkInvalidException {
        Object object = this._chunkid_lock;
        synchronized (object) {
            if (this._main_panel.isExit()) {
                throw new ChunkInvalidException(null);
            }
            Long next_id = this._rejectedChunkIds.poll();
            if (next_id != null) {
                return next_id;
            }
            return ++this._last_chunk_id_dispatched;
        }
    }

    public void rejectChunkId(long chunk_id) {
        this._rejectedChunkIds.add(chunk_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this._notified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgress(long progress) {
        Object object = this._progress_lock;
        synchronized (object) {
            long old_progress = this._progress;
            this._progress = progress;
            this.getMain_panel().getDownload_manager().increment_total_progress(this._progress - old_progress);
            int old_percent_progress = (int)Math.floor((double)old_progress / (double)this._file_size.longValue() * 100.0);
            int new_percent_progress = (int)Math.floor((double)progress / (double)this._file_size.longValue() * 100.0);
            if (new_percent_progress == 100 && progress != this._file_size) {
                new_percent_progress = 99;
            }
            if (new_percent_progress > old_percent_progress) {
                this.getView().updateProgressBar(this._progress, this._progress_bar_rate);
            }
        }
    }

    @Override
    public boolean isStatusError() {
        return this._status_error != null;
    }

    @Override
    public int getSlotsCount() {
        return this.getChunkworkers().size();
    }

    @Override
    public boolean isFrozen() {
        return this._frozen;
    }

    @Override
    public void unfreeze() {
        this.getView().printStatusNormal(this.getView().getStatus_label().getText().replaceFirst("^\\([^)]+\\) ", ""));
        this._frozen = false;
    }

    @Override
    public void upWaitQueue() {
        this._main_panel.getDownload_manager().upWaitQueue(this);
    }

    @Override
    public void downWaitQueue() {
        this._main_panel.getDownload_manager().downWaitQueue(this);
    }

    @Override
    public void bottomWaitQueue() {
        this._main_panel.getDownload_manager().bottomWaitQueue(this);
    }

    @Override
    public void topWaitQueue() {
        this._main_panel.getDownload_manager().topWaitQueue(this);
    }

    @Override
    public boolean isRestart() {
        return this._restart;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public int getPausedWorkers() {
        return this._paused_workers;
    }

    @Override
    public int getTotWorkers() {
        return this.getChunkworkers().size();
    }
}

