/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class ContextMenuMouseListener
extends MouseAdapter {
    private static final Logger LOG = Logger.getLogger(ContextMenuMouseListener.class.getName());
    private final JPopupMenu _popup = new JPopupMenu();
    private final Action _cutAction;
    private final Action _copyAction;
    private final Action _pasteAction;
    private final Action _undoAction = new AbstractAction("Undo"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ContextMenuMouseListener.this._textComponent.setText("");
            ContextMenuMouseListener.this._textComponent.replaceSelection(ContextMenuMouseListener.this._savedString);
            ContextMenuMouseListener.this._lastActionSelected = _Actions.UNDO;
        }
    };
    private final Action _selectAllAction;
    private JTextComponent _textComponent;
    private String _savedString = "";
    private _Actions _lastActionSelected;

    public ContextMenuMouseListener() {
        this._popup.add(this._undoAction);
        this._popup.addSeparator();
        this._cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this._lastActionSelected = _Actions.CUT;
                ContextMenuMouseListener.this._savedString = ContextMenuMouseListener.this._textComponent.getText();
                ContextMenuMouseListener.this._textComponent.cut();
            }
        };
        this._popup.add(this._cutAction);
        this._copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this._lastActionSelected = _Actions.COPY;
                ContextMenuMouseListener.this._textComponent.copy();
            }
        };
        this._popup.add(this._copyAction);
        this._pasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this._lastActionSelected = _Actions.PASTE;
                ContextMenuMouseListener.this._savedString = ContextMenuMouseListener.this._textComponent.getText();
                ContextMenuMouseListener.this._textComponent.paste();
            }
        };
        this._popup.add(this._pasteAction);
        this._popup.addSeparator();
        this._selectAllAction = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this._lastActionSelected = _Actions.SELECT_ALL;
                ContextMenuMouseListener.this._textComponent.selectAll();
            }
        };
        this._popup.add(this._selectAllAction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            if (!(e.getSource() instanceof JTextComponent)) {
                return;
            }
            this._textComponent = (JTextComponent)e.getSource();
            this._textComponent.requestFocus();
            boolean enabled = this._textComponent.isEnabled();
            boolean editable = this._textComponent.isEditable();
            boolean nonempty = this._textComponent.getText() != null && !this._textComponent.getText().isEmpty();
            boolean marked = this._textComponent.getSelectedText() != null;
            boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
            this._undoAction.setEnabled(enabled && editable && (this._lastActionSelected == _Actions.CUT || this._lastActionSelected == _Actions.PASTE));
            this._cutAction.setEnabled(enabled && editable && marked);
            this._copyAction.setEnabled(enabled && marked);
            this._pasteAction.setEnabled(enabled && editable && pasteAvailable);
            this._selectAllAction.setEnabled(enabled && nonempty);
            int nx = e.getX();
            if (nx > 500) {
                nx -= this._popup.getSize().width;
            }
            this._popup.show(e.getComponent(), nx, e.getY() - this._popup.getSize().height);
        }
    }

    private static enum _Actions {
        UNDO,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL;

    }
}

