/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ClipboardChangeObservable;
import com.tonikelope.megabasterd.ClipboardChangeObserver;
import com.tonikelope.megabasterd.DBTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipboardSpy
implements Runnable,
ClipboardOwner,
SecureSingleThreadNotifiable,
ClipboardChangeObservable {
    private static final int SLEEP = 250;
    private static final Logger LOG = Logger.getLogger(ClipboardSpy.class.getName());
    private final Clipboard _sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
    private volatile boolean _notified = false;
    private final ConcurrentLinkedQueue<ClipboardChangeObserver> _observers;
    private Transferable _contents = null;
    private final Object _secure_notify_lock = new Object();
    private volatile boolean _enabled = false;

    public ClipboardSpy() {
        this._observers = new ConcurrentLinkedQueue();
    }

    @Override
    public Transferable getContents() {
        return this._contents;
    }

    private void _setEnabled(boolean enabled) {
        this._enabled = enabled;
        boolean monitor_clipboard = true;
        String monitor_clipboard_string = DBTools.selectSettingValue("clipboardspy");
        if (monitor_clipboard_string != null) {
            monitor_clipboard = monitor_clipboard_string.equals("yes");
        }
        if (this._enabled && monitor_clipboard) {
            this._contents = this.getClipboardContents();
            this.notifyChangeToMyObservers();
            this.gainOwnership(this._contents);
            LOG.log(Level.INFO, "{0} Monitoring clipboard ON...", Thread.currentThread().getName());
        } else if (monitor_clipboard) {
            LOG.log(Level.INFO, "{0} Monitoring clipboard OFF...", Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified = false;
        }
    }

    @Override
    public void run() {
        this.secureWait();
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
        if (this._enabled) {
            this._contents = this.getClipboardContents();
            this.notifyChangeToMyObservers();
            this.gainOwnership(this._contents);
        }
    }

    private Transferable getClipboardContents() {
        boolean error;
        Transferable c = null;
        do {
            error = false;
            try {
                c = this._sysClip.getContents(this);
            }
            catch (Exception ex) {
                error = true;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex1) {
                    LOG.log(Level.SEVERE, ex1.getMessage());
                }
            }
        } while (error);
        return c;
    }

    private void gainOwnership(Transferable t) {
        boolean error;
        do {
            error = false;
            try {
                this._sysClip.setContents(t, this);
            }
            catch (Exception ex) {
                error = true;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex1) {
                    LOG.log(Level.SEVERE, ex1.getMessage());
                }
            }
        } while (error);
    }

    @Override
    public void attachObserver(ClipboardChangeObserver observer) {
        if (!this._observers.contains(observer)) {
            this._observers.add(observer);
        }
        if (!this._observers.isEmpty() && !this._enabled) {
            this._setEnabled(true);
        }
    }

    @Override
    public void detachObserver(ClipboardChangeObserver observer) {
        if (this._observers.contains(observer)) {
            this._observers.remove(observer);
            if (this._observers.isEmpty() && this._enabled) {
                this._setEnabled(false);
            }
        }
    }

    @Override
    public void notifyChangeToMyObservers() {
        this._observers.forEach(o -> o.notifyClipboardChange());
    }
}

