/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;

public class ChunkWriterManager
implements Runnable,
SecureSingleThreadNotifiable {
    private static final Logger LOG = Logger.getLogger(ChunkWriterManager.class.getName());
    private static final ReentrantLock JOIN_CHUNKS_LOCK = new ReentrantLock();
    private volatile long _last_chunk_id_written;
    private volatile long _bytes_written;
    private final long _file_size;
    private final Download _download;
    private final byte[] _byte_file_key;
    private final byte[] _byte_iv;
    private volatile boolean _exit = false;
    private final Object _secure_notify_lock;
    private volatile boolean _notified = false;
    private final String _chunks_dir;

    public static long calculateChunkOffset(long chunk_id, int size_multi) {
        long[] offs = new long[]{0L, 128L, 384L, 768L, 1280L, 1920L, 2688L};
        return (chunk_id <= 7L ? offs[(int)chunk_id - 1] : 3584L + (chunk_id - 8L) * 1024L * (long)size_multi) * 1024L;
    }

    public static String genChunkUrl(String file_url, long file_size, long offset, long chunk_size) {
        return file_url != null ? file_url + "/" + offset + (offset + chunk_size == file_size ? "" : "-" + (offset + chunk_size - 1L)) : null;
    }

    public static void checkChunkID(long chunk_id, long file_size, long offset) throws ChunkInvalidException {
        if (file_size > 0L ? offset >= file_size : chunk_id > 1L) {
            throw new ChunkInvalidException(String.valueOf(chunk_id));
        }
    }

    public static long calculateChunkSize(long chunk_id, long file_size, long offset, int size_multi) {
        long chunk_size;
        long l = chunk_size = chunk_id >= 1L && chunk_id <= 7L ? chunk_id * 128L * 1024L : (long)(0x100000 * size_multi);
        if (offset + chunk_size > file_size) {
            chunk_size = file_size - offset;
        }
        return chunk_size;
    }

    public ChunkWriterManager(Download downloader) throws Exception {
        this._download = downloader;
        this._chunks_dir = this._create_chunks_temp_dir();
        this._secure_notify_lock = new Object();
        this._file_size = this._download.getFile_size();
        this._byte_file_key = CryptTools.initMEGALinkKey(this._download.getFile_key());
        this._byte_iv = CryptTools.initMEGALinkKeyIV(this._download.getFile_key());
        if (this._download.getProgress() == 0L) {
            this._last_chunk_id_written = 0L;
            this._bytes_written = 0L;
        } else {
            this._last_chunk_id_written = this._download.getLast_chunk_id_dispatched();
            this._bytes_written = this._download.getProgress();
        }
    }

    public String getChunks_dir() {
        return this._chunks_dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified = false;
        }
    }

    public boolean isExit() {
        return this._exit;
    }

    public long getLast_chunk_id_written() {
        return this._last_chunk_id_written;
    }

    private String _create_chunks_temp_dir() {
        File chunks_temp_dir = new File((this._download.getCustom_chunks_dir() != null ? this._download.getCustom_chunks_dir() : this._download.getDownload_path()) + "/.MEGABASTERD_CHUNKS_" + MiscTools.HashString("sha1", this._download.getUrl()));
        chunks_temp_dir.mkdirs();
        return chunks_temp_dir.getAbsolutePath();
    }

    public void delete_chunks_temp_dir() {
        try {
            MiscTools.deleteDirectoryRecursion(Paths.get(this.getChunks_dir(), new String[0]));
        }
        catch (IOException ex) {
            Logger.getLogger(ChunkWriterManager.class.getName()).log(Level.SEVERE, ex.getMessage());
        }
    }

    private void finishDownload() {
        this._download.getMain_panel().getDownload_manager().getTransference_running_list().remove(this._download);
        this._download.getMain_panel().getDownload_manager().secureNotify();
        this._download.getView().printStatusNormal("Download finished. Joining file chunks, please wait...");
        this._download.getView().getPause_button().setVisible(false);
        this._download.getMain_panel().getGlobal_dl_speed().detachTransference(this._download);
        this._download.getView().getSpeed_label().setVisible(false);
        this._download.getView().getSlots_label().setVisible(false);
        this._download.getView().getSlot_status_label().setVisible(false);
        this._download.getView().getSlots_spinner().setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} ChunkWriterManager: let's do some work! {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
        LOG.log(Level.INFO, "{0} ChunkWriterManager LAST CHUNK WRITTEN -> [{1}] {2} {3}...", new Object[]{Thread.currentThread().getName(), this._last_chunk_id_written, this._bytes_written, this._download.getFile_name()});
        boolean download_finished = false;
        if (this._file_size > 0L) {
            block23: {
                try {
                    while (!(this._exit || this._download.isStopped() && this._download.getChunkworkers().isEmpty() || this._bytes_written >= this._file_size)) {
                        boolean chunk_io_error;
                        if (!JOIN_CHUNKS_LOCK.isHeldByCurrentThread()) {
                            LOG.log(Level.INFO, "{0} ChunkWriterManager: JOIN LOCK LOCKED FOR {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
                            JOIN_CHUNKS_LOCK.lock();
                        }
                        if (!download_finished && this._download.getProgress() == this._file_size) {
                            this.finishDownload();
                            download_finished = true;
                        }
                        do {
                            chunk_io_error = false;
                            try {
                                File chunk_file = new File(this.getChunks_dir() + "/" + MiscTools.HashString("sha1", this._download.getUrl()) + ".chunk" + String.valueOf(this._last_chunk_id_written + 1L));
                                while (chunk_file.exists() && chunk_file.canRead() && chunk_file.canWrite() && chunk_file.length() > 0L) {
                                    if (!download_finished && this._download.getProgress() == this._file_size) {
                                        this.finishDownload();
                                        download_finished = true;
                                    }
                                    byte[] buffer = new byte[16384];
                                    try (CipherInputStream cis = new CipherInputStream(new BufferedInputStream(new FileInputStream(chunk_file)), CryptTools.genDecrypter("AES", "AES/CTR/NoPadding", this._byte_file_key, CryptTools.forwardMEGALinkKeyIV(this._byte_iv, this._bytes_written)));){
                                        int reads;
                                        while ((reads = cis.read(buffer)) != -1) {
                                            this._download.getOutput_stream().write(buffer, 0, reads);
                                        }
                                    }
                                    catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
                                        LOG.log(Level.SEVERE, ex.getMessage());
                                    }
                                    this._bytes_written += chunk_file.length();
                                    ++this._last_chunk_id_written;
                                    LOG.log(Level.INFO, "{0} ChunkWriterManager has written to disk chunk [{1}] {2} {3} {4}...", new Object[]{Thread.currentThread().getName(), this._last_chunk_id_written, this._bytes_written, this._download.calculateLastWrittenChunk(this._bytes_written), this._download.getFile_name()});
                                    chunk_file.delete();
                                    chunk_file = new File(this.getChunks_dir() + "/" + MiscTools.HashString("sha1", this._download.getUrl()) + ".chunk" + String.valueOf(this._last_chunk_id_written + 1L));
                                }
                            }
                            catch (IOException ex) {
                                chunk_io_error = true;
                                LOG.log(Level.WARNING, ex.getMessage());
                                MiscTools.pausar(1000L);
                            }
                        } while (chunk_io_error);
                        if (this._exit || this._download.isStopped() && this._download.getChunkworkers().isEmpty() || this._bytes_written >= this._file_size) continue;
                        LOG.log(Level.INFO, "{0} ChunkWriterManager waiting for chunk [{1}] {2}...", new Object[]{Thread.currentThread().getName(), this._last_chunk_id_written + 1L, this._download.getFile_name()});
                        if (JOIN_CHUNKS_LOCK.isHeldByCurrentThread() && JOIN_CHUNKS_LOCK.isLocked()) {
                            LOG.log(Level.INFO, "{0} ChunkWriterManager: JOIN LOCK RELEASED FOR {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
                            JOIN_CHUNKS_LOCK.unlock();
                        }
                        this.secureWait();
                    }
                    if (!JOIN_CHUNKS_LOCK.isHeldByCurrentThread() || !JOIN_CHUNKS_LOCK.isLocked()) break block23;
                }
                catch (Throwable throwable) {
                    if (JOIN_CHUNKS_LOCK.isHeldByCurrentThread() && JOIN_CHUNKS_LOCK.isLocked()) {
                        LOG.log(Level.INFO, "{0} ChunkWriterManager: JOIN LOCK RELEASED FOR {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
                        JOIN_CHUNKS_LOCK.unlock();
                    }
                    throw throwable;
                }
                LOG.log(Level.INFO, "{0} ChunkWriterManager: JOIN LOCK RELEASED FOR {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
                JOIN_CHUNKS_LOCK.unlock();
            }
            if (this._bytes_written == this._file_size && MiscTools.isDirEmpty(Paths.get(this.getChunks_dir(), new String[0]))) {
                this.delete_chunks_temp_dir();
            }
        }
        this._exit = true;
        this._download.secureNotify();
        LOG.log(Level.INFO, "{0} ChunkWriterManager: bye bye {1}", new Object[]{Thread.currentThread().getName(), this._download.getFile_name()});
    }
}

