/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.ChunkWriterManager;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MegaAPI;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.ThrottledOutputStream;
import com.tonikelope.megabasterd.Upload;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.CipherInputStream;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.QueueOutputStream;

public class ChunkUploader
implements Runnable,
SecureSingleThreadNotifiable {
    public static final int MAX_CHUNK_ERROR = 50;
    private static final Logger LOG = Logger.getLogger(ChunkUploader.class.getName());
    private final int _id;
    private final Upload _upload;
    private volatile boolean _exit;
    private final Object _secure_notify_lock = new Object();
    private volatile boolean _error_wait;
    private volatile boolean _notified = false;
    private volatile boolean _chunk_exception;

    public ChunkUploader(int id, Upload upload) {
        this._id = id;
        this._upload = upload;
        this._chunk_exception = false;
        this._exit = false;
        this._error_wait = false;
    }

    public boolean isChunk_exception() {
        return this._chunk_exception;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    public boolean isError_wait() {
        return this._error_wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified = false;
        }
    }

    public int getId() {
        return this._id;
    }

    public boolean isExit() {
        return this._exit;
    }

    public Upload getUpload() {
        return this._upload;
    }

    public void setError_wait(boolean error_wait) {
        this._error_wait = error_wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} ChunkUploader {1} hello! {2}", new Object[]{Thread.currentThread().getName(), this.getId(), this._upload.getFile_name()});
        long chunk_id = 0L;
        byte[] buffer = new byte[16384];
        byte[] buffer_enc = new byte[16384];
        boolean fatal_error = false;
        int conta_error = 0;
        try {
            while (!(this._upload.getMain_panel().isExit() || this._exit || this._upload.isStopped() || conta_error >= 50 || fatal_error)) {
                HttpURLConnection con;
                block85: {
                    block82: {
                        boolean timeout;
                        block86: {
                            block84: {
                                if (this._upload.isPaused() && !this._upload.isStopped()) {
                                    this._upload.pause_worker();
                                    this.secureWait();
                                }
                                String worker_url = this._upload.getUl_url();
                                int reads = 0;
                                chunk_id = this._upload.nextChunkId();
                                long chunk_offset = ChunkWriterManager.calculateChunkOffset(chunk_id, 1);
                                long chunk_size = ChunkWriterManager.calculateChunkSize(chunk_id, this._upload.getFile_size(), chunk_offset, 1);
                                ChunkWriterManager.checkChunkID(chunk_id, this._upload.getFile_size(), chunk_offset);
                                String chunk_url = ChunkWriterManager.genChunkUrl(worker_url, this._upload.getFile_size(), chunk_offset, chunk_size);
                                URL url = new URL(chunk_url);
                                if (MainPanel.isUse_proxy()) {
                                    con = (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                                    if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                                        con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                                    }
                                } else {
                                    con = (HttpURLConnection)url.openConnection();
                                }
                                con.setConnectTimeout(60000);
                                con.setReadTimeout(60000);
                                con.setRequestMethod("POST");
                                con.setDoOutput(true);
                                con.setUseCaches(false);
                                con.setFixedLengthStreamingMode(chunk_size);
                                con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                                long tot_bytes_up = 0L;
                                boolean chunk_error = true;
                                timeout = false;
                                try {
                                    if (!this._exit) {
                                        RandomAccessFile f = new RandomAccessFile(this._upload.getFile_name(), "r");
                                        f.seek(chunk_offset);
                                        ByteArrayOutputStream chunk_mac = new ByteArrayOutputStream();
                                        try (QueueInputStream qis = new QueueInputStream();
                                             QueueOutputStream qos = qis.newQueueOutputStream();
                                             BufferedInputStream bis = new BufferedInputStream(Channels.newInputStream(f.getChannel()));
                                             CipherInputStream cis = new CipherInputStream(qis, CryptTools.genCrypter("AES", "AES/CTR/NoPadding", this._upload.getByte_file_key(), CryptTools.forwardMEGALinkKeyIV(this._upload.getByte_file_iv(), chunk_offset)));
                                             ThrottledOutputStream out = new ThrottledOutputStream(con.getOutputStream(), this._upload.getMain_panel().getStream_supervisor());){
                                            LOG.log(Level.INFO, "{0} Uploading chunk {1} from worker {2} {3}...", new Object[]{Thread.currentThread().getName(), chunk_id, this._id, this._upload.getFile_name()});
                                            while (!this._exit && tot_bytes_up < chunk_size && (reads = bis.read(buffer)) != -1) {
                                                int i;
                                                chunk_mac.write(buffer, 0, reads);
                                                for (i = 0; i < reads; ++i) {
                                                    qos.write(buffer[i]);
                                                }
                                                for (i = 0; i < reads; ++i) {
                                                    buffer_enc[i] = (byte)cis.read();
                                                }
                                                ((OutputStream)out).write(buffer_enc, 0, reads);
                                                this._upload.getPartialProgress().add(Long.valueOf(reads));
                                                this._upload.getProgress_meter().secureNotify();
                                                if (!this._upload.isPaused() || this._exit || this._upload.isStopped() || (tot_bytes_up += (long)reads) >= chunk_size) continue;
                                                this._upload.pause_worker();
                                                this.secureWait();
                                            }
                                            this._upload.getMac_generator().CHUNK_QUEUE.put(chunk_offset, chunk_mac);
                                        }
                                        if (!this._exit) {
                                            int http_status = con.getResponseCode();
                                            if (http_status != 200) {
                                                LOG.log(Level.INFO, "{0} Worker {1} Failed : HTTP error code : {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, http_status, this._upload.getFile_name()});
                                            } else if (tot_bytes_up == chunk_size || reads == -1) {
                                                String httpresponse;
                                                if (this._upload.getProgress() == this._upload.getFile_size()) {
                                                    this._upload.getView().printStatusWarning("Waiting for completion handler ... ***DO NOT EXIT MEGABASTERD NOW***");
                                                    this._upload.getView().getPause_button().setEnabled(false);
                                                }
                                                try (InputStream is = con.getInputStream();
                                                     ByteArrayOutputStream byte_res = new ByteArrayOutputStream();){
                                                    while ((reads = is.read(buffer)) != -1) {
                                                        byte_res.write(buffer, 0, reads);
                                                    }
                                                    httpresponse = new String(byte_res.toByteArray(), "UTF-8");
                                                }
                                                if (httpresponse.length() > 0) {
                                                    if (MegaAPI.checkMEGAError(httpresponse) != 0) {
                                                        LOG.log(Level.WARNING, "{0} Worker {1} UPLOAD FAILED! (MEGA ERROR: {2}) {3}", new Object[]{Thread.currentThread().getName(), this._id, MegaAPI.checkMEGAError(httpresponse), this._upload.getFile_name()});
                                                        fatal_error = true;
                                                    } else {
                                                        LOG.log(Level.INFO, "{0} Worker {1} Completion handler -> {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, httpresponse, this._upload.getFile_name()});
                                                        this._upload.setCompletion_handler(httpresponse);
                                                        chunk_error = false;
                                                    }
                                                } else if (this._upload.getProgress() != this._upload.getFile_size() || this._upload.getCompletion_handler() != null) {
                                                    chunk_error = false;
                                                }
                                            }
                                        }
                                        if (this._upload.getMain_panel().isExit()) {
                                            this.secureWait();
                                        }
                                    }
                                    if (!chunk_error) break block82;
                                }
                                catch (IOException ex) {
                                    block92: {
                                        block83: {
                                            block93: {
                                                block91: {
                                                    try {
                                                        if (ex instanceof SocketTimeoutException) {
                                                            timeout = true;
                                                            LOG.log(Level.SEVERE, "{0} Worker {1} {2} timeout reading chunk {3}", new Object[]{Thread.currentThread().getName(), this._id, this._upload.getFile_name(), chunk_id});
                                                        } else {
                                                            LOG.log(Level.SEVERE, ex.getMessage());
                                                        }
                                                        if (!chunk_error) break block83;
                                                    }
                                                    catch (Throwable throwable) {
                                                        block89: {
                                                            block87: {
                                                                block90: {
                                                                    block88: {
                                                                        if (!chunk_error) break block87;
                                                                        LOG.log(Level.WARNING, "{0} Uploading chunk {1} from worker {2} FAILED! {3}...", new Object[]{Thread.currentThread().getName(), chunk_id, this._id, this._upload.getFile_name()});
                                                                        this._upload.rejectChunkId(chunk_id);
                                                                        if (tot_bytes_up > 0L) {
                                                                            this._upload.getPartialProgress().add(-1L * tot_bytes_up);
                                                                            this._upload.getProgress_meter().secureNotify();
                                                                        }
                                                                        if (!fatal_error) break block88;
                                                                        this._upload.stopUploader("UPLOAD FAILED: FATAL ERROR");
                                                                        LOG.log(Level.SEVERE, "UPLOAD FAILED: FATAL ERROR {0}", new Object[]{this._upload.getFile_name()});
                                                                        break block89;
                                                                    }
                                                                    if (++conta_error != 50) break block90;
                                                                    this._upload.stopUploader("UPLOAD FAILED: too many errors");
                                                                    LOG.log(Level.SEVERE, "UPLOAD FAILED: too many errors {0}", new Object[]{this._upload.getFile_name()});
                                                                    break block89;
                                                                }
                                                                if (!(this._exit || this._upload.isStopped() || timeout)) {
                                                                    this._error_wait = true;
                                                                    this._upload.getView().updateSlotsStatus();
                                                                    try {
                                                                        Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error) * 1000L);
                                                                    }
                                                                    catch (InterruptedException interruptedException) {
                                                                        // empty catch block
                                                                    }
                                                                    this._error_wait = false;
                                                                    this._upload.getView().updateSlotsStatus();
                                                                }
                                                                break block89;
                                                            }
                                                            LOG.log(Level.INFO, "{0} Worker {1} has uploaded chunk {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._upload.getFile_name()});
                                                            conta_error = 0;
                                                        }
                                                        con.disconnect();
                                                        throw throwable;
                                                    }
                                                    LOG.log(Level.WARNING, "{0} Uploading chunk {1} from worker {2} FAILED! {3}...", new Object[]{Thread.currentThread().getName(), chunk_id, this._id, this._upload.getFile_name()});
                                                    this._upload.rejectChunkId(chunk_id);
                                                    if (tot_bytes_up > 0L) {
                                                        this._upload.getPartialProgress().add(-1L * tot_bytes_up);
                                                        this._upload.getProgress_meter().secureNotify();
                                                    }
                                                    if (!fatal_error) break block91;
                                                    this._upload.stopUploader("UPLOAD FAILED: FATAL ERROR");
                                                    LOG.log(Level.SEVERE, "UPLOAD FAILED: FATAL ERROR {0}", new Object[]{this._upload.getFile_name()});
                                                    break block92;
                                                }
                                                if (++conta_error != 50) break block93;
                                                this._upload.stopUploader("UPLOAD FAILED: too many errors");
                                                LOG.log(Level.SEVERE, "UPLOAD FAILED: too many errors {0}", new Object[]{this._upload.getFile_name()});
                                                break block92;
                                            }
                                            if (!(this._exit || this._upload.isStopped() || timeout)) {
                                                this._error_wait = true;
                                                this._upload.getView().updateSlotsStatus();
                                                try {
                                                    Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error) * 1000L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                                this._error_wait = false;
                                                this._upload.getView().updateSlotsStatus();
                                            }
                                            break block92;
                                        }
                                        LOG.log(Level.INFO, "{0} Worker {1} has uploaded chunk {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._upload.getFile_name()});
                                        conta_error = 0;
                                    }
                                    con.disconnect();
                                    continue;
                                }
                                LOG.log(Level.WARNING, "{0} Uploading chunk {1} from worker {2} FAILED! {3}...", new Object[]{Thread.currentThread().getName(), chunk_id, this._id, this._upload.getFile_name()});
                                this._upload.rejectChunkId(chunk_id);
                                if (tot_bytes_up > 0L) {
                                    this._upload.getPartialProgress().add(-1L * tot_bytes_up);
                                    this._upload.getProgress_meter().secureNotify();
                                }
                                if (!fatal_error) break block84;
                                this._upload.stopUploader("UPLOAD FAILED: FATAL ERROR");
                                LOG.log(Level.SEVERE, "UPLOAD FAILED: FATAL ERROR {0}", new Object[]{this._upload.getFile_name()});
                                break block85;
                            }
                            if (++conta_error != 50) break block86;
                            this._upload.stopUploader("UPLOAD FAILED: too many errors");
                            LOG.log(Level.SEVERE, "UPLOAD FAILED: too many errors {0}", new Object[]{this._upload.getFile_name()});
                            break block85;
                        }
                        if (!(this._exit || this._upload.isStopped() || timeout)) {
                            this._error_wait = true;
                            this._upload.getView().updateSlotsStatus();
                            try {
                                Thread.sleep(MiscTools.getWaitTimeExpBackOff(conta_error) * 1000L);
                            }
                            catch (InterruptedException f) {
                                // empty catch block
                            }
                            this._error_wait = false;
                            this._upload.getView().updateSlotsStatus();
                        }
                        break block85;
                    }
                    LOG.log(Level.INFO, "{0} Worker {1} has uploaded chunk {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._upload.getFile_name()});
                    conta_error = 0;
                }
                con.disconnect();
            }
        }
        catch (ChunkInvalidException ex) {
            this._chunk_exception = true;
        }
        catch (Exception | OutOfMemoryError error) {
            this._upload.stopUploader(error.getMessage());
            LOG.log(Level.SEVERE, error.getMessage());
        }
        this._upload.stopThisSlot(this);
        this._upload.getMac_generator().secureNotify();
        LOG.log(Level.INFO, "{0} ChunkUploader [{1}] {2} bye bye...", new Object[]{Thread.currentThread().getName(), this._id, this._upload.getFile_name()});
    }
}

