/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkDownloader;
import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.ChunkWriterManager;
import com.tonikelope.megabasterd.CryptTools;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.ThrottledInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.CipherInputStream;

public class ChunkDownloaderMono
extends ChunkDownloader {
    private static final Logger LOG = Logger.getLogger(ChunkDownloaderMono.class.getName());
    public static final int READ_TIMEOUT_RETRY = 3;

    public ChunkDownloaderMono(Download download) {
        super(1, download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.log(Level.INFO, "{0} Worker [{1}]: let''s do some work! {2}", new Object[]{Thread.currentThread().getName(), this.getId(), this.getDownload().getFile_name()});
        HttpURLConnection con = null;
        try {
            String worker_url = null;
            int http_error = 0;
            int http_status = 0;
            int conta_error = 0;
            boolean chunk_error = false;
            boolean timeout = false;
            long bytes_downloaded = this.getDownload().getProgress();
            byte[] byte_file_key = CryptTools.initMEGALinkKey(this.getDownload().getFile_key());
            byte[] byte_iv = CryptTools.initMEGALinkKeyIV(this.getDownload().getFile_key());
            byte[] buffer = new byte[16384];
            CipherInputStream cis = null;
            while (!(this.getDownload().getMain_panel().isExit() || this.isExit() || this.getDownload().isStopped())) {
                if (worker_url == null || http_error == 403) {
                    worker_url = this.getDownload().getDownloadUrlForWorker();
                }
                long chunk_id = this.getDownload().nextChunkId();
                long chunk_offset = ChunkWriterManager.calculateChunkOffset(chunk_id, 1);
                long chunk_size = ChunkWriterManager.calculateChunkSize(chunk_id, this.getDownload().getFile_size(), chunk_offset, 1);
                ChunkWriterManager.checkChunkID(chunk_id, this.getDownload().getFile_size(), chunk_offset);
                long chunk_reads = 0L;
                try {
                    if (con == null || chunk_error) {
                        if (http_error == 509 && MainPanel.isRun_command()) {
                            MainPanel.run_external_command();
                        }
                        URL url = new URL(worker_url + "/" + chunk_offset);
                        if (MainPanel.isUse_proxy()) {
                            con = (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                            if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                                con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                            }
                        } else {
                            con = (HttpURLConnection)url.openConnection();
                        }
                        con.setUseCaches(false);
                        con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                        http_status = con.getResponseCode();
                        cis = new CipherInputStream(new ThrottledInputStream(con.getInputStream(), this.getDownload().getMain_panel().getStream_supervisor()), CryptTools.genDecrypter("AES", "AES/CTR/NoPadding", byte_file_key, CryptTools.forwardMEGALinkKeyIV(byte_iv, bytes_downloaded)));
                    }
                    chunk_error = true;
                    timeout = false;
                    http_error = 0;
                    if (http_status != 200) {
                        LOG.log(Level.INFO, "{0} Failed : HTTP error code : {1} {2}", new Object[]{Thread.currentThread().getName(), http_status, this.getDownload().getFile_name()});
                        http_error = http_status;
                        this.getDownload().rejectChunkId(chunk_id);
                        if (this.isExit() || http_error == 403) continue;
                        this.setError_wait(true);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException url) {
                            // empty catch block
                        }
                        this.setError_wait(false);
                        continue;
                    }
                    if (this.isExit() || this.getDownload().isStopped() || cis == null) continue;
                    int reads = 0;
                    while (!this.getDownload().isStopped() && chunk_reads < chunk_size && (reads = cis.read(buffer, 0, Math.min((int)(chunk_size - chunk_reads), buffer.length))) != -1) {
                        this.getDownload().getOutput_stream().write(buffer, 0, reads);
                        this.getDownload().getPartialProgress().add(Long.valueOf(reads));
                        this.getDownload().getProgress_meter().secureNotify();
                        if (!this.getDownload().isPaused() || this.getDownload().isStopped() || (chunk_reads += (long)reads) >= chunk_size) continue;
                        this.getDownload().pause_worker_mono();
                        this.secureWait();
                    }
                    if (chunk_reads != chunk_size) continue;
                    bytes_downloaded += chunk_reads;
                    chunk_error = false;
                    http_error = 0;
                    conta_error = 0;
                }
                catch (IOException ex) {
                    if (ex instanceof SocketTimeoutException) {
                        timeout = true;
                        LOG.log(Level.SEVERE, "{0} TIMEOUT downloading chunk {1}", new Object[]{Thread.currentThread().getName(), chunk_id});
                        continue;
                    }
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
                finally {
                    if (!chunk_error) continue;
                    this.getDownload().rejectChunkId(chunk_id);
                    if (chunk_reads > 0L) {
                        this.getDownload().getPartialProgress().add(-1L * chunk_reads);
                        this.getDownload().getProgress_meter().secureNotify();
                    }
                    if (!(this.isExit() || this.getDownload().isStopped() || timeout || http_error == 403)) {
                        this.setError_wait(true);
                        try {
                            Thread.sleep(MiscTools.getWaitTimeExpBackOff(++conta_error) * 1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.setError_wait(false);
                    }
                    if (con == null) continue;
                    con.disconnect();
                    con = null;
                }
            }
        }
        catch (ChunkInvalidException worker_url) {
        }
        catch (Exception | OutOfMemoryError error) {
            this.getDownload().stopDownloader(error.getMessage());
            LOG.log(Level.SEVERE, error.getMessage());
        }
        this.getDownload().stopThisSlot(this);
        this.getDownload().secureNotify();
        LOG.log(Level.INFO, "{0} ChunkDownloaderMONO {1}: bye bye", new Object[]{Thread.currentThread().getName(), this.getDownload().getFile_name()});
    }
}

