/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.ChunkInvalidException;
import com.tonikelope.megabasterd.ChunkWriterManager;
import com.tonikelope.megabasterd.Download;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MiscTools;
import com.tonikelope.megabasterd.SecureSingleThreadNotifiable;
import com.tonikelope.megabasterd.ThrottledInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChunkDownloader
implements Runnable,
SecureSingleThreadNotifiable {
    public static final int SMART_PROXY_RECHECK_509_TIME = 3600;
    private static final Logger LOG = Logger.getLogger(ChunkDownloader.class.getName());
    private final int _id;
    private final Download _download;
    private volatile boolean _exit = false;
    private final Object _secure_notify_lock = new Object();
    private volatile boolean _error_wait;
    private volatile boolean _chunk_exception = false;
    private volatile boolean _notified = false;
    private final ArrayList<String> _excluded_proxy_list;
    private volatile boolean _reset_current_chunk;
    private volatile InputStream _chunk_inputstream = null;
    private volatile long _509_timestamp = -1L;
    private String _current_smart_proxy;

    public void RESET_CURRENT_CHUNK() {
        if (this._chunk_inputstream != null) {
            this._reset_current_chunk = true;
            try {
                this._chunk_inputstream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ChunkDownloader.class.getName()).log(Level.SEVERE, null, ex);
            }
            this._chunk_inputstream = null;
        }
    }

    public ChunkDownloader(int id, Download download) {
        this._id = id;
        this._download = download;
        this._current_smart_proxy = null;
        this._excluded_proxy_list = new ArrayList();
        this._error_wait = false;
        this._reset_current_chunk = false;
    }

    public boolean isChunk_exception() {
        return this._chunk_exception;
    }

    public String getCurrent_smart_proxy() {
        return this._current_smart_proxy;
    }

    public void setExit(boolean exit) {
        this._exit = exit;
    }

    public boolean isExit() {
        return this._exit;
    }

    public Download getDownload() {
        return this._download;
    }

    public int getId() {
        return this._id;
    }

    public boolean isError_wait() {
        return this._error_wait;
    }

    public void setError_wait(boolean error_wait) {
        this._error_wait = error_wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureNotify() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            this._notified = true;
            this._secure_notify_lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureWait() {
        Object object = this._secure_notify_lock;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._secure_notify_lock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    this._exit = true;
                    LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            this._notified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}]: let''s do some work! {2}", new Object[]{Thread.currentThread().getName(), this._id, this._download.getFile_name()});
        try {
            http_error = 0;
            http_status = -1;
            conta_error = 0;
            chunk_error = false;
            timeout = false;
            smart_proxy_socks = false;
            worker_url = null;
            buffer = new byte[16384];
            proxy_manager = MainPanel.getProxy_manager();
            while (!(this._download.getMain_panel().isExit() || this._exit || this._download.isStopped())) {
                if (this._download.isPaused() && !this._download.isStopped() && !this._download.getChunkmanager().isExit()) {
                    this._download.pause_worker();
                    this.secureWait();
                }
                if (http_error == 509 && (this._509_timestamp == -1L || this._509_timestamp + 3600000L < System.currentTimeMillis())) {
                    this._509_timestamp = System.currentTimeMillis();
                }
                if (worker_url == null || http_error == 403) {
                    worker_url = this._download.getDownloadUrlForWorker();
                }
                chunk_id = this._download.nextChunkId();
                chunk_offset = ChunkWriterManager.calculateChunkOffset(chunk_id, 20);
                chunk_size = ChunkWriterManager.calculateChunkSize(chunk_id, this._download.getFile_size(), chunk_offset, 20);
                ChunkWriterManager.checkChunkID(chunk_id, this._download.getFile_size(), chunk_offset);
                chunk_url = ChunkWriterManager.genChunkUrl(worker_url, this._download.getFile_size(), chunk_offset, chunk_size);
                if (http_error == 509 && MainPanel.isRun_command()) {
                    MainPanel.run_external_command();
                } else if (http_error != 509 && MainPanel.LAST_EXTERNAL_COMMAND_TIMESTAMP != -1L) {
                    MainPanel.LAST_EXTERNAL_COMMAND_TIMESTAMP = -1L;
                }
                if (MainPanel.isUse_smart_proxy() && (proxy_manager != null && proxy_manager.isForce_smart_proxy() || this._current_smart_proxy != null || http_error == 509 || this._509_timestamp != -1L && this._509_timestamp + 3600000L > System.currentTimeMillis()) && !MainPanel.isUse_proxy()) {
                    if (this._current_smart_proxy != null && chunk_error) {
                        if (!timeout && http_error != 429) {
                            proxy_manager.blockProxy(this._current_smart_proxy, timeout != false ? "TIMEOUT!" : "HTTP " + String.valueOf(http_error));
                        } else if (timeout) {
                            this._excluded_proxy_list.add(this._current_smart_proxy);
                            ChunkDownloader.LOG.log(Level.WARNING, "{0} Worker [{1}] PROXY {2} TIMEOUT", new Object[]{Thread.currentThread().getName(), this._id, this._current_smart_proxy});
                        } else {
                            this._excluded_proxy_list.add(this._current_smart_proxy);
                            ChunkDownloader.LOG.log(Level.WARNING, "{0} Worker [{1}] PROXY {2} TOO MANY CONNECTIONS", new Object[]{Thread.currentThread().getName(), this._id, this._current_smart_proxy});
                        }
                        smart_proxy = proxy_manager.getProxy(this._excluded_proxy_list);
                        this._current_smart_proxy = smart_proxy[0];
                        smart_proxy_socks = smart_proxy[1].equals("socks");
                    } else if (this._current_smart_proxy == null) {
                        smart_proxy = proxy_manager.getProxy(this._excluded_proxy_list);
                        this._current_smart_proxy = smart_proxy[0];
                        smart_proxy_socks = smart_proxy[1].equals("socks");
                    }
                    if (this._current_smart_proxy != null) {
                        if (!this.getDownload().isTurbo()) {
                            this.getDownload().enableTurboMode();
                        }
                        proxy_info = this._current_smart_proxy.split(":");
                        proxy = new Proxy(smart_proxy_socks != false ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(proxy_info[0], Integer.parseInt(proxy_info[1])));
                        url = new URL(chunk_url);
                        con = (HttpURLConnection)url.openConnection(proxy);
                    } else {
                        ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] SmartProxy getProxy returned NULL! {2}", new Object[]{Thread.currentThread().getName(), this._id, this._download.getFile_name()});
                        url = new URL(chunk_url);
                        con = (HttpURLConnection)url.openConnection();
                    }
                } else {
                    url = new URL(chunk_url);
                    if (MainPanel.isUse_proxy()) {
                        this._current_smart_proxy = null;
                        con = (HttpURLConnection)url.openConnection(new Proxy(smart_proxy_socks != false ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new InetSocketAddress(MainPanel.getProxy_host(), MainPanel.getProxy_port())));
                        if (MainPanel.getProxy_user() != null && !"".equals(MainPanel.getProxy_user())) {
                            con.setRequestProperty("Proxy-Authorization", "Basic " + MiscTools.Bin2BASE64((MainPanel.getProxy_user() + ":" + MainPanel.getProxy_pass()).getBytes("UTF-8")));
                        }
                    } else {
                        con = (HttpURLConnection)url.openConnection();
                    }
                }
                if (this._current_smart_proxy != null && proxy_manager != null) {
                    con.setConnectTimeout(proxy_manager.getProxy_timeout());
                    con.setReadTimeout(proxy_manager.getProxy_timeout() * 2);
                } else {
                    con.setConnectTimeout(60000);
                    con.setReadTimeout(60000);
                }
                con.setUseCaches(false);
                con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:61.0) Gecko/20100101 Firefox/61.0");
                chunk_reads = 0L;
                chunk_error = true;
                timeout = false;
                http_error = 0;
                tmp_chunk_file = null;
                chunk_file = null;
                ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] is downloading chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                try {
                    if (!this._exit && !this._download.isStopped()) {
                        http_status = con.getResponseCode();
                        if (http_status != 200) {
                            ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] Failed chunk download : HTTP error code : {2} {3}", new Object[]{Thread.currentThread().getName(), this._id, http_status, this._download.getFile_name()});
                            http_error = http_status;
                        } else {
                            chunk_file = new File(this._download.getChunkmanager().getChunks_dir() + "/" + MiscTools.HashString("sha1", this._download.getUrl()) + ".chunk" + chunk_id);
                            if (!chunk_file.exists() || chunk_file.length() != chunk_size) {
                                tmp_chunk_file = new File(this._download.getChunkmanager().getChunks_dir() + "/" + MiscTools.HashString("sha1", this._download.getUrl()) + ".chunk" + chunk_id + ".tmp");
                                this._chunk_inputstream = new ThrottledInputStream(con.getInputStream(), this._download.getMain_panel().getStream_supervisor());
                                tmp_chunk_file_os = new BufferedOutputStream(new FileOutputStream(tmp_chunk_file));
                                try {
                                    reads = 0;
                                    if (this._exit || this._download.isStopped() || this._download.getChunkmanager().isExit()) ** GOTO lbl120
                                    while (!(this._reset_current_chunk || this._exit || this._download.isStopped() || this._download.getChunkmanager().isExit() || chunk_reads >= chunk_size || (reads = this._chunk_inputstream.read(buffer, 0, Math.min((int)(chunk_size - chunk_reads), buffer.length))) == -1)) {
                                        tmp_chunk_file_os.write(buffer, 0, reads);
                                        this._download.getPartialProgress().add(Long.valueOf(reads));
                                        this._download.getProgress_meter().secureNotify();
                                        if (this._reset_current_chunk || !this._download.isPaused() || this._exit || this._download.isStopped() || this._download.getChunkmanager().isExit() || (chunk_reads += (long)reads) >= chunk_size) continue;
                                        this._download.pause_worker();
                                        this.secureWait();
                                    }
                                }
                                finally {
                                    tmp_chunk_file_os.close();
                                }
                            } else {
                                ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] has RECOVERED PREVIOUS chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                                chunk_reads = chunk_size;
                                this._download.getPartialProgress().add(chunk_size);
                                this._download.getProgress_meter().secureNotify();
                            }
                        }
lbl120:
                        // 4 sources

                        if (chunk_reads == chunk_size) {
                            ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] has OK DOWNLOADED (" + (this._current_smart_proxy != null ? "smartproxy" : "direct") + ") chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                            if (!(tmp_chunk_file == null || chunk_file == null || chunk_file.exists() && chunk_file.length() == chunk_size)) {
                                if (chunk_file.exists()) {
                                    chunk_file.delete();
                                }
                                tmp_chunk_file.renameTo(chunk_file);
                            }
                            chunk_error = false;
                            conta_error = 0;
                            http_error = 0;
                            if (this._current_smart_proxy != null && this._509_timestamp != -1L) {
                                this._509_timestamp = -1L;
                                if (this._download.isTurbo()) {
                                    this._download.disableTurboMode();
                                }
                            }
                            this._excluded_proxy_list.clear();
                            this._download.getChunkmanager().secureNotify();
                        }
                    }
                    if (this._chunk_inputstream == null) ** GOTO lbl197
                    ** GOTO lbl191
                }
                catch (IOException | IllegalStateException ex) {
                    block91: {
                        block90: {
                            block85: {
                                block89: {
                                    block88: {
                                        try {
                                            if (ex instanceof SocketTimeoutException) {
                                                timeout = true;
                                                ChunkDownloader.LOG.log(Level.WARNING, "{0} Worker [{1}] TIMEOUT downloading chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                                            } else {
                                                ChunkDownloader.LOG.log(Level.SEVERE, ex.getMessage());
                                            }
                                            if (this._chunk_inputstream != null) {
                                            }
                                            break block85;
                                        }
                                        catch (Throwable var25_32) {
                                            block87: {
                                                block86: {
                                                    if (this._chunk_inputstream != null) {
                                                        try {
                                                            this._chunk_inputstream.close();
                                                        }
                                                        catch (IOException ex) {
                                                            Logger.getLogger(ChunkDownloader.class.getName()).log(Level.SEVERE, null, ex);
                                                        }
                                                        this._chunk_inputstream = null;
                                                    }
                                                    if (!chunk_error) break block86;
                                                    ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] has FAILED downloading (" + (this._current_smart_proxy != null ? "smartproxy" : "direct") + ") chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                                                    if (tmp_chunk_file != null && tmp_chunk_file.exists()) {
                                                        tmp_chunk_file.delete();
                                                    }
                                                    this._download.rejectChunkId(chunk_id);
                                                    if (chunk_reads > 0L) {
                                                        this._download.getPartialProgress().add(-1L * chunk_reads);
                                                        this._download.getProgress_meter().secureNotify();
                                                    }
                                                    if (!(this._exit || this._download.isStopped() || timeout || this._current_smart_proxy != null || http_error == 509 || http_error == 403 || http_error == 503)) {
                                                        this._error_wait = true;
                                                        this._download.getView().updateSlotsStatus();
                                                        try {
                                                            Thread.sleep(MiscTools.getWaitTimeExpBackOff(++conta_error) * 1000L);
                                                        }
                                                        catch (InterruptedException var26_34) {
                                                            // empty catch block
                                                        }
                                                        this._error_wait = false;
                                                        this._download.getView().updateSlotsStatus();
                                                        break block87;
                                                    } else if (http_error == 503 && this._current_smart_proxy == null && !this._download.isTurbo()) {
                                                        this.setExit(true);
                                                    }
                                                    break block87;
                                                }
                                                if (proxy_manager != null && proxy_manager.isReset_slot_proxy()) {
                                                    this._current_smart_proxy = null;
                                                }
                                            }
                                            if (this._reset_current_chunk) {
                                                ChunkDownloader.LOG.log(Level.WARNING, "Worker [{0}] FORCE RESET CHUNK [{1}]! {2}", new Object[]{this._id, chunk_id, this._download.getFile_name()});
                                                this._current_smart_proxy = null;
                                                this._reset_current_chunk = false;
                                            }
                                            con.disconnect();
                                            throw var25_32;
                                        }
lbl191:
                                        // 1 sources

                                        try {
                                            this._chunk_inputstream.close();
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(ChunkDownloader.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                        this._chunk_inputstream = null;
lbl197:
                                        // 2 sources

                                        if (!chunk_error) break block88;
                                        ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] has FAILED downloading (" + (this._current_smart_proxy != null ? "smartproxy" : "direct") + ") chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                                        if (tmp_chunk_file != null && tmp_chunk_file.exists()) {
                                            tmp_chunk_file.delete();
                                        }
                                        this._download.rejectChunkId(chunk_id);
                                        if (chunk_reads > 0L) {
                                            this._download.getPartialProgress().add(-1L * chunk_reads);
                                            this._download.getProgress_meter().secureNotify();
                                        }
                                        if (!(this._exit || this._download.isStopped() || timeout || this._current_smart_proxy != null || http_error == 509 || http_error == 403 || http_error == 503)) {
                                            this._error_wait = true;
                                            this._download.getView().updateSlotsStatus();
                                            try {
                                                Thread.sleep(MiscTools.getWaitTimeExpBackOff(++conta_error) * 1000L);
                                            }
                                            catch (InterruptedException ex) {
                                                // empty catch block
                                            }
                                            this._error_wait = false;
                                            this._download.getView().updateSlotsStatus();
                                            break block89;
                                        } else if (http_error == 503 && this._current_smart_proxy == null && !this._download.isTurbo()) {
                                            this.setExit(true);
                                        }
                                        break block89;
                                    }
                                    if (proxy_manager != null && proxy_manager.isReset_slot_proxy()) {
                                        this._current_smart_proxy = null;
                                    }
                                }
                                if (this._reset_current_chunk) {
                                    ChunkDownloader.LOG.log(Level.WARNING, "Worker [{0}] FORCE RESET CHUNK [{1}]! {2}", new Object[]{this._id, chunk_id, this._download.getFile_name()});
                                    this._current_smart_proxy = null;
                                    this._reset_current_chunk = false;
                                }
                                con.disconnect();
                                continue;
                                try {
                                    this._chunk_inputstream.close();
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(ChunkDownloader.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                this._chunk_inputstream = null;
                            }
                            if (!chunk_error) break block90;
                            ChunkDownloader.LOG.log(Level.INFO, "{0} Worker [{1}] has FAILED downloading (" + (this._current_smart_proxy != null ? "smartproxy" : "direct") + ") chunk [{2}]! {3}", new Object[]{Thread.currentThread().getName(), this._id, chunk_id, this._download.getFile_name()});
                            if (tmp_chunk_file != null && tmp_chunk_file.exists()) {
                                tmp_chunk_file.delete();
                            }
                            this._download.rejectChunkId(chunk_id);
                            if (chunk_reads > 0L) {
                                this._download.getPartialProgress().add(-1L * chunk_reads);
                                this._download.getProgress_meter().secureNotify();
                            }
                            if (!(this._exit || this._download.isStopped() || timeout || this._current_smart_proxy != null || http_error == 509 || http_error == 403 || http_error == 503)) {
                                this._error_wait = true;
                                this._download.getView().updateSlotsStatus();
                                try {
                                    Thread.sleep(MiscTools.getWaitTimeExpBackOff(++conta_error) * 1000L);
                                }
                                catch (InterruptedException var22_28) {
                                    // empty catch block
                                }
                                this._error_wait = false;
                                this._download.getView().updateSlotsStatus();
                                break block91;
                            } else if (http_error == 503 && this._current_smart_proxy == null && !this._download.isTurbo()) {
                                this.setExit(true);
                            }
                            break block91;
                        }
                        if (proxy_manager != null && proxy_manager.isReset_slot_proxy()) {
                            this._current_smart_proxy = null;
                        }
                    }
                    if (this._reset_current_chunk) {
                        ChunkDownloader.LOG.log(Level.WARNING, "Worker [{0}] FORCE RESET CHUNK [{1}]! {2}", new Object[]{this._id, chunk_id, this._download.getFile_name()});
                        this._current_smart_proxy = null;
                        this._reset_current_chunk = false;
                    }
                    con.disconnect();
                }
            }
        }
        catch (ChunkInvalidException e) {
            this._chunk_exception = true;
        }
        catch (Exception | OutOfMemoryError error) {
            this._download.stopDownloader(error.getMessage());
            ChunkDownloader.LOG.log(Level.SEVERE, error.getMessage());
        }
        this._download.stopThisSlot(this);
        this._download.getChunkmanager().secureNotify();
        ChunkDownloader.LOG.log(Level.INFO, "{0} ChunkDownloader [{1}] {2}: bye bye", new Object[]{Thread.currentThread().getName(), this._id, this._download.getFile_name()});
    }
}

