/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

public class BoundedExecutor {
    private final ExecutorService exec;
    private final Semaphore semaphore;

    public BoundedExecutor(ExecutorService exec, int bound) {
        this.exec = exec;
        this.semaphore = new Semaphore(bound);
    }

    public void submitTask(final Runnable command) throws InterruptedException {
        this.semaphore.acquire();
        try {
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedExecutor.this.semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
        }
    }
}

