/*
 * Decompiled with CFR 0.152.
 */
package com.tonikelope.megabasterd;

import com.tonikelope.megabasterd.LabelTranslatorSingleton;
import com.tonikelope.megabasterd.MainPanel;
import com.tonikelope.megabasterd.MainPanelView;
import com.tonikelope.megabasterd.MiscTools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.sound.midi.Sequencer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class AboutDialog
extends JDialog {
    public static final String MEGA_URL = "https://mega.nz/";
    public static final String MEGABASTERD_URL = "https://github.com/tonikelope/megabasterd/releases/latest";
    public static final String TONIKELOPE_URL = "https://github.com/tonikelope/";
    public static final String MEGACRYPTER_URL = "https://tonikelope.github.io/megacrypter/";
    public static final String SPAIN_URL = "https://en.wikipedia.org/wiki/Spain";
    public static final String MEGABASTERD_GITHUB_URL = "https://tonikelope.github.io/megabasterd/";
    public static final String KIM_URL = "http://www.kim.com/";
    private static volatile Sequencer _midi = null;
    private JLabel author_webpage_label;
    private JButton check_version_button;
    private JLabel dot_com_label;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JLabel java_version;
    private JLabel made_in_spain_label;
    private JLabel mb_label;
    private JLabel mc_logo_label;
    private JButton mcdown_url_button;
    private JLabel subtitle_label;
    private JLabel title_label;
    private static final Logger LOG = Logger.getLogger(AboutDialog.class.getName());

    public AboutDialog(MainPanelView parent, boolean modal) {
        super((Frame)parent, modal);
        MiscTools.GUIRunAndWait(() -> {
            this.initComponents();
            MiscTools.updateFonts(this, MainPanel.GUI_FONT, parent.getMain_panel().getZoom_factor());
            MiscTools.translateLabels(this);
            if (MainPanel.getNew_version() != null) {
                this.mcdown_url_button.setEnabled(true);
            }
            this.pack();
        });
    }

    private void initComponents() {
        this.title_label = new JLabel();
        this.made_in_spain_label = new JLabel();
        this.subtitle_label = new JLabel();
        this.mc_logo_label = new JLabel();
        this.mcdown_url_button = new JButton();
        this.author_webpage_label = new JLabel();
        this.mb_label = new JLabel();
        this.check_version_button = new JButton();
        this.dot_com_label = new JLabel();
        this.java_version = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setIconImage(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                AboutDialog.this.formWindowOpened(evt);
            }
        });
        this.title_label.setFont(new Font("Dialog", 1, 48));
        this.title_label.setText("MegaBasterd 8.22 ");
        this.title_label.setCursor(new Cursor(12));
        this.title_label.setDoubleBuffered(true);
        this.title_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.title_labelMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AboutDialog.this.title_labelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AboutDialog.this.title_labelMouseEntered(evt);
            }
        });
        this.made_in_spain_label.setIcon(new ImageIcon(this.getClass().getResource("/images/m_in_spain.png")));
        this.made_in_spain_label.setCursor(new Cursor(12));
        this.made_in_spain_label.setDoubleBuffered(true);
        this.made_in_spain_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.made_in_spain_labelMouseReleased(evt);
            }
        });
        this.subtitle_label.setFont(new Font("Dialog", 1, 20));
        this.subtitle_label.setForeground(new Color(102, 102, 102));
        this.subtitle_label.setText("Yet another unofficial (and ugly) cross-platform MEGA downloader/uploader/streaming suite.");
        this.subtitle_label.setCursor(new Cursor(12));
        this.subtitle_label.setDoubleBuffered(true);
        this.subtitle_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.subtitle_labelMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AboutDialog.this.subtitle_labelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AboutDialog.this.subtitle_labelMouseEntered(evt);
            }
        });
        this.mc_logo_label.setIcon(new ImageIcon(this.getClass().getResource("/images/mega_crypter.png")));
        this.mc_logo_label.setCursor(new Cursor(12));
        this.mc_logo_label.setDoubleBuffered(true);
        this.mc_logo_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.mc_logo_labelMouseReleased(evt);
            }
        });
        this.mcdown_url_button.setFont(new Font("Dialog", 1, 14));
        this.mcdown_url_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-copy-to-clipboard-30.png")));
        this.mcdown_url_button.setText("Download latest version");
        this.mcdown_url_button.setDoubleBuffered(true);
        this.mcdown_url_button.setEnabled(false);
        this.mcdown_url_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.mcdown_url_buttonActionPerformed(evt);
            }
        });
        this.author_webpage_label.setFont(new Font("Dialog", 0, 18));
        this.author_webpage_label.setForeground(new Color(102, 102, 102));
        this.author_webpage_label.setText("Made with love (and with no warranty) by tonikelope.");
        this.author_webpage_label.setCursor(new Cursor(12));
        this.author_webpage_label.setDoubleBuffered(true);
        this.author_webpage_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AboutDialog.this.author_webpage_labelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AboutDialog.this.author_webpage_labelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.author_webpage_labelMouseReleased(evt);
            }
        });
        this.mb_label.setIcon(new ImageIcon(this.getClass().getResource("/images/mbasterd_logo_nuevo.png")));
        this.mb_label.setCursor(new Cursor(12));
        this.mb_label.setDoubleBuffered(true);
        this.mb_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.mb_labelMouseReleased(evt);
            }
        });
        this.check_version_button.setFont(new Font("Dialog", 1, 14));
        this.check_version_button.setIcon(new ImageIcon(this.getClass().getResource("/images/icons8-restart-30.png")));
        this.check_version_button.setText("Check version");
        this.check_version_button.setDoubleBuffered(true);
        this.check_version_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.check_version_buttonActionPerformed(evt);
            }
        });
        this.dot_com_label.setIcon(new ImageIcon(this.getClass().getResource("/images/dot_com2.png")));
        this.dot_com_label.setCursor(new Cursor(12));
        this.dot_com_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                AboutDialog.this.dot_com_labelMouseReleased(evt);
            }
        });
        this.java_version.setFont(new Font("Dialog", 0, 14));
        this.java_version.setForeground(new Color(102, 102, 102));
        this.java_version.setHorizontalAlignment(4);
        this.java_version.setText(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
        this.jLabel5.setFont(new Font("Dialog", 0, 16));
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/turkey.png")));
        this.jLabel5.setText("FabrieI");
        this.jLabel2.setFont(new Font("Dialog", 0, 16));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/germany.png")));
        this.jLabel2.setText("NieckLikesCode");
        this.jLabel3.setFont(new Font("Dialog", 0, 16));
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/hungary.png")));
        this.jLabel3.setText("Roschach96 ");
        this.jLabel1.setFont(new Font("Dialog", 0, 16));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/china.png")));
        this.jLabel1.setText("linkea131");
        this.jLabel1.setDoubleBuffered(true);
        this.jLabel4.setFont(new Font("Dialog", 0, 16));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/italy.png")));
        this.jLabel4.setText("bovirus ");
        this.jLabel6.setFont(new Font("Dialog", 0, 16));
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/images/flags/vietnam.png")));
        this.jLabel6.setText("rattybox");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jLabel3).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jLabel4).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jLabel5).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jLabel6).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.subtitle_label, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.title_label, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mcdown_url_button).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.check_version_button)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.made_in_spain_label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dot_com_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.mb_label).addGap(18, 18, 18).addComponent(this.mc_logo_label)).addComponent(this.author_webpage_label, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.java_version, -2, 481, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.title_label).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mcdown_url_button).addComponent(this.check_version_button)))).addGap(18, 18, 18).addComponent(this.subtitle_label).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.made_in_spain_label).addComponent(this.dot_com_label).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mb_label).addComponent(this.mc_logo_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.author_webpage_label))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.java_version).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void mcdown_url_buttonActionPerformed(ActionEvent evt) {
        MiscTools.openBrowserURL(MEGABASTERD_URL);
    }

    private void check_version_buttonActionPerformed(ActionEvent evt) {
        String old_check_version_button_text = this.check_version_button.getText();
        this.check_version_button.setEnabled(false);
        this.check_version_button.setText(LabelTranslatorSingleton.getInstance().translate("Checking, please wait..."));
        this.pack();
        AboutDialog tthis = this;
        MainPanel.THREAD_POOL.execute(() -> {
            String new_version = MiscTools.checkNewVersion(MEGABASTERD_URL);
            MiscTools.GUIRun(() -> {
                if (new_version != null) {
                    JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("MegaBasterd NEW VERSION is available! -> ") + new_version);
                    this.mcdown_url_button.setEnabled(true);
                } else {
                    JOptionPane.showMessageDialog(tthis, LabelTranslatorSingleton.getInstance().translate("You have the latest version ;)"));
                    this.mcdown_url_button.setEnabled(false);
                }
                this.check_version_button.setText(old_check_version_button_text);
                this.check_version_button.setEnabled(true);
                this.pack();
            });
        });
    }

    private void mb_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(MEGABASTERD_GITHUB_URL);
    }

    private void author_webpage_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(TONIKELOPE_URL);
    }

    private void mc_logo_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(MEGACRYPTER_URL);
    }

    private void made_in_spain_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(SPAIN_URL);
    }

    private void title_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(MEGABASTERD_GITHUB_URL);
    }

    private void author_webpage_labelMouseEntered(MouseEvent evt) {
        this.author_webpage_label.setForeground(Color.blue);
    }

    private void author_webpage_labelMouseExited(MouseEvent evt) {
        this.author_webpage_label.setForeground(new Color(102, 102, 102));
    }

    private void title_labelMouseEntered(MouseEvent evt) {
        this.title_label.setForeground(Color.blue);
    }

    private void title_labelMouseExited(MouseEvent evt) {
        this.title_label.setForeground(new Color(51, 51, 51));
    }

    private void subtitle_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(MEGA_URL);
    }

    private void dot_com_labelMouseReleased(MouseEvent evt) {
        MiscTools.openBrowserURL(KIM_URL);
    }

    private void subtitle_labelMouseEntered(MouseEvent evt) {
        this.subtitle_label.setForeground(Color.blue);
    }

    private void subtitle_labelMouseExited(MouseEvent evt) {
        this.subtitle_label.setForeground(new Color(102, 102, 102));
    }

    private void formWindowOpened(WindowEvent evt) {
        MainPanel.THREAD_POOL.execute(() -> {
            if (_midi == null) {
                _midi = MiscTools.midiLoopPlay("/midis/a-team.mid", 70);
            } else {
                _midi.start();
            }
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        MainPanel.THREAD_POOL.execute(() -> _midi.stop());
        this.dispose();
    }
}

